/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.converter.Converter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.PirkaWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtoConverter
implements Serializable {
    public static Map<String, Object> getDto(FieldMap fieldMap, Converter ... converters) {
        return DtoConverter.getDto(fieldMap, false, converters);
    }

    public static Map<String, Object> getDto(FieldMap fieldMap, boolean inputCtrlOnly, Converter ... converters) {
        HashMap<String, Object> dto = new HashMap<String, Object>();
        Map<String, Converter> converterMap = DtoConverter.createConverterMap(converters);
        DtoConverter.getDtoMain(dto, fieldMap, converterMap, inputCtrlOnly);
        return dto;
    }

    private static void getDtoMain(Map<String, Object> dto, FieldMap fieldMap, Map<String, Converter> converterMap, boolean inputCtrlOnly) {
        String[] fieldNames;
        Map<String, String> groupMap = DtoConverter.createGroupMap(fieldMap);
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (!(cp.isLoop() || cp.isGroupItem() || inputCtrlOnly && !cp.isInputCtrl())) {
                Converter converter = converterMap.get(fieldName);
                if (converter == null) {
                    dto.put(fieldName, fieldItem.getValue());
                } else if (converter.getDataConverter() == null) {
                    dto.put(converter.getTargetFieldName(), fieldItem.getValue());
                } else {
                    dto.put(converter.getTargetFieldName(), converter.getDataConverter().win2Target(fieldItem.getValue()));
                }
            }
            if (cp.isLoop()) {
                ArrayList<HashMap<String, Object>> dtoList = new ArrayList<HashMap<String, Object>>();
                dto.put(fieldName, dtoList);
                List list = (List)fieldItem.getValue();
                for (FieldMap childFieldMap : list) {
                    HashMap<String, Object> childDto = new HashMap<String, Object>();
                    DtoConverter.getDtoMain(childDto, childFieldMap, converterMap, inputCtrlOnly);
                    dtoList.add(childDto);
                }
            }
            ++n;
        }
        for (String fieldName : groupMap.keySet()) {
            Converter converter = converterMap.get(fieldName);
            if (converter == null) {
                dto.put(fieldName, fieldMap.getGroupValue(fieldName));
                continue;
            }
            if (converter.getDataConverter() == null) {
                dto.put(converter.getTargetFieldName(), fieldMap.getGroupValue(fieldName));
                continue;
            }
            dto.put(converter.getTargetFieldName(), converter.getDataConverter().win2Target(fieldMap.getGroupValue(fieldName)));
        }
    }

    public static void setDto(PirkaWindow window, Map<String, Object> dto, FieldMap fieldMap, Converter ... converters) {
        DtoConverter.setDto(window, dto, fieldMap, false, converters);
    }

    public static void setDto(PirkaWindow window, Map<String, Object> dto, FieldMap fieldMap, boolean inputCtrlOnly, Converter ... converters) {
        Map<String, Converter> converterMap = DtoConverter.createConverterMap(converters);
        DtoConverter.setDtoMain(dto, fieldMap, converterMap, window, inputCtrlOnly);
    }

    private static void setDtoMain(Map<String, Object> dto, FieldMap fieldMap, Map<String, Converter> converterMap, PirkaWindow window, boolean inputCtrlOnly) {
        String[] fieldNames;
        Map<String, String> groupMap = DtoConverter.createGroupMap(fieldMap);
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String targetFieldName;
            Converter converter;
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (!(cp.isLoop() || cp.isGroupItem() || inputCtrlOnly && !cp.isInputCtrl())) {
                converter = converterMap.get(fieldName);
                targetFieldName = fieldName;
                if (converter != null) {
                    targetFieldName = converter.getTargetFieldName();
                }
                if (dto.containsKey(targetFieldName)) {
                    Object value = dto.get(targetFieldName);
                    if (converter != null && converter.getDataConverter() != null) {
                        value = converter.getDataConverter().target2Win(value);
                    }
                    if (cp.isCheckCtrl()) {
                        if (value == null || !(value instanceof Boolean)) {
                            fieldMap.setValue(fieldName, false);
                        } else {
                            fieldMap.setValue(fieldName, (Boolean)value);
                        }
                    } else if (value == null) {
                        fieldMap.setValue(fieldName, "");
                    } else if (value instanceof Date) {
                        fieldMap.setValue(fieldName, (Date)value);
                    } else if (value instanceof Time) {
                        fieldMap.setValue(fieldName, (Time)value);
                    } else if (value instanceof Timestamp) {
                        fieldMap.setValue(fieldName, (Timestamp)value);
                    } else if (value instanceof BigDecimal) {
                        fieldMap.setValue(fieldName, (BigDecimal)value);
                    } else if (value instanceof Integer) {
                        fieldMap.setValue(fieldName, (Integer)value);
                    } else if (value instanceof Long) {
                        fieldMap.setValue(fieldName, (Long)value);
                    } else if (value instanceof String) {
                        fieldMap.setValue(fieldName, (String)value);
                    } else {
                        fieldMap.setValue(fieldName, value.toString());
                    }
                }
            }
            if (cp.isLoop()) {
                converter = converterMap.get(fieldName);
                targetFieldName = fieldName;
                if (converter != null) {
                    targetFieldName = converter.getTargetFieldName();
                }
                if (dto.containsKey(targetFieldName)) {
                    fieldMap.clearFieldMap(fieldName);
                    Object loopObject = dto.get(targetFieldName);
                    Object[] loopDto = null;
                    if (loopObject instanceof List) {
                        loopDto = ((List)loopObject).toArray();
                    } else if (loopObject instanceof Map[]) {
                        loopDto = (Object[])loopObject;
                    }
                    if (loopDto != null) {
                        Object[] objectArray = loopDto;
                        int n3 = 0;
                        int n4 = objectArray.length;
                        while (n3 < n4) {
                            FieldMap newFieldMap;
                            Object childDto = objectArray[n3];
                            if (childDto != null && childDto instanceof Map && (newFieldMap = window.createLoopFieldMap(fieldName)) != null) {
                                fieldMap.addFieldMap(fieldName, newFieldMap);
                                DtoConverter.setDtoMain((Map)childDto, newFieldMap, converterMap, window, inputCtrlOnly);
                            }
                            ++n3;
                        }
                    }
                }
            }
            ++n;
        }
        for (String fieldName : groupMap.keySet()) {
            Converter converter = converterMap.get(fieldName);
            String targetFieldName = fieldName;
            if (converter != null) {
                targetFieldName = converter.getTargetFieldName();
            }
            if (!dto.containsKey(targetFieldName)) continue;
            Object value = dto.get(targetFieldName);
            if (converter != null && converter.getDataConverter() != null) {
                value = converter.getDataConverter().target2Win(value);
            }
            if (value == null) {
                fieldMap.setGroupValue(targetFieldName, "");
                continue;
            }
            if (value instanceof String) {
                fieldMap.setGroupValue(targetFieldName, (String)value);
                continue;
            }
            fieldMap.setGroupValue(targetFieldName, "");
        }
    }

    private static Map<String, Converter> createConverterMap(Converter ... converters) {
        HashMap<String, Converter> map = new HashMap<String, Converter>();
        Converter[] converterArray = converters;
        int n = 0;
        int n2 = converterArray.length;
        while (n < n2) {
            Converter converter = converterArray[n];
            map.put(converter.getWindowFieldName(), converter);
            ++n;
        }
        return map;
    }

    private static Map<String, String> createGroupMap(FieldMap fieldMap) {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        DtoConverter.createGroupMapMain(groupMap, fieldMap, 0);
        return groupMap;
    }

    private static void createGroupMapMain(Map<String, String> groupMap, FieldMap fieldMap, int groupLevel) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (cp.isGroupItem() && fieldItem.getCtrl().getGroupLevel() == groupLevel) {
                groupMap.put(fieldItem.getCtrl().getBaseName(), fieldItem.getCtrl().getBaseName());
            }
            if (cp.isLoop()) {
                List list = (List)fieldItem.getValue();
                for (FieldMap childFieldMap : list) {
                    DtoConverter.createGroupMapMain(groupMap, childFieldMap, groupLevel + 1);
                }
            }
            ++n;
        }
    }
}

