/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.general;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import jp.oarts.pirka.core.general.HtmlPartsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParts
implements Serializable {
    private HtmlPartsType type;
    private int deep;
    private String orgString;
    private String tagName;
    private String name;
    private String endTagOrgString;
    private TreeMap<String, String> option;
    private List<HtmlParts> child;

    public Object clone() {
        HtmlParts cloneObject = new HtmlParts();
        cloneObject.type = this.type;
        cloneObject.deep = this.deep;
        cloneObject.orgString = this.orgString;
        cloneObject.tagName = this.tagName;
        cloneObject.name = this.name;
        cloneObject.endTagOrgString = this.endTagOrgString;
        if (this.option != null) {
            cloneObject.option = new TreeMap();
            cloneObject.option.putAll(this.option);
        } else {
            cloneObject.option = null;
        }
        if (this.child == null) {
            cloneObject.child = null;
        } else {
            cloneObject.child = new ArrayList<HtmlParts>();
            for (HtmlParts parts : this.child) {
                cloneObject.child.add((HtmlParts)parts.clone());
            }
        }
        return cloneObject;
    }

    public int getDeep() {
        return this.deep;
    }

    public void setDeep(int deep) {
        this.deep = deep;
    }

    public String getEndTag() {
        return this.endTagOrgString;
    }

    public void setEndTag(String endTag) {
        this.endTagOrgString = endTag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TreeMap<String, String> getOption() {
        return this.option;
    }

    public void setOption(TreeMap<String, String> option) {
        this.option = option;
    }

    public String getOrgString() {
        return this.orgString;
    }

    public void setOrgString(String orgString) {
        this.orgString = orgString;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public HtmlPartsType getType() {
        return this.type;
    }

    public void setType(HtmlPartsType type) {
        this.type = type;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String leftMrg) {
        StringBuilder sb = new StringBuilder();
        sb.append(leftMrg);
        sb.append("type=" + this.type.toString());
        sb.append(", ");
        sb.append("deep=" + this.deep);
        sb.append(", ");
        sb.append("tagName=" + this.tagName);
        sb.append(", ");
        sb.append("name=" + this.name);
        sb.append(", ");
        sb.append("endTag=" + this.endTagOrgString);
        sb.append(", ");
        sb.append("option:");
        if (this.option == null) {
            sb.append("null");
        } else {
            boolean first = true;
            for (String key : this.option.keySet()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String value = this.option.get(key);
                if (value.length() <= 0) {
                    sb.append(key);
                    continue;
                }
                sb.append(key);
                sb.append("=");
                sb.append(value);
            }
        }
        sb.append(", ");
        sb.append("orgString=" + this.orgString.replace('\n', '.').replace('\r', '.'));
        if (this.child != null) {
            sb.append("\n");
            leftMrg = String.valueOf(leftMrg) + "  ";
            for (HtmlParts part : this.child) {
                sb.append(part.toString(leftMrg));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public List<HtmlParts> getChild() {
        return this.child;
    }

    public void setChild(List<HtmlParts> child) {
        this.child = child;
    }
}

