#!/bin/sh
if [ ! -e $2 ]; then
  echo "File $2 is not exists"
fi
base_dir=${0%/*}
if [ $base_dir = $0 ]; then
    base_dir="./"
fi
. $base_dir/env.sh
echo "gzip -cd $2 > ${2%.gz}"
gzip -cd $2 > ${2%.gz}
python $base_dir/import_logs.py --idsite=$1 --url=$PIWIK_URL --token-auth=$PIWIK_TOKEN_AUTH --config=$PIWIK_INSTALL_DIR/config/config.ini.php --recorders=4 --recorder-max-payload-size=200  --enable-bot -d --log-format-name=apache_fluentd --exclude-path-from=$base_dir/../exclude/exclude_idsite${1}.txt ${2%.gz} 2>&1 | tee ${2%.gz}.archive
$PIWIK_INSTALL_DIR/console core:archive --url=$PIWIK_URL 2>&1 | tee -a ${2%.gz}.archive
echo "/bin/rm -rf ${2%.gz}"
/bin/rm -rf ${2%.gz}
