<?php
require_once 'Plugg/RoutingController.php';

class Plugg_Main extends Plugg_RoutingController
{
    public function __construct()
    {
        parent::__construct('Index', 'Plugg_Main_', dirname(__FILE__) . '/Main');
        $this->_eventNamePrefix = 'PluggMain';
    }

    public function isAuthenticatedBeforeFilter(Sabai_Application_Context $context)
    {
        if (!$context->user->isAuthenticated()) {
            if ($this->pluginManager->getPlugin('user')) {
                // Redirect to the user plugin login page if the plugin is active
                $context->response
                    ->setError(
                        sprintf(
                            $this->gettext->_('You must <a href="%s">login</a> to perform this operation'),
                            $this->url->create(array(
                                'base' => '/user/login',
                                'params' => array('return' => 1)
                            ))
                        ),
                        array('base' => '/user/login', 'params' => array('return' => 1))
                    )
                    ->send($this->_application);
            } else {
                $context->response
                    ->setError($this->gettext->_('Invalid request'))
                    ->send($this->_application);
            }
        }
    }

    public function isAuthenticatedAfterFilter(Sabai_Application_Context $context){}
}