<?php
abstract class Sabai_Application_ModelEntityController extends Sabai_Application_Controller
{
    /**
     * @var string
     * @access protected
     */
    protected $_entityName;
    /**
     * @var array
     * @access protected
     */
    protected $_options = array();

    /**
     * Constructor
     *
     * @param string $entityName
     * @param array $options
     * @return Sabai_Application_ModelEntityController
     */
    protected function __construct($entityName, array $options = array())
    {
        $this->_entityName = $entityName;
        $this->_options = array_merge(array(
            'viewName'   => null,
            'successURL' => null,
            'errorURL'   => null
        ), $options);
    }
    
    protected function _getErrorUrl(Sabai_Application_Context $context)
    {
        if (empty($this->_options['errorURL'])) {
            return $this->url->getScriptUrl();
        }

        if (is_array($this->_options['errorURL'])) {
            return $this->url->create($this->_options['errorURL']);
        }

        return $this->_options['errorURL'];
    }
    
    protected function _getSuccessUrl(Sabai_Application_Context $context)
    {
        if (empty($this->_options['successURL'])) {
            return $this->url->getScriptUrl();
        }

        if (is_array($this->_options['successURL'])) {
            return $this->url->create($this->_options['successURL']);
        }

        return $this->_options['successURL'];
    }
    
    protected function _getOption($name)
    {
        return $this->_options[$name];
    }
    
    protected function _setOption($name, $value)
    {
        $this->_options[$name] = $value;
    }

    /**
     * Returns the model object
     *
     * @access protected
     * @return Sabai_Model
     * @param Sabai_Application_Context
     */
    abstract protected function _getModel(Sabai_Application_Context $context);
}