<?php
require_once 'Plugg/PluginAdmin.php';

class Plugg_Search_Admin extends Plugg_PluginAdmin
{
    public function __construct()
    {
        parent::__construct(__CLASS__ . '_', dirname(__FILE__) . '/Admin', 'List');
    }
    
    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->addTabs(array(
            'searchable' => array(
                'title' => $context->plugin->_('Searchable contents')
            ),
        ));
        $context->response->setCurrentTab('searchable');
        $context->response->setPageInfo($context->plugin->_('Searchable contents'));
        return array(
            'submit' => array(
                'controller' => 'Submit'
            ),
            ':searchable_id' => array(
                'controller' => 'Searchable',
                'requirements' => array(
                    ':searchable_id' => '\d+'
                )
            ),
        );
    }
}