<?php
require_once 'Sabai/Application/ModelEntityController/Paginate.php';

class Plugg_User_Admin_Role_List extends Sabai_Application_ModelEntityController_Paginate
{
    var $_select;
    var $_sortBy = array('name', 'ASC');

    function __construct()
    {
        $options = array(
            'tplVarPages' => 'role_pages',
            'tplVarPageRequested' => 'role_page_requested',
            'tplVarEntities' => 'roles',
            'perpage' => 30
        );
        parent::__construct('Role', $options);
    }

    function _getCriteria(Sabai_Application_Context $context)
    {
        return false;
    }

    function _getRequestedSort($request)
    {
        if ($sort_by = $request->getAsStr('sortby')) {
            $sort_by = explode(',', $sort_by);
            if (count($sort_by) == 2) {
                $this->_sortBy = $sort_by;
            }
        }
        if ($this->_sortBy[0] == 'name') {
            return 'name';
        }
        return array($this->_sortBy[0], 'name');
    }

    function _getRequestedOrder($request)
    {
        if ($this->_sortBy[0] != 'name') {
            return array($this->_sortBy[1], 'ASC');
        }
        return $this->_sortBy[1];
    }

    function _onPaginateEntities($entities, Sabai_Application_Context $context)
    {
        $context->response->clearTabPageInfo();
        $context->response->setVars(array(
            'role_requested_sortby' => implode(',', $this->_sortBy)
        ));
        return $entities;
    }

    protected function _getModel(Sabai_Application_Context $context)
    {
        return $context->plugin->getModel();
    }
}