<?php
class Plugg_User_Main_Identity_Friend_Request_Accept extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        $request = $this->_parent->getRequestedFriendRequest($context);
        $identity = $this->_parent->getRequestedUserIdentity($context);
        $url = array(
            'base' => '/user',
            'path' => '/' . $identity->getId(),
            'params' => array('tab_id' => $context->request->getAsInt('tab_id'))
        );

        if (!$request->isPending() || $request->get('to') != $identity->getId()) {
            $context->response->setError($context->plugin->_('Invalid request'),$url);
            return;
        }

        $request_user = $request->get('User');
        $form = $this->_getForm($context, $request);
        if ($form->validate()) {
            $request->setAccepted();
            $model = $context->plugin->getModel();
            $friend = $model->create('Friend');
            $friend->setVar('userid', $request_user->getId());
            $friend->set('with', $identity->getId());
            $friend->set('relationships', 'contact'); // Defaults to "contact" relationship
            $friend->markNew();
            $friend2 = $model->create('Friend');
            $friend2->setVar('userid', $identity->getId());
            $friend2->set('with', $request_user->getId());
            $friend2->set('relationships', 'contact'); // Defaults to "contact" relationship
            $friend2->markNew();
            if ($model->commit()) {
                $message = $context->plugin->_('Friend request accepted successfully.');
                $context->response->setSuccess($message, $url);
                $this->_parent->clearMenuInSession($context);
                return;
            }
        }

        $context->response->setPageInfo($context->plugin->_('Accept a friend request'));
        $context->response->setVars(array('request_form' => $form));
    }

    private function _getForm(Sabai_Application_Context $context, $request)
    {
        $request_user = $request->get('User');
        $form = $request->toHTMLQuickForm();
        $form->removeElementsAll();
        $form->addElement(
            'static',
            '',
            $context->plugin->_('Request sent from'),
            sprintf(
                '<a href="%3$s" title="%1$s"><img alt="" src="%2$s" width="32" /></a>',
                $request_user->getUsername(),
                $request_user->getImage(),
                $this->url->create(array('base' => '/user', 'path' => '/' . $request_user->getId()))
            )
        );
        $form->addElement('static', '', $context->plugin->_('Message'), h($request->get('message')));
        $form->addSubmitButtons(
            $context->plugin->_('Accept'),
            sprintf(
                '<a href="%s">%s</a>',
                $this->url->create(array(
                    'base' => '/user',
                    'params' => array('tab_id' => $context->request->getAsInt('tab_id'))
                )),
                $context->plugin->_('Cancel')
            )
        );
        $form->useToken();
        return $form;
    }
}