<?php
class Plugg_User_Main_Identity_Friend extends Plugg_RoutingController
{
    public function __construct()
    {
        parent::__construct('Index', 'Plugg_User_Main_Identity_Friend_', dirname(__FILE__) . '/Friend');
        $this->addFilter('_isValidUserAccess');
        $this->addControllerFilter('SendRequest', '_isValidOwnerAccess');
        $this->addControllerFilter(array('Edit', 'Remove'), '_isValidFriendRequested');
    }

    protected function _isValidFriendRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        // Make sure the requested message exists and belongs to the user
        $identity = $this->_parent->getRequestedUserIdentity($context);
        if ((!$friend = $this->getRequestedFriend($context)) ||
            !$friend->isOwnedBy($identity)
        ) {
            $context->response
                ->setError($context->plugin->_('Invalid request'))
                ->send($this->_application);
        }
    }

    protected function _isValidFriendRequestedAfterFilter(Sabai_Application_Context $context){}

    protected function _isValidUserAccessBeforeFilter(Sabai_Application_Context $context)
    {
        if (!$context->plugin->getParam('useFriendsFeature')) {
            $context->response
                ->setError($context->plugin->_('Invalid request'))
                ->send($this->_application);
        }

        // Check permission if trying to access other user's messages
        $identity = $this->getRequestedUserIdentity($context);
        if ($identity->getId() != $context->user->getId()) {
            if (!$context->user->hasPermission('user friend view any')) {
                $context->response
                    ->setError($context->plugin->_('Permission denied'))
                    ->send($this->_application);
            }
        }
    }

    protected function _isValidUserAccessAfterFilter(Sabai_Application_Context $context){}

    protected function _isValidOwnerAccessBeforeFilter(Sabai_Application_Context $context)
    {
        // Make sure only the user profile owner can access
        $identity = $this->getRequestedUserIdentity($context);
        if ($identity->getId() != $context->user->getId()) {
            $context->response
                ->setError($context->plugin->_('Permission denied'))
                ->send($this->_application);
        }
    }

    protected function _isValidOwnerAccessAfterFilter(Sabai_Application_Context $context){}

    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'request' => array(
                'controller' => 'SendRequest'
            ),
            'request/:request_id' => array(
                'controller' => 'Request',
                'requirements' => array(':request_id' => '\d+')
            ),
            ':friend_id/remove'   => array(
                'controller' => 'Remove',
                'requirements' => array(':friend_id' => '\d+')
            ),
            ':friend_id/edit'   => array(
                'controller' => 'Edit',
                'requirements' => array(':friend_id' => '\d+')
            ),
        );
    }

    public function getRequestedFriend(Sabai_Application_Context $context, $clearCache = false)
    {
        if ($id = $context->request->getAsInt('friend_id')) {
            if ($friend = $context->plugin->getModel()->Friend->fetchById($id, $clearCache)) {
                $friend->cache();
                return $friend;
            }
        }
        return false;
    }
}