<?php
class Plugg_Locale_Admin_EditPluginMessagesForm extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        // check if valid request
        if (!$plugin = $this->_getRequestedPlugin($context)) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        
        $plugin_name = $plugin->getName();       
        $model = $context->plugin->getModel();
        $token_param = '_TOKEN';
        $token_name = 'locale_messages_submit';
        
        // load custom messages
        $pages = $model->Message
            ->criteria()
            ->plugin_is($plugin_name)
            ->lang_is(SABAI_LANG)
            ->paginate(50);
        $page = $pages->getValidPage($context->request->getAsInt('page', 1));
        $custom = $custom_ids = array();
        foreach ($page->getElements() as $message) {
            $custom[$message->get('key')] = $message->get('localized');
            $custom_ids[] = $message->getId();
        }
        
        // load original messages
        $original = $this->_getPluginOriginalMessages($plugin, $context);
        
        // submit
        if ($context->request->isPost() && $this->_parent->validateToken($token_param, $token_name, $context)) {
            if ($submitted = $context->request->getAsArray('messages')) {
                // delete retrieved custom messages first
                if (empty($custom_ids) || false !== $model->getGateway('Message')->deleteByIds($custom_ids)) {
                    if (false !== $saved = $this->_parent->saveMessages($submitted, $original, $plugin_name, $model)) {
                        // cache messages
                        $this->gettext->updateCachedMessages(array_merge($original, $saved), $plugin_name);
                        $context->response->setSuccess($context->plugin->_('Locale messages updated successfully'));
                        return;
                    }
                }
            }
        }
        
        if ($plugin->isClone()) {
            $context->response->setPageInfo(sprintf('%s - %s(%s)', $plugin->getNicename(), $plugin->getLibrary(), $plugin_name));
        } else {
            $context->response->setPageInfo(sprintf('%s - %s', $plugin->getNicename(), $plugin->getLibrary()));
        }
        $context->response->setVars(array(
            'original_messages' => $original,
            'pages' => $pages,
            'custom_messages' => $custom,
            'token_param' => $token_param,
            'token_name' => $token_name
        ));
    }
    
    function _getPluginOriginalMessages($plugin, Sabai_Application_Context $context)
    {
        // Reload messages without using cache
        $this->gettext->loadMessages($plugin->getName(), $plugin->getLibrary() . '.mo', false);
        return $this->gettext->getMessages($plugin->getName());
    }
    
    function _getRequestedPlugin(Sabai_Application_Context $context)
    {
        if ($plugin_name = $context->request->getAsStr('plugin_name')) {
            if (($plugin = $this->pluginManager->getPlugin($plugin_name)) && $plugin->hasLocale()) {
                return $plugin;
            }
        }
        return false;
    }
}