<?php
class Plugg_Xigg_Admin_Node extends Plugg_RoutingController
{
    public function __construct()
    {
        parent::__construct('List', 'Plugg_Xigg_Admin_Node_', dirname(__FILE__) . '/Node');
        $this->addControllerFilter(array('Comment', 'Trackback', 'Vote', 'Update', 'Delete', 'Details'), '_isValidNodeRequested');
    }

    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->setCurrentTab('node');
        $context->response->setPageInfo($context->plugin->_('Article administration'), array(
            'path' => '/node'
        ));
        return array(
            'list' => array('controller' => 'List'),
            'submit' => array('controller' => 'Submit'),
            ':node_id/comment' => array(
                'controller'   => 'Comment',
                'requirements' => array(
                    ':node_id' => '\d+'
                )
            ),
            ':node_id/trackback' => array(
                'controller'   => 'Trackback',
                'requirements' => array(
                    ':node_id' => '\d+'
                )
            ),
            ':node_id/vote' => array(
                'controller'   => 'Vote',
                'requirements' => array(
                    ':node_id' => '\d+'
                )
            ),
            ':node_id/edit' => array(
                'controller'   => 'Update',
                'requirements' => array(
                    ':node_id' => '\d+'
                )
            ),
            ':node_id/delete' => array(
                'controller'   => 'Delete',
                'requirements' => array(
                    ':node_id' => '\d+'
                )
            ),
            ':node_id' => array(
                'controller'   => 'Details',
                'requirements' => array(
                    ':node_id' => '\d+'
                )
            )
        );
    }

    protected function _isValidNodeRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        $node = $this->_parent->isValidEntityRequested($context, 'Node', 'node_id');
        $context->response->setPageInfo($node->title, array(
            'path' => '/node/' . $node->getId()
        ));
        $context->response->setVars(array(
            'node_id' => $node->getId(),
            'node' => $node
        ));
    }

    protected function _isValidNodeRequestedAfterFilter(Sabai_Application_Context $context){}

    public function getRequestedNode(Sabai_Application_Context $context, $entityIdVar = null, $noCache = false)
    {
        return $this->_parent->getRequestedEntity($context, 'Node', $entityIdVar, $noCache);
    }
}