<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_Node_ShowCommentForm extends Plugg_FormController
{
    private $_comment;
    private $_node;

    protected function _init(Sabai_Application_Context $context)
    {
        if ((!$this->_node = $this->_parent->getNodeById($context, 'node_id')) ||
            !$this->_node->isReadable($context->user)
        ) {
            return false;
        }
        if (!$this->_node->allow_comments) {
            $context->response->setError($context->plugin->_('Comments not allowed for this news article'), array(
                'path' => '/' . $this->_node->getId(),
            ));
            return false;
        }
        $this->_comment = $this->_node->createComment();

        return true;
    }

    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowCommentForm', array($context, $form, /*$isReply*/ true));
        $context->response->setPageInfo($this->_node->title, array('path' => '/' . $this->_node->getId()));
        $context->response->setPageInfo($context->plugin->_('Submit comment'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_comment->toHTMLQuickForm('', $this->url->create(array(
            'path' => '/' . $this->_node->getId() . '/comment'))
        );
        $form->removeElements(array('Node', 'body_html', 'allow_edit'));
        $form->setDefaults(array(
            'title' => 'Re: ' . trim($this->_node->title),
            'body' => "\n\n" . strtr("\n" . $this->_node->body, array("\n>" => "\n>>", "\n" => "\n> "))
        ));
        return $form;
    }
}