<?php
class Plugg_Xigg_Main_Node_ShowComments extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        if ((!$node = $this->_parent->getNodeById($context, 'node_id')) ||
            !$node->isReadable($context->user)
        ) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        $comment_view = $context->request->getAsStr('comment_view');
        $comment_perpage = $context->plugin->getParam('numberOfCommentsOnPage');
        switch ($comment_view) {
            case 'nested':
                $pages = $node->paginateCommentsByParentComment('NULL', $comment_perpage, false);
                break;
            case 'newest':
                $pages = $node->paginateComments($comment_perpage, 'comment_created', 'DESC');
                break;
            case 'oldest':
            default:
                $pages = $node->paginateComments($comment_perpage, 'comment_created', 'ASC');
                $comment_view = 'oldest';
                break;
        }
        $page = $pages->getValidPage($context->request->getAsInt('comment_page', 1));
        $comment_form_show = false;
        if ($node->get('allow_comments')) {
            if ($context->user->isAuthenticated() ||
                $context->plugin->getParam('guestCommentsAllowed')
            ) {
                $comment_form_show = true;
            }
        }
        $context->response->setVars(array(
            'node'              => $node,
            'comment_pages'     => $pages,
            'comment_page'      => $page,
            'comment_form_show' => $comment_form_show,
            'comment_view'      => $comment_view,
            'comments'          => $comments = $page->getElements()->with('UserWithData'),
            'comment_ids'       => $comments->getAllIds()
        ));
    }
}