<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_Node_PublishNodeForm extends Plugg_FormController
{
    private $_node;

    protected function _init(Sabai_Application_Context $context)
    {
        $this->_confirmable = false;

        if ((!$this->_node = $this->_parent->getNodeById($context, 'node_id')) ||
            !$this->_node->isReadable($context->user)
        ) {
            return false;
        }
        if (!$context->user->hasPermission('xigg publish any')) {
            if (!$this->_node->isOwnedBy($context->user) || !$context->user->hasPermission('xigg publish own')) {
                $context->response->setError($context->plugin->_('Permission denied'), array('path' => '/' . $this->_node->getId()));
                return false;
            }
        }

        return true;
    }

    protected function _confirmForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_node->applyForm($form);
        $this->_node->assignUser($context->user);
    }

    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_node->publish();
        if ($this->_node->commit()) {
            $context->response->setSuccess($context->plugin->_('News article published successfully'), array('path' => '/' . $this->_node->getId()));

            return true;
        }

        return false;
    }

    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowNodeForm', array($context, $form, /*$isEdit*/ true));
        $context->response->setPageInfo($context->plugin->_('Publish article'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_node->toHTMLQuickForm();
        $form->removeElementsAll();
        return $form;
    }
}