<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_Node_ShowVoteForm extends Plugg_FormController
{
    private $_node;

    protected function _init(Sabai_Application_Context $context)
    {
        $this->_confirmable = false;
        
        if ((!$this->_node = $this->_parent->getNodeById($context, 'node_id')) ||
            !$this->_node->isReadable($context->user)
        ) {
            return false;
        }
        
        $this->_tokenId = 'Vote_submit_' . $this->_node->getId();
        
        return true;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $context->response->setPageInfo($this->_node->title, array('path' => '/' . $this->_node->getId()));
        $context->response->setPageInfo($context->plugin->_('Submit vote'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_node->createVote()->toHTMLQuickForm('', $this->url->create(array(
            'path' => '/' . $this->_node->getId() . '/vote'
        )));
        $form->removeElements(array('Node', 'ip', 'score'));
        return $form;
    }
}