<?php
class Plugg_Xigg_Main_ShowCommentReplies extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        if (!$comment_id = $context->request->getAsInt('comment_id', false)) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        if (!$comment = $context->plugin->getModel()->Comment->fetchById($comment_id)) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        if (!$comment->Node->isReadable($context->user)) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        $comment_form_show = false;
        if ($comment->Node->allow_comments) {
            if ($context->user->isAuthenticated() ||
                $context->plugin->getParam('guestCommentsAllowed')
            ) {
                $comment_form_show = true;
            }
        }
        $context->response->setVars(array(
            'node' => $comment->Node,
            'comment' => $comment,
            'comment_replies' => $comment->descendantsAsTree()->with('UserWithData'),
            'comment_form_show' => $comment_form_show
        ));
    }
}