<?php
require_once 'Plugg/PluginAdmin.php';

class Plugg_User_Admin extends Plugg_PluginAdmin
{
    public function __construct()
    {
        parent::__construct(__CLASS__ . '_', dirname(__FILE__) . '/Admin');
    }
    
    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->addTabs(array(
            'user' => array(
                'title' => $context->plugin->_('Users')
            ),
            'role' => array(
                'title' => $context->plugin->_('Roles'),
                'url' => array('path' => '/role')
            ),
            'auth' => array(
                'title' => $context->plugin->_('Authentications'),
                'url' => array('path' => '/auth')
            ),
            'field' => array(
                'title' => $context->plugin->_('Fields'),
                'url' => array('path' => '/field')
            ),
            'widget' => array(
                'title' => $context->plugin->_('Widgets'),
                'url' => array('path' => '/widget')
            ),
            'tab' => array(
                'title' => $context->plugin->_('Tabs'),
                'url' => array('path' => '/tab')
            ),
            'menu' => array(
                'title' => $context->plugin->_('Menu'),
                'url' => array('path' => '/menu')
            ),
            'queue' => array(
                'title' => $context->plugin->_('Queues'),
                'url' => array('path' => '/queue')
            ),
            'autologin' => array(
                'title' => $context->plugin->_('Autologins'),
                'url' => array('path' => '/autologin')
            )
        ));
        $routes = array(
            'role' => array('controller' => 'Role'),
            'submit' => array('controller' => 'Submit'),
            'field' => array('controller' => 'Field'),
            'tab' => array('controller' => 'Tab'),
            'auth' => array('controller' => 'Auth'),
            'widget' => array('controller' => 'Widget'),
            'menu' => array('controller' => 'Menu'),
            'queue' => array('controller' => 'Queue'),
            'autologin' => array('controller' => 'Autologin'),
        );
        return $routes;
    }
}