// Accelerator Table class - Copyright(C) 2003 minamina

//

//////////////////////////////////////////////////////////////////////



#if !defined(AFX_ACCELERATOR_TABLE_H__4F92F354_5630_44E1_8B3D_AF57A8A84BD3__INCLUDED_)

#define AFX_ACCELERATOR_TABLE_H__4F92F354_5630_44E1_8B3D_AF57A8A84BD3__INCLUDED_



#if _MSC_VER > 1000

#pragma once

#endif // _MSC_VER > 1000



#pragma warning (disable : 4786)

#pragma warning (push, 1)

#include <vector>

#include <string>

#include <map>

#include <set>

#pragma warning (pop)



class CAcceleratorTable  

{

private:

	void SetMenuString(const HMENU& hMenu, const UINT& nPos, const std::string& menuString);

	inline void TrimComment(std::string& str, const TCHAR& delim);

	inline void TrimSpace(std::string& str);

	void ClearShortcutList();

	typedef std::set<HWND> TARGET_WINDOW_LIST;

	TARGET_WINDOW_LIST m_targetWindowList;

	void DestroyAcceleratorTable();

	bool IsValid();

	HACCEL m_hAccel;

	std::string ToLower(const std::string& inputString);

	void LoadVirtualKeyMap();

	void AddVirtualKey(const std::string& virtualKeyString, const WORD& wVirtualKeyCode);

	const std::vector<std::string> SplitShortcut(const std::string& shortcutString);

//	void LoadDefaultAcceleratorList();



	typedef struct tagACCELERATOR

	{

		WORD wCommand;

		std::vector<std::string> shortcutList;

		std::string captionString;

	} ACCELERATOR;



	typedef std::map<std::string, ACCELERATOR> ACCELERATOR_LIST;



	ACCELERATOR_LIST m_acceleratorList;

	std::map<std::string, WORD> m_virtualKeyMap;

	const ACCELERATOR* FindAccelerator(const WORD& wCommand);

	const std::string GetMenuCaptionWithShortcut(const ACCELERATOR& accelerator);



public:

	void ModifyMenuCaption(HMENU hMenu);

	void AddTargetWindow(const HWND hWnd);

	bool Load(const std::string& filenameString, const std::string& sectionName);

	bool Save(const std::string& filenameString, const std::string& sectionName);

	bool CreateAcceleratorTable();

	void AddAccelerator(const std::string& nameString, const WORD& wCommand, const std::string& shortcutString, const std::string& captionString);

	void DeleteAll();

	bool TranslateAccelerator(HWND hWnd, MSG* pMsg);

	CAcceleratorTable();

	virtual ~CAcceleratorTable();

};



#endif // !defined(AFX_ACCELERATOR_TABLE_H__4F92F354_5630_44E1_8B3D_AF57A8A84BD3__INCLUDED_)

