// Background Bitmap List View class - Copyright(C) 2003 minamina

//

//////////////////////////////////////////////////////////////////////



#include "stdafx.h"

#include <assert.h>

#include "BitmapListView.h"

#include "MemoryDC.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



#define BITMAP_LIST_VIEW_TEXT_OFFSET (4)



/////////////////////////////////////////////////////////////////////////////

// CBitmapListView



IMPLEMENT_DYNCREATE(CBitmapListView, CListView)



CBitmapListView::CBitmapListView()

{

}



CBitmapListView::~CBitmapListView()

{

}



BEGIN_MESSAGE_MAP(CBitmapListView, CListView)

	//{{AFX_MSG_MAP(CBitmapListView)

	ON_NOTIFY(HDN_ENDTRACKA, 0, OnEndtrack)

	ON_WM_ERASEBKGND()

	ON_NOTIFY(HDN_ENDTRACKW, 0, OnEndtrack)

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CBitmapListView bZ[W nh



// I[i[h[

void CBitmapListView::DrawItem(LPDRAWITEMSTRUCT /*lpDrawItemStruct*/)

{

	// Ǝ`KvȂߍ폜

}



void CBitmapListView::MeasureItem(LPMEASUREITEMSTRUCT /*lpMeasureItemStruct*/)

{

	// ƎvZKvȂߍ폜

}



// wi摜t@Cw

bool CBitmapListView::SetBkImage(LPCTSTR lpszzFilename)

{

	assert(m_hWnd != NULL);



	bool bResult = false;



	HDC hDC = ::GetDC(m_hWnd);

	bResult = m_bkBitmapDC.CreateFromBitmap(hDC, lpszzFilename);

	::ReleaseDC(m_hWnd, hDC);



	return bResult;

}



// wi摜\[Xw

bool CBitmapListView::SetBkImage(WORD wResourceID)

{

	assert(m_hWnd != NULL);



	bool bResult = false;



	HDC hDC = ::GetDC(m_hWnd);

	bResult = m_bkBitmapDC.CreateFromBitmap(hDC, ::AfxGetInstanceHandle(), wResourceID);

	::ReleaseDC(m_hWnd, hDC);



	return bResult;

}



// wirbg}bv`

void CBitmapListView::DrawMemoryBitmap(CDC* pDC)

{

	if (HasBkBitmap())

	{

		CRect clientRect;

		GetClientRect(&clientRect);



		static int nOldClientWidth = -1;

		static int nOldClientHeight = -1;

		int nClientWidth = clientRect.Width();

		int nClientHeight = clientRect.Height();

		if (nClientWidth != nOldClientWidth || nClientHeight != nOldClientHeight)

		{

			m_bkMemDC.Create(pDC->GetSafeHdc(), nClientWidth, nClientHeight);



			nOldClientWidth = nClientWidth;

			nOldClientHeight = nClientHeight;

		}



		if (m_bkMemDC.IsValid())

		{

			CRect rootRect(0, 0, 0, 0);

			if (GetListCtrl().GetItemRect(0, &rootRect, LVIR_BOUNDS) == 0)

			{

				GetListCtrl().GetHeaderCtrl()->GetItemRect(0, &rootRect);

				rootRect.top = rootRect.bottom;

			}

			rootRect.left = -GetScrollPos(SB_HORZ);



			// ^Cɕ`悷

			int nX, nY, nBitmapWidth, nBitmapHeight;

			nBitmapWidth = m_bkBitmapDC.GetBitmap().bmWidth;

			nBitmapHeight = m_bkBitmapDC.GetBitmap().bmHeight;

			for (nY = rootRect.top; nY < clientRect.bottom; nY += nBitmapHeight)

			{

				for (nX = rootRect.left; nX < clientRect.right; nX += nBitmapWidth)

				{

					::BitBlt(m_bkMemDC.GetDC(), nX, nY, nBitmapWidth, nBitmapHeight,

						m_bkBitmapDC.GetDC(), 0, 0, SRCCOPY);

				}

			}

		}

	}

}



// wb_[TCYύXĕ`

void CBitmapListView::OnEndtrack(NMHDR* /*pNMHDR*/, LRESULT* pResult) 

{

//	HD_NOTIFY *phdn = (HD_NOTIFY *) pNMHDR;

//	if (HasBkBitmap())

	{

		GetListCtrl().Invalidate(TRUE);

	}



	*pResult = 0;

}



// wihԂ

// modified by isr-san

BOOL CBitmapListView::OnEraseBkgnd(CDC* pDC) 

{

/*	CRect clientRect;

	GetClientRect(&clientRect);



	CListCtrl* pList = &GetListCtrl();



	// h~

	bool bSetRgn = false;

	int nTopIndex = pList->GetTopIndex();

	int nCountPerPage = pList->GetCountPerPage();

	if (nCountPerPage > 0)

	{

		CRect topRect, lastRect;

		if (pList->GetItemRect(nTopIndex, &topRect, LVIR_BOUNDS) != 0)

		{

			if (pList->GetItemRect(nTopIndex + nCountPerPage - 1, &lastRect, LVIR_BOUNDS) != 0)

			{

				CRect allItemRect = topRect;

				allItemRect.bottom = lastRect.bottom;

				CRgn rgn;

				if (rgn.CreateRectRgnIndirect(&allItemRect) != 0)

				{

					pDC->SelectClipRgn(&rgn, RGN_DIFF);

					rgn.DeleteObject();

					bSetRgn = true;

				}

			}

		}

	}



	if (HasBkBitmap())

	{

		DrawMemoryBitmap(pDC);



		::BitBlt(pDC->GetSafeHdc(), 0, 0, clientRect.Width(), clientRect.Height(), m_bkMemDC.GetDC(), 0, 0, SRCCOPY);

		if (bSetRgn)

		{

			pDC->SelectClipRgn(NULL);

			bSetRgn = false;

		}



		// Windows 2000 ȂǂŃwb_Rg[ƃgbvACe̊Ԃɏo錄ԑΉ

		CRect headerRect(0, 0, 0, 0);

		pList->GetHeaderCtrl()->GetItemRect(0, &headerRect);

		CRect topItemRect(0, 0, 0, 0);

		if (pList->GetItemRect(pList->GetTopIndex(), &topItemRect, LVIR_BOUNDS) != 0)

		{

			if (topItemRect.top > headerRect.bottom)

			{

				CRect spaceRect = clientRect;

				spaceRect.top = headerRect.bottom;

				spaceRect.bottom = topItemRect.top;

				pDC->FillSolidRect(&spaceRect, pList->GetBkColor());

			}

		}

	}

	else

	{

		pDC->FillSolidRect(&clientRect, pList->GetBkColor());

		if (bSetRgn)

		{

			pDC->SelectClipRgn(NULL);

			bSetRgn = false;

		}

	}



	return TRUE;

//	return CListView::OnEraseBkgnd(pDC);*/

 

	CRect clientRect;

    GetClientRect(&clientRect);



    CListCtrl* pList = &GetListCtrl();



    // h~

    bool bSetRgn = false;

    int nItemCount = pList->GetItemCount();

    int nTopIndex  = pList->GetTopIndex();

    int nCountPerPage = pList->GetCountPerPage();

    int nDrawnItems = nTopIndex < nCountPerPage ? nItemCount : nCountPerPage;

    if (nCountPerPage > 0)

    {

        CRect topRect, lastRect;

        if (pList->GetItemRect(nTopIndex, &topRect, LVIR_BOUNDS) != 0)

        {

            if (pList->GetItemRect(nTopIndex + nCountPerPage - 1, &lastRect,

                LVIR_BOUNDS) != 0)

            {

                CRect allItemRect = topRect;

                allItemRect.bottom = lastRect.bottom;

                CRgn rgn;

                if (rgn.CreateRectRgnIndirect(&allItemRect) != 0)

                {

                    pDC->SelectClipRgn(&rgn, RGN_DIFF);

                    rgn.DeleteObject();

                    bSetRgn = true;

                }

            }

        }

    }



    if (HasBkBitmap())

    {

        DrawMemoryBitmap(pDC);



        if (!nItemCount)

        {

            ::BitBlt(pDC->GetSafeHdc(),0, 0,

                clientRect.Width(), clientRect.Height(), m_bkMemDC.GetDC(),

                0, 0, SRCCOPY);

            if (bSetRgn)

            {

                pDC->SelectClipRgn(NULL);

                bSetRgn = false;

            }

            return TRUE ;

        }



        CRect itemRect ;

        pList->GetItemRect(nTopIndex, &itemRect, LVIR_BOUNDS);

        if (nTopIndex + nCountPerPage >= nItemCount)

        {

            GetClientRect(&clientRect);

            pList->GetItemRect(nTopIndex + nDrawnItems - 1, &itemRect, LVIR_BOUNDS);

            clientRect.top = itemRect.bottom;

        }



        ::BitBlt(pDC->GetSafeHdc(), clientRect.left, clientRect.top,

                clientRect.Width(), clientRect.Height(), m_bkMemDC.GetDC(),

                clientRect.left, clientRect.top, SRCCOPY);





        // draw right half if we need to

        if (itemRect.right < clientRect.right)

        {

            GetClientRect(&clientRect);

            clientRect.left = itemRect.right;

            ::BitBlt(pDC->GetSafeHdc(), clientRect.left, clientRect.top,

                clientRect.Width(), clientRect.Height(), m_bkMemDC.GetDC(),

                clientRect.left, clientRect.top, SRCCOPY);

        }



        if (bSetRgn)

        {

            pDC->SelectClipRgn(NULL);

            bSetRgn = false;

        }



        // Windows 2000 ȂǂŃwb_Rg[ƃgbvACe̊Ԃɏo錄ԑΉ

        CRect headerRect(0, 0, 0, 0);

        pList->GetHeaderCtrl()->GetItemRect(0, &headerRect);

        CRect topItemRect(0, 0, 0, 0);

        if (pList->GetItemRect(pList->GetTopIndex(), &topItemRect, LVIR_BOUNDS) != 0)

        {

            GetClientRect(&clientRect);

            if (topItemRect.top > headerRect.bottom)

            {

                CRect spaceRect = clientRect;

                spaceRect.top = headerRect.bottom;

                spaceRect.bottom = topItemRect.top;

                pDC->FillSolidRect(&spaceRect, pList->GetBkColor());

            }

        }

    }

    else

    {

        if (!nItemCount)

        {

            pDC->FillSolidRect(&clientRect, pList->GetBkColor());

            if (bSetRgn)

            {

                pDC->SelectClipRgn(NULL);

                bSetRgn = false;

            }

            return TRUE ;

        }



        CRect itemRect ;

        pList->GetItemRect(nTopIndex, &itemRect, LVIR_BOUNDS);

        //  draw top portion

        GetClientRect(&clientRect);

        pList->GetItemRect(nTopIndex, &itemRect, LVIR_BOUNDS);

        clientRect.bottom = itemRect.top;

        pDC->FillSolidRect(&clientRect, pList->GetBkColor());



        //  draw bottom portion if we have to

        if (nTopIndex + nCountPerPage >= nItemCount)

        {

            GetClientRect(&clientRect);

            pList->GetItemRect(nTopIndex + nDrawnItems - 1, &itemRect, LVIR_BOUNDS);

            clientRect.top = itemRect.bottom;

            pDC->FillSolidRect(&clientRect, pList->GetBkColor());

        }



        //  draw right half if we need to

        if (itemRect.right < clientRect.right)

        {

            GetClientRect(&clientRect);

            clientRect.left = itemRect.right;

            pDC->FillSolidRect(&clientRect, pList->GetBkColor());

        }





        if (bSetRgn)

        {

            pDC->SelectClipRgn(NULL);

            bSetRgn = false;

        }

    }



    return TRUE;

    // return CListView::OnEraseBkgnd(pDC);

}



BOOL CBitmapListView::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 

{

	CListCtrl* pList = &GetListCtrl();

	LPNMHDR lpNmhdr = (LPNMHDR)lParam;

	if (lpNmhdr->hwndFrom == pList->GetHeaderCtrl()->GetSafeHwnd())

	{

		switch (lpNmhdr->code)

		{

		case HDN_DIVIDERDBLCLICKW:

		case HDN_DIVIDERDBLCLICKA:

			{

				if (HasBkBitmap())

				{

					pList->Invalidate(TRUE);

				}

			}

			break;

		}

	}

	

	return CListView::OnNotify(wParam, lParam, pResult);

}



bool CBitmapListView::HasBkBitmap()

{

	return m_bkBitmapDC.IsValid();

}

