// Background Bitmap Rich Edit View class - Copyright(C) 2003 minamina

//

//////////////////////////////////////////////////////////////////////



#include "stdafx.h"

#include <assert.h>

#include "BitmapRichEditView.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



/////////////////////////////////////////////////////////////////////////////

// CBitmapRichEditView



CBitmapRichEditView::CBitmapRichEditView() : m_bThumbScroll(false), m_nClipLeft(0), m_bKeyDown(false)

{

}



CBitmapRichEditView::~CBitmapRichEditView()

{

}



BEGIN_MESSAGE_MAP(CBitmapRichEditView, CRichEditView)

	//{{AFX_MSG_MAP(CBitmapRichEditView)

	ON_WM_ERASEBKGND()

	ON_WM_HSCROLL()

	ON_WM_VSCROLL()

	ON_WM_PAINT()

	ON_WM_KEYDOWN()

	ON_WM_KEYUP()

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CBitmapRichEditView bZ[W nh



// \[Xwi摜ݒ

bool CBitmapRichEditView::SetBkImage(WORD wResourceID)

{

	assert(m_hWnd != NULL);



	bool bResult = false;



	HDC hDC = ::GetDC(m_hWnd);

	bResult = m_bkBitmapDC.CreateFromBitmap(hDC, ::AfxGetInstanceHandle(), wResourceID);

	::ReleaseDC(m_hWnd, hDC);



	if (HasBkBitmap())

	{

		ModifyStyleEx(0, WS_EX_TRANSPARENT);

	}

	else

	{

		ModifyStyleEx(WS_EX_TRANSPARENT, 0);

	}



	return bResult;

}



// t@C烊\[X摜ݒ

bool CBitmapRichEditView::SetBkImage(LPCTSTR lpszFilename)

{

	assert(m_hWnd != NULL);



	bool bResult = false;



	HDC hDC = ::GetDC(m_hWnd);

	bResult = m_bkBitmapDC.CreateFromBitmap(hDC, lpszFilename);

	::ReleaseDC(m_hWnd, hDC);



	if (HasBkBitmap())

	{

		ModifyStyleEx(0, WS_EX_TRANSPARENT);

	}

	else

	{

		ModifyStyleEx(WS_EX_TRANSPARENT, 0);

	}



	return bResult;

}



bool CBitmapRichEditView::HasBkBitmap()

{

	return m_bkBitmapDC.IsValid();

}



BOOL CBitmapRichEditView::OnEraseBkgnd(CDC* pDC) 

{

	if (!HasBkBitmap())

	{

		return CRichEditView::OnEraseBkgnd(pDC);

	}

	else

	{

		CRect clipBoxRect, clientRect;

		pDC->GetClipBox(&clipBoxRect);

		GetClientRect(&clientRect);



		if (!clipBoxRect.IsRectEmpty())

		{

			const int nWidth = clientRect.Width();

			const int nHeight = clientRect.Height();



			HDC hDC = pDC->GetSafeHdc();



			CMemoryDC tileDC;

			if (tileDC.Create(hDC, nWidth, nHeight))

			{

				int nLeft;

				int nTop;

				if (m_bThumbScroll)

				{

					// XN[o[hbO`悷

					SCROLLINFO si;

					si.cbSize = sizeof(SCROLLINFO);

					si.fMask = SIF_TRACKPOS;

					GetScrollInfo(SB_HORZ, &si, SIF_TRACKPOS);

					nLeft = -si.nTrackPos;

					GetScrollInfo(SB_VERT, &si, SIF_TRACKPOS);

					nTop = -si.nTrackPos;

				}

				else

				{

					nLeft = -GetScrollPos(SB_HORZ);

					nTop = -GetScrollPos(SB_VERT);

				}



				// ^Cɕ`

				int nX, nY, nBitmapWidth, nBitmapHeight;

				nBitmapWidth = m_bkBitmapDC.GetBitmap().bmWidth;

				nBitmapHeight = m_bkBitmapDC.GetBitmap().bmHeight;

				for (nY = nTop; nY < clientRect.bottom; nY += nBitmapHeight)

				{

					for (nX = nLeft; nX < clientRect.right; nX += nBitmapWidth)

					{

						::BitBlt(tileDC.GetDC(), nX, nY, nBitmapWidth, nBitmapHeight,

							m_bkBitmapDC.GetDC(), 0, 0, SRCCOPY);

					}

				}

			}



			::BitBlt(hDC, clipBoxRect.left, clipBoxRect.top, clipBoxRect.Width(), clipBoxRect.Height(),

				tileDC.GetDC(), clipBoxRect.left, clipBoxRect.top, SRCCOPY);



			if (m_nClipLeft < clipBoxRect.left)

			{

				m_nClipLeft = clipBoxRect.left;

			}

		}

	}



	return TRUE;

}



void CBitmapRichEditView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 

{

	if (!HasBkBitmap())

	{

		CRichEditView::OnHScroll(nSBCode, nPos, pScrollBar);

	}

	else

	{

		switch (nSBCode)

		{

		case SB_THUMBPOSITION:

		case SB_THUMBTRACK:

			{

				m_bThumbScroll = true;

				CRichEditView::OnHScroll(nSBCode, nPos, pScrollBar);

				m_bThumbScroll = false;

			}

			break;



		default:

			{

				CRichEditView::OnHScroll(nSBCode, nPos, pScrollBar);

			}

			break;

		}

	}

}



void CBitmapRichEditView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 

{

	if (!HasBkBitmap())

	{

		CRichEditView::OnVScroll(nSBCode, nPos, pScrollBar);

	}

	else

	{

		switch (nSBCode)

		{

		case SB_THUMBPOSITION:

		case SB_THUMBTRACK:

			{

				m_bThumbScroll = true;

				CRichEditView::OnVScroll(nSBCode, nPos, pScrollBar);

				m_bThumbScroll = false;

			}

			break;



		default:

			{

				CRichEditView::OnVScroll(nSBCode, nPos, pScrollBar);

			}

			break;

		}

	}

}



void CBitmapRichEditView::OnPaint() 

{

	CRichEditView::OnPaint();



	if (HasBkBitmap())

	{

		// ̖̈ĕ`悷

		static int nMaxClipLeft = -1;



		if (m_nClipLeft > 0)

		{

			CRect clientRect;

			GetClientRect(&clientRect);

			clientRect.right = m_nClipLeft;

			InvalidateRect(&clientRect, TRUE);



			if (m_nClipLeft > nMaxClipLeft)

			{

				nMaxClipLeft = m_nClipLeft;

			}

			m_nClipLeft = 0;

		}

		else if (m_bKeyDown)

		{

			static int nOldVertPos = -1, nOldHorzPos = -1;

			int nVertPos = GetScrollPos(SB_VERT);

			int nHorzPos = GetScrollPos(SB_HORZ);

			if (nVertPos != nOldVertPos || nHorzPos != nOldHorzPos)

			{

				if (nMaxClipLeft > 0)

				{

					CRect clientRect;

					GetClientRect(&clientRect);

					clientRect.right = clientRect.left + nMaxClipLeft;

					InvalidateRect(&clientRect, TRUE);

				}

				else

				{

					InvalidateRect(NULL, TRUE);

				}

				nOldVertPos = nVertPos;

				nOldHorzPos = nHorzPos;

			}

		}

	}

}



void CBitmapRichEditView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 

{

	if (HasBkBitmap())

	{

		m_bKeyDown = true;

	}



	CRichEditView::OnKeyDown(nChar, nRepCnt, nFlags);

}



void CBitmapRichEditView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 

{

	CRichEditView::OnKeyUp(nChar, nRepCnt, nFlags);



	if (HasBkBitmap())

	{

		m_bKeyDown = false;

	}

}



BOOL CBitmapRichEditView::PreCreateWindow(CREATESTRUCT& cs) 

{

	// I RichEdit 2.0 𗘗p

	// Windows 98 Ȃǂł RichEd20.dll OɓǂݍłKv

	m_strClass = _T("RichEdit20A");



	return CRichEditView::PreCreateWindow(cs);

}

