/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// Csv.cpp:

//

//////////////////////////////////////////////////////////////////////



#include "stdafx.h"

#include "pochy.h"

#include "Csv.h"

#include "StrTok.h"

#include "lib.h"



#ifdef _DEBUG

#undef THIS_FILE

static char THIS_FILE[]=__FILE__;

#define new DEBUG_NEW

#endif



//////////////////////////////////////////////////////////////////////

// \z/

//////////////////////////////////////////////////////////////////////



CCsv::CCsv(LPCTSTR path)

{

	if(path == NULL)

		return;

	CString buf;

	CString message;

	CStdioFile read_file;

	if(!read_file.Open(path, CFile::modeRead | CFile::typeText)){

		message.Format("%sJ܂", path);

		AfxMessageBox(message);

		return;

	}



	CStringArray tmp_array;

	buf.Empty();

	while(read_file.ReadString(buf)){

		tmp_array.Add(buf);

		buf.Empty();

	}



	m_data.RemoveAll();

	m_data.SetSize(tmp_array.GetSize());



	int start;

	int start2;

	int end;

	int max = tmp_array.GetSize();

	for(int n=0; n<max; n++){

		buf = tmp_array.GetAt(n);

		start=0;

		while((end = buf.Find(",", start)) != -1){

			// if buf include (") or (,)

			if(buf[start] == '"'){

				while(1){

					int i = CountDQuotation(buf, start, end);

					if(i%2 == 1 || i == 1){

						break;

					}else{

						start2 = end+1;

						end = buf.Find(",", start2);

						if(end == -1){

							end = buf.GetLength()-1;

							break;

						}

						continue;

					}

				}

			}

			if(buf[start] == '"'){

				CString tmp = buf.Mid(start+1, end-start-1);

				this->StripQuotation(tmp);

				m_data[n].Add(tmp);

			}else{

				m_data[n].Add(buf.Mid(start, end-start));

			}

			start = end+1;

		}

		buf = buf.Mid(start);

		buf.TrimRight();

		m_data[n].Add(buf);

	}

}



CCsv::~CCsv()

{

}



CString CCsv::GetValue(int row, int column)

{

	ASSERT(row < GetRowSize());

	ASSERT(column < GetColumnSize(row));

	return m_data[row].GetAt(column);

}



int CCsv::GetRowSize()

{

	return m_data.GetSize();

}



void CCsv::RemoveAll()

{

	m_data.RemoveAll();

}



void CCsv::AddRow(CStringArray *new_row)

{

	int size = m_data.GetSize();

	m_data.SetSize(size+1);

	int max = new_row->GetSize();

	for(int i=0; i<max; i++)

		m_data[size].Add(new_row->GetAt(i));

}



void CCsv::Save(LPCTSTR path)

{

	CString buf;

	CString data;

	CString tmp;

	data.Empty();

	buf.Empty();

	int max1 = m_data.GetSize();

	int max2;

	for(int i=0; i<max1; i++){

		max2 = m_data[i].GetSize();

		for(int j=0; j<max2; j++){

			tmp = m_data[i].GetAt(j);

			if(tmp.Find("\"") != -1 || tmp.Find(",") != -1)

				this->AddQuotation(tmp);

			if(j==0){

				buf += tmp;

			}else{

				buf += ","+tmp;

			}

		}

		data += buf+"\r\n";

		buf.Empty();

	}

	FILE* file = fopen(path, "wb");

	fwrite(data, sizeof(char), data.GetLength(), file);

	fclose(file);

}



// count number of double-quotation(") just before comma(,).

// end must be position of single-quotation(') in buf.

// if return of this function is odd, this mean this comma(,) is separation mark of csv.

int CCsv::CountDQuotation(LPCTSTR buf, int start, int end)

{

	int n=1;

	while(buf[end-n] == '"' && end-n > start){

		n++;

	}

	return n-1;

}



void CCsv::StripQuotation(CString &buf)

{

	int p=0;

	while((p = buf.Find('"', p)) != -1){

		buf.Delete(p);

		p=p+1;

	}

}



void CCsv::AddQuotation(CString &buf)

{

	BOOL flag = FALSE;

	CString tmp;



	int max = buf.GetLength();

	for(int i=0; i<max; i++){

		if(buf[i] == '"'){

			flag |= TRUE;

			tmp += "\"\"";

		}else if(buf[i] == ','){

			flag |= TRUE;

			tmp += buf[i];

		}else{

			tmp += buf[i];

		}

	}

	if(flag)

		buf = "\""+tmp+"\"";

}



void CCsv::SetAt(int row, int column, LPCTSTR buf)

{

	ASSERT(row < GetRowSize());

	ASSERT(column < GetColumnSize(row));

	m_data[row].SetAt(column, buf);

}



void CCsv::RemoveAt(int row, int column)

{

	ASSERT(row < GetRowSize());

	ASSERT(column < GetColumnSize(row));

	m_data[row].RemoveAt(column);

}



void CCsv::RemoveRow(int row)

{

	ASSERT(row < GetRowSize());

	m_data.RemoveAt(row);

}



int CCsv::GetColumnSize(int row)

{

	ASSERT(row < GetRowSize());

	return m_data[row].GetSize();

}



void CCsv::AddColumn(int row, LPCTSTR buf)

{

	ASSERT(row < GetRowSize());

	m_data[row].Add(buf);

}