/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// Filter.cpp: CFilter

//

//////////////////////////////////////////////////////////////////////



#include "stdafx.h"

#include "Pochy.h"

#include "Filter.h"



#include "FetchMail.h"

//#include "direct.h"			// _mkdir

#include "HeaderInfo.h"

#include "lib.h"

#include "_regex.h"



#ifdef _DEBUG

#undef THIS_FILE

static char THIS_FILE[]=__FILE__;

#define new DEBUG_NEW

#endif





//////////////////////////////////////////////////////////////////////

// \z/

//////////////////////////////////////////////////////////////////////



CFilter::CFilter(LPCTSTR path)

{

	m_data.SetSize(0);

	SetPath(path);

	SetData();

}



CFilter::CFilter()

{



}



CFilter::~CFilter()

{



}



// analyze ocntent of variable, return apropriate path.

void CFilter::GetPath(CHeaderInfo &hi, CStringArray &path_array)

{

	CString buf;



	path_array.RemoveAll();



	if(m_data.GetSize() == 0){

		buf.Empty();

		path_array.Add(buf);

		return;

	}



	Find(hi, path_array);

	if(path_array.GetSize() == 0){

		buf.Empty();

		path_array.Add(buf);

	}

}



BOOL CFilter::SetData()

{

	CString message;

	CString buf;

	CString tmp;

	CStdioFile ReadFile;

	int i, j;



	regex_t reg; // for regex

	regmatch_t pmatch[4]; // result of regexec is put into this



	m_data.RemoveAll();



	if(!ReadFile.Open(m_path + "\\filter", CFile::modeRead | CFile::typeText)){

#if 0 // if filter file does not exist, create.

		message.Format("CFilter: cannot open %s", m_path + "\\filter");

		AfxMessageBox(message);

		return FALSE;

#else

		g_string2file(FILTER_INSTRUCTION, m_path + "\\filter"); // create filter file.

		if(!ReadFile.Open(m_path + "\\filter", CFile::modeRead | CFile::typeText)){

			message.Format("CFilter: cannot open %s", m_path + "\\filter");

			AfxMessageBox(message);

			return -1;

		}

#endif

	}



	i=0;

	while(FALSE != ReadFile.ReadString(buf)){

		if(buf.Find("!") == 0) continue;

		else if(buf.Find("#") == 0) continue;

		else if(buf == "\r\n") continue;



		buf.TrimLeft();

		buf.TrimRight();

		m_data.SetSize(m_data.GetSize()+1);



		regcomp(&reg, "^(.?):?([\\\|][^/:\*\?\"<>\|]+)$", REG_EXTENDED | REG_NEWLINE | REG_ICASE);

		if(0 == regexec(&reg, buf, 3, pmatch, 0)){

			tmp = buf.Mid(pmatch[2].rm_so, pmatch[2].rm_eo-pmatch[2].rm_so);

			m_data[i].path = tmp;

			tmp = buf.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);

			if(strcmp(tmp, "c") == 0){

				m_data[i].copy = TRUE;

			}else{

				m_data[i].copy = FALSE;

			}

		}else{

			message.Format("%s ͕spathł", buf);

			AfxMessageBox(message);

			tmp.Empty();

			m_data[i].path = tmp;

			m_data[i].copy = FALSE;

		}

		regfree(&reg);



		regcomp(&reg, "^(.:)?(.+)=(.+)$", REG_EXTENDED | REG_NEWLINE | REG_ICASE);

		j=0;

		while(FALSE != ReadFile.ReadString(buf)){

			if(buf.Find("!") == 0) break;

			else if(buf.Find("#") == 0) break;

			else if(buf == "\r\n") break;

			buf.TrimLeft();

			buf.TrimRight();



			if(0 == regexec(&reg, buf, 4, pmatch, 0)){

				m_data[i].data.SetSize(m_data[i].data.GetSize()+1);

				m_data[i].data[j].name = buf.Mid(pmatch[2].rm_so,

					pmatch[2].rm_eo-pmatch[2].rm_so);

				m_data[i].data[j].value = buf.Mid(pmatch[3].rm_so,

					pmatch[3].rm_eo-pmatch[3].rm_so);

				tmp = buf.Mid(pmatch[1].rm_so,

					pmatch[1].rm_eo-pmatch[1].rm_so);

				tmp.TrimRight(":");

				if(strcmp(tmp, "r") == 0){

					m_data[i].data[j].regex = TRUE;

				}else if(strcmp(tmp, "n") == 0){

					m_data[i].data[j].no_case = TRUE;

				}else{

					m_data[i].data[j].regex = FALSE;

					m_data[i].data[j].no_case = FALSE;

				}

				j++;

			}

		}

		regfree(&reg);

		i++;

	}

	return TRUE;

}



void CFilter::SetPath(LPCTSTR path)

{

	m_path.Empty();

	m_path = path;

}



// analyze variable, return appropriate path for saveing mail.

void CFilter::Find(CHeaderInfo &hi, CStringArray &path_array)

{

	int i;

	int j;

	int max;

	CString buf;

	regex_t reg; // for regex

	regmatch_t pmatch[2]; // result of regexec is put into this



	path_array.RemoveAll();



	max = m_data.GetSize();

	for(i=0; i<max; i++)

	{

		for(j=0; j<m_data[i].data.GetSize(); j++)

		{

			buf = hi.GetOneLine(m_data[i].data[j].name);

			// non-ascii cannot be used in regex

			if(m_data[i].data[j].regex){

				regcomp(&reg, m_data[i].data[j].value, REG_EXTENDED | REG_NEWLINE);

				if(0 == regexec(&reg, buf, 1, pmatch, 0))

				{

					if(j == m_data[i].data.GetSize()-1)

					{

						if(!m_data[i].path.IsEmpty())

						{

							regfree(&reg);

							path_array.Add(m_path + m_data[i].path);

							if(m_data[i].copy){

								break;

							}else{

								return;

							}

						}

						else

						{

							regfree(&reg);

							buf.Empty();

							path_array.Add(buf);

							if(m_data[i].copy){

								break;

							}else{

								return;

							}

						}

					}

				}

				else

				{

					regfree(&reg);

					break;

				}

				regfree(&reg);

			}

			else

			{

				if(m_data[i].data[j].no_case)

				{

					buf.MakeLower();

					m_data[i].data[j].value.MakeLower();

				}

				if(-1 != buf.Find(m_data[i].data[j].value))

				{

					if(j == m_data[i].data.GetSize()-1)

					{

						if(!m_data[i].path.IsEmpty())

						{

							path_array.Add(m_path + m_data[i].path);

							if(m_data[i].copy){

								break;

							}else{

								return;

							}

						}

						else

						{

							buf.Empty();

							path_array.Add(buf);

							if(m_data[i].copy){

								break;

							}else{

								return;

							}

						}

					}

				}

				else

				{

					break;

				}

			}

		}

	}

}

