/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// GpgDlg.cpp : Cve[V t@C

//



#include "stdafx.h"

#include "Pochy.h"

#include "GpgDlg.h"

#include "Gpg.h"

#include "lib.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



/////////////////////////////////////////////////////////////////////////////

// CGpgDlg _CAO





CGpgDlg::CGpgDlg(CWnd* pParent /*=NULL*/)

	: CDialog(CGpgDlg::IDD, pParent)

{

	//{{AFX_DATA_INIT(CGpgDlg)

	m_key_length = -1;

	m_key_type = -1;

	//}}AFX_DATA_INIT

}





void CGpgDlg::DoDataExchange(CDataExchange* pDX)

{

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CGpgDlg)

	DDX_Control(pDX, IDC_GPG_STATUS, m_status);

	DDX_Control(pDX, IDC_GPG_KEY, m_key);

	DDX_Control(pDX, IDC_GPG_DATE2, m_date2);

	DDX_Control(pDX, IDC_GPG_DATE1, m_date1);

	DDX_Control(pDX, IDC_GPG_COMMENT, m_comment);

	DDX_Control(pDX, IDC_PASS, m_password);

	DDX_Control(pDX, IDC_MAIL_ADDRESS, m_mail_address);

	DDX_Control(pDX, IDC_GPG_REAL_NAME, m_real_name);

	DDX_Control(pDX, IDC_GPG_LIST1, m_lc);

	DDX_Radio(pDX, IDC_GPG_KEY_LENGTH, m_key_length);

	DDX_Radio(pDX, IDC_GPG_KEY_TYPE, m_key_type);

	//}}AFX_DATA_MAP

}





BEGIN_MESSAGE_MAP(CGpgDlg, CDialog)

	//{{AFX_MSG_MAP(CGpgDlg)

	ON_NOTIFY(LVN_GETDISPINFO, IDC_GPG_LIST1, OnGetdispinfoGpgList1)

	ON_CBN_SELCHANGE(IDC_GPG_DATE2, OnSelchangeGpgDate2)

	ON_BN_CLICKED(IDC_GPG_CREATE, OnGpgCreateKey)

	ON_BN_CLICKED(IDC_GPG_CLEAR1, OnGpgClear1)

	ON_BN_CLICKED(IDC_GPG_ADD_KEY, OnGpgAddKey)

	ON_BN_CLICKED(IDC_GPG_CLEAR2, OnGpgClear2)

	ON_BN_CLICKED(IDC_GPG_OPEN_KEY, OnGpgOpenKey)

	ON_BN_CLICKED(IDC_GPG_DEL, OnGpgDel)

	ON_BN_CLICKED(IDC_GPG_EXPORT, OnGpgExport)

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CGpgDlg bZ[W nh



BOOL CGpgDlg::OnInitDialog()

{

	CDialog::OnInitDialog();



	int Num;

	int ColumnWidth[] = { 175, 50, 65, 185, 75, 75 };

	char* Column[] = { "̎", "", "Mx", "O", "", "L" };

	LV_COLUMN lvc;

	lvc.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH|LVCF_SUBITEM;

	lvc.fmt = LVCFMT_LEFT;

	for(Num = 0; Num < 6; Num++){

		lvc.pszText = Column[Num];

		lvc.cx = ColumnWidth[Num];

		m_lc.InsertColumn(Num, &lvc);

	}

	m_lc.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_lc.ModifyStyle(0, LVS_SHOWSELALWAYS);



	ReDraw();



	m_key_type = 0;

	m_key_length = 1;



	m_date2.AddString("Ȃ");

	m_date2.AddString("");

	m_date2.AddString("T");

	m_date2.AddString("");

	m_date2.AddString("N");

	m_date2.SetCurSel(0);



	m_date1.SetReadOnly();



	UpdateData(FALSE);



	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂

	// O: OCX vpeB y[W̖߂l FALSE ƂȂ܂

}



void CGpgDlg::ReDraw()

{

	// Xg擾

	CGpg gpg;

	CStringArray comline;

	CString pub;

	CString out2;

	CString body;

	body = gpg.GetKeyList();



	// Xgr[ɕ\

	int i;

	SLISTSTACK list;

	CStringArray bodya;

	g_string2cstringarray(body, bodya, "\r\n", FALSE);



	m_keylist.RemoveAll();

	int max = bodya.GetSize();

	for(i=0; i<max; i++){

		CString tmps = bodya.GetAt(i);

		if(tmps.Find("pub")==0 || tmps.Find("sub")==0 || tmps.Find("sec")==0 || tmps.Find("ssb")==0){

			Str2Sliststack(tmps,list);

			TranslateKeycode(list);

			m_keylist.Add(list);

		}

	}

	TruncateSubKey();



	m_lc.DeleteAllItems();

	max = m_keylist.GetSize();

	for(i=0; i<max; i++)

		m_lc.InsertItem(m_lc.GetItemCount(),m_keylist.GetAt(i).m_str4);



	// Ԃ̐ݒ

	m_lc.SetFocus();

	m_lc.SetItemState(0,LVIS_SELECTED | LVIS_FOCUSED,-1);

}



void CGpgDlg::TranslateKeycode(SLISTSTACK& ls)

{

	if(ls.m_str4=="16"){

		if(ls.m_str1=="pub" || ls.m_str1=="sub")

			ls.m_str4="ELGamal(encrypt)";

		if(ls.m_str1=="sec" || ls.m_str1=="ssb")

			ls.m_str4="ELGamal(decrypt)";

	}

	if(ls.m_str4=="17"){

		if(ls.m_str1=="pub" || ls.m_str1=="sub")

		ls.m_str4="DSA(verify)";

		if(ls.m_str1=="sec" || ls.m_str1=="ssb")

		ls.m_str4="DSA(sign)";

	}

	if(ls.m_str4=="20"){

		if(ls.m_str1=="pub" || ls.m_str1=="sub")

			ls.m_str4="ELGamal(public)";

		if(ls.m_str1=="sec" || ls.m_str1=="ssb")

			ls.m_str4="ELGamal(secret)";

	}

	if(ls.m_str7.IsEmpty())

		ls.m_str7="-";

	if(ls.m_str2=="u")

		ls.m_str2="Ultimately";

	if(ls.m_str2=="q")

		ls.m_str2="Undefined";

	if(ls.m_str2=="f")

		ls.m_str2="Full";

	ls.m_str8 = "#"+ls.m_str8;

}



void CGpgDlg::TruncateSubKey()

{

	int i;

	int max = m_keylist.GetSize();

	for(i=0; i<max; i++){

		if(m_keylist.GetAt(i).m_str1 == "sec" || m_keylist.GetAt(i).m_str1 == "ssb"){

			for(int j=0;j<m_keylist.GetSize();j++){

				if(m_keylist.GetAt(j).m_str5 == m_keylist.GetAt(i).m_str5 && (m_keylist.GetAt(j).m_str1 == "pub" || m_keylist.GetAt(j).m_str1 == "sub")){

					m_keylist[i].m_str8 = m_keylist.GetAt(j).m_str8;

				}

			}

		}

	}

	// modified by disfolk, added to Pochy0.2.1a, 2004/03/04

	// start

	// merge sub-key records to master key records

	int nCurrentMasterKey = -1;

	for (i = 0; i < m_keylist.GetSize(); ++i)

	{

		if (m_keylist.GetAt(i).m_str1 == "pub" || m_keylist.GetAt(i).m_str1 == "sec")

		{

			nCurrentMasterKey = i;

			continue;

		}

		if (m_keylist.GetAt(i).m_str1 == "sub" ||m_keylist.GetAt(i).m_str1 == "ssb")

		{

			if (nCurrentMasterKey < 0) continue;

			m_keylist[nCurrentMasterKey].m_str4 += "/"+m_keylist.GetAt(i).m_str4;

			m_keylist.RemoveAt(i);

			i--;

		}

	}

/*

	for(i=0; i<m_keylist.GetSize(); i++){

		if(m_keylist.GetAt(i).m_str1 == "sub"){

			for(int j=0;j<m_keylist.GetSize();j++){

				if(m_keylist.GetAt(j).m_str8 == m_keylist.GetAt(i).m_str8 && m_keylist.GetAt(j).m_str1 == "pub"){

					m_keylist[j].m_str4 += "/"+m_keylist.GetAt(i).m_str4;

				}

			}

			m_keylist.RemoveAt(i);

			i--;

		}

	}

	max = m_keylist.GetSize();

//	for(i=0; i<max; i++)

//		TRACE("ID=%s\n",m_keylist.GetAt(i).m_str8);

	for(i=0; i<m_keylist.GetSize(); i++){

		if(m_keylist.GetAt(i).m_str1 == "ssb"){

			for(int j=0; j<m_keylist.GetSize(); j++){

				if(m_keylist.GetAt(j).m_str8 == m_keylist.GetAt(i).m_str8 && m_keylist.GetAt(j).m_str1 == "sec")

					m_keylist[j].m_str4 += "/"+m_keylist.GetAt(i).m_str4;

			}

			m_keylist.RemoveAt(i);

			i--;

		}

	}

*/

	// end

}



void CGpgDlg::Str2Sliststack(CString& str,SLISTSTACK& ls)

{

	int i;

	CStringArray stra;

	CString* pstr;

	CString buf;

	g_string2cstringarray(str, stra,":", FALSE);

	for(i=0;i<stra.GetSize()-1;i++){

		pstr = &ls.m_str1 + i;

		buf = stra.GetAt(i);

		*pstr = buf;

	}

}





void CGpgDlg::OnGetdispinfoGpgList1(NMHDR* pNMHDR, LRESULT* pResult)

{

/*	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ

	

	*pResult = 0;*/



	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;



	int num,max_num;

	char *buf;



	num = pDispInfo->item.iItem;

	max_num = m_keylist.GetSize();



	if(pDispInfo->item.mask & LVIF_TEXT){

		switch(pDispInfo->item.iSubItem){

			case 1:// 

				buf = m_keylist[num].m_str3.GetBuffer(0);

				break;

			case 2:// Mx

				buf = m_keylist[num].m_str2.GetBuffer(0);

				break;

			case 3:// O

				buf = m_keylist[num].m_str10.GetBuffer(0);

				break;

			case 4:// 

				buf = m_keylist[num].m_str6.GetBuffer(0);

				break;

			case 5:// L

				buf = m_keylist[num].m_str7.GetBuffer(0);

				break;

		}

		lstrcpy(pDispInfo->item.pszText, buf);

	}

	*pResult = 0;

}



void CGpgDlg::OnSelchangeGpgDate2()

{

	if(0 != m_date2.GetCurSel())

		m_date1.SetReadOnly(FALSE);

	else

		m_date1.SetReadOnly();

}



void CGpgDlg::OnGpgCreateKey()

{

//	CDialog wd;

//	wd.Create(IDD_DIALOG8,this);



	m_status.SetWindowText("쐬łB΂炭҂B");



	CString out1;

	CString out2;

	CStringArray comline;

	CString tmp;

	CString gen_info_file;

	GEN_KEY_STRUCT key_info;

	CGpg gpg;

	UpdateData();



	switch(m_key_length){

	case 0:

		key_info.Key_Length = "768";

		key_info.Subkey_Length = "768";

		break;

	case 1:

		key_info.Key_Length = "1024";

		key_info.Subkey_Length = "1024";

		break;

	case 2:

		key_info.Key_Length = "2048";

		key_info.Subkey_Length = "2048";

		break;

	}



/*	switch(m_key_type){

	case 0:

		key_info.Key_Type = "DSA";

		break;

	case 1:

		key_info.Key_Type = 

	case 2:



	}*/



	CString d;

	m_date1.GetWindowText(d);

	switch(m_date2.GetCurSel()){

	case 0:

		key_info.Expire_Date = "0";

		break;

	case 1:

		key_info.Expire_Date = d;

		break;

	case 2:

		key_info.Expire_Date = d+"w";

		break;

	case 3:

		key_info.Expire_Date = d+"m";

		break;

	case 4:

		key_info.Expire_Date = d+"y";

		break;

	}

	key_info.Key_Type = "DSA";

	key_info.Subkey_Type = "ELG-E";

	m_real_name.GetWindowText(key_info.Name_Real);

	m_comment.GetWindowText(key_info.Name_Comment);

	m_mail_address.GetWindowText(key_info.Name_Email);

	m_password.GetWindowText(key_info.Passphrase);



	if(!gpg.GenKey(&key_info)){

		m_status.SetWindowText("");

		return;

	}

	ReDraw();

	InitializeAddKey();

	m_status.SetWindowText("");

}



void CGpgDlg::InitializeAddKey()

{

	m_real_name.SetWindowText("");

	m_comment.SetWindowText("");

	m_mail_address.SetWindowText("");

	m_password.SetWindowText("");

	m_key_type = 0;

	m_key_length = 1;

	m_date1.SetWindowText("");

	m_date1.SetReadOnly();

	m_date2.SetCurSel(0);

	UpdateData(FALSE);

}



void CGpgDlg::OnGpgClear1()

{

	InitializeAddKey();	

}



void CGpgDlg::OnGpgAddKey()

{

	CString key;

	CGpg gpg;

	m_status.SetWindowText("ǉłB΂炭҂B");

	m_key.GetWindowText(key);

	if(!gpg.ImportKey(key)){

		m_status.SetWindowText("");

		return;

	}

	m_key.SetWindowText("");

	m_status.SetWindowText("");

	ReDraw();

}



void CGpgDlg::OnGpgClear2()

{

	m_key.SetWindowText("");	

}



void CGpgDlg::OnGpgOpenKey()

{

	CString path;

	CFileDialog dlg(TRUE, NULL, NULL, OFN_PATHMUSTEXIST, NULL, this);

	dlg.m_ofn.lpstrTitle = _T( "L[ǉ" );

	if(dlg.DoModal() == IDOK){

		path = dlg.GetPathName();

	}else{

		return;

	}



	CString buf;

	g_file2cstring(path, buf);

	m_key.SetWindowText(buf);

}



void CGpgDlg::OnGpgDel() 

{

	POSITION pos = m_lc.GetFirstSelectedItemPosition();

	int si;



	CGpg gpg;

	CString message;

	while(pos){

		si = m_lc.GetNextSelectedItem(pos);

		message = m_keylist[si].m_str10+"\r\n\r\n폜ĂǂłH";

		if(IDYES != AfxMessageBox(message, MB_YESNO))

			continue;

		if(m_keylist[si].m_str1 == "pub")

			gpg.DelPubKey(g_ma(m_keylist[si].m_str10));

		if(m_keylist[si].m_str1 == "sec")

			gpg.DelSecKey(g_ma(m_keylist[si].m_str10));

	}

	ReDraw();	

}



void CGpgDlg::OnGpgExport() 

{

	if(1 < m_lc.GetSelectedCount()){

		AfxMessageBox("I͂ł܂");

		return;

	}

	if(m_lc.GetSelectedCount() < 1){

		return;

	}

	CString path;

	CFileDialog dlg(FALSE, NULL, path, OFN_HIDEREADONLY, NULL, this);

	if(dlg.DoModal() == IDOK){

		path = dlg.GetPathName();

		if(g_is_there(path)){

			if(IDYES != AfxMessageBox(path+"\r\n\r\n͊ɑ݂܂B㏑Ă悢łH", MB_YESNO))

				return;

		}

		POSITION pos = m_lc.GetFirstSelectedItemPosition();

		int si = m_lc.GetNextSelectedItem(pos);

		CGpg gpg;

		CString key;



		if(m_keylist[si].m_str1 == "pub")

			key = gpg.ExportKey(g_ma(m_keylist[si].m_str10));

		if(m_keylist[si].m_str1 == "sec")

			key = gpg.ExportSecKey(g_ma(m_keylist[si].m_str10));

		g_string2file(key, path);

	}

}

