// HeaderView.cpp : Cve[V t@C

//



#include "stdafx.h"

#include "pochy.h"

#include "HeaderView.h"

#include "MainFrm.h"

#include "_regex.h"

#include "lib.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



#define HEADERVIEW_BACKGROUND_FILENAME _T("\\skin\\HeaderViewBk.bmp")



/////////////////////////////////////////////////////////////////////////////

// CHeaderView



IMPLEMENT_DYNCREATE(CHeaderView, CRichEditView)



CHeaderView::CHeaderView()

{

}



CHeaderView::~CHeaderView()

{

}





BEGIN_MESSAGE_MAP(CHeaderView, CBitmapRichEditView)

	//{{AFX_MSG_MAP(CHeaderView)

	//}}AFX_MSG_MAP

	ON_NOTIFY_REFLECT_EX(EN_LINK, OnLink)

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CHeaderView `



void CHeaderView::OnDraw(CDC* pDC)

{

	CDocument* pDoc = GetDocument();

	// TODO: ̈ʒuɕ`p̃R[hǉĂ

}



/////////////////////////////////////////////////////////////////////////////

// CHeaderView ff



#ifdef _DEBUG

void CHeaderView::AssertValid() const

{

	CRichEditView::AssertValid();

}



void CHeaderView::Dump(CDumpContext& dc) const

{

	CRichEditView::Dump(dc);

}

#endif //_DEBUG



/////////////////////////////////////////////////////////////////////////////

// CHeaderView bZ[W nh



void CHeaderView::OnInitialUpdate() 

{

	CRichEditView::OnInitialUpdate();

	CPochyApp *app = (CPochyApp *)AfxGetApp();

	

	this->GetRichEditCtrl().SetReadOnly();

	COLORREF cr = GetSysColor(COLOR_BTNFACE);

	this->GetRichEditCtrl().SetBackgroundColor(FALSE, cr);

	this->GetRichEditCtrl().SetBackgroundColor(FALSE, RGB(

				app->GetProfileInt("HeaderViewColor", "BkColorR", GetRValue(cr)),

				app->GetProfileInt("HeaderViewColor", "BkColorG", GetGValue(cr)),

				app->GetProfileInt("HeaderViewColor", "BkColorB", GetBValue(cr))));	



	LOGFONT lf;

	LPBYTE pData;

	UINT nSize;

	if(app->GetProfileBinary("HeaderViewFont", "LogFont", &pData, &nSize)){

		ASSERT(nSize == sizeof(LOGFONT));

		::CopyMemory(&lf, pData, sizeof(LOGFONT));

		delete [] pData;

	}else{

		lf.lfHeight = -12;

		lf.lfWidth = 0;

		lf.lfEscapement = 0;

		lf.lfOrientation = 0;

		lf.lfWeight = 400;

		lf.lfItalic = 0;

		lf.lfUnderline = 0;

		lf.lfStrikeOut = 0;

		lf.lfCharSet = 128;

		lf.lfOutPrecision = 3;

		lf.lfClipPrecision = 2;

		lf.lfQuality = 1;

		lf.lfPitchAndFamily = 49;

		strcpy(lf.lfFaceName, "lr SVbN");

	}

	this->SetFontEx(lf);



	// clickable url

	::SendMessage(m_hWnd, EM_AUTOURLDETECT, TRUE, 0);

	this->GetRichEditCtrl().SetEventMask(ENM_LINK);



	// wb_[r[̔wi摜ݒ

	CString strBackgroundFilePath;

	if(app->m_skin.getHeaderViewBackBmp() == ""){

		strBackgroundFilePath = app->m_app_path + HEADERVIEW_BACKGROUND_FILENAME;

	}else{

		strBackgroundFilePath = app->m_skin.getSkinIniPath() + "\\" + app->m_skin.getHeaderViewBackBmp();

	}

	SetBkImage(strBackgroundFilePath);

}



BOOL CHeaderView::PreCreateWindow(CREATESTRUCT& cs) 

{

	BOOL b = CBitmapRichEditView::PreCreateWindow(cs);

	cs.style &= ~(WS_HSCROLL);

	return b;

}



void CHeaderView::Clear()

{

	this->GetRichEditCtrl().SetWindowText(_T(""));

}



void CHeaderView::SetFontEx(LOGFONT &lf)

{

	m_font.DeleteObject();

	if(m_font.CreateFontIndirect(&lf))

		GetRichEditCtrl().SetFont(&m_font);

}



void CHeaderView::SetHeaderText(CString buf)

{

	CPochyApp *app = (CPochyApp *)AfxGetApp();

	int len = 0;

	int start, end;

	CString buf2, tmp1, tmp2;

	buf2 = buf;

	

	this->SetWindowText(_T(""));

	this->SetWindowText(buf);



	regex_t reg;

	regmatch_t pmatch[2]; 

	CString regex = "[a-z0-9\.\_\-]+@[a-z0-9\.\_\-]+";

	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);



	CHARFORMAT2 cf;

	this->GetRichEditCtrl().GetSelectionCharFormat(cf);

	cf.dwMask = CFM_LINK;

	cf.dwEffects = CFE_LINK;



	for(;;){

		if(!regexec(&reg, buf2, 2, pmatch, 0)){

			start = g_richedit_count_char(buf.Left(len+pmatch[0].rm_so));

			end = g_richedit_count_char(buf.Left(len+pmatch[0].rm_eo));

			this->GetRichEditCtrl().HideSelection(TRUE, FALSE);

			this->GetRichEditCtrl().SetSel(start, end);

			this->GetRichEditCtrl().SetSelectionCharFormat(cf);

			this->GetRichEditCtrl().SetSel(0, 0);

			this->GetRichEditCtrl().HideSelection(FALSE, FALSE);

			len += pmatch[0].rm_eo+1;

			buf2 = buf2.Mid(pmatch[0].rm_eo+1);

		}else{

			break;

		}

	}

	regfree(&reg);



	// set attribute of charactor

	this->GetRichEditCtrl().GetDefaultCharFormat(cf);

	cf.dwMask = CFM_COLOR | CFM_PROTECTED | CFM_FACE | CFM_SIZE | CFM_CHARSET | CFM_SUBSCRIPT;

	cf.crTextColor = RGB(

		app->GetProfileInt("HeaderViewColor", "TxtColorR", DEF_TXT_COLOR_R),

		app->GetProfileInt("HeaderViewColor", "TxtColorG", DEF_TXT_COLOR_G),

		app->GetProfileInt("HeaderViewColor", "TxtColorB", DEF_TXT_COLOR_B));

	cf.dwEffects = CFE_PROTECTED | CFE_SUBSCRIPT;

	this->GetRichEditCtrl().SetSel(0, -1);

	this->GetRichEditCtrl().SetSelectionCharFormat(cf);

	this->GetRichEditCtrl().HideSelection(TRUE, FALSE);

	this->GetRichEditCtrl().SetSel(0, 0);

}



BOOL CHeaderView::OnLink(NMHDR* in_pNotifyHeader, LRESULT* out_pResult)

{

	CPochyApp *app = (CPochyApp *)AfxGetApp();

	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

	CString current_account = mf->m_pAcntV->GetCurrentAccountName();



	ENLINK * pLink = (ENLINK*)in_pNotifyHeader;



	if(app->GetProfileInt("Customize", "HeaderViewSingleClick", 0)){

		if(pLink->msg == WM_LBUTTONUP && m_onlink != pLink->lParam){

			m_onlink = pLink->lParam;



			this->GetRichEditCtrl().SetSel(pLink->chrg);

			CString link = this->GetRichEditCtrl().GetSelText();

			link.MakeLower();

			if(link.Find("http:") == 0){

				CString strBrowserPath = app->GetProfileString(_T("Customize"), _T("BrowserPath"), _T(""));

				if (strBrowserPath != _T(""))

				{

					::ShellExecute(NULL, NULL, strBrowserPath, link, NULL, SW_NORMAL);

				}

				else

				{

					ShellExecute(this->GetSafeHwnd(), _T( "open" ), link, NULL, NULL, SW_NORMAL);

				}

			}else{

				// initialization.

				app->m_me.Initialize();

				// setting To

				app->m_me.SetTo(link);



				// setting From

				CString path = app->m_app_path+"\\"+current_account+"\\account.ini";

				CString address;

				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				address.ReleaseBuffer();

				app->m_me.SetFrom(address);



				// setting "cc"

				CString cc;

				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				cc.ReleaseBuffer();

				app->m_me.SetCc(cc);



				// setting "bcc"

				CString bcc;

				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				bcc.ReleaseBuffer();

				app->m_me.SetBcc(bcc);



				// setting "reply-to"

				CString reply_to;

				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				reply_to.ReleaseBuffer();

				app->m_me.SetReplyTo(reply_to);



				// getting signature.

				CString signature;

				g_file2cstring(app->m_app_path+"\\"+current_account+"\\signature", signature);

				// set main text.

				app->m_me.AddText(signature);

				// draftframe

				app->CreateDraftFrame(mf->m_pAcntV->GetCurrentAccountName());

			}

		}

	}else{

		if(pLink->msg == WM_LBUTTONDBLCLK && m_onlink != pLink->lParam){

			m_onlink = pLink->lParam;



			this->GetRichEditCtrl().SetSel(pLink->chrg);

			CString link = this->GetRichEditCtrl().GetSelText();

			link.MakeLower();

			if(link.Find("http:") == 0){

				CString strBrowserPath = app->GetProfileString(_T("Customize"), _T("BrowserPath"), _T(""));

				if (strBrowserPath != _T(""))

				{

					::ShellExecute(NULL, NULL, strBrowserPath, link, NULL, SW_NORMAL);

				}

				else

				{

					ShellExecute(this->GetSafeHwnd(), _T( "open" ), link, NULL, NULL, SW_NORMAL);

				}

			}else{

				// initialization.

				app->m_me.Initialize();

				// setting To

				app->m_me.SetTo(link);



				// setting From

				CString path = app->m_app_path+"\\"+current_account+"\\account.ini";

				CString address;

				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				address.ReleaseBuffer();

				app->m_me.SetFrom(address);



				// setting "cc" field

				CString cc;

				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				cc.ReleaseBuffer();

				app->m_me.SetCc(cc);



				// setting "bcc" field

				CString bcc;

				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				bcc.ReleaseBuffer();

				app->m_me.SetBcc(bcc);



				// setting "reply-to" field

				CString reply_to;

				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

				reply_to.ReleaseBuffer();

				app->m_me.SetReplyTo(reply_to);



				// getting signature.

				CString signature;

				g_file2cstring(app->m_app_path+"\\"+current_account+"\\signature", signature);

				// set main text.

				app->m_me.AddText(signature);

				// draftframe

				app->CreateDraftFrame(mf->m_pAcntV->GetCurrentAccountName());

			}

		}

	}

	return TRUE;

}

