/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// MailEditView.cpp : CMailEditView NX̓̒`s܂B

//



#include "stdafx.h"

#include "Pochy.h"

#include "PochyDoc.h"

#include "MailEditView.h"

#include "mainfrm.h"

#include "GpgKeyListDlg.h"

#include "lib.h"

#include "CodeConvert.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



#define MAILEDITVIEW_BACKGROUND_FILENAME _T("\\skin\\MailEditViewBk.bmp")



/////////////////////////////////////////////////////////////////////////////

// CMailEditView



IMPLEMENT_DYNCREATE(CMailEditView, CRichEditView)



BEGIN_MESSAGE_MAP(CMailEditView, CBitmapRichEditView)

	//{{AFX_MSG_MAP(CMailEditView)

	ON_WM_CHAR()

	ON_WM_KEYDOWN()

	ON_WM_RBUTTONDOWN()

	ON_COMMAND(ID_EDITVIEW_PASTE, OnEditviewPaste)

	ON_COMMAND(ID_EDITVIEW_COPY, OnEditviewCopy)

	ON_COMMAND(ID_EDITVIEW_SELALL, OnEditviewSelall)

	ON_COMMAND(ID_EDITVIEW_CUT, OnEditviewCut)

	ON_COMMAND(ID_EDITVIEW_UNDO, OnEditviewUndo)

	ON_COMMAND(ID_EDITVIEW_PASTE_QUOTATION, OnEditviewPasteQuotation)

	ON_WM_DROPFILES()

	//}}AFX_MSG_MAP

	// WR}h

	ON_COMMAND(ID_FILE_PRINT, CRichEditView::OnFilePrint)

	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRichEditView::OnFilePrint)

	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRichEditView::OnFilePrintPreview)

	ON_NOTIFY_REFLECT_EX(EN_LINK, OnLink)

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CMailEditView NX̍\z/



CMailEditView::CMailEditView()

{

}



CMailEditView::~CMailEditView()

{

}



BOOL CMailEditView::PreCreateWindow(CREATESTRUCT& cs)

{

	BOOL bPreCreated = CBitmapRichEditView::PreCreateWindow(cs);

//	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// [h bvgp\ɂ܂



	return bPreCreated;

}



/////////////////////////////////////////////////////////////////////////////

// CMailEditView NX̕`



void CMailEditView::OnDraw(CDC* pDC)

{

	CPochyDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B

}



/////////////////////////////////////////////////////////////////////////////

// CMailEditView NẌ



BOOL CMailEditView::OnPreparePrinting(CPrintInfo* pInfo)

{

	// ftHg CEditView ̈

	return CRichEditView::OnPreparePrinting(pInfo);

}



void CMailEditView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)

{

	// ftHg CEditView ňJn܂B

	CRichEditView::OnBeginPrinting(pDC, pInfo);

}



void CMailEditView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)

{

	// ftHg CEditView ̈̌㏈

	CRichEditView::OnEndPrinting(pDC, pInfo);

}



/////////////////////////////////////////////////////////////////////////////

// CMailEditView NX̐ff



#ifdef _DEBUG

void CMailEditView::AssertValid() const

{

	CRichEditView::AssertValid();

}



void CMailEditView::Dump(CDumpContext& dc) const

{

	CRichEditView::Dump(dc);

}



CPochyDoc* CMailEditView::GetDocument() /* fobO o[W̓CCłB */

{

	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPochyDoc)));

	return (CPochyDoc*)m_pDocument;

}

#endif _DEBUG



/////////////////////////////////////////////////////////////////////////////

// CMailEditView NX̃bZ[W nh



void CMailEditView::OnInitialUpdate() 

{

	CPochyApp* app = (CPochyApp*)AfxGetApp();

	CRichEditView::OnInitialUpdate();



	long lENM=GetRichEditCtrl().GetEventMask();

	lENM|=ENM_LINK;

	GetRichEditCtrl().SetEventMask(lENM);

	BOOL bEnable=1;

	::SendMessage(m_hWnd,EM_AUTOURLDETECT,bEnable,0);



	LOGFONT lf;

	LPBYTE pData;

	UINT nSize;

	if(app->GetProfileBinary("EditViewFont", "LogFont", &pData, &nSize)){

		ASSERT(nSize == sizeof(LOGFONT));

		::CopyMemory(&lf, pData, sizeof(LOGFONT));

		delete [] pData; 

	}else{

		lf.lfHeight = -16;

		lf.lfWidth = 0;

		lf.lfEscapement = 0;

		lf.lfOrientation = 0;

		lf.lfWeight = 400;

		lf.lfItalic = 0;

		lf.lfUnderline = 0;

		lf.lfStrikeOut = 0;

		lf.lfCharSet = 128;

		lf.lfOutPrecision = 3;

		lf.lfClipPrecision = 2;

		lf.lfQuality = 1;

		lf.lfPitchAndFamily = 49;

		strcpy(lf.lfFaceName, "lr SVbN");

	}

	SetFontEx(lf);



	// ftHg̕ݒ

	CHARFORMAT2 cf;

	CRichEditCtrl& r = GetRichEditCtrl();

	r.GetDefaultCharFormat(cf);



	cf.dwMask = CFM_COLOR | CFM_PROTECTED | CFM_FACE | CFM_SIZE | CFM_CHARSET | CFM_SUBSCRIPT;

	cf.crTextColor = RGB(

		app->GetProfileInt("EditViewColor", "TxtColorR", DEF_TXT_COLOR_R),

		app->GetProfileInt("EditViewColor", "TxtColorG", DEF_TXT_COLOR_G),

		app->GetProfileInt("EditViewColor", "TxtColorB", DEF_TXT_COLOR_B));

	cf.dwEffects = CFE_PROTECTED | CFE_SUBSCRIPT;



	// tHgς

//	m_font_size = 8;

//	strncpy(cf.szFaceName, "FixedSys", m_font_size);

//	cf.szFaceName[8]='\0';

//	cf.bPitchAndFamily=FIXED_PITCH;

//	cf.bCharSet=SHIFTJIS_CHARSET;

//	cf.yHeight=280;

//	r.SetDefaultCharFormat(cf);

//	cf.cbSize=sizeof(cf);

	r.SendMessage(EM_SETCHARFORMAT,(WPARAM)SCF_ALL,(LPARAM)&cf);

	r.SetDefaultCharFormat(cf);

	this->SetCharFormat(cf);





	// sԂ𒲐

/*	PARAFORMAT2 pf;

	pf.cbSize = sizeof(pf);

	pf.dwMask = PFM_LINESPACING | PFM_SPACEAFTER;

	pf.dySpaceAfter = 0;

	pf.bLineSpacingRule = 4;

	pf.dyLineSpacing = 280;

	r.SetSel(0,-1);

	r.SendMessage(EM_SETPARAFORMAT,0,(LPARAM)&pf);

	r.SetSel(0,0);*/



	// {ݒ

	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	CString body;

	if(df->m_me.GetMode() == ME_MODE_PGP){

		body = df->m_me.GetMultipartBody(1);

		r.SetReadOnly();

	}else{

		body = df->m_me.GetMultipartBody(0);

	}

	CCodeConvert cc(body);

	body = cc.ToSjis();

	SetWindowText(body);



	// ̑̐ݒ

	r.SetBackgroundColor(FALSE, RGB(

    app->GetProfileInt("EditViewColor", "BkColorR", DEF_BKG_COLOR_R),

    app->GetProfileInt("EditViewColor", "BkColorG", DEF_BKG_COLOR_G),

    app->GetProfileInt("EditViewColor", "BkColorB", DEF_BKG_COLOR_B)));



	if(!app->GetProfileInt("Customize", "WordWrap", 0)){

		m_nWordWrap = WrapNone;

		WrapChanged(); // ܂ԂȂ

	}

	r.SetOptions(ECOOP_OR,ECO_AUTOHSCROLL);



	// [GfBbgr[̔wi摜ݒ

	CString strBackgroundFilePath;

	if(app->m_skin.getMailEditViewBackBmp() == ""){

		strBackgroundFilePath = app->m_app_path + MAILEDITVIEW_BACKGROUND_FILENAME;

	}else{

		strBackgroundFilePath = app->m_skin.getSkinIniPath() + "\\" + app->m_skin.getMailEditViewBackBmp();

	}

	SetBkImage(strBackgroundFilePath);

//	CString strBackgroundFilePath = app->m_app_path + MAILEDITVIEW_BACKGROUND_FILENAME;

//	SetBkImage(strBackgroundFilePath);



	r.SetModify(FALSE);

}



void CMailEditView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 

{

	TRACE("char=%d\n",nChar);

	CPochyApp* app = (CPochyApp*)AfxGetApp();

	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	if(app->GetProfileInt("Customize", "MewKeyBind", 0)){

		if(df->Char(nChar,this))

			return;

	}



	/*	long a,b;

	int y;



	CRichEditCtrl& r = GetRichEditCtrl();

	r.GetSel(a,b);

	y = r.LineFromChar(a);

	int li = r.LineIndex();

	int pli = r.LineIndex(y-1);

	int nli = r.LineIndex(y+1);

//	int len = r.LineLength();

	int plen = r.LineLength(pli);

	int nlen = r.LineLength(nli);



	switch(nChar){ // emacsCNȑBƃBBB

		case 2:

			r.SetSel(a-1,a-1);

			return;

		case 16:

			if(plen<(a-li))

				r.SetSel(pli+plen,pli+plen);

			else

				r.SetSel(pli+a-li,pli+a-li);

			return;

		case 14:

			if(nlen<(a-li))

				r.SetSel(nli+nlen,nli+nlen);

			else

				r.SetSel(nli+a-li,nli+a-li);

			return;

		case 6:

			r.SetSel(a+1,a+1);

			return;

		case 32:

			if(a!=b)

				r.SetSel(b,b);

	}*/

	CRichEditView::OnChar(nChar, nRepCnt, nFlags);

}



void CMailEditView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 

{

	CPochyApp* app = (CPochyApp*)AfxGetApp();

	CDraftFrame* df = (CDraftFrame*)GetParentFrame();



	if(app->GetProfileInt("Customize", "MewKeyBind", 0)){

		if(df->KeyDown(nChar,this))

			return;

	}



	if(::GetKeyState(VK_CONTROL) & 0xff00){	

		switch(nChar){

		case 'V':

			this->OnEditviewPaste();

			return;

		default:

			break;

		}

	}



	CBitmapRichEditView::OnKeyDown(nChar, nRepCnt, nFlags);

}



void CMailEditView::GetText(CString &buf)

{

/*	buf.Empty();

	CRichEditCtrl &r = GetRichEditCtrl();

	CHARRANGE cr;

	char *tmp;

	tmp = new char [r.GetTextLength()+1];

	r.GetSel(cr);

	r.HideSelection(TRUE,FALSE);

	r.SetSel(0,r.GetTextLength());

	r.GetSelText(tmp);

	r.SetSel(cr);

	buf=tmp;

	delete [] tmp;*/

	buf.Empty();

	this->GetRichEditCtrl().GetWindowText(buf);

}



void CMailEditView::Font()

{

	CRichEditCtrl& r = GetRichEditCtrl();

	CHARFORMAT cf;

	DWORD dwMask = r.GetDefaultCharFormat(cf);



	LOGFONT lf = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "\0"};

	if(cf.dwEffects & CFE_STRIKEOUT)

		lf.lfStrikeOut = 1;

	if(cf.dwEffects & CFE_UNDERLINE)

		lf.lfUnderline = 1;

	if(cf.dwEffects & CFE_ITALIC)

		lf.lfItalic |= 1;

	if(cf.dwEffects & CFE_BOLD)

		lf.lfWeight = FW_BOLD;

	else

		lf.lfWeight = FW_NORMAL;

	strcpy(lf.lfFaceName, cf.szFaceName);

	lf.lfPitchAndFamily = cf.bPitchAndFamily;

	lf.lfCharSet = cf.bCharSet;

	lf.lfHeight = cf.yHeight * 4/3 * 1/20;



	CFontDialog fd(&lf, CF_EFFECTS | CF_SCREENFONTS | CF_BOTH, NULL, this);

	fd.m_cf.rgbColors = cf.crTextColor;

	if(fd.DoModal() == IDOK){

		int minilen = min(strlen(lf.lfFaceName), LF_FACESIZE);

		strncpy(cf.szFaceName, lf.lfFaceName, minilen);

		cf.szFaceName[minilen] = '\0';



		cf.bPitchAndFamily = lf.lfPitchAndFamily;

		cf.bCharSet = lf.lfCharSet;



		cf.yHeight = fd.m_cf.iPointSize * 2;

		cf.crTextColor = fd.m_cf.rgbColors;

		cf.dwEffects &= ~CFE_AUTOCOLOR;

		cf.dwMask = CFM_BOLD | CFM_CHARSET | CFM_COLOR | CFM_FACE | CFM_ITALIC | CFM_SIZE | CFM_OFFSET | CFM_STRIKEOUT | CFM_UNDERLINE;

		if(lf.lfStrikeOut)

			cf.dwEffects |= CFE_STRIKEOUT;

		else

			cf.dwEffects &= ~CFE_STRIKEOUT;

		if(lf.lfUnderline)

			cf.dwEffects |= CFE_UNDERLINE;

		else

			cf.dwEffects &= ~CFE_UNDERLINE;

		if(lf.lfItalic)

			cf.dwEffects |= CFE_ITALIC;

		else

			cf.dwEffects &= ~CFE_ITALIC;

		if(lf.lfWeight > FW_NORMAL)

			cf.dwEffects |= CFE_BOLD;

		else

			cf.dwEffects &= ~CFE_BOLD;



		long nStartChar, nEndChar;

		r.GetSel(nStartChar, nEndChar);

		r.SetDefaultCharFormat(cf);

		r.SetSel(nStartChar, nEndChar);



		Invalidate(TRUE);

		this->UpdateWindow();

	}

}



/*void CMailEditView::Export()

{

/*	CPochyApp* app = (CPochyApp*)AfxGetApp();

	HANDLE hOutputReadTmp,hOutputRead,hOutputWrite;

	HANDLE hInputWriteTmp,hInputRead,hInputWrite;

	HANDLE hErrorReadTmp,hErrorRead,hErrorWrite;

	SECURITY_ATTRIBUTES sa;

	sa.nLength = sizeof(SECURITY_ATTRIBUTES);

	sa.lpSecurityDescriptor = NULL;

	sa.bInheritHandle = TRUE;



	// Create the child output pipe. 

	if (!CreatePipe(&hOutputReadTmp,&hOutputWrite,&sa,0))

		AfxMessageBox("CreatePipe");

	if (!CreatePipe(&hErrorReadTmp,&hErrorWrite,&sa,0))

		AfxMessageBox("CreatePipe");

	if (!CreatePipe(&hInputRead,&hInputWriteTmp,&sa,0))

		AfxMessageBox("CreatePipe");



	if (!DuplicateHandle(GetCurrentProcess(),hErrorReadTmp,

		GetCurrentProcess(),&hErrorRead,0,TRUE,DUPLICATE_SAME_ACCESS))

		AfxMessageBox("DuplicateHandle");

	if (!DuplicateHandle(GetCurrentProcess(),hOutputReadTmp,

		GetCurrentProcess(),&hOutputRead,0,FALSE,DUPLICATE_SAME_ACCESS))

		AfxMessageBox("DuplicateHandle");

	if (!DuplicateHandle(GetCurrentProcess(),hInputWriteTmp,

		GetCurrentProcess(),&hInputWrite,0,FALSE,DUPLICATE_SAME_ACCESS))

		AfxMessageBox("DuplicateHandle");



	// Close inheritable copies of the handles you do not want to be

	// inherited.

	if (!CloseHandle(hOutputReadTmp)) AfxMessageBox("CloseHandle");

	if (!CloseHandle(hInputWriteTmp)) AfxMessageBox("CloseHandle");

	if (!CloseHandle(hErrorReadTmp)) AfxMessageBox("CloseHandle");



	// ʂ͂̕t@Cɏ

	CString buf;

	GetRichEditCtrl().GetWindowText(buf);



	// ̑I

	CGpgKeyListDlg lkd;

	CString exported_key;

	exported_key.Empty();

	if(lkd.DoModal()==IDOK && app->m_key_id_list.GetSize()){

		for(int i=0;i<app->m_key_id_list.GetSize();i++)

			exported_key += " " + app->m_key_id_list[i];



		// vZXN

		STARTUPINFO siStartInfo;

		PROCESS_INFORMATION pi;

		ZeroMemory( &siStartInfo, sizeof(STARTUPINFO) );

		siStartInfo.hStdError = hErrorWrite;

		siStartInfo.hStdOutput = hOutputWrite;

		siStartInfo.hStdInput = hInputRead;

		siStartInfo.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;

		siStartInfo.wShowWindow = SW_HIDE;

		siStartInfo.cb = sizeof(STARTUPINFO);

		CString tmps = "gpg --verbose --always-trust -a -o tmpout --export"+exported_key;

		LPSTR lps = tmps.GetBuffer(0);

		if(!CreateProcess(NULL,lps,

			NULL,NULL,TRUE,CREATE_NEW_CONSOLE,NULL,NULL,&siStartInfo,&pi))

			AfxMessageBox("process creation failed.");

		WaitForSingleObject(pi.hProcess,INFINITE);

		CloseHandle(pi.hProcess);

		CloseHandle(pi.hThread);



		// G[̃`FbN

		CString body;

#if 1

		DWORD len;

		LPSTR pbody;

		pbody = body.GetBuffer(1000);

		ReadFile(hErrorRead,pbody,1000,&len,NULL);

		pbody[len]=0;

		body.ReleaseBuffer();

		if(body.Find("error")!=-1){

			AfxMessageBox(body);

			app->m_gpg_passphrase.Empty();

			if(!CloseHandle(hInputWrite)) AfxMessageBox("CloseHandle");

			if(!CloseHandle(hOutputRead)) AfxMessageBox("CloseHandle");

			if(!CloseHandle(hErrorRead)) AfxMessageBox("CloseHandle");

			DeleteFile("tmpfile");

			return;

		}

#endif

		// gpg̏o͂ǂݍ

		g_file2cstring("tmpout",body);

		DeleteFile("tmpout");



		if(!CloseHandle(hInputWrite)) AfxMessageBox("CloseHandle");

		if(!CloseHandle(hOutputRead)) AfxMessageBox("CloseHandle");

		if(!CloseHandle(hErrorRead)) AfxMessageBox("CloseHandle");



		// \

		GetRichEditCtrl().SetWindowText(body);

	}

	DeleteFile("tmpfile");

}*/



/*

void CMailEditView::OnEditPaste() 

{

	char *buffer;



	if(OpenClipboard()){

		HANDLE hData = ::GetClipboardData(CF_TEXT);

		buffer = (char*)GlobalLock(hData);

		GlobalUnlock(hData);

		CloseClipboard();

	}



	CString source;

	source=buffer;



	if(OpenClipboard()){

		HGLOBAL clipbuffer;

		EmptyClipboard();

		clipbuffer = GlobalAlloc(GMEM_DDESHARE, source.GetLength()+1);

		buffer = (char*)GlobalLock(clipbuffer);

		strcpy(buffer, LPCSTR(source));

		GlobalUnlock(clipbuffer);

		SetClipboardData(CF_TEXT,clipbuffer);

		CloseClipboard();

	}

	GetRichEditCtrl().Paste();



	char * buffer;



	if(OpenClipboard()){

		HANDLE hData = ::GetClipboardData(CF_TEXT);

		buffer = (char*)GlobalLock(hData);

		GlobalUnlock(hData);

		CloseClipboard();

	}



	CString source;

	source=buffer;



	if(OpenClipboard()){

		HGLOBAL clipbuffer;

		EmptyClipboard();

		clipbuffer = GlobalAlloc(GMEM_DDESHARE, source.GetLength()+1);

		buffer = (char*)GlobalLock(clipbuffer);

		strcpy(buffer, LPCSTR(source));

		GlobalUnlock(clipbuffer);

		SetClipboardData(CF_TEXT,clipbuffer);

		CloseClipboard();

	}

	GetRichEditCtrl().PasteSpecial(CF_TEXT);

}*/



BOOL CMailEditView::OnLink( NMHDR* in_pNotifyHeader, LRESULT* out_pResult )

{

	*out_pResult = 0;

	CPochyApp *app = (CPochyApp *)AfxGetApp();

	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

	ENLINK * pLink = (ENLINK*)in_pNotifyHeader;

	if(pLink->msg == WM_LBUTTONDBLCLK && m_onlink != pLink->lParam){

		// dNh߂Ɍ݂̃}EX̃NbNꂽ|CgۑĂ

		m_onlink = pLink->lParam; // ̍

		// NbNꂽN̕擾

		GetRichEditCtrl().SetSel(pLink->chrg);

		CString link = GetRichEditCtrl().GetSelText();

		if(link.Find("mailto:") == 0){

			// 

			app->m_me.Initialize();

			// To ̐ݒ

			if(link.Find("?", 7) != -1) // mailto:hoge@hoge.com?subject=PGP%20Key&Body=Please%20send%20keyƂ

				// subject body Ƃ͖

				app->m_me.SetTo(link.Mid(7, link.Find("?", 7)-7));

			else

				app->m_me.SetTo(link.Mid(7));

			// From ̐ݒ

			CString path = app->m_app_path+"\\"+mf->m_pAcntV->GetCurrentAccountName()+"\\account.ini";

			CString address;

			GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			address.ReleaseBuffer();

			app->m_me.SetFrom(address);

			// ̎擾

			CString signature;

			g_file2cstring(app->m_app_path+"\\"+mf->m_pAcntV->GetCurrentAccountName()+"\\signature", signature);

			// {ݒ

			app->m_me.AddText(signature);

			// draftframe

			app->CreateDraftFrame(mf->m_pAcntV->GetCurrentAccountName());

		}

		else

		{

			CString strBrowserPath = app->GetProfileString(_T("Customize"), _T("BrowserPath"), _T(""));

			if (strBrowserPath != _T(""))

			{

				::ShellExecute(NULL, NULL, strBrowserPath, link, NULL, SW_SHOWNORMAL);

			}

			else

			{

				ShellExecute(this->GetSafeHwnd(), _T( "open" ), link, NULL, NULL, SW_SHOWNORMAL);

			}

		}

	}

	return TRUE;

}



void CMailEditView::OnRButtonDown(UINT nFlags, CPoint point) 

{

	POINT pt;



	PostMessage(WM_NULL, 0, 0); /* this is point */

	GetCursorPos(&pt);

	CMenu menu;



	menu.LoadMenu(IDR_EDITVIEW_POPUP);



	// 񂪑IĂ邩ǂmF

	CRichEditCtrl &r = GetRichEditCtrl();

	if(r.GetSelText().IsEmpty()){

		menu.EnableMenuItem(ID_EDITVIEW_COPY, MF_GRAYED /*  */);

		menu.EnableMenuItem(ID_EDITVIEW_CUT, MF_GRAYED /*  */);

	}else{

		menu.EnableMenuItem(ID_EDITVIEW_COPY, MF_ENABLED /* L */);

		menu.EnableMenuItem(ID_EDITVIEW_CUT, MF_ENABLED /*  */);

	}



	// undo\ǂmF

	if(r.CanUndo())

		menu.EnableMenuItem(ID_EDITVIEW_UNDO, MF_ENABLED /* L */);

	else

		menu.EnableMenuItem(ID_EDITVIEW_UNDO, MF_GRAYED /*  */);



	// uׂđIv\ǂmF

	if(r.GetTextLength() == 0)

		menu.EnableMenuItem(ID_EDITVIEW_SELALL, MF_GRAYED /*  */);

	else

		menu.EnableMenuItem(ID_EDITVIEW_SELALL, MF_ENABLED /* L */);



	CPochyApp* pPochyApp = (CPochyApp*)::AfxGetApp();

	if (pPochyApp != NULL)

	{

		pPochyApp->m_pluginManager.OnInitMenu(menu.GetSubMenu(0)->GetSafeHmenu(), POCHY_MENU_DRAFT_MAIL_EDIT_VIEW);

	}



	CMenu *pPopup = menu.GetSubMenu(0);

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, (int)pt.x, (int)pt.y, this);	

	CRichEditView::OnRButtonDown(nFlags, point);

}



void CMailEditView::OnEditviewPaste() 

{

	char * buffer;



	if(OpenClipboard()){

		HANDLE hData = ::GetClipboardData(CF_TEXT);

		buffer = (char*)GlobalLock(hData);

		GlobalUnlock(hData);

		CloseClipboard();

	}



	CString source;

	source=buffer;



	if(OpenClipboard()){

		HGLOBAL clipbuffer;

		EmptyClipboard();

		clipbuffer = GlobalAlloc(GMEM_DDESHARE, source.GetLength()+1);

		buffer = (char*)GlobalLock(clipbuffer);

		strcpy(buffer, LPCSTR(source));

		GlobalUnlock(clipbuffer);

		SetClipboardData(CF_TEXT,clipbuffer);

		CloseClipboard();

	}

	GetRichEditCtrl().PasteSpecial(CF_TEXT);

}



void CMailEditView::OnEditviewCopy() 

{

	CRichEditCtrl &r = GetRichEditCtrl();

	r.Copy();

}



void CMailEditView::OnEditviewSelall() 

{

	// select all

	CRichEditCtrl &r = GetRichEditCtrl();

	r.SetSel(0, -1);	

}



void CMailEditView::OnEditviewCut() 

{

	CRichEditCtrl &r = GetRichEditCtrl();

	r.Cut();

}



void CMailEditView::OnEditviewUndo() 

{

	CRichEditCtrl &r = GetRichEditCtrl();

	r.Undo();

}



/*int CMailEditView::GetPos()

{

	CPoint p;

	p = GetCaretPos();

	return p.x/m_font_size-1;

}*/



void CMailEditView::OnEditviewPasteQuotation() 

{

	char * buffer;



	if(OpenClipboard()){

		HANDLE hData = ::GetClipboardData(CF_TEXT);

		buffer = (char*)GlobalLock(hData);

		GlobalUnlock(hData);

		CloseClipboard();

	}



	CString source;

	source=buffer;



	source.Replace("\r\n", "\r\n> ");

	source = "> "+source;



	if(OpenClipboard()){

		HGLOBAL clipbuffer;

		EmptyClipboard();

		clipbuffer = GlobalAlloc(GMEM_DDESHARE, source.GetLength()+1);

		buffer = (char*)GlobalLock(clipbuffer);

		strcpy(buffer, LPCSTR(source));

		GlobalUnlock(clipbuffer);

		SetClipboardData(CF_TEXT,clipbuffer);

		CloseClipboard();

	}

	GetRichEditCtrl().Paste();

}





void CMailEditView::SetFontEx(LOGFONT &lf)

{

	CRichEditCtrl &r = GetRichEditCtrl();



	m_font.DeleteObject();

	if(m_font.CreateFontIndirect(&lf))

		r.SetFont(&m_font);

	SetFontColorAndLink();

}



void CMailEditView::SetFontColorAndLink()

{

	CRichEditCtrl &r = GetRichEditCtrl();

	CPochyApp* app = (CPochyApp*)AfxGetApp();



	// clickable url Lɂ

	long lENM = r.GetEventMask();

	lENM |= ENM_LINK;

	r.SetEventMask(lENM);

	BOOL bEnable = 1;

	::SendMessage(m_hWnd, EM_AUTOURLDETECT, bEnable, 0);



	// ̑ݒ

	CHARFORMAT2 cf;

	r.GetDefaultCharFormat(cf);

	cf.dwMask = CFM_COLOR | CFM_PROTECTED | CFM_FACE | CFM_SIZE | CFM_CHARSET | CFM_SUBSCRIPT;

	cf.crTextColor = RGB(

		app->GetProfileInt("EditViewColor", "TxtColorR", DEF_TXT_COLOR_R),

		app->GetProfileInt("EditViewColor", "TxtColorG", DEF_TXT_COLOR_G),

		app->GetProfileInt("EditViewColor", "TxtColorB", DEF_TXT_COLOR_B));

	cf.dwEffects = CFE_PROTECTED | CFE_SUBSCRIPT;

//	cf.bCharSet=GB2312_CHARSET;

	r.SendMessage(EM_SETCHARFORMAT,(WPARAM)SCF_ALL,(LPARAM)&cf);

}



void CMailEditView::OnDropFiles(HDROP hDropInfo) 

{

//	CRichEditView::OnDropFiles(hDropInfo);



	this->GetRichEditCtrl().UpdateData(TRUE);

	CDraftFrame *df = (CDraftFrame*)GetParentFrame();



	// count number of droped file

	int num = DragQueryFile(hDropInfo,~0lu, NULL, 0);



	for(int i=0; i<num; i++){

		// get length of file name

		int len = DragQueryFile(hDropInfo, i, NULL, 0);



		// get file path

		CString file_path;

		DragQueryFile(hDropInfo, i, file_path.GetBuffer(len+1), len+1);

		file_path.ReleaseBuffer();



		// add m_me

		if(!df->m_me.AddAttachedFile(file_path)){

			AfxMessageBox("cannot open file");

			continue;

		}



		// add item to attachedfielview.

		df->m_pListV2->AddFile(file_path);

		file_path.ReleaseBuffer();

	}

	df->HideAttachedFileView(FALSE);

	df->ReArrangeSplit();

//	df->m_pEditV->SetFocus();

	this->GetRichEditCtrl().UpdateData(FALSE);



//	CRichEditView::OnDropFiles(hDropInfo);

}



BOOL CMailEditView::OnCommand(WPARAM wParam, LPARAM lParam) 

{

	CPochyApp *pPochyApp = (CPochyApp *)AfxGetApp();

	if (pPochyApp != NULL)

	{

		CMainFrame *pMainFrame = (CMainFrame*)pPochyApp->m_pMainWnd;

		if (pMainFrame != NULL)

		{

			pMainFrame->CallPluginCallback(this->GetSafeHwnd(), LOWORD(wParam));

		}

	}

	

	return CBitmapRichEditView::OnCommand(wParam, lParam);

}

