/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// MimeDecode.cpp: CMimeDecode NX̃Cve[V

//

//////////////////////////////////////////////////////////////////////



#include "stdafx.h"

#include "Pochy.h"

#include "MimeDecode.h"

#include <afxtempl.h>	// CArrayev[gNXɕKv

#include "lib.h"





//////////////////////////////////////////////////////////////////////

// \z/

//////////////////////////////////////////////////////////////////////



CMimeDecode::CMimeDecode()

{



}



CMimeDecode::~CMimeDecode()

{



}



// partŎw肳ꂽmultipartbodydstiCStringArrayj֏

void CMimeDecode::GetBody(int part, CStringArray &dst)

{

	ASSERT(part < HowManyPart());

	int start;

	int end;



	start = m_data.GetAt(part).end_header+2;

	end = m_data.GetAt(part).end;

	g_cstringarray_getpart(m_mail, dst, start, end);

}



CString CMimeDecode::GetContentType(int part)

{

	ASSERT(part < HowManyPart());

	return m_data[part].content_type;

}



int CMimeDecode::GetEncodingType(int part)

{

	ASSERT(part < HowManyPart());

	return m_data[part].encoding_type;

}



CString CMimeDecode::GetEncodingTypeStr(int part)

{

	int type = GetEncodingType(part);

	CString typeStr = "";

	switch(type){

	case SEVEN_BIT:

		typeStr = "7bit";

		break;

	case EIGHT_BIT:

		typeStr = "8bit";

		break;

	case BIN:

		typeStr = "bin";

		break;

	case BASE64:

		typeStr = "base64";

		break;

	case QUOTED_PRINTABLE:

		typeStr = "quoted-printable";

		break;

	}

	return typeStr;

}



CString CMimeDecode::GetFileName(int part)

{

	ASSERT(part < HowManyPart());

	return m_data[part].name;

}



CString CMimeDecode::GetRawCT(int part)

{

	ASSERT(part < HowManyPart());

	return m_data[part].raw_content_type;

}



CString CMimeDecode::GetRawCD(int part)

{

	ASSERT(part < HowManyPart());

	return m_data[part].raw_content_disposition;

}



CString CMimeDecode::GetRawCTE(int part)

{

	ASSERT(part < HowManyPart());

	return m_data[part].raw_content_transfer_encoding;

}



CString CMimeDecode::GetMultipartType()

{

	CString buf;

	int start;

	int end;



	if(IsMultipart()){

		buf = m_hi.GetCT();

		start = buf.Find("/")+1;

		end = buf.Find(";", start);

		return buf.Mid(start, end-start);

	}



	buf.Empty();

	return buf;

}



int CMimeDecode::HowManyPart()

{

	return m_data.GetSize();

}



BOOL CMimeDecode::IsMultipart()

{

	return m_hi.IsMultipart();

}



BOOL CMimeDecode::GetHeaderEndPoint(CStringArray &mail, int &p)

{

	int n;

	int max = mail.GetSize();



	for(n=0; n<max; n++){

		mail.GetAt(n);

		if(mail.GetAt(n) == "\x0D\x0A"){

			p = n-1;

			break;

		}

	}

	return TRUE;

}



BOOL CMimeDecode::DoIt2(CString mail)

{

	Initialize();



	int p = 0; // headeȑI

	g_string2cstringarray(mail, m_mail, "\r\n", TRUE);

	GetHeaderEndPoint(m_mail, p);

	if(p == -1){

		AfxMessageBox("[Ă܂iwb_܂j");

		return FALSE;

	}



	CStringArray header;

	g_cstringarray_getpart(m_mail, header, 0, p);

	m_hi.DoIt(header);



	MULTIPART_STRUCT data;

	int n;



	if(IsMultipart()){

		if(!AnalyzeMultiPart(0, m_hi.GetBoundary())){

			AfxMessageBox("MIME̍\ςł");

			return FALSE;

		}

		int max=m_data.GetSize();

		for(n=0; n<max; n++){

			if(!m_data.GetAt(n).boundary.IsEmpty())

				if(!AnalyzeMultiPart(m_data.GetAt(n).start, m_data.GetAt(n).boundary)){

					AfxMessageBox("MIME̍\ςł");

					return FALSE;

				}

		}



		// multipartq\̐e폜

		for(n=0; n<m_data.GetSize(); n++){

			if(!m_data.GetAt(n).boundary.IsEmpty()){

				m_data.RemoveAt(n);

			}

		}

	}else{

		data.start = 0;

		GetHeaderEndPoint(m_mail, p);

		data.end_header = p;

		data.end = m_mail.GetSize()-1;

		data.name = m_hi.GetFilename();

		if(data.name.IsEmpty())

			data.name = m_hi.GetName();

		data.content_type = m_hi.GetCType();

		data.encoding_type = m_hi.GetEnc();

		m_data.Add(data);

	}

	return TRUE;

}

BOOL CMimeDecode::DoIt(CString path)

{

	Initialize();



	CString message;

	if(!g_is_there(path)){

		message.Format("%s ݂ȂߊJ܂", path);

		AfxMessageBox(message);

		message.Empty();

		return FALSE;

	}



	int p = 0; // headeȑI

	CStringArray header;

	g_file2cstringarray(path, m_mail);

	GetHeaderEndPoint(m_mail, p);

	if(p == -1){

		AfxMessageBox("[Ă܂iwb_܂j");

		return FALSE;

	}

	g_cstringarray_getpart(m_mail, header, 0, p);

	m_hi.DoIt(header);



	MULTIPART_STRUCT data;

	int n;



	if(IsMultipart()){

		if(!AnalyzeMultiPart(0, m_hi.GetBoundary())){

			AfxMessageBox("MIME̍\ςł");

			return FALSE;

		}

		int max = m_data.GetSize();

		for(n=0; n<max; n++){

			if(!m_data.GetAt(n).boundary.IsEmpty())

				if(!AnalyzeMultiPart(m_data.GetAt(n).start, m_data.GetAt(n).boundary)){

					AfxMessageBox("MIME̍\ςł");

					return FALSE;

				}

		}



		// multipartq\̐e폜

		for(n=0; n<m_data.GetSize(); n++){

			if(!m_data.GetAt(n).boundary.IsEmpty()){

				m_data.RemoveAt(n);

			}

		}

	}else{

		data.start = 0;

		GetHeaderEndPoint(m_mail, p);

		data.end_header = p;

		data.end = m_mail.GetSize()-1;

		data.name = m_hi.GetFilename();

		if(data.name.IsEmpty())

			data.name = m_hi.GetName();

		data.content_type = m_hi.GetCType();

		data.encoding_type = m_hi.GetEnc();

		data.raw_content_type = m_hi.GetCT();

		data.raw_content_transfer_encoding = m_hi.GetCTE();

		data.raw_content_disposition = m_hi.GetCD();

		m_data.Add(data);

	}

	return TRUE;

}



BOOL CMimeDecode::AnalyzeMultiPart(int start, LPCTSTR boundary)

{

	int n1;

	int n2;

	int p;

	int max;

	CUIntArray ia;

	CHeaderInfo hi;

	CStringArray part;

	CString sep;// = "--"+boundary+"\r\n";

	CString last;// = "--"+boundary+"--"+"\r\n";

	CStringArray pheader;

	MULTIPART_STRUCT data;



	sep.Format("--%s\r\n", boundary);

	last.Format("--%s--\r\n", boundary);



	max = m_mail.GetSize();

	for(n1=start; n1<max; n1++){

		if(m_mail.GetAt(n1) == sep){

			ia.Add(n1);

			continue;

		}

		if(m_mail.GetAt(n1) == last){

			ia.Add(n1);

			break;

		}

	}



	if(ia.GetSize() < 2)

		return FALSE;



	max = ia.GetSize();

	for(n2=0; n2+1<max; n2++){

		g_cstringarray_getpart(m_mail, part, ia.GetAt(n2)+1, ia.GetAt(n2+1)-1);

		GetHeaderEndPoint(part, p);

		g_cstringarray_getpart(m_mail, pheader, ia.GetAt(n2)+1, ia.GetAt(n2)+1+p);

		hi.DoIt(pheader);



		data.start = ia.GetAt(n2)+1;

		data.end_header = data.start+p;

		data.end = ia.GetAt(n2+1)-1;

		data.boundary = hi.GetBoundary();

		data.content_type = hi.GetCType();

		data.encoding_type = hi.GetEnc();

		data.name = hi.GetFilename();

		if(data.name.IsEmpty())

			data.name = hi.GetName();

		data.raw_content_type = hi.GetCT();

		data.raw_content_transfer_encoding = hi.GetCTE();

		data.raw_content_disposition = hi.GetCD();

		m_data.Add(data);

	}

	return TRUE;

}



void CMimeDecode::Initialize()

{

	// ϐ̏

	m_data.RemoveAll();

	m_mail.RemoveAll();

}



BOOL CMimeDecode::IsPgpMime()

{

	return g_string_compare_no_case(m_hi.GetProtocol(), "application/pgp-encrypted");

}



CString CMimeDecode::GetCharSet()

{

	return m_hi.GetCharset();

}



CString CMimeDecode::GetExtension(CString media_type)

{

	CMapStringToString map;



	map.SetAt("application/andrew-inset",		"ez");	//ez

	map.SetAt("application/excel",			"xls");		//xls

	map.SetAt("application/octet-stream",		"bin");	//bin

	map.SetAt("application/oda",	"oda");				//oda

	map.SetAt("application/pdf",	"pdf");				//pdf

	map.SetAt("application/pgp",	"pgp");				//pgp

	map.SetAt("application/postscript",	"ps");			//ps PS eps

	map.SetAt("application/postscript",		"eps");

	map.SetAt("application/rtf",	"rtf");				//rtf

	map.SetAt("application/x-arj-compressed",	"arj");	//arj

	map.SetAt("application/x-bcpio",	"bcpio");		//bcpio

	map.SetAt("application/x-chess-pgn",	"pgn");		//pgn

	map.SetAt("application/x-cpio",	"cpio");			//cpio

	map.SetAt("application/x-csh",	"csh");				//csh

	map.SetAt("application/x-debian-package",	"deb");	//deb

	map.SetAt("application/x-msdos-program",	"com");	//com exe bat

	map.SetAt("application/x-msdos-program",	"exe");

	map.SetAt("application/x-msdos-program",	"bat");

	map.SetAt("application/x-dvi",	"dvi");				//dvi

	map.SetAt("application/x-gtar",	"gtar");			//gtar

	map.SetAt("application/x-gunzip",	"gz");			//gz

	map.SetAt("application/x-hdf",	"hdf");				//hdf

	map.SetAt("application/x-latex",	"latex");		//latex

	map.SetAt("application/x-mif",	"mif");				//mif

	map.SetAt("application/x-netcdf",	"cdf");			//cdf nc

	map.SetAt("application/x-netcdf",	"nc");

	map.SetAt("application/x-perl",	"pl");				//pl pm

	map.SetAt("application/x-perl",	"pm");

	map.SetAt("application/x-rar-compressed",	"rar");	//rar

	map.SetAt("application/x-sh",	"sh");				//sh

	map.SetAt("application/x-shar",	"shar");			//shar

	map.SetAt("application/x-sv4cpio",	"sv4cpio");		//sv4cpio

	map.SetAt("application/x-sv4crc",	"sv4src");		//sv4crc

	map.SetAt("application/x-tar",	"tar");				//tar

	map.SetAt("application/x-tar-gz",	"tgz");			//tgz tar.gz

	map.SetAt("application/x-tar-gz",	"tar.gz");

	map.SetAt("application/x-tcl",	"tcl");				//tcl

	map.SetAt("application/x-tex",	"tex");				//tex

	map.SetAt("application/x-texinfo",	"texi");		//texi texinfo

	map.SetAt("application/x-texinfo",	"texinfo");

	map.SetAt("application/x-troff",	"t");			//t tr roff

	map.SetAt("application/x-troff",	"tr");

	map.SetAt("application/x-troff",	"roff");

	map.SetAt("application/x-troff-man",	"man");		//man

	map.SetAt("application/x-troff-me",	"me");			//me

	map.SetAt("application/x-troff-ms",	"ms");			//ms

	map.SetAt("application/x-ustar",	"ustar");		//ustar

	map.SetAt("application/x-wais-source",	"src");		//src

	map.SetAt("application/x-zip-compressed",	"zip");	//zip



	map.SetAt("audio/basic",	"snd");					//snd

	map.SetAt("audio/midi",	"mid");						//mid midi

	map.SetAt("audio/midi",	"midi");

	map.SetAt("audio/ulaw",	"au");						//au

	map.SetAt("audio/x-aiff",	"aif");					//aif aifc aiff

	map.SetAt("audio/x-aiff",	"aifc");

	map.SetAt("audio/x-aiff",	"aiff");

	map.SetAt("audio/x-wav",	"wav");					//wav



	map.SetAt("image/gif",	"gif");						//gif

	map.SetAt("image/ief",	"ief");						//ief

	map.SetAt("image/jpeg",	"jpe");						//jpe jpeg jpg

	map.SetAt("image/jpeg",	"jpeg");

	map.SetAt("image/jpeg",	"jpg");

	map.SetAt("image/png",	"png");						//png

	map.SetAt("image/tiff",	"tif");						//tif tiff

	map.SetAt("image/tiff",	"tiff");

	map.SetAt("image/x-cmu-raster",	"ras");				//ras

	map.SetAt("image/x-portable-anymap",	"pnm");		//pnm

	map.SetAt("image/x-portable-bitmap",	"pbm");		//pbm

	map.SetAt("image/x-portable-graymap",	"pgm");		//pgm

	map.SetAt("image/x-portable-pixmap",	"ppm");		//ppm

	map.SetAt("image/x-rgb",	"rgb");					//rgb

	map.SetAt("image/x-xbitmap",	"xbm");				//xbm

	map.SetAt("image/x-xpixmap",	"xpm");				//xpm

	map.SetAt("image/x-xwindowdump",	"xwd");			//xwd



	map.SetAt("text/html",	"html");					//html htm

	map.SetAt("text/html",	"htm");

	map.SetAt("text/plain",	"asc");						//asc txt

	map.SetAt("text/plain",	"txt");

	map.SetAt("text/richtext",	"rtx");					//rtx

	map.SetAt("text/tab-separated-values",	"tsv");		//tsv

	map.SetAt("text/x-setext",	"etx");					//etx



	map.SetAt("video/dl",	"dl");						//dl

	map.SetAt("video/fli",	"fli");						//fli

	map.SetAt("video/gl",	"gl");						//gl

	map.SetAt("video/mpeg",	"mp2");						//mp2 mpe mpeg mpg

	map.SetAt("video/mpeg",	"mpe");

	map.SetAt("video/mpeg",	"mpeg");

	map.SetAt("video/mpeg",	"mpg");

	map.SetAt("video/quicktime",	"mov");				//mov qt

	map.SetAt("video/quicktime",	"qt");

	map.SetAt("video/x-msvideo",	"avi");				//avi

	map.SetAt("video/x-sgi-movie",	"movie");			//movie



	map.SetAt("x-world/x-vrml",	"vrm");					//vrm vrml wrl

	map.SetAt("x-world/x-vrml",	"vrml");

	map.SetAt("x-world/x-vrml",	"wrl");



	media_type.MakeLower();



	CString extension;

	map.Lookup(media_type, extension);

	return extension;

}