// NotifyIcon class - Copyright(C) 2003 minamina

//

//////////////////////////////////////////////////////////////////////



#if !defined(AFX_NOTIFYICON_H__F7A01C65_D801_4CE0_B295_8D43709B3B53__INCLUDED_)

#define AFX_NOTIFYICON_H__F7A01C65_D801_4CE0_B295_8D43709B3B53__INCLUDED_



#if _MSC_VER > 1000

#pragma once

#endif // _MSC_VER > 1000



#include <shellapi.h>



#define DEFAULT_ANIMATION_TIMER_EVENT_ID (200)



class CNotifyIcon

{

public:

	void EndAnimation();

	bool StartAnimation();

	bool SetAnimation(LPCTSTR lpszFilename, DWORD dwInterval, bool bLoop = false, COLORREF crMask = RGB(255, 255, 255),

		UINT uiEventID = DEFAULT_ANIMATION_TIMER_EVENT_ID, UINT fuLoad = LR_DEFAULTCOLOR | LR_LOADFROMFILE);

	bool SetAnimation(WORD wResourceID, DWORD dwInterval, bool bLoop = false, COLORREF crMask = RGB(255, 255, 255),

		UINT uiEventID = DEFAULT_ANIMATION_TIMER_EVENT_ID, UINT fuLoad = LR_DEFAULTCOLOR);

	bool IsActive();

	void SetTip(WORD wResourceID);

	void SetTip(LPCTSTR lpszTip);

	bool SetIcon(WORD wResourceID, UINT fuLoad = LR_DEFAULTCOLOR);

	bool SetIcon(LPCTSTR lpszFilename, UINT fuLoad = LR_DEFAULTCOLOR | LR_LOADFROMFILE);

	bool SetIcon(HICON hIcon, bool bAutoDestroyIcon = true);

	void SetHInstance(HINSTANCE hInstance);

	UINT GetID();

	void SetID(UINT uID);

	void SetWindow(HWND hWnd);

	bool Modify();

	bool ModifyIcon(WORD wResourceID);

	bool ModifyIcon(LPCTSTR lpszFilename);

	bool ModifyIcon(HICON hIcon, bool bAutoDestroyIcon = true);

	bool ModifyTip(WORD wResourceID);

	bool ModifyTip(LPCTSTR lpszTip);

	bool Delete();

	bool Add();

	bool AddIcon(WORD wResourceID);

	bool AddIcon(LPCTSTR lpszFilename);

	bool AddIcon(HICON hIcon, bool bAutoDestroyIcon = true);



	UINT m_uTaskbarCreated;

	void Initialize(HINSTANCE hInstance, HWND hWnd, UINT uCallbackMessage);

	CNotifyIcon();

	virtual ~CNotifyIcon();

private:

	static CNotifyIcon* s_pNotifyIcon;

	static VOID CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

	void DestroyAnimationIcon();

	bool m_bAnimationLoop;

	HICON* m_hAnimationIconList;

	UINT m_uiAnimationTimerEventID;

	DWORD m_dwAnimationInterval;

	DWORD m_dwAnimationCount;

	DWORD m_dwAnimationIndex;

	bool m_bAutoDestroyIcon;

	bool m_bActive;

	void DestroyIcon();

	HINSTANCE m_hInstance;

	NOTIFYICONDATA m_notifyIconData;

};



#endif // !defined(AFX_NOTIFYICON_H__F7A01C65_D801_4CE0_B295_8D43709B3B53__INCLUDED_)

