// Pochy Plugin Copyright(C) 2004 minamina

// CPlugin & CPluginManager class



// This program is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published by

// the Free Software Foundation; either version 2 of the License, or

// (at your option) any later version.

//

// This program is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with this program; if not, write to the Free Software

// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit

// http://www.gnu.org/copyleft/gpl.html .



#include "stdafx.h"

#include <assert.h>

#include "Plugin.h"



//////////////////////////////////////////////////////////////////////

// \z/

//////////////////////////////////////////////////////////////////////



CPlugin::CPlugin() : m_hModule(NULL)

{

	PC_OnPluginCheck = NULL;

	PC_OnLoadPlugin = NULL;

	PC_OnUnloadPlugin = NULL;

	PC_OnOpen = NULL;

	PC_OnClose = NULL;

	PC_OnTextViewChanged = NULL;

	PC_OnOpenDraft = NULL;

	PC_OnSendMail = NULL;

	PC_OnAccountChanged = NULL;

	PC_OnFolderChanged = NULL;

	PC_OnActivate = NULL;

	PC_OnPreFilter = NULL;

	PC_OnPostFilter = NULL;

	PC_OnFetchFinished = NULL;

	PC_OnInitMenu = NULL;

}



CPlugin::~CPlugin()

{

}



bool CPlugin::IsValid()

{

	return m_hModule != NULL;

}



const CPlugin::CInfo& CPlugin::GetInfo() const

{

	return m_info;

}



const std::string CPlugin::GetPluginDllName()

{

	return m_dllPath.substr(m_dllPath.find_last_of(_T('\\')) + 1);

}



bool CPlugin::IsPreFilterPlugin()

{

	return PC_OnPreFilter != NULL;

}



bool CPlugin::LoadLibrary(const std::string& path)

{

	GetPluginDllName();

	m_hModule = ::LoadLibrary(path.c_str());



	if (m_hModule != NULL)

	{

		(FARPROC&)PC_OnPluginCheck = ::GetProcAddress(m_hModule, _T("PC_OnPluginCheck"));

		(FARPROC&)PC_OnLoadPlugin = ::GetProcAddress(m_hModule, _T("PC_OnLoadPlugin"));

		(FARPROC&)PC_OnUnloadPlugin = ::GetProcAddress(m_hModule, _T("PC_OnUnloadPlugin"));

		(FARPROC&)PC_OnOpen = ::GetProcAddress(m_hModule, _T("PC_OnOpen"));

		(FARPROC&)PC_OnClose = ::GetProcAddress(m_hModule, _T("PC_OnClose"));

		(FARPROC&)PC_OnTextViewChanged = ::GetProcAddress(m_hModule, _T("PC_OnTextViewChanged"));

		(FARPROC&)PC_OnOpenDraft = ::GetProcAddress(m_hModule, _T("PC_OnOpenDraft"));

		(FARPROC&)PC_OnSendMail = ::GetProcAddress(m_hModule, _T("PC_OnSendMail"));

		(FARPROC&)PC_OnAccountChanged = ::GetProcAddress(m_hModule, _T("PC_OnAccountChanged"));

		(FARPROC&)PC_OnFolderChanged = ::GetProcAddress(m_hModule, _T("PC_OnFolderChanged"));

		(FARPROC&)PC_OnActivate = ::GetProcAddress(m_hModule, _T("PC_OnActivate"));

		(FARPROC&)PC_OnPreFilter = ::GetProcAddress(m_hModule, _T("PC_OnPreFilter"));

		(FARPROC&)PC_OnPostFilter = ::GetProcAddress(m_hModule, _T("PC_OnPostFilter"));

		(FARPROC&)PC_OnFetchFinished = ::GetProcAddress(m_hModule, _T("PC_OnFetchFinished"));

		(FARPROC&)PC_OnInitMenu = ::GetProcAddress(m_hModule, _T("PC_OnInitMenu"));



		m_dllPath = path;

	}



	return m_hModule != NULL;

}



void CPlugin::FreeLibrary()

{

	if (m_hModule != NULL)

	{

		::FreeLibrary(m_hModule);

		m_hModule = NULL;

	}

}



bool CPlugin::OnPluginCheck()

{

	if (IsValid() && PC_OnPluginCheck != NULL)

	{

		POCHY_PLUGIN_INFO pluginInfo;



		PC_OnPluginCheck(&pluginInfo);



		pluginInfo.szName[POCHY_PLUGIN_INFO_NAME_SIZE - 1] = _T('\0');

		pluginInfo.szVersion[POCHY_PLUGIN_INFO_VERSION_SIZE - 1] = _T('\0');

		pluginInfo.szCopyright[POCHY_PLUGIN_INFO_COPYRIGHT_SIZE - 1] = _T('\0');

		pluginInfo.szComments[POCHY_PLUGIN_INFO_COMMENTS_SIZE - 1] = _T('\0');



		m_info.m_name = pluginInfo.szName;

		m_info.m_version = pluginInfo.szVersion;

		m_info.m_copyright = pluginInfo.szCopyright;

		m_info.m_comments = pluginInfo.szComments;



		return true;

	}

	return false;

}



void CPlugin::OnLoadPlugin()

{

	if (IsValid() && PC_OnLoadPlugin != NULL)

	{

		PC_OnLoadPlugin();

	}

}



void CPlugin::OnUnloadPlugin()

{

	if (IsValid() && PC_OnUnloadPlugin != NULL)

	{

		PC_OnUnloadPlugin();

	}

}



void CPlugin::OnOpen()

{

	if (IsValid() && PC_OnOpen != NULL)

	{

		PC_OnOpen();

	}

}



POCHY_RESULT_TYPE CPlugin::OnClose()

{

	if (IsValid() && PC_OnClose != NULL)

	{

		return PC_OnClose();

	}

	return PR_CLOSE_OK;

}



void CPlugin::OnTextViewChanged(BOOL bShow)

{

	if (IsValid() && PC_OnTextViewChanged != NULL)

	{

		PC_OnTextViewChanged(bShow);

	}

}



void CPlugin::OnOpenDraft(HWND hDraftWindow)

{

	if (IsValid() && PC_OnOpenDraft != NULL)

	{

		PC_OnOpenDraft(hDraftWindow);

	}

}



POCHY_RESULT_TYPE CPlugin::OnSendMail(LPCTSTR lpszRawMessage)

{

	if (IsValid() && PC_OnSendMail != NULL)

	{

		return PC_OnSendMail(lpszRawMessage);

	}

	return PR_SEND_OK;

}



void CPlugin::OnAccountChanged(LPCTSTR lpszAccountName)

{

	if (IsValid() && PC_OnAccountChanged != NULL)

	{

		PC_OnAccountChanged(lpszAccountName);

	}

}



void CPlugin::OnFolderChanged(LPCTSTR lpszFolderName)

{

	if (IsValid() && PC_OnFolderChanged != NULL)

	{

		PC_OnFolderChanged(lpszFolderName);

	}

}



void CPlugin::OnActivate(UINT nState)

{

	if (IsValid() && PC_OnActivate != NULL)

	{

		PC_OnActivate(nState);

	}

}



void CPlugin::OnPreFilter(LPCTSTR lpszRawMessage, LPTSTR lpszMailSavePath)

{

	if (IsValid() && PC_OnPreFilter != NULL)

	{

		PC_OnPreFilter(lpszRawMessage, lpszMailSavePath);

	}

}



void CPlugin::OnPostFilter(LPCTSTR lpszMailSaveFilename)

{

	if (IsValid() && PC_OnPostFilter != NULL)

	{

		PC_OnPostFilter(lpszMailSaveFilename);

	}

}



void CPlugin::OnFetchFinished(LPCTSTR lpszAccountName, const int nFetchCount)

{

	if (IsValid() && PC_OnFetchFinished != NULL)

	{

		PC_OnFetchFinished(lpszAccountName, nFetchCount);

	}

}



void CPlugin::OnInitMenu(HMENU hMenu, POCHY_MENU_TYPE nPochyMenuType)

{

	if (IsValid() && PC_OnInitMenu != NULL)

	{

		PC_OnInitMenu(hMenu, nPochyMenuType);

	}

}



//////////////////////////////////////////////////////////////////////

// \z/

//////////////////////////////////////////////////////////////////////



CPluginManager::CPluginManager() : m_bHasPreFilterPlugin(false)

{

}



CPluginManager::~CPluginManager()

{

	UnloadAllPlugins();

}



const CPluginManager::PLUGIN_LIST& CPluginManager::GetPluginList()

{

	return m_pluginList;

}



const std::string CPluginManager::GetPluginPath()

{

	std::string pluginPath;



	const int MAX_PLUGIN_FOLDER = 1024;

	TCHAR tcPath[MAX_PLUGIN_FOLDER], tcDrive[MAX_PLUGIN_FOLDER],

		tcDir[MAX_PLUGIN_FOLDER], tcFname[MAX_PLUGIN_FOLDER], tcExt[MAX_PLUGIN_FOLDER];

	if (::GetModuleFileName(NULL, tcPath, MAX_PLUGIN_FOLDER) > 0)

	{

		_tsplitpath(tcPath, tcDrive, tcDir, tcFname, tcExt);

		pluginPath = (std::string)tcDrive + tcDir + _T("Plugins");

	}



	return pluginPath;

}



// OnPreFilter ĂvOC邩ǂԂ

// FetchMail ̒ RowMail WJKv邩ǂ𔻒f邽߂Ɏg

bool CPluginManager::HasPreFilterPlugin()

{

	return m_bHasPreFilterPlugin;

}



void CPluginManager::LoadAllPlugins()

{

	std::string pluginPath = GetPluginPath();

	WIN32_FIND_DATA findFileData;

	HANDLE hFindFile = ::FindFirstFile((pluginPath + _T("\\*.dll")).c_str(), &findFileData);

	if (hFindFile != INVALID_HANDLE_VALUE)

	{

		do

		{

			CPlugin plugin;

			if (plugin.LoadLibrary(pluginPath + _T("\\") + findFileData.cFileName))

			{

				if (plugin.OnPluginCheck())

				{

					m_pluginList.push_back(plugin);

					if (plugin.IsPreFilterPlugin())

					{

						m_bHasPreFilterPlugin = true;

					}

				}

				else

				{

					plugin.FreeLibrary();

				}

			}

		}

		while (::FindNextFile(hFindFile, &findFileData) != 0);



		::FindClose(hFindFile);

	}



	OnLoadPlugin();

}



void CPluginManager::UnloadAllPlugins()

{

	OnUnloadPlugin();



	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->FreeLibrary();

	}

	m_pluginList.clear();

}



void CPluginManager::OnLoadPlugin()

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnLoadPlugin();

	}

}



void CPluginManager::OnUnloadPlugin()

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnUnloadPlugin();

	}

}



void CPluginManager::OnOpen()

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnOpen();

	}

}



POCHY_RESULT_TYPE CPluginManager::OnClose()

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		if (it->OnClose() == PR_CLOSE_CANCEL)

		{

			return PR_CLOSE_CANCEL;

		}

	}

	return PR_CLOSE_OK;

}



void CPluginManager::OnTextViewChanged(BOOL bShow)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnTextViewChanged(bShow);

	}

}



void CPluginManager::OnOpenDraft(HWND hDraftWindow)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnOpenDraft(hDraftWindow);

	}

}



POCHY_RESULT_TYPE CPluginManager::OnSendMail(LPCTSTR lpszRawMessage)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		if (it->OnSendMail(lpszRawMessage) == PR_SEND_CANCEL)

		{

			return PR_SEND_CANCEL;

		}

	}

	return PR_SEND_OK;

}



void CPluginManager::OnAccountChanged(LPCTSTR lpszAccountName)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnAccountChanged(lpszAccountName);

	}

}



void CPluginManager::OnFolderChanged(LPCTSTR lpszFolderName)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnFolderChanged(lpszFolderName);

	}

}



void CPluginManager::OnActivate(UINT nState)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnActivate(nState);

	}

}



void CPluginManager::OnPreFilter(LPCTSTR lpszRawMessage, LPTSTR lpszMailSavePath)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnPreFilter(lpszRawMessage, lpszMailSavePath);

	}

}



void CPluginManager::OnPostFilter(LPCTSTR lpszMailSaveFilename)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnPostFilter(lpszMailSaveFilename);

	}

}



void CPluginManager::OnFetchFinished(LPCTSTR lpszAccountName, const int nFetchCount)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnFetchFinished(lpszAccountName, nFetchCount);

	}

}



void CPluginManager::OnInitMenu(HMENU hMenu, POCHY_MENU_TYPE nPochyMenuType)

{

	PLUGIN_LIST::iterator it;

	for (it = m_pluginList.begin(); it != m_pluginList.end(); ++it)

	{

		it->OnInitMenu(hMenu, nPochyMenuType);

	}

}

