/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



#include "stdafx.h"

#include "Pochy.h"

#include "MainFrm.h"

#include "DraftFrame.h"

#include "Smtp.h"

#include "sendmail.h"

#include "direct.h"

#include "PassPhraseDlg.h"

#include "lib.h"

#include "DraftSendDlg.h"

#include "Pop.h"

#include "SendMailThreadCmd.h" // [MXbh̃R}hꗗ



BOOL pop_before_smtp(LPCTSTR address, LPCTSTR port, LPCTSTR user, LPCTSTR pass, BOOL apop)

{

	CPochyApp* app = (CPochyApp*)AfxGetApp();

	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;



	CPop pop;

	CString message;

	CString receive;

	CString log_path = app->m_app_path+"\\smtp_debug_log.txt";



	// wheather or not log

	int log = app->GetProfileInt("Log", "Smtp", 0);



	// start pop session

	if(log) g_log("start pop before smtp session\r\n", log_path);

	if(!pop.StartSession(address, port, receive)){

		return FALSE;

	}

	message = receive; // keep this for apop

	if(log) g_log(receive, log_path);



	if(apop){

		// if using apop, below is done.

		if(log) g_log("apop\r\n", log_path);

		if(!pop.Apop(user, pass, message, receive)){

			return FALSE;

		}

		if(log) g_log(receive, log_path);

	}else{

		// below is normal authentification using user and pass command.

		// user

		if(log) g_log("user\r\n", log_path);

		if(!pop.User(user, receive)){

			return FALSE;

		}

		if(log) g_log(receive, log_path);

		// pass

		if(log) g_log("pass\r\n", log_path);

		if(!pop.Pass(pass, receive)){

			return FALSE;

		}

		if(log) g_log(receive, log_path);

	}



	// quit

	if(log) g_log("quit\r\n", log_path);

	pop.Quit(receive);

	if(log) g_log(receive, log_path);

	// close socket

	pop.DisConnect();



	return TRUE;

}



UINT SendMail(LPVOID pParam)

{

	CDraftFrame *df = (CDraftFrame *)pParam;

	CPochyApp* app = (CPochyApp*)AfxGetApp();

	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;



	CSmtp smtp;

	CSock pop;

	CString smtp_ip;

  	CString smtp_addr;

	CString smtp_port;

	CString smtp_auth_id;

	CString smtp_auth_pass;

	CString buf;

	CString log_path = app->m_app_path+"\\smtp_debug_log.txt";



	mf->StartTaskTrayAnimation();



	// wheather or not log

	int log = app->GetProfileInt("Log", "Smtp", 0);



	// prepare for ini file path

	CString path = app->m_app_path + "\\" + df->m_account + "\\account.ini";



	try{

		// confirmation of header

		if(df->m_me.GetTo().IsEmpty()){

			buf = "To: tB[hł";

			throw buf;

		}

		if(df->m_me.GetFrom().IsEmpty()){

			buf = "From: tB[hł";

			throw buf;

		}

		if(df->m_me.GetSubject().IsEmpty()){

			buf = "Subject: tB[hł\r\nM𑱂܂?";

			if(IDNO == df->MessageBox(buf, "mF", MB_YESNO)){

				buf.Empty();

				throw buf;

			}

		}

		// pop before smtp

		if(GetPrivateProfileInt("smtp", "pop_before_smtp", 0, path)){

			CString pop_addr;

			CString pop_port;

			CString pop_user;

			CString pop_pass;

			CString is_secreted;



			// get user name from ini file.

			GetPrivateProfileString("pop", "user", "", pop_user.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			pop_user.ReleaseBuffer();



			// get password from ini file.

			GetPrivateProfileString("pop", "pass", "", pop_pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			pop_pass.ReleaseBuffer();



			GetPrivateProfileString("secreted", "pass_secreted", "", is_secreted.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			is_secreted.ReleaseBuffer();

			//if pass_secreted equals "yes" then pass decode.

			if(!is_secreted.IsEmpty()) {	

				if(is_secreted.Compare("yes") == 0) {

					pop_pass = g_simple_decode(pop_pass);

				}

			}



			if(pop_pass.IsEmpty() && !mf->m_pAcntV->GetPopPass(df->m_account).IsEmpty()){

				pop_pass = mf->m_pAcntV->GetPopPass(df->m_account);

			}else if(pop_pass.IsEmpty() && mf->m_pAcntV->GetPopPass(df->m_account).IsEmpty()){

				// if getting no password from ini file, then show dialog for input password.

				CPassPhraseDlg passDlg(df);

				if(IDOK == passDlg.DoModal()){

					pop_pass = passDlg.GetPass();

					mf->m_pAcntV->SetPopPass(df->m_account, pop_pass);

				}else{

					buf = "";

					throw buf;

				}

			}



			// prepare for pop session

			GetPrivateProfileString("pop", "server_addr", "", pop_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			pop_addr.ReleaseBuffer();

			GetPrivateProfileString("pop", "port", "", pop_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			pop_port.ReleaseBuffer();



			df->m_send_dlg->m_status.SetWindowText("pop before smtp");

			if(!pop_before_smtp(pop_addr, pop_port, pop_user, pop_pass, GetPrivateProfileInt("pop", "apop", 0, path))){

				pop_pass.Empty();

				mf->m_pAcntV->SetPopPass(df->m_account, pop_pass);

				buf = "pop before smtp error";

				throw buf;

			}

		}



		// start smtp session

		if(GetPrivateProfileInt("smtp", "auth", 0, path)){

			// get auth id from ini file.

			GetPrivateProfileString("smtp", "auth_id", "", smtp_auth_id.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			smtp_auth_id.ReleaseBuffer();



			// get auth password from ini file.

			GetPrivateProfileString("smtp", "auth_pass", "", smtp_auth_pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			smtp_auth_pass.ReleaseBuffer();



			CString isSecreted;

			GetPrivateProfileString("secreted", "pass_secreted", "", isSecreted.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			isSecreted.ReleaseBuffer();

			//if pass_secreted equals "yes" then pass decode.

			if(!isSecreted.IsEmpty()) {	

				if(isSecreted.Compare("yes") == 0) {

					smtp_auth_pass = g_simple_decode(smtp_auth_pass);

				}

			}



			if(smtp_auth_pass.IsEmpty() && !mf->m_pAcntV->GetSmtpAuthPass(df->m_account).IsEmpty()){

				smtp_auth_pass = mf->m_pAcntV->GetSmtpAuthPass(df->m_account);

			}else if(smtp_auth_pass.IsEmpty() && mf->m_pAcntV->GetSmtpAuthPass(df->m_account).IsEmpty()){

				// if getting no password from ini file, then show dialog for inputing password.

				CPassPhraseDlg passDlg(df);

				if(IDOK == passDlg.DoModal()){

					smtp_auth_pass = passDlg.GetPass();

					mf->m_pAcntV->SetSmtpAuthPass(df->m_account, smtp_auth_pass);

				}else{

					buf = "";

					throw buf;

				}

			}

		}

		// prepare for smtp session

		GetPrivateProfileString("smtp", "server_addr", "", smtp_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

		smtp_addr.ReleaseBuffer();

		GetPrivateProfileString("smtp", "port", "", smtp_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

		smtp_port.ReleaseBuffer();



		// start smtp session

		df->m_send_dlg->m_status.SetWindowText("start session");

		if(log) g_log("start session\r\n", log_path);

		if(!smtp.StartSession(smtp_addr, smtp_port, buf)){

			throw buf;

		}

		df->m_send_dlg->m_status.SetWindowText(buf);

		if(log) g_log(buf, log_path);

		// helo or ehlo

		if(GetPrivateProfileInt("smtp", "auth", 0, path)){

			df->m_send_dlg->m_status.SetWindowText("ehlo");

			if(log) g_log("ehlo\r\n", log_path);

			if(!smtp.Ehlo(smtp_auth_id, smtp_auth_pass, buf)){

				mf->m_pAcntV->SetSmtpAuthPass(df->m_account, "");

				throw buf;

			}

			df->m_send_dlg->m_status.SetWindowText(buf);

			if(log) g_log(buf, log_path);

		}else{

			df->m_send_dlg->m_status.SetWindowText("helo");

			if(log) g_log("helo\r\n", log_path);

			if(!smtp.Helo(buf))

				throw buf;

			df->m_send_dlg->m_status.SetWindowText(buf);

			if(log) g_log(buf, log_path);

		}

		// mail from

		df->m_send_dlg->m_status.SetWindowText("mail from");

		if(log) g_log("mail from\r\n", log_path);

		if(!smtp.MailFrom(g_ma(df->m_me.GetFrom()), buf)){

			throw buf;

		}

		df->m_send_dlg->m_status.SetWindowText(buf);

		if(log) g_log(buf, log_path);

		// rcpt to

		df->m_send_dlg->m_status.SetWindowText("rcpt to");

		if(log) g_log("rcpt to\r\n", log_path);

		CString to = df->m_me.GetTo();

		if(!df->m_me.GetCc().IsEmpty())

			to += ", "+df->m_me.GetCc();

		if(!df->m_me.GetBcc().IsEmpty())

			to += ", "+df->m_me.GetBcc();

		CStringArray to_array;

		g_split_address(to, to_array, FALSE, TRUE);



		if(log) g_log("rcpt to\r\n", log_path);

		if(!smtp.RcptTo(to_array, buf)){

			throw buf;

		}

		df->m_send_dlg->m_status.SetWindowText(buf);

		if(log) g_log(buf, log_path);



		// data

		df->m_send_dlg->m_status.SetWindowText("date");

		if(log) g_log("date\r\n", log_path);

		if(!smtp.DataStart(buf)){

			throw buf;

		}

		df->m_send_dlg->m_status.SetWindowText(buf);

		if(log) g_log(buf, log_path);



		CString mail = df->m_me.GetMail(ME_GET_SEND);

		mail.Replace("\r\n.", "\r\n..");



		int whole_len = mail.GetLength();

		int current_len;

		int part_len;

		part_len = current_len = mail.GetLength()/8;



		df->m_send_dlg->m_progress.SetRange32(0, whole_len);

		df->m_send_dlg->m_progress.SetPos(0);

		while(current_len < whole_len){

			buf = mail.Left(part_len);

			mail = mail.Mid(part_len);

			smtp.SockWrite(buf, buf.GetLength());

			buf.Empty();

			df->m_send_dlg->m_progress.SetPos(current_len);

			current_len += part_len;

		}

		smtp.SockWrite(mail, mail.GetLength());

		df->m_send_dlg->m_progress.SetPos(whole_len);



		// finish data with \r\n.\r\n

		if(log) g_log(".\r\n", log_path);

		if(!smtp.DataEnd(buf)){

			throw buf;

		}

		df->m_send_dlg->m_status.SetWindowText(buf);

		if(log) g_log(buf, log_path);



		// get path to outbox

		CString path = app->m_app_path + "\\" + df->m_account + "\\outbox";

		// save mail in outbox

		CSummaryView *sv = mf->m_pListV;

		sv->SaveMail(path, df->m_me.GetMail(ME_GET_OUTBOX), SMRY_STATUS_NONE, SMRY_COLUMN_TO);



		// ʃXbhĂяoƃG[ɂȂꍇ (march 9th, 2004 by color)

//		sv->SortWithRequiredCheck();

		::PostMessage(sv->m_hWnd, SENDMAIL_THREAD_COMMAND, SDMTC_SORT_WITH_REQUIRED_CHECK, 0);



		// quit

		df->m_send_dlg->m_status.SetWindowText("quit");

		if(log) g_log("normal quit\r\n", log_path);

		smtp.Quit(buf);

		df->m_send_dlg->m_status.SetWindowText(buf);

		if(log) g_log(buf, log_path);

		// close socket

		smtp.EndSession();

	}

	catch(CString &errorstr){

		if(log) g_log(errorstr, log_path);

		if(log) g_log("error quit\r\n", log_path);

		// quit

		smtp.Quit(buf);

		if(log) g_log(buf, log_path);

		// close socket

		smtp.EndSession();

		if(!errorstr.IsEmpty()){

			df->MessageBox(errorstr, df->m_account+" - smtp error");

		}

		df->EnableWindow(TRUE);

		df->m_send_dlg->m_status.SetWindowText("");

		df->m_send_dlg->EndDialog(0);

		df->m_send_dlg = NULL;

		mf->StopTaskTrayAnimation();

		return FALSE;

	}



	df->EnableWindow(TRUE);

	df->m_send_dlg->m_status.SetWindowText("");

	df->m_send_dlg->EndDialog(0);

	df->m_send_dlg = NULL;

	mf->StopTaskTrayAnimation();



	// destroy draft window

	PostMessage(df->m_hWnd, WM_COMMAND, WM_END, NULL);



	// remove current draftframe poionter from draftframe pointer array

	for(int i=0; i<app->m_draft_array.GetSize(); i++){

		if(df == app->m_draft_array[i])

			app->m_draft_array.RemoveAt(i);

	}



	return TRUE;

}

