/*

 * Copyright (C) 2002-2003 chik, s.hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// SettingDlg.cpp : Cve[V t@C

//



#include "stdafx.h"

#include "Pochy.h"

#include "SettingAccountDlg.h"

#include "direct.h"

#include "mainfrm.h"

#include "lib.h"

#include "AccountView.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



/////////////////////////////////////////////////////////////////////////////

// CSettingAccountDlg _CAO





CSettingAccountDlg::CSettingAccountDlg(CWnd* pParent /*=NULL*/)

	: CDialog(CSettingAccountDlg::IDD, pParent)

{

	//{{AFX_DATA_INIT(CSettingAccountDlg)

	//}}AFX_DATA_INIT

}





void CSettingAccountDlg::DoDataExchange(CDataExchange* pDX)

{

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CSettingAccountDlg)

	DDX_Control(pDX, IDC_SETTING_CHECK_SMTP_AUTH, m_smtp_auth);

	DDX_Control(pDX, IDC_SETTING_SMTP_AUTH_PASS, m_smtp_auth_pass);

	DDX_Control(pDX, IDC_SETTING_SMTP_AUTH_ID, m_smtp_auth_id);

	DDX_Control(pDX, IDC_SETTING_DEF_ADDRESS_EDIT, m_def_address_edit);

	DDX_Control(pDX, IDC_SETTING_DEF_ADDRESS, m_def_address);

	DDX_Control(pDX, IDC_SETTING_CHECK_APOP, m_apop);

	DDX_Control(pDX, IDC_SETTING_CHECK_DELMAIL, m_deletemail_pop);

	DDX_Control(pDX, IDC_SETTING_CHECK_POP_BEFORE_SMTP, m_pop_before_smtp);

	DDX_Control(pDX, IDOK, m_button_ok);

	DDX_Control(pDX, IDC_SETTING_BOXNAME, m_boxname);

	DDX_Control(pDX, IDC_SETTING_SIG, m_signature);

	DDX_Control(pDX, IDC_SETTING_USERID, m_user);

	DDX_Control(pDX, IDC_SETTING_ADDRESS, m_address);

	DDX_Control(pDX, IDC_SETTING_PASS, m_password);

	DDX_Control(pDX, IDC_SETTING_SMTP_PORT, m_smtpserver_port);

	DDX_Control(pDX, IDC_SETTING_SMTP_IP, m_smtpserver);

	DDX_Control(pDX, IDC_SETTING_POP_PORT, m_popserver_port);

	DDX_Control(pDX, IDC_SETTING_POP_IP, m_popserver);

	//}}AFX_DATA_MAP

}





BEGIN_MESSAGE_MAP(CSettingAccountDlg, CDialog)

	//{{AFX_MSG_MAP(CSettingAccountDlg)

	ON_CBN_SELCHANGE(IDC_SETTING_DEF_ADDRESS, OnSelchangeAutoAddress)

	ON_BN_CLICKED(IDC_SETTING_CHECK_SMTP_AUTH, OnCheckSmtpAuth)

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CSettingAccountDlg bZ[W nh



BOOL CSettingAccountDlg::OnInitDialog() 

{

	CDialog::OnInitDialog();

	get_app;

	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

	CString current_account = mf->m_pAcntV->GetCurrentAccountName();



	CString path = app->m_app_path + "\\" + current_account + "\\account.ini";

	CString pop_addr;

	GetPrivateProfileString("pop", "server_addr", "", pop_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	pop_addr.ReleaseBuffer();

	m_popserver.SetWindowText(pop_addr);



	CString pop_port;

	GetPrivateProfileString("pop", "port", "", pop_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	pop_port.ReleaseBuffer();

	if(pop_port.IsEmpty()) pop_port = "110";

	m_popserver_port.SetWindowText(pop_port);



	CString smtp_addr;

	GetPrivateProfileString("smtp", "server_addr", "", smtp_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	smtp_addr.ReleaseBuffer();

	m_smtpserver.SetWindowText(smtp_addr);



	CString smtp_port;

	GetPrivateProfileString("smtp", "port", "", smtp_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	smtp_port.ReleaseBuffer();

	if(smtp_port.IsEmpty()) smtp_port = "25";

	m_smtpserver_port.SetWindowText(smtp_port);



/*	CString pass;

	GetPrivateProfileString("pop", "pass", "", pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	pass.ReleaseBuffer();

	pass = g_simple_decode(pass);

	m_password.SetWindowText(pass);*/

	CString pass,isSecreted;

	GetPrivateProfileString("pop", "pass", "", pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	GetPrivateProfileString("secreted", "pass_secreted", "", isSecreted.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	pass.ReleaseBuffer();

	isSecreted.ReleaseBuffer();

	//if pass_secreted equals "yes" then pass decode.

	if(!isSecreted.IsEmpty()) {	

		if(isSecreted.Compare("yes") == 0) {

			pass = g_simple_decode(pass);

		}

	}

	m_password.SetWindowText(pass);



	CString address;

	GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	address.ReleaseBuffer();

	m_address.SetWindowText(address);



	CString user;

	GetPrivateProfileString("pop", "user", "", user.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	user.ReleaseBuffer();

	m_user.SetWindowText(user);



	m_boxname.SetWindowText(current_account);



	m_deletemail_pop.SetCheck(GetPrivateProfileInt("pop", "delete_mail", 0, path));



	m_pop_before_smtp.SetCheck(GetPrivateProfileInt("smtp", "pop_before_smtp", 0, path));



	m_apop.SetCheck(GetPrivateProfileInt("pop", "apop", 0, path));



	CString smtp_auth_id;

	CString smtp_auth_pass;

	m_smtp_auth.SetCheck(GetPrivateProfileInt("smtp", "auth", 0, path));

	if(m_smtp_auth.GetCheck()){

		m_smtp_auth_id.SetReadOnly(FALSE);

		GetPrivateProfileString("smtp", "auth_id", "", smtp_auth_id.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

		smtp_auth_id.ReleaseBuffer();

		m_smtp_auth_id.SetWindowText(smtp_auth_id);



		m_smtp_auth_pass.SetReadOnly(FALSE);

		GetPrivateProfileString("smtp", "auth_pass", "", smtp_auth_pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

		smtp_auth_pass.ReleaseBuffer();

		//if pass_secreted equals "yes" then pass decode.

		if(!isSecreted.IsEmpty()) {	

			if(isSecreted.Compare("yes") == 0) {

				smtp_auth_pass = g_simple_decode(smtp_auth_pass);

			}

		}

		m_smtp_auth_pass.SetWindowText(smtp_auth_pass);

	}else{

		m_smtp_auth_id.SetReadOnly();

		m_smtp_auth_pass.SetReadOnly();

	}



	// default address

	m_def_address.AddString("Cc");

	m_def_address.AddString("Bcc");

	m_def_address.AddString("Reply-To");



	CString cc;

	GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	cc.ReleaseBuffer();

	m_def_address_array.Add(cc);



	CString bcc;

	GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	bcc.ReleaseBuffer();

	m_def_address_array.Add(bcc);



	CString reply_to;

	GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

	reply_to.ReleaseBuffer();

	m_def_address_array.Add(reply_to);



	m_def_address.SetCurSel(0);

	m_current_def_address = 0;

	m_def_address_edit.SetWindowText(m_def_address_array.GetAt(0));



	// signature without pgp key

	CString signature;

	signature.Empty();

	if(g_file2cstring(app->m_app_path+"\\"+mf->m_pAcntV->GetCurrentAccountName()+"\\signature", signature))

		m_signature.SetWindowText(signature);

	else

		m_signature.SetWindowText("");



	return FALSE;

}



void CSettingAccountDlg::OnOK()

{

	get_app;

	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

	CString current_account = mf->m_pAcntV->GetCurrentAccountName();



	// getting edited accout name

	CString account;

	this->GetDlgItemText(IDC_SETTING_BOXNAME, account);

	account.TrimLeft();

	account.TrimRight();

	if (account.IsEmpty())

	{

		AfxMessageBox("AJEg󔒂ł");

		return;

	}

	if(account.FindOneOf("/:*?\\\"<>|") != -1){

		AfxMessageBox(account+" ͕sȃAJEgł");

		return;

	}



	// change account name

	if(current_account != account){

		// if same name folder exist, exit

		if(g_is_there(app->m_app_path+"\\"+account)){

			CString message;

			message.Format("%s͊ɑ݂Ă܂\r\nOς܂傤", account);

			AfxMessageBox(message);

			return;

		}

		rename(app->m_app_path+"\\"+current_account, app->m_app_path+"\\"+account);

		mf->m_pAcntV->RenameAccount(current_account, account);

		// if edited account is default account, below need to be done.

		if(app->GetProfileString("DefaultMailBox", "boxname") == current_account)

			app->WriteProfileString("DefaultMailBox", "boxname", account);

	}



	CString path = app->m_app_path+"\\"+account+"\\account.ini";



	CString stmp;

	m_user.GetWindowText(stmp); WritePrivateProfileString("pop", "user", stmp, path);

	m_password.GetWindowText(stmp); WritePrivateProfileString("secreted", "pass_secreted", "yes", path);

	m_password.GetWindowText(stmp); WritePrivateProfileString("pop", "pass", g_simple_encode(stmp), path);

	m_popserver.GetWindowText(stmp); WritePrivateProfileString("pop", "server_addr", stmp, path);

	m_smtpserver.GetWindowText(stmp); WritePrivateProfileString("smtp", "server_addr", stmp, path);

	m_address.GetWindowText(stmp); WritePrivateProfileString("mailbox", "address", stmp, path);

	m_popserver_port.GetWindowText(stmp); WritePrivateProfileString("pop", "port", stmp, path);

	m_smtpserver_port.GetWindowText(stmp); WritePrivateProfileString("smtp", "port", stmp, path);

	m_signature.GetWindowText(stmp);

	DeleteFile(app->m_app_path + "\\" + account + "\\signature");

	g_string2file(stmp ,app->m_app_path + "\\" + account + "\\signature");



	CString check;

	// check romoving delete mail from spool or not

	itoa(m_deletemail_pop.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);

	check.ReleaseBuffer();

	WritePrivateProfileString("pop", "delete_mail", check, path);

	// check using pop before smtp or not

	itoa(m_pop_before_smtp.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);

	check.ReleaseBuffer();

	WritePrivateProfileString("smtp", "pop_before_smtp", check, path);

	// check using apop or not

	itoa(m_apop.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);

	check.ReleaseBuffer();

	WritePrivateProfileString("pop", "apop", check, path);

	// check smtp auth

	itoa(m_smtp_auth.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);

	check.ReleaseBuffer();

	WritePrivateProfileString("smtp", "auth", check, path);

	m_smtp_auth_id.GetWindowText(stmp); WritePrivateProfileString("smtp", "auth_id", stmp, path);

	m_smtp_auth_pass.GetWindowText(stmp); WritePrivateProfileString("smtp", "auth_pass", g_simple_encode(stmp), path);



	// save def address

	int sel = m_def_address.GetCurSel();

	CString def_address;

	m_def_address_edit.GetWindowText(def_address);

	m_def_address_array.SetAt(sel, def_address);

	WritePrivateProfileString("def_address", "cc", m_def_address_array.GetAt(0), path);

	WritePrivateProfileString("def_address", "bcc", m_def_address_array.GetAt(1), path);

	WritePrivateProfileString("def_address", "reply_to", m_def_address_array.GetAt(2), path);



	CDialog::OnOK();

}



void CSettingAccountDlg::OnSelchangeAutoAddress() 

{

	CString address;

	m_def_address_edit.GetWindowText(address);

	this->m_def_address_array.SetAt(this->m_current_def_address, address);

	int sel = m_def_address.GetCurSel();

	address = m_def_address_array.GetAt(sel);

	m_def_address_edit.SetWindowText(address);

	this->m_current_def_address = sel;



}



void CSettingAccountDlg::OnCheckSmtpAuth() 

{

	if(m_smtp_auth.GetCheck()){

		m_smtp_auth_id.SetReadOnly(FALSE);

		m_smtp_auth_pass.SetReadOnly(FALSE);

	}else{

		m_smtp_auth_id.SetReadOnly();

		m_smtp_auth_pass.SetReadOnly();

	}

}

