/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



// SettingGeneralOtherDlg.cpp : Cve[V t@C

//



#include "stdafx.h"

#include "pochy.h"

#include "MainFrm.h"

#include "SettingGeneralOtherDlg.h"

#include "lib.h"



#ifdef _DEBUG

#define new DEBUG_NEW

#undef THIS_FILE

static char THIS_FILE[] = __FILE__;

#endif



/////////////////////////////////////////////////////////////////////////////

// CSettingGeneralOtherDlg _CAO





CSettingGeneralOtherDlg::CSettingGeneralOtherDlg(CWnd* pParent /*=NULL*/)

	: CDialog(CSettingGeneralOtherDlg::IDD, pParent)

{

	//{{AFX_DATA_INIT(CSettingGeneralOtherDlg)

	//}}AFX_DATA_INIT

}





void CSettingGeneralOtherDlg::DoDataExchange(CDataExchange* pDX)

{

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CSettingGeneralOtherDlg)

	DDX_Control(pDX, IDC_SETTING_GENERAL_SHOW_UNREAD_COUNT, m_checkShowUnreadCount);

	DDX_Control(pDX, IDC_SETTING_GENERAL_TASKTRAY_ONLY, m_checkTaskTrayOnly);

	DDX_Control(pDX, IDC_SETTING_GENERAL_USE_TASKTRAY, m_checkUseTaskTray);

	DDX_Control(pDX, IDC_SETTING_GENERAL_AUTOFETCH_MINUTES, m_autofetch_minute);

	DDX_Control(pDX, IDC_SETTING_GENERAL_DEFACCOUNT, m_def_account);

	DDX_Control(pDX, IDC_SETTING_GENERAL_EDITOR_PATH, m_editor_path);

	//}}AFX_DATA_MAP

}





BEGIN_MESSAGE_MAP(CSettingGeneralOtherDlg, CDialog)

	//{{AFX_MSG_MAP(CSettingGeneralOtherDlg)

	ON_BN_CLICKED(IDC_SETTING_GENERAL_EDITOR_REF, OnEditorRef)

	ON_BN_CLICKED(IDC_SETTING_GENERAL_USE_TASKTRAY, OnSettingGeneralUseTasktray)

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////

// CSettingGeneralOtherDlg bZ[W nh



void CSettingGeneralOtherDlg::OnEditorRef() 

{

	CFileDialog dlg(TRUE, NULL, NULL, OFN_PATHMUSTEXIST, NULL, this);

	dlg.m_ofn.lpstrTitle = _T( "OGfB^[" );

	if(dlg.DoModal() == IDOK){

		m_editor_path.SetWindowText(dlg.GetPathName());

	}else{

		return;

	}

}



BOOL CSettingGeneralOtherDlg::OnInitDialog() 

{

	CDialog::OnInitDialog();

	CPochyApp *app = (CPochyApp *)AfxGetApp();



	m_editor_path.SetWindowText(app->GetProfileString("Editor", "Path")); 



	CFileFind ff;

	BOOL b = ff.FindFile(app->m_app_path+"\\*.*");

	int index;

	CString message;



	while(b){

		b = ff.FindNextFile();

		if(ff.IsDirectory() && !ff.IsDots()){

			if(g_is_there(app->m_app_path+"\\"+ff.GetFileName()+"\\account.ini")){

				index = m_def_account.AddString(ff.GetFileName());

				switch(index){

				case CB_ERR:

					message.Format("%s̏擾ɃG[܂", ff.GetFileName());

					AfxMessageBox(message);

				case CB_ERRSPACE:

					message.Format("%d̏擾ɃȂȂ܂", ff.GetFileName());

					AfxMessageBox(message);

				}

				if(m_def_account.SetItemData(index, index) == CB_ERR){

					message.Format("%s̏擾ɃG[܂", ff.GetFileName());

					AfxMessageBox(message);

				}else{

					m_def_account.SetItemData(index, index);

				}

			}

		}

	}

	CString account = app->GetProfileString("DefaultMailBox", "BoxName");

	if(!account.IsEmpty()){

		index = m_def_account.FindStringExact(-1, account);

		m_def_account.SetCurSel(index);

	}



	char buf[10];

	int minute = app->GetProfileInt("AutoFetch", "minute", 0);

	m_autofetch_minute.SetWindowText(itoa(minute, buf, 10));



	// ^XNgCACRݒǂݍ

	int nUseTaskTray = app->GetProfileInt(_T("TaskTray"), _T("UseTaskTray"), 0);

	m_checkUseTaskTray.SetCheck(nUseTaskTray);

	int nTaskTrayOnly = app->GetProfileInt(_T("TaskTray"), _T("TaskTrayOnly"), 0);

	m_checkTaskTrayOnly.SetCheck(nTaskTrayOnly);

	m_checkTaskTrayOnly.EnableWindow(nUseTaskTray != 0);



	// ǐ\ݒǂݍ

	int nShowUnreadCount = app->GetProfileInt(_T("FolderView"), _T("ShowUnreadCount"), 1);

	m_checkShowUnreadCount.SetCheck(nShowUnreadCount);

	CMainFrame *mf = (CMainFrame *)AfxGetApp()->m_pMainWnd;

	mf->m_pTreeV->SetShowUnreadCount(nShowUnreadCount == 1);



	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂

	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂

}



void CSettingGeneralOtherDlg::OnOK() 

{

}



void CSettingGeneralOtherDlg::OnSettingGeneralUseTasktray() 

{

	// ^XNgC𗘗p`FbN{bNXIꂽƂĂ΂

	int nUseTaskTray = m_checkUseTaskTray.GetCheck();

	m_checkTaskTrayOnly.EnableWindow(nUseTaskTray != 0);

}



void CSettingGeneralOtherDlg::OnCancel() 

{

	::PostMessage(::GetParent(::GetParent(GetSafeHwnd())), WM_KEYDOWN, VK_ESCAPE, 1);

}

