// TimeEx.cpp: CTimeEx NX̃Cve[V

//

//////////////////////////////////////////////////////////////////////



#include "stdafx.h"

#include "TimeEx.h"

#include "lib.h"



//////////////////////////////////////////////////////////////////////

// \z/

//////////////////////////////////////////////////////////////////////



CTimeEx::CTimeEx(time_t time, LPCTSTR offset)

{

	SetTimeT(time, offset);

}



CTimeEx::CTimeEx(LPCTSTR mail_format_date)

{

	SetMailFormatDate(mail_format_date);

}



CTimeEx::CTimeEx()

{



}



CTimeEx::~CTimeEx()

{



}



void CTimeEx::SetMailFormatDate(CString mail_format_date)

{



	char* buff = new char[mail_format_date.GetLength()+1];

	int max = mail_format_date.GetLength()+1;

	int cnt = 0;

	int patern_cnt = 0;

	int i,j,n;

	int work;

	char *split;

	char time_buff[8];

	int day,year,month,hour,minute,second;

	CString offset;

	// Date:     Mon, 3 Feb 2003 00:00:43 -0600

	// Date: Sat, 29 Mar 2003 05:01:48 +0900

	// Date: 29 Sep 2005 07:10:15 -0000

	day=year=month=hour=minute=second=0;

	strcpy(buff, mail_format_date);	

	

	i=0;

    split = strtok( buff, " " );

    while ( split != NULL ) {

		switch (i) {

		case 0: //day-name or day

			work = atoi(split);	

			if (work >= 1 && work <=31) {

				day = work;

			}

			break;

		case 1: //day or month 

			work = atoi(split);	

			if (work >= 1 && work <=31) {

				day = work;

			}else{

				month = GetMonthAbbr(split); //When it is month, counter(i) is plus one.

				++i;

			}

			break;

		case 2: //month-name

			if (month==0) {

				month = GetMonthAbbr(split);

			}else{

				if (day==0) {

					work = atoi(split);	

					if (work >= 1 && work <=31) {

						day = work;

					}else{

						return;

					}

				}

			}

			break;

		case 3: //year

			work = atoi(split);	

			if (work >= 1 && work <=9999) {

				year = work;

			}else{

				return;					

			}

			break;

		case 4: //time

			j=0;

			n=strlen(split);

			strcpy(time_buff,"");

			if (n<=8) {

				for(j=0;j<=n;++j) {

					if (split[j]==':' || j==n) {

						if (j<3) {

							hour = atoi(time_buff);

						}else if(j>=4 && j<6) {

							minute = atoi(time_buff);

						}else if(j>=7) {

							second = atoi(time_buff);

						}

						strcpy(time_buff,"");

					}else{

						strncat(time_buff,&split[j],1);

					}

				}

			}else{

				hour = 0;

				minute = 0;

				second = 0;

			}			

			break;

		case 5: //zone

			if (strlen(split)==5){

				offset = split;

			}

			break;

		default:

			break;

		}

        split = strtok( NULL," " );

        if ( split != NULL ) {

			i++;	

		}



    }



	CTime time(year, month, day, hour, minute, second);



	m_time = time;



	if(!offset.SpanExcluding("0123456789+-").IsEmpty()){

		offset = GetTzOffsetFromTzName(offset);

	}

	if(offset.IsEmpty()){

		m_offset = "+0000";

	}else{

		m_offset = offset;

	}

}



void CTimeEx::SetTimeT(time_t time, LPCTSTR offset)

{

	m_time = time;

	

	// if not offset

	CString tmp = offset;

	if(!tmp.SpanExcluding("0123456789+-").IsEmpty()){

		tmp = GetTzOffsetFromTzName(tmp);

	}

	if(tmp.IsEmpty()){

		return;

	}else{

		m_offset = tmp;

	}

}



time_t CTimeEx::GetGmTimeT()

{

	// adjust time zone

	CString plus_minus;

	CString hour;

	CString minute;

	CTime t = m_time;



	if(m_offset.GetLength() < 5){

		return t.GetTime();

	}

	plus_minus = m_offset[0];

	hour = m_offset.Mid(1, 2);

	minute = m_offset.Mid(3, 2);



	// change to GMT

	if(plus_minus == "-"){

		t += CTimeSpan(0, atoi(hour), atoi(minute), 0);

	}else if(plus_minus == "+"){

		t -= CTimeSpan(0, atoi(hour), atoi(minute), 0);

	}



	return t.GetTime();

}



void CTimeEx::SetNewOffset(LPCTSTR offset)

{

	CTime t = GetGmTimeT();



	if(strlen(offset) < 5)

		return;



	CString dst_offset = offset;



	if(!dst_offset.SpanExcluding("0123456789+-").IsEmpty()){

		dst_offset = GetTzOffsetFromTzName(dst_offset);

	}

	if(dst_offset.IsEmpty()){

		return;

	}



	CString plus_minus = dst_offset[0];

	CString hour = dst_offset.Mid(1, 2);

	CString minute = dst_offset.Mid(3, 2);



	if(plus_minus == "-"){

		t -= CTimeSpan(0, atoi(hour), atoi(minute), 0);

	}else if(plus_minus == "+"){

		t += CTimeSpan(0, atoi(hour), atoi(minute), 0);

	}



	m_time = t;

	m_offset = dst_offset;

}



CString CTimeEx::GetFormatDate(LPCTSTR format)

{

	return m_time.Format(format);

}



CString CTimeEx::GetTzOffsetFromTzName(LPCTSTR zone_name)

{

	CString tmp = zone_name;

	tmp.MakeUpper();



	CMapStringToString map;



	map.SetAt("NZDT",	"+1300");	// New Zealand Daylight Time (j[W[hĎ)

	map.SetAt("IDLE",	"+1200");	// International Date Line, East (ۓtύXA)

	map.SetAt("NZST",	"+1200");	// New Zealand Std Time (j[W[hW)

	map.SetAt("NZT",	"+1200");	// New Zealand Time (j[W[h)

	map.SetAt("AESST",	"+1100");	// Australia Eastern Summer Std Time (I[XgAWĎ)

	map.SetAt("ACSST",	"+1030");	// Central Australia Summer Std Time (I[XgAWĎ)

	map.SetAt("CADT",	"+1030");	// Central Australia Daylight Savings Time (I[XgAĎ)

	map.SetAt("SADT",	"+1030");	// South Australian Daylight Time (I[XgA암Ď)

	map.SetAt("AEST",	"+1000");	// Australia Eastern Std Time (I[XgAW)

	map.SetAt("EAST",	"+1000");	// East Australian Std Time (I[XgAW)

	map.SetAt("GST",	"+1000");	// Guam Std Time, USSR Zone 9 (OAWԁA\rGg^C][ 9)

	map.SetAt("LIGT",	"+1000");	// Melbourne, Australia (I[XgAA{)

	map.SetAt("ACST",	"+0930");	// Central Australia Std Time (I[XgAW)

	map.SetAt("CAST",	"+0930");	// Central Australia Std Time (I[XgAW)

	map.SetAt("SAT",	"+0930");	// South Australian Std Time (I[XgA암W)

	map.SetAt("AWSST",	"+0900");	// Australia Western Summer Std Time (I[XgAW)

	map.SetAt("JST",	"+0900");	// Japan Std Time, USSR Zone 8 ({WԁA\rGg^C][ 8)

	map.SetAt("KST",	"+0900");	// Korea Standard Time (؍W)

	map.SetAt("WDT",	"+0900");	// West Australian Daylight Time (I[XgAĎ)

	map.SetAt("MT",		"+0830");	// Moluccas Time (bJ)

	map.SetAt("AWST",	"+0800");	// Australia Western Std Time (I[XgAW)

	map.SetAt("CCT",	"+0800");	// China Coastal Time (pݎ)

	map.SetAt("WADT",	"+0800");	// West Australian Daylight Time (A[XgAĎ)

	map.SetAt("WST",	"+0800");	// West Australian Std Time (I[XgAW)

	map.SetAt("JT",		"+0730");	// Java Time (Java )

	map.SetAt("WAST",	"+0700");	// West Australian Std Time (I[XgAW)

	map.SetAt("IT",		"+0330");	// Iran Time (C)

	map.SetAt("BT",		"+0300");	// Baghdad Time (oO_bh)

	map.SetAt("EETDST",	"+0300");	// Eastern Europe Daylight Savings Time ([bpĎ)

	map.SetAt("CETDST",	"+0200");	// Central European Daylight Savings Time ([bpĎ)

	map.SetAt("EET",	"+0200");	// Eastern Europe, USSR Zone 1 ([bpԁA\rGg^C][ 1)

	map.SetAt("FWT",	"+0200");	// French Winter Time (tX~)

	map.SetAt("IST",	"+0200");	// Israel Std Time (CXGW)

	map.SetAt("MEST",	"+0200");	// Middle Europe Summer Time ([bpĎ)

	map.SetAt("METDST",	"+0200");	// Middle Europe Daylight Time ([bpĎ)

	map.SetAt("SST",	"+0200");	// Swedish Summer Time (XEF[fĎ)

	map.SetAt("BST",	"+0100");	// British Summer Time (CMXĎ)

	map.SetAt("CET",	"+0100");	// Central European Time ([bp)

	map.SetAt("DNT",	"+0100");	// Dansk Normal Tid (f}[NW)

	map.SetAt("DST",	"+0100");	// Dansk Standard Time (?) (f}[NW (?))

	map.SetAt("FST",	"+0100");	// French Summer Time (tXĎ)

	map.SetAt("MET",	"+0100");	// Middle Europe Time ([bp)

	map.SetAt("MEWT",	"+0100");	// Middle Europe Winter Time ([bp~)

	map.SetAt("MEZ",	"+0100");	// Middle Europe Zone ([bp)

	map.SetAt("NOR",	"+0100");	// Norway Standard Time (mEF[W)

	map.SetAt("SET",	"+0100");	// Seychelles Time (ZCVF)

	map.SetAt("SWT",	"+0100");	// Swedish Winter Time (XEF[f~)

	map.SetAt("WETDST",	"+0100");	// Western Europe Daylight Savings Time ([bpĎ)

	map.SetAt("GMT",	"+0000");	// Greenwish Mean Time (OjbWW)

	map.SetAt("WET",	"+0000");	// Western Europe ([bp)

	map.SetAt("WAT",	"-0100");	// West Africa Time (AtJ)

	map.SetAt("NDT",	"-0230");	// Newfoundland Daylight Time (j[t@hhĎ)

	map.SetAt("ADT",	"-0300");	// Atlantic Daylight Time (吼mĎ)

	map.SetAt("NFT",	"-0330");	// Newfoundland Standard Time (j[t@hhW)

	map.SetAt("NST",	"-0330");	// Newfoundland Standard Time (j[t@hhW)

	map.SetAt("AST",	"-0400");	// Atlantic Std Time (Canada) (吼mW (Ji_))

	map.SetAt("EDT",	"-0400");	// Eastern Daylight Time (AJĎ)

	map.SetAt("ZP4",	"-0400");	// GMT +4 

	map.SetAt("CDT",	"-0500");	// Central Daylight Time (AJĎ)

	map.SetAt("EST",	"-0500");	// Eastern Standard Time (AJW)

	map.SetAt("ZP5",	"-0500");	// GMT +5 

	map.SetAt("CST",	"-0600");	// Central Std Time (AJW)

	map.SetAt("MDT",	"-0600");	// Mountain Daylight Time (AJRxĎ)

	map.SetAt("ZP6",	"-0600");	// GMT +6 hours (OjbWW +6 )

	map.SetAt("MST",	"-0700");	// Mountain Standard Time (AJRxW)

	map.SetAt("PDT",	"-0700");	// Pacific Daylight Time (AJmĎ)

	map.SetAt("PST",	"-0800");	// Pacific Std Time (AJmW)

	map.SetAt("YDT",	"-0800");	// Yukon Daylight Time ([RĎ)

	map.SetAt("HDT",	"-0900");	// Hawaii/Alaska Daylight Time (nC/AXJĎ)

	map.SetAt("YST",	"-0900");	// Yukon Standard Time ([RW)

	map.SetAt("AHST",	"-1000");	// Alaska-Hawaii Std Time (AXJ-nCW)

	map.SetAt("CAT",	"-1000");	// Central Alaska Time (AXJ)

	map.SetAt("NT",		"-1100");	// Nome Time (m[)

	map.SetAt("IDLW",	"-1200");	// International Date Line, West (ۓtύXA)



	CString value;

	map.Lookup(tmp, value);

	return value;

}



CString CTimeEx::GetMailFormatDate()

{

	CString tmp = m_time.Format("%a, %d %b %Y %H:%M:%S ")+m_offset;

	return tmp;

}



int CTimeEx::GetMonthAbbr(LPCSTR month)

{

	int ret;



	ret=0;



	if(strcmp(month,"Apr")==0) ret = 4;

	else if(strcmp(month,"May")==0) ret = 5;

	else if(strcmp(month,"Jun")==0) ret = 6;

	else if(strcmp(month,"Jul")==0) ret = 7;

	else if(strcmp(month,"Aug")==0) ret = 8;

	else if(strcmp(month,"Sep")==0) ret = 9;

	else if(strcmp(month,"Oct")==0) ret = 10;

	else if(strcmp(month,"Nov")==0) ret = 11;

	else if(strcmp(month,"Dec")==0) ret = 12;

	else if(strcmp(month,"Jan")==0) ret = 1;

	else if(strcmp(month,"Feb")==0) ret = 2;

	else if(strcmp(month,"Mar")==0) ret = 3;

	

	return ret;

}