/*

 * Copyright (C) 2002-2003 chik, hiranaka

 * For license terms, see the file COPYING in this directory.

 */



#include "stdafx.h"

#include "Pochy.h"

#include "MainFrm.h"

#include "SummaryView.h"

#include "HeaderInfo.h"

#include "CodeConvert.h"

#include "direct.h"

#include "lib.h"

#include "_regex.h" // K\֐

#include "process.h" // getpid()

#include "base64.h"

#include "quoted-printable.h"



void g_log(LPCTSTR log, LPCTSTR path)

{

	FILE* file;

	if((file = fopen(path, "ab"))==NULL){

		return;

	}

	fwrite(log, sizeof(char), strlen(log), file);

	fclose(file);

}



// 啶Ɋ֌WȂcdr֐

BOOL g_string_compare_no_case(LPCTSTR c, LPCTSTR d)

{

	CString tmp1 = c;

	CString tmp2 = d;



	if(tmp1.CompareNoCase(tmp2) == 0)

		return TRUE;



	return FALSE;

}



BOOL g_rm_recursive(LPCTSTR path)

{

	CFileFind ff;

	BOOL b_Find;

	CString tmp = path;



	b_Find = ff.FindFile(tmp + "\\*.*");

	while(b_Find){

		b_Find = ff.FindNextFile();

		if(ff.IsDots())

			continue;

		if(ff.IsDirectory()){

			if(!g_rm_recursive(tmp + "\\" + ff.GetFileName()))

				return FALSE;

		}else{

			if(!DeleteFile(tmp + "\\" +ff.GetFileName()))

				return FALSE;

		}

	}

	ff.FindFile(tmp + "\\.."); // JgfBNgύXĂȂrmdirłȂ

	if(_rmdir(path))

		return FALSE;

	return TRUE;

}



// CStringt@CփeLXgo֐

BOOL g_string2file(/*CString& buf*/LPCTSTR buf, LPCTSTR file_name)

{

	FILE *fp;



	fp = fopen(file_name, "wb");

	if(0 > fwrite(buf, sizeof(char), strlen(buf), fp)){

		AfxMessageBox("g_string2file error");

		fclose(fp);

		return FALSE;

	}



	fclose(fp);

	return TRUE;

}



// t@CCStringɃeLXgo֐

BOOL g_file2cstring(LPCTSTR path,CString& buf)

{

	CFile file;

	if(!file.Open(path, CFile::modeRead)){

		return FALSE;

	}

	LPSTR pbuf;

	pbuf = buf.GetBuffer(file.GetLength()+1);

	file.Read(pbuf,file.GetLength());

	pbuf[file.GetLength()]=0;

	buf.ReleaseBuffer();

	file.Close();

	return TRUE;

}



// t@C쐬֐

BOOL g_file_create(LPCTSTR path)

{

	HANDLE h = CreateFile(

		path,

		GENERIC_WRITE,

		FILE_SHARE_READ,

		0,	// NT2000Ƒ߁AvC

		OPEN_ALWAYS,

		FILE_ATTRIBUTE_NORMAL,

		NULL);	

	if(h == NULL){

		CloseHandle(h);

		return FALSE;

	}	

	CloseHandle(h);

	return TRUE;

}



// vZX֐ڑ֐

BOOL g_connect_process(CStringArray &comline, CString &out1, CString &out2)

{

	HANDLE hOutputReadTmp,hOutputRead,hOutputWrite;

	HANDLE hInputWriteTmp,hInputRead,hInputWrite;

	HANDLE hErrorReadTmp,hErrorRead,hErrorWrite;

	SECURITY_ATTRIBUTES sa;

	sa.nLength = sizeof(SECURITY_ATTRIBUTES);

	sa.lpSecurityDescriptor = NULL;

	sa.bInheritHandle = TRUE;



	// Create the child output pipe.

	if (!CreatePipe(&hOutputReadTmp,&hOutputWrite,&sa,0))

		AfxMessageBox("CreatePipe");

	if (!CreatePipe(&hErrorReadTmp,&hErrorWrite,&sa,0))

		AfxMessageBox("CreatePipe");

	if (!CreatePipe(&hInputRead,&hInputWriteTmp,&sa,0))

		AfxMessageBox("CreatePipe");



	if (!DuplicateHandle(GetCurrentProcess(),hErrorReadTmp,

		GetCurrentProcess(),&hErrorRead,0,TRUE,DUPLICATE_SAME_ACCESS))

		AfxMessageBox("DuplicateHandle");

	if (!DuplicateHandle(GetCurrentProcess(),hOutputReadTmp,

		GetCurrentProcess(),&hOutputRead,0,FALSE,DUPLICATE_SAME_ACCESS))

		AfxMessageBox("DuplicateHandle");

	if (!DuplicateHandle(GetCurrentProcess(),hInputWriteTmp,

		GetCurrentProcess(),&hInputWrite,0,FALSE,DUPLICATE_SAME_ACCESS))

		AfxMessageBox("DuplicateHandle");



	// Close inheritable copies of the handles you do not want to be 

	// inherited.

	if (!CloseHandle(hOutputReadTmp)) AfxMessageBox("CloseHandle");

	if (!CloseHandle(hInputWriteTmp)) AfxMessageBox("CloseHandle");

	if (!CloseHandle(hErrorReadTmp)) AfxMessageBox("CloseHandle");



	// vZXN

	STARTUPINFO siStartInfo;

	PROCESS_INFORMATION pi;

	ZeroMemory( &siStartInfo, sizeof(STARTUPINFO) );

	siStartInfo.hStdError = hErrorWrite;

	siStartInfo.hStdOutput = hOutputWrite;

	siStartInfo.hStdInput = hInputRead;

	siStartInfo.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;

	siStartInfo.wShowWindow = SW_HIDE;

	siStartInfo.cb = sizeof(STARTUPINFO);

	LPSTR lps = comline[0].GetBuffer(0);

	if(!CreateProcess(NULL,lps,

		NULL,NULL,TRUE,CREATE_NEW_CONSOLE/*NORMAL_PRIORITY_CLASS|DETACHED_PROCESS*/,NULL,NULL,&siStartInfo,&pi)){ //CREATE_NEW_CONSOLE

		if(!CloseHandle(hInputWrite)) AfxMessageBox("CloseHandle");

		if(!CloseHandle(hOutputRead)) AfxMessageBox("CloseHandle");

		if(!CloseHandle(hErrorRead)) AfxMessageBox("CloseHandle");

		return FALSE;

	}



	// ͂

	int max = comline.GetSize();

	for(int i=1; i<max; i++){

		DWORD len;

		WaitForInputIdle(pi.hProcess,INFINITE);

		WriteFile(hInputWrite,comline[i],comline[i].GetLength(),&len,NULL);

	}



	DWORD BytesAvail;

	DWORD ret;

	out1.Empty();

	out2.Empty();

	CString buf;

    // vZXÑpCve󂯎菈

	while((ret = WaitForSingleObject(pi.hProcess,0)) != WAIT_ABANDONED){

		PeekNamedPipe(hOutputRead,NULL,0,NULL,&BytesAvail,NULL);

		if(BytesAvail>0){

			LPSTR pout1;

			DWORD len;

			pout1 = buf.GetBuffer(65536);

			ReadFile(hOutputRead,pout1,65536,&len,NULL);

			pout1[len]=0;

			buf.ReleaseBuffer();

			out1 += buf;

			buf.Empty();

		}

		PeekNamedPipe(hErrorRead,NULL,0,NULL,&BytesAvail,NULL);

		if(BytesAvail>0){

			LPSTR pout2;

			DWORD len;

			pout2 = buf.GetBuffer(65536);

			ReadFile(hErrorRead,pout2,65536,&len,NULL);

			pout2[len]=0;

			buf.ReleaseBuffer();

			out2 += buf;

			buf.Empty();

		}

		// bZ[WL[擾A݂΁A𑣂

/*		MSG msg;

		if(::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){

			::TranslateMessage(&msg);

			::DispatchMessage(&msg);

		}*/

		// vZXIȂA[v𔲂

		if(ret == WAIT_OBJECT_0)

			break;

		Sleep(10);

	}

    GetExitCodeProcess(pi.hProcess, &ret);

	if(!CloseHandle(hInputWrite)) AfxMessageBox("CloseHandle");

	if(!CloseHandle(hOutputRead)) AfxMessageBox("CloseHandle");

	if(!CloseHandle(hErrorRead)) AfxMessageBox("CloseHandle");



	return TRUE;

}



// put each part separated with sep into CStringArray

void g_string2cstringarray(LPCTSTR string, CStringArray& array, LPCTSTR sep, BOOL include_sep)

{

	int a;

	CString tmp = string;



	array.RemoveAll();

	a = tmp.Find(sep);

	while(a!=-1){

		if(include_sep){

			array.Add(tmp.Left(a+strlen(sep)));

		}else{

			array.Add(tmp.Left(a));

		}

		tmp = tmp.Mid(a+strlen(sep));

		a = tmp.Find(sep);

	}

	array.Add(tmp);

}



// CStringArrayɊesi[̂CStringɏo

void g_cstringarray2cstring(CStringArray& cstra, CString& cstr)

{

	int i;

	int max;

	cstr.Empty();



	char *p = cstr.GetBuffer(g_cstringarray_getsize(cstra));

	max = cstra.GetSize();

	for(i=0; i<max; i++){

		strcpy(p, cstra.GetAt(i));

		p += cstra.GetAt(i).GetLength();

	}

	cstr.ReleaseBuffer();

}



// CStringArrayɊi[ꂽCStringS̃TCY

int g_cstringarray_getsize(CStringArray& cstra)

{

	int i;

	int n;

	int max;



	n = 0;

	max = cstra.GetSize();

	for(i=0; i<max; i++){

		n += cstra.GetAt(i).GetLength();

	}

	return n;

}



// eLXgt@C̊esCStringArrayɓǂݍ

BOOL g_file2cstringarray(LPCTSTR path, CStringArray &cstra)

{

	CString buf;

	CStdioFile file;

	int i;



	cstra.RemoveAll();

	cstra.SetSize(1000);



	if(!file.Open(path, CFile::modeRead | CFile::typeText))

		return FALSE;



	for(i=0; file.ReadString(buf); i++){

		if(i == cstra.GetSize()){

			cstra.SetSize(cstra.GetSize()+100);

		}

		buf += "\r\n";

		cstra.SetAt(i, buf);

	}

	file.Close();



	for(i=cstra.GetSize()-1; i>=0; i--){

		if(cstra[i].IsEmpty()){

			cstra.RemoveAt(i);

		}else{

			break;

		}

	}



	return TRUE;

}



// CStringArrayɊesi[ꂽeLXgt@C֏o

BOOL g_cstringarray2file(LPCTSTR path, CStringArray &cstra)

{

	int n;

	int max;

	FILE *file;



	file = fopen(path, "wb");

	if(file == NULL){

		AfxMessageBox("g_cstringarray2file error");

		return FALSE;

	}

	max = cstra.GetSize();

	for(n=0; n<max; n++){

		fwrite(cstra.GetAt(n), sizeof(char), cstra.GetAt(n).GetLength(), file);

	}

	fclose(file);



	return TRUE;

}



// t@C̑傫Ԃ

long g_get_file_size(LPCTSTR path)

{

	FILE *file;

	long size = 0;



	if((file = fopen(path, "rt"))){

		fseek(file, 0, SEEK_END);

		size = ftell(file);

		fclose(file);

		return size;

	}



	return -1;

}



// t@CԍƂČƂA

// (num)ȏł܂݂Ȃŏ̔ԍԂ֐

int g_get_min_num(LPCTSTR path)

{

	CString tmp = path;



	int i=0;

	CFileFind ff;

	BOOL b = ff.FindFile(tmp+"\\*.*");

	while(b){

		b = ff.FindNextFile();

		if(	!ff.IsDirectory() &&

			!ff.IsDots() &&

			ff.GetFileName().SpanExcluding("0123456789").IsEmpty())

		{

			if(i<atoi(ff.GetFileName()))

				i=atoi(ff.GetFileName());

		}

	}

	ff.Close();

	return ++i;

}



// CStringAray̕o֐

void g_cstringarray_getpart(CStringArray &org, CStringArray &dst, int start, int end)

{

	dst.RemoveAll();



	while(/*start < org.GetSize() || */start < end+1){

		dst.Add(org.GetAt(start));

		start++;

	}

}



// t@C݂Ă邩ǂԂ֐

BOOL g_is_there(LPCTSTR path)

{

	WIN32_FIND_DATA wfd;



	HANDLE handle = FindFirstFile(path, &wfd);

	if(handle == INVALID_HANDLE_VALUE){

		FindClose(handle);

		return FALSE;

	}else{

		FindClose(handle);

		return TRUE;

	}

}



// <>̒̕Ԃ֐

CString g_ma(LPCTSTR to)

{

	CString tmp1 = to;

	CString tmp2;



	int p,p2,q,q2;

	p = tmp1.Find("<")+1;

	q = tmp1.Find(">")+1;

	p2 = tmp1.Find("<",p)+1;

	q2 = tmp1.Find(">",q)+1;



	if(p && q && !p2 && !q2){

		tmp2 = tmp1.Mid(p,q-p-1);

		return tmp2;

	}

	if(p && q && (p2 || q2)){

		tmp2.Empty();

		return tmp2;

	}

	return tmp1;

}



// Message-ID𐶐֐

CString g_gen_msgid(LPCTSTR from)

{

	CString message_id;

	CTime t = CTime::GetCurrentTime();

	message_id.Format("<%d%02d%02d.%02d%02d%02d.%d.%s>",

			t.GetYear(),

			t.GetMonth(),

			t.GetDay(),

			t.GetHour(),

			t.GetMinute(),

			t.GetSecond(),

			getpid(),

			g_ma(from)); // from͂ƃ[AhX|Kv

	return message_id;

}



void g_cstring_chop(CString &buf)

{

	if(buf.IsEmpty()) return;

	buf.TrimRight("\r\n");

	buf.TrimLeft("\t ");

}



// e|[t@C쐬Ãt@Cւ̃pXԂ

CString g_get_tmp_file()

{

	// e|[t@C̃fBNg擾

	TCHAR tmp_path[MAX_PATH];

	DWORD d_result = GetTempPath(MAX_PATH, tmp_path);

	ASSERT(d_result);

	// t@C̍쐬

	TCHAR tmp_file[MAX_PATH];

	UINT u_result = GetTempFileName(tmp_path, _T("~ex"), 0, tmp_file);

	ASSERT(u_result);



	return tmp_file;

}



// directory폜֐iɂt@CSāj

BOOL g_delete_directory(LPCTSTR dir_path)

{

	CFileFind ff;

	CString path = dir_path;

	path.TrimRight('\\');

	BOOL r;



	r = ff.FindFile(path+"\\*.*");

	while(r){

		r = ff.FindNextFile();

		if(ff.IsDots())

			continue;

		if(ff.IsDirectory())

			g_delete_directory(path+"\\"+ff.GetFileName());

		else

			DeleteFile(path+"\\"+ff.GetFileName());

	}

	ff.Close();



	return RemoveDirectory(dir_path);

}



// logfontRs[֐

void g_logfont_copy(LOGFONT *dst, LOGFONT *org)

{

	dst->lfCharSet				= org->lfCharSet;

	dst->lfClipPrecision				= org->lfClipPrecision;

	dst->lfEscapement				= org->lfEscapement;

	strcpy(dst->lfFaceName, org->lfFaceName);

	dst->lfHeight				= org->lfHeight;

	dst->lfItalic				= org->lfItalic;

	dst->lfOrientation			= org->lfOrientation;

	dst->lfOutPrecision			= org->lfOutPrecision;

	dst->lfPitchAndFamily		= org->lfPitchAndFamily;

	dst->lfQuality				= org->lfQuality;

	dst->lfStrikeOut			= org->lfStrikeOut;

	dst->lfUnderline			= org->lfUnderline;

	dst->lfWeight				= org->lfWeight;

	dst->lfWidth				= org->lfWidth;

}



// cstringmarkň͂܂ꂽr

void g_strip_part(CString &buf, LPCTSTR mark)

{

	int start = 0;

	int end;

	while((start = buf.Find(mark, start)) != -1){

		end = buf.Find(mark, start+1);

		buf = buf.Left(start)+buf.Mid(end+1);

		start = start+1;

	}

}



int g_richedit_count_char(CString buf)

{

	buf.Replace("\n", "");

	return _mbsnccnt((const unsigned char *)buf.GetBuffer(0), buf.GetLength());

}



// ̊ȈՕ

CString g_simple_encode(const CString& in, const TCHAR seed)

{

	CString out;



	const int nInLength = in.GetLength();

	if (nInLength > 0)

	{

		TCHAR* tcIn = new TCHAR[nInLength];

		TCHAR* tcOut = new TCHAR[nInLength * 2 + 10];



		int i;

		for (i = 0; i < nInLength; i++)

		{

			tcIn[i] = TCHAR(in[i] ^ seed);

		}



		to64frombits((unsigned char*)tcOut, (unsigned char*)tcIn, nInLength);



		out = tcOut;



		delete[] tcOut;

		delete[] tcIn;

	}



	return out;

}



// ̊ȈՕ

CString g_simple_decode(const CString& in, const TCHAR seed)

{

	CString out;



	const int nInLength = in.GetLength();

	if (nInLength > 0)

	{

		TCHAR* tcOut = new TCHAR[nInLength];



		int nOutLength = from64tobits(tcOut, in, nInLength);

		if (nOutLength > 0)

		{

			int i;

			for (i = 0; i < nOutLength; i++)

			{

				tcOut[i] = TCHAR(tcOut[i] ^ seed);

			}

			tcOut[i] = _T('\0');



			out = tcOut;

		}



		delete[] tcOut;

	}



	return out;

}



void g_empty_directory(LPCTSTR path)

{

	CString tmp;



	tmp.Format("%s\\*.*", path);

	CFileFind ff;

	BOOL b = ff.FindFile(tmp);

	if(b){

		while(b){

			b = ff.FindNextFile();

			if(!ff.IsDirectory() && !ff.IsDots()){

				tmp.Format("%s\\%s", path, ff.GetFileName());

				DeleteFile(tmp);

			}

		}

	}

}



void g_split_address(CString address, CStringArray &array_address, BOOL include_comma, BOOL strip)

{

	CString buf;

	BOOL quotation = FALSE;

	int max = address.GetLength();



	buf.Empty();

	for(int n=0; n < max; n++){

		// in case that comment exit in each address field.

		if(address[n] == '"'){

			if(quotation == TRUE) quotation = FALSE;

			else quotation = TRUE;

		}

		if(!quotation && address[n] == ','){

			if(include_comma){

				buf += address[n];

			}

			buf.TrimLeft(" ");

			buf.TrimRight(" ");

			buf.TrimRight("\r\n");

			if(strip){

				buf = g_ma(buf);

			}

			array_address.Add(buf);

			buf.Empty();

			continue;

		}

		buf += address[n];

	}

	buf.TrimLeft(" ");

	buf.TrimRight(" ");

	buf.TrimRight("\r\n");

	if(strip){

		buf = g_ma(buf);

	}

	array_address.Add(buf);

}



void g_glue_address(CString &address, CStringArray &array_address)

{

	int size = g_cstringarray_getsize(array_address);

	int max = array_address.GetSize();

	char *p = address.GetBuffer(size+max+1);

	CString buf;



	for(int i=0; i<max; i++){

		buf = array_address.GetAt(i);

		buf.TrimRight(",");

		if(i != max-1){

			buf += ",";

		}

		strcpy(p, buf);

		p += buf.GetLength();

	}

	*p = '\0';

	address.ReleaseBuffer();

}



BOOL g_split_name_address(CString in, CString &name, CString &address)

{

	int i;

	int max;

	BOOL iso_2022 = FALSE;



	name.Empty();

	address.Empty();



	max = in.GetLength();

	for(i=0; i<max; i++){

		if(in[i] == 0x1b){

			if(!iso_2022)

				iso_2022 = TRUE;

			else

				iso_2022 = FALSE;

		}else if(in[i] == '<' && !iso_2022){

			name = in.Left(i);

			address = in.Mid(i);

			return TRUE;

		}

	}

	return FALSE;

}



BOOL g_is_all_ascii(CString buf)

{

	int n;

	int max = buf.GetLength();

	for(n=0; n<max; n++){

		if(!isascii((int)buf[n])){

			return FALSE;

		}

	}

	return TRUE;

}



BOOL g_is_iso2022(CString buf)

{

	int n;

	int max = buf.GetLength();

	for(n=0; n<max; n++){

		if(buf[n] == 0x1b){

			return TRUE;

		}

		n++;

	}

	return FALSE;

}



void g_encode_base64(LPCTSTR in, CString &out)

{

	if(!strlen(in))

		return;

	unsigned char *buf = (unsigned char *)new char[strlen(in)*3];

	to64frombits(buf, (const unsigned char *)in, strlen(in));

	out = buf;

	delete [] buf;

}



void g_decode_base64(LPCTSTR in, CString &out)

{

	if(!strlen(in))

		return;

	char *buf = (char *)new char[strlen(in)];

	int len = from64tobits(buf, in, strlen(in));

	buf[len] = '\0';

	out = buf;

	delete [] buf;

}



void g_decode_qp(LPCTSTR in, CString &out)

{

	char *buf = new char[strlen(in)+10];

	int len = fromQPtobits(buf, in, strlen(in));

	buf[len] = '\0';

	out = buf;

	delete [] buf;

}



CString g_get_complete_path(LPCTSTR path)

{

	CString tmp = path;



	// if path include "\..\", remove

	LPCTSTR regex = "[^\\\\]+\\\\\\.\\.\\\\";

	regex_t reg; // for regex

	regmatch_t pmatch[1]; // result of regexec is put into this

	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);

	while(0 == regexec(&reg, tmp, 1, pmatch, 0)){

		tmp = tmp.Left(pmatch[0].rm_so) + tmp.Mid(pmatch[0].rm_eo);

	}

	regfree(&reg);



	return tmp;

}



BOOL g_get_header(LPCTSTR path, CStringArray &header)

{

	CStdioFile sf;

	CString buf;

	int i;

	

	header.RemoveAll();

	header.SetSize(50);



	if(!sf.Open(path, CFile::modeRead | CFile::typeText)){

		return FALSE;

	}



	i = 0;

	while(sf.ReadString(buf)){

		if(buf == ""){

			break;

		}

		if(i == header.GetSize()){

			header.SetSize(header.GetSize()+1);

		}

		header.SetAt(i, buf);

		i++;

	}



	for(i=header.GetSize()-1; i>=0; i--){

		if(header.GetAt(i).IsEmpty()){

			header.RemoveAt(i);

		}else{

			break;

		}

	}



	sf.Close();

	return TRUE;

}



CString g_get_relative_path(LPCTSTR org_path, LPCTSTR dst_path)

{

	CString path;

	CString org = org_path;

	CString dst = dst_path;

	CStringArray org_array;

	CStringArray dst_array;

	int i, j;



	org.MakeLower();

	dst.MakeLower();



	g_string2cstringarray(org, org_array, "\\", FALSE);

	g_string2cstringarray(dst, dst_array, "\\", FALSE);



	int max_org = org_array.GetSize();

	int max_dst = dst_array.GetSize();

	for(i=0; org_array[i] == dst_array[i] && i < max_org && i < max_dst; i++);



	for(j=i; j<max_org; j++){

		path += "\\..";

	}



	for(j=i; j<max_dst; j++){

		path += "\\"+dst_array[j];

	}



	return path;

}