// CodeConvert.h:
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CODECONVERT_H__8F086B81_53D9_11D5_8C76_444553540000__INCLUDED_)
#define AFX_CODECONVERT_H__8F086B81_53D9_11D5_8C76_444553540000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define isjis(c) (((c)>=0x21 && (c)<=0x7e))
#define iseuc(c) (((c)>=0xa1 && (c)<=0xfe))
#define issjis1(c) (((c)>=0x81 && (c)<=0x9f) || ((c)>=0xe0 && (c)<=0xef))
    // VtgJIS 1oCg
#define issjis2(c) ((c)>=0x40 && (c)<=0xfc && (c)!=0x7f)
    // VtgJIS 2oCg
#define ishankana(c) ((c)>=0xa0 && (c)<=0xdf)
    // 锼pJi

class CCodeConvert  
{
public:
	void SetString(CString &Src);
	LPCTSTR ToJis(void);
	LPCTSTR ToSjis(void);
	CCodeConvert(CString &Src);
	CCodeConvert();
	virtual ~CCodeConvert();
	LPCTSTR JisToSjis(void);
	LPCTSTR SjisToJis(void);
	LPCTSTR EucToSjis(void);

private:
	char *m_buf;
	int putc(int c);
	int getc(void);
	void jis_to_sjis(int *ph, int *pl);
	void sjis_to_jis(int *ph, int *pl);
	LPCTSTR m_pSrc;
	int m_out_counter;
	int m_in_counter;
	int guess(void);
};

#endif // !defined(AFX_CODECONVERT_H__8F086B81_53D9_11D5_8C76_444553540000__INCLUDED_)
