// Accelerator Table class - Copyright(C) 2003 minamina
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include <assert.h>
#pragma warning (disable : 4786)
#pragma warning (push, 1)
#include <sstream>
#include <algorithm>
#pragma warning (pop)
#include "AcceleratorTable.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define FOR_EACH(list, iterator) for (iterator = list.begin(); iterator != list.end(); ++iterator)
#define ACCELERATOR_TABLE_CAPTION_NAME _T("Caption")

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CAcceleratorTable::CAcceleratorTable() : m_hAccel(NULL)
{
	LoadVirtualKeyMap();
}

CAcceleratorTable::~CAcceleratorTable()
{
	DeleteAll();
}

// eAvP[VœƎɐݒ肷
//void CAcceleratorTable::LoadDefaultAccelerator()
//{
//	DeleteAll();
//
//	AddAccelerator("Test1", ID_TEST, "Ctrl+T", "");
//	AddAccelerator("Test1", ID_TEST, "Ctrl+Space", "");
//	AddAccelerator("Test2", ID_TEST2, "Ctrl+Shift+Space", "");
//	AddAccelerator("Test2", ID_TEST2, "Alt+Space", "");
//
//	CreateAcceleratorTable();
//}

// Virtual Key Map 
// AvP[VIɌĂяoKv͖
// L[͏ɂ邱
void CAcceleratorTable::LoadVirtualKeyMap()
{
	m_virtualKeyMap.clear();

	AddVirtualKey(_T("backspace"),	VK_BACK);
	AddVirtualKey(_T("tab"),		VK_TAB);
	AddVirtualKey(_T("enter"),		VK_RETURN);
	AddVirtualKey(_T("esc"),		VK_ESCAPE);
	AddVirtualKey(_T("space"),		VK_SPACE);
	AddVirtualKey(_T("pageup"),		VK_PRIOR);
	AddVirtualKey(_T("pagedown"),	VK_NEXT);
	AddVirtualKey(_T("end"),		VK_END);
	AddVirtualKey(_T("home"),		VK_HOME);
	AddVirtualKey(_T("left"),		VK_LEFT);
	AddVirtualKey(_T("up"),			VK_UP);
	AddVirtualKey(_T("right"),		VK_RIGHT);
	AddVirtualKey(_T("down"),		VK_DOWN);
	AddVirtualKey(_T("delete"),		VK_DELETE);
	AddVirtualKey(_T("f1"),			VK_F1);
	AddVirtualKey(_T("f2"),			VK_F2);
	AddVirtualKey(_T("f3"),			VK_F3);
	AddVirtualKey(_T("f4"),			VK_F4);
	AddVirtualKey(_T("f5"),			VK_F5);
	AddVirtualKey(_T("f6"),			VK_F6);
	AddVirtualKey(_T("f7"),			VK_F7);
	AddVirtualKey(_T("f8"),			VK_F8);
	AddVirtualKey(_T("f9"),			VK_F9);
	AddVirtualKey(_T("f10"),		VK_F10);
	AddVirtualKey(_T("f11"),		VK_F11);
	AddVirtualKey(_T("f12"),		VK_F12);
}

// ANZ[^L[ݒ肷
//
// nameString : Rɂ閼OBwCommand ƃyAŃj[NłKv
// wCommand : ĂяoR}h IDB WM_COMMAND  WPARAM ɂȂ
// sortcutString : V[gJbgL[B Ctrl+A Ȃǂ̌`w肷
// captionString : gp
// Oŕ̃V[gJbgL[w肷邱Ƃo
//
//  :
// AddAccelerator(_T("About"), ID_ABOUT, _T("Ctrl+A"), _T(""));
// AddAccelerator(_T("About"), ID_ABOUT, _T("a"), _T(""));
//
void CAcceleratorTable::AddAccelerator(const std::string& nameString, const WORD& wCommand, const std::string& shortcutString, const std::string& captionString)
{
	if (nameString != _T(""))
	{
		ACCELERATOR_LIST::iterator accelerator_it = m_acceleratorList.find(nameString);
		if (accelerator_it != m_acceleratorList.end())
		{
			// łɂ΃V[gJbgǉ
			accelerator_it->second.shortcutList.push_back(shortcutString);
		}
		else
		{
			// ΕKvĒǉ
			ACCELERATOR accelerator;
			accelerator.wCommand = wCommand;
			accelerator.shortcutList.push_back(shortcutString);
			accelerator.captionString = captionString;
			m_acceleratorList.insert(ACCELERATOR_LIST::value_type(nameString, accelerator));
		}
	}
}

// ANZ[^[Xg HACCEL 
bool CAcceleratorTable::CreateAcceleratorTable()
{
	bool bResult = false;

	std::vector<ACCEL> accelList;
	ACCELERATOR_LIST::const_iterator accelerator_it;
	FOR_EACH (m_acceleratorList, accelerator_it)
	{
		std::vector<std::string>::const_iterator shortcutList_it;
		FOR_EACH (accelerator_it->second.shortcutList, shortcutList_it)
		{
			std::vector<std::string> splitShortcut = SplitShortcut(*shortcutList_it);
			if (splitShortcut.size() > 0)
			{
				ACCEL accel;
				accel.cmd = accelerator_it->second.wCommand;
				accel.fVirt = FVIRTKEY;

				std::vector<std::string>::const_iterator splitShortcut_it;
				FOR_EACH (splitShortcut, splitShortcut_it)
				{
					if (splitShortcut_it->length() == 1)
					{
						// key
						accel.key = ::VkKeyScan(ToLower(*splitShortcut_it).at(0));
					}
					else if (ToLower(*splitShortcut_it) == _T("ctrl"))
					{
						accel.fVirt |= FCONTROL;
					}
					else if (ToLower(*splitShortcut_it) == _T("shift"))
					{
						accel.fVirt |= FSHIFT;
					}
					else if (ToLower(*splitShortcut_it) == _T("alt"))
					{
						accel.fVirt |= FALT;
					}
					else if (splitShortcut_it->length() > 0)
					{
						// virtual key
						std::map<std::string, WORD>::const_iterator keyMap_it;
						keyMap_it = m_virtualKeyMap.find(ToLower(*splitShortcut_it));
						if (keyMap_it != m_virtualKeyMap.end())
						{
							accel.key = keyMap_it->second;
						}
					}
				}
				accelList.push_back(accel);
			}
		}
	}

	if (accelList.size() > 0)
	{
		DestroyAcceleratorTable();
		m_hAccel = ::CreateAcceleratorTable(&accelList[0], accelList.size());
		if (m_hAccel != NULL)
		{
			bResult = true;
		}
	}

	return bResult;
}

// + ŋ؂ꂽV[gJbg𕪉
const std::vector<std::string> CAcceleratorTable::SplitShortcut(const std::string &shortcutString)
{
	std::vector<std::string> outputList;
	std::istringstream sin(shortcutString);
	std::string line;

	if (shortcutString.length() == 1)
	{
		outputList.push_back(shortcutString);
	}
	else
	{
		while (std::getline(sin, line, _T('+')))
		{
			if (line.length() > 0)
			{
				outputList.push_back(line);
			}
			if (shortcutString.length() - sin.tellg() == 1)
			{
				// c 1̂Ƃǉ
				std::getline(sin, line);
				outputList.push_back(line);
			}
		}
	}

	return outputList;
}

// Virtual Key Map ɃL[R[hǉ
void CAcceleratorTable::AddVirtualKey(const std::string& virtualKeyString, const WORD& wVirtualKeyCode)
{
	m_virtualKeyMap.insert(std::pair<std::string, WORD>(virtualKeyString, wVirtualKeyCode));
}

// ɕϊ
std::string CAcceleratorTable::ToLower(const std::string& inputString)
{
	std::string outputString;
	outputString.resize(inputString.size());

	std::transform(inputString.begin(), inputString.end(), outputString.begin(), _totlower);

	return outputString;
}

// ׂẴL[폜
void CAcceleratorTable::DeleteAll()
{
	DestroyAcceleratorTable();
	m_acceleratorList.clear();
	// virtualKeyMap ͕ςȂ̂ō폜Ȃ
	//m_virtualKeyMap.clear();
	m_targetWindowList.clear();	
}

// ۂɃL[ϊ
// PreTranslateMessage ȂǂĂяo
// Ƃ true Ԃ
bool CAcceleratorTable::TranslateAccelerator(HWND hWnd, MSG *pMsg)
{
	bool bResult = false;

	if (IsValid())
	{
		if (m_targetWindowList.find(pMsg->hwnd) != m_targetWindowList.end())
		{
			bResult = ::TranslateAccelerator(hWnd, m_hAccel, pMsg) != 0;
		}
	}

	return bResult;
}

// L?
bool CAcceleratorTable::IsValid()
{
	return m_hAccel != NULL;
}

// HACCEL 폜
void CAcceleratorTable::DestroyAcceleratorTable()
{
	if (m_hAccel != NULL)
	{
		::DestroyAcceleratorTable(m_hAccel);
		m_hAccel = NULL;
	}
}

// t@CɃL[ۑ
// sectionName Ɏw肳ꂽZNVɃL[ۑ
// sectionName + Caption ƂZNVɃLvVۑ
bool CAcceleratorTable::Save(const std::string& filenameString, const std::string& sectionName)
{
	std::ostringstream keyOut;
	std::ostringstream captionOut;
	ACCELERATOR_LIST::const_iterator accelerator_it;
	FOR_EACH (m_acceleratorList, accelerator_it)
	{
		std::vector<std::string>::const_iterator shortcutList_it;
		FOR_EACH (accelerator_it->second.shortcutList, shortcutList_it)
		{
			keyOut << accelerator_it->first << _T('=') << (*shortcutList_it) << std::ends;
		}
		captionOut << accelerator_it->first << _T('=') << accelerator_it->second.captionString << std::ends;
	}
	keyOut << std::ends;
	captionOut << std::ends;

	// key 
	bool bResult = ::WritePrivateProfileSection(sectionName.c_str(), keyOut.str().c_str(), filenameString.c_str()) != 0;
	// caption 
	::WritePrivateProfileSection((sectionName + ACCELERATOR_TABLE_CAPTION_NAME).c_str(), captionOut.str().c_str(), filenameString.c_str());

	return bResult;
}

// t@CL[ǂݍ
// sectionName Ɏw肳ꂽZNVL[ǂݍ
// sectionName + Caption ƂZNVLvVǂݍ
//
// ł AddAccelerator() ŒǉꂽL[̂ݓǂݍނƂo
// Load ĂяoO AddAccelerator 𕡐ĂяoAftHg̒lݒ肵ĂKvƂ
// ̊֐ĂяõL[VL[}bvLɂȂ
//
bool CAcceleratorTable::Load(const std::string& filenameString, const std::string& sectionName)
{
	std::string keySectionName = _T("[") + sectionName + _T("]");
	std::string captionSectionName = _T("[") + sectionName + ACCELERATOR_TABLE_CAPTION_NAME + _T("]");
	CStdioFile file;
	std::string bufferString;
	if (file.Open(filenameString.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::typeText))
	{
		int nLength = file.GetLength();
		if (nLength > 0)
		{
			char* pBuffer = new char[nLength];
			if (file.Read(pBuffer, nLength) > 0)
			{
				bufferString = pBuffer;
			}
			delete[] pBuffer;
		}
		file.Close();
	}
//	std::ifstream fin(filenameString.c_str());
	std::istringstream fin(bufferString.c_str());
	if (!fin.fail())
	{
		std::string line;
		while (std::getline(fin, line) && line != keySectionName);
		if (line == keySectionName)
		{
			// ini t@CɃZNV݂ĂƂݒ㏑
			// Gg[͍폜V[gJbgXĝݏ
			ClearShortcutList();
		}
		while (std::getline(fin, line) && line != captionSectionName)
		{
			// key ǂݍ

			TrimComment(line, _T(';'));

			std::istringstream sin(line);
			std::string nameString;
			std::getline(sin, nameString, _T('='));
			std::string shortcutString;
			std::getline(sin, shortcutString);

			TrimSpace(nameString);
			TrimSpace(shortcutString);
			
			if (nameString.length() > 0 && shortcutString.length() > 0)
			{
				ACCELERATOR_LIST::iterator accelerator_it = m_acceleratorList.find(nameString);
				if (accelerator_it != m_acceleratorList.end())
				{
					accelerator_it->second.shortcutList.push_back(shortcutString);
				}
			}
		}
		while (std::getline(fin, line) && (line.length() == 0 || line.at(0) != _T('[')))
		{
			// caption ǂݍ

			TrimComment(line, _T(';'));

			std::istringstream sin(line);
			std::string nameString;
			std::getline(sin, nameString, _T('='));
			std::string captionString;
			std::getline(sin, captionString);

			TrimSpace(nameString);
			TrimSpace(captionString);
			
			if (nameString.length() > 0 && captionString.length() > 0)
			{
				ACCELERATOR_LIST::iterator accelerator_it = m_acceleratorList.find(nameString);
				if (accelerator_it != m_acceleratorList.end())
				{
					accelerator_it->second.captionString = captionString;
				}
			}
		}
	}

	return CreateAcceleratorTable();
}

// ΏۂƂEBhEnhǉ
void CAcceleratorTable::AddTargetWindow(const HWND hWnd)
{
	if (hWnd != NULL)
	{
		m_targetWindowList.insert(hWnd);
	}
}

// V[gJbgL[񃊃Xgׂď
// L[Gg[͍폜Ȃ
void CAcceleratorTable::ClearShortcutList()
{
	ACCELERATOR_LIST::iterator accelerator_it;
	FOR_EACH (m_acceleratorList, accelerator_it)
	{
		accelerator_it->second.shortcutList.clear();
	}
}

// ÕXy[Xƃ^u폜
void CAcceleratorTable::TrimSpace(std::string& str)
{
	str.erase(0, str.find_first_not_of(_T(" \t")));
	str.erase(str.find_last_not_of(_T(" \t")) + 1);
}

// Rg폜
// delim ȍ~̕폜 (delim ܂)
void CAcceleratorTable::TrimComment(std::string& str, const TCHAR& delim)
{
	std::string::size_type pos = str.find(delim);
	if (pos != std::string::npos)
	{
		str.erase(pos);
	}
}

// ID vj[̕u
void CAcceleratorTable::ModifyMenuCaption(HMENU hMenu)
{
	assert(hMenu != NULL);
	if (hMenu != NULL)
	{
		int nMenuCount = ::GetMenuItemCount(hMenu);
		int nMenuPos;
		for (nMenuPos = 0; nMenuPos < nMenuCount; nMenuPos++)
		{
			UINT uiMenuItemID = ::GetMenuItemID(hMenu, nMenuPos);
			if (uiMenuItemID == -1)
			{
				// Tuj[
				HMENU hSubMenu = ::GetSubMenu(hMenu, nMenuPos);
				if (hSubMenu != NULL)
				{
					ModifyMenuCaption(hSubMenu);
				}
			}
			else
			{
				const ACCELERATOR* pAccelerator = FindAccelerator((WORD)uiMenuItemID);
				if (pAccelerator != NULL)
				{
					const std::string menuString = GetMenuCaptionWithShortcut(*pAccelerator);
					SetMenuString(hMenu, nMenuPos, menuString);
				}
			}
		}
	}
}

// wCommand  ACCELERATOR T
const CAcceleratorTable::ACCELERATOR* CAcceleratorTable::FindAccelerator(const WORD& wCommand)
{
	const ACCELERATOR* pAccelerator = NULL;

	ACCELERATOR_LIST::const_iterator accelerator_it;
	FOR_EACH (m_acceleratorList, accelerator_it)
	{
		if (wCommand == accelerator_it->second.wCommand)
		{
			pAccelerator = &accelerator_it->second;
			break;
		}
	}
	
	return pAccelerator;
}

// j[ύX郉bp[֐
void CAcceleratorTable::SetMenuString(const HMENU& hMenu, const UINT& nPos, const std::string& menuString)
{
	assert(hMenu != NULL);

	MENUITEMINFO mi;
	mi.cbSize = sizeof(MENUITEMINFO);
	mi.fMask = MIIM_TYPE;
	mi.fType = MFT_STRING;
	mi.dwTypeData = const_cast<LPTSTR>(menuString.c_str());
	mi.cch = menuString.length();
	if (::SetMenuItemInfo(hMenu, nPos, TRUE, &mi) != 0)
	{
	}
}

// j[ɃV[gJbgǉĕԂ
const std::string CAcceleratorTable::GetMenuCaptionWithShortcut(const ACCELERATOR& accelerator)
{
	std::string menuString;

	menuString = accelerator.captionString;
	int nShortcutListSize = accelerator.shortcutList.size();
	if (nShortcutListSize > 0)
	{
		menuString += _T("\t");
	}
	int nShortcut = 0;
	std::vector<std::string>::const_iterator shortcutList_it;
	FOR_EACH (accelerator.shortcutList, shortcutList_it)
	{
		menuString += *shortcutList_it;
		nShortcut++;
		if (nShortcut < nShortcutListSize)
		{
			menuString += _T(", ");
		}
	}

	return menuString;
}
