/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// DraftFrame.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Pochy.h"
#include "DraftFrame.h"
#include "sock.h"
#include "mainfrm.h"
#include "SendMail.h"
#include "MailEditView.h"
#include "lib.h"
#include "direct.h"
#include "MimeEncode.h"
#include <imm.h>
#include "Gpg.h"
#include "GpgKeyListDlg.h"
#include "GpgDlg.h"
#include "SummaryView.h"
#include "AddressView.h"
#include "ExEditor.h"
#include "DraftAddressBookDlg.h"
#include "DraftSendDlg.h"
#include "TimeEx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TOOLBAR_DRAFT_FILENAME _T("\\skin\\toolbar_draft.bmp")
#define NUMBER_OF_TOOLBAR_DRAFT_ICON (6)

/////////////////////////////////////////////////////////////////////////////
// CDraftFrame

IMPLEMENT_DYNCREATE(CDraftFrame, CFrameWnd)

CDraftFrame::CDraftFrame()
{
	CGpg gpg;
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	this->m_flag = FALSE;
	this->m_hide_attach = FALSE;
	this->m_button_gpg = app->m_gpg_enable;
	this->m_button_gpgenc = app->m_gpg_enable;
	this->m_button_gpgexp = app->m_gpg_enable;
	this->m_button_addfile = TRUE;
	this->m_button_address = TRUE;
	this->m_button_exteditor = TRUE;
	this->m_button_savedraft = TRUE;
	this->m_button_sendmail = TRUE;
	this->m_send_dlg = NULL;
	this->m_me.CopyFrom(&app->m_me);
}

CDraftFrame::~CDraftFrame()
{
}

BEGIN_MESSAGE_MAP(CDraftFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CDraftFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_SEND_MAIL, OnSend)
	ON_COMMAND(ID_SAVE_TO_DRAFT, OnSaveToDraft)
	ON_COMMAND(ID_ADD_FILE, OnAddFile)
	ON_COMMAND(ID_DRAFT_EXT_EDITOR, OnExtEditor)
	ON_WM_SIZE()
	ON_UPDATE_COMMAND_UI(ID_SEND_MAIL, OnUpdateSend)
	ON_UPDATE_COMMAND_UI(ID_DRAFT_GPG, OnUpdateGpg)
	ON_UPDATE_COMMAND_UI(ID_GPG_DRAFT_KEY_MANAGEMENT, OnUpdateGpg)
	ON_UPDATE_COMMAND_UI(ID_GPG_ENC, OnUpdateGpgEnc)
	ON_UPDATE_COMMAND_UI(ID_GPG_EXP, OnUpdateGpgExp)
	ON_UPDATE_COMMAND_UI(ID_ADD_FILE, OnUpdateAddFile)
	ON_UPDATE_COMMAND_UI(ID_DRAFT_ADDRESS, OnUpdateAddress)
	ON_UPDATE_COMMAND_UI(ID_SAVE_TO_DRAFT, OnUpdateSaveDraft)
	ON_UPDATE_COMMAND_UI(ID_DRAFT_EXT_EDITOR, OnUpdateExtEditor)
	ON_COMMAND(ID_GPG_ENC, OnGpgEnc)
	ON_COMMAND(ID_DRAFT_ADDRESS, OnAddress)
	ON_COMMAND(ID_DRAFT_GPG, OnGpg)
	ON_COMMAND(ID_GPG_EXP, OnGpgExport)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_NOTIFY(TBN_DROPDOWN, AFX_IDW_TOOLBAR, OnToolbarDropDown)
	ON_COMMAND(ID_CHANGE_BK_COLOR_DRAFT, OnChangeBkColorDraft)
	ON_COMMAND(ID_CHANGE_TXT_COLOR_DRAFT, OnChangeTxtColorDraft)
	ON_COMMAND(ID_GPG_DRAFT_KEY_MANAGEMENT, OnGpgKeyManagement)
	ON_WM_COPYDATA()
	ON_WM_CHAR()
	ON_UPDATE_COMMAND_UI(ID_DRAFT_GPG, OnUpdateGpg)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_SWITCH_VIEW, OnSwitchView)
	ON_WM_SYSCOMMAND()
	//}}AFX_MSG_MAP
	ON_COMMAND(WM_END, OnEnd)
	ON_COMMAND(WM_PROGCREATE, OnProgCreate)
	ON_COMMAND(WM_PROGDESTROY, OnProgDestroy)
	ON_WM_GETMINMAXINFO()
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,		// Xe[^X C CWP[^
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CDraftFrame bZ[W nh

int CDraftFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if(CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
/*	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_DRAFTFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}*/

	if(m_me.GetMode() == ME_MODE_PGP){
		this->m_button_addfile = FALSE;
		this->m_button_exteditor = FALSE;
		this->m_button_gpgenc = FALSE;
		this->m_button_gpgexp = FALSE;
	}

	if(!this->CreateToolbar())
		return -1;

	if (!this->m_wndStatusBar.Create(this) ||
		!this->m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create.
	}

  	// get previous window position from ini fileini.
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CRect rc;

	// resurrect previous window position.
	rc.left = app->GetProfileInt("DraftWndPlace", "Left", 0);
	rc.top = app->GetProfileInt("DraftWndPlace", "Top", 0);
	rc.right = app->GetProfileInt("DraftWndPlace", "Right", 700);
	rc.bottom = app->GetProfileInt("DraftWndPlace", "Bottom", 520);

	RECT rc2;
	if(!::IsRectEmpty(&rc)){
		SystemParametersInfo(SPI_GETWORKAREA, 0, &rc2, 0);
		rc.left = rc.left+rc2.left;
		rc.top = rc.top+rc2.top;
		rc.right = rc.right+rc2.left;
		rc.bottom = rc.bottom+rc2.top;
		this->MoveWindow(rc);
	}

	m_pAddrsV->SetFocus();

	if (app != NULL)
	{
		HMENU hMenu = ::GetMenu(GetSafeHwnd());
		if (hMenu != NULL)
		{
			// GPG Ƃ̓j[\ɂ
			// j[폜Əς邽ߐԍZbg
			int nGPGMenuPos = 2;
			int nHelpMenuPos = 3;
			CGpg gpg;
			if (!gpg.Check())
			{
				::DeleteMenu(hMenu, nGPGMenuPos, MF_BYPOSITION);
				nGPGMenuPos = -1; // 폜ꂽ邵Ƃ -1
				nHelpMenuPos--;
			}
			if (nGPGMenuPos == -1)
			{
				::DrawMenuBar(GetSafeHwnd());
			}

			for (int i = 0; i < ::GetMenuItemCount(hMenu); i++)
			{
				HMENU hSubMenu = ::GetSubMenu(hMenu, i);
				if (hSubMenu != NULL)
				{
					POCHY_MENU_TYPE nMenuType = POCHY_MENU_DRAFT_MAIL;
					switch (i)
					{
					case 0: nMenuType = POCHY_MENU_DRAFT_MAIL; break;
					case 1: nMenuType = POCHY_MENU_DRAFT_VIEW; break;
					default:
						{
							if (i == nGPGMenuPos)
							{
								nMenuType = POCHY_MENU_DRAFT_GPG;
							}
							else if (i == nHelpMenuPos)
							{
								nMenuType = POCHY_MENU_DRAFT_HELP;
							}
						}
						break;
					}
					app->m_pluginManager.OnInitMenu(hSubMenu, nMenuType);
				}
			}
		}
		HMENU hSystemMenu = ::GetSystemMenu(GetSafeHwnd(), FALSE);
		if (hSystemMenu != NULL)
		{
			app->m_pluginManager.OnInitMenu(hSystemMenu, POCHY_MENU_DRAFT_SYSTEM);
//			::GetSystemMenu(GetSafeHwnd(), TRUE);
		}
	}

	return 0;
}

void CDraftFrame::OnSend()
{
	CPochyApp* app=(CPochyApp*)AfxGetApp();

	CString body;

	
	this->m_pEditV->GetText(body);

	this->m_me.SetTo(m_pAddrsV->GetTo());
	this->m_me.SetCc(m_pAddrsV->GetCc());
	this->m_me.SetBcc(m_pAddrsV->GetBcc());
	this->m_me.SetFrom(m_pAddrsV->GetFrom());
	this->m_me.SetSubject(m_pAddrsV->GetSubject());
	this->m_me.SetReplyTo(m_pAddrsV->GetReplyTo());
	this->m_me.SetXMailer(app->GetProfileString("Customize", "XMailer", X_MAILER));
	// get date
	// below is mosyly by hiro-san
	tzset();
	CString offset;
	// get current system time zone offset
	offset.Format("%+03d%02d",(-_timezone)/60/60,(-_timezone)/60%60);
	CTimeEx time(CTime::GetCurrentTime().GetTime(), offset);
	// change to default time zone offset
	time.SetNewOffset(app->m_time_zone_offset);
	this->m_me.SetDate(time.GetMailFormatDate());

	// setting mail body.
	if(this->m_me.GetMode() == ME_MODE_NONE)
		this->m_me.SetMultipartBody(0, body);

	if (app->m_pluginManager.OnSendMail(m_me.GetMail(ME_GET_SEND)) == PR_SEND_OK)
	{
		this->EnableWindow(FALSE);

		this->m_send_dlg = new CDraftSendDlg();
		this->m_send_dlg->Create(IDD_DRAFT_SEND_STATUS, this);
		this->m_send_dlg->ShowWindow(SW_SHOW);
		this->m_send_dlg->CenterWindow();

		AfxBeginThread(SendMail, this);
	}
}

void CDraftFrame::OnSaveToDraft()
{
	this->SaveToDraft(FALSE);

	CPochyApp *app = (CPochyApp*)AfxGetApp();
	// confirm whether or not draft is saved.
	for(int i=0; i<app->m_draft_array.GetSize(); i++){
		if(this == app->m_draft_array[i])
			app->m_draft_array.RemoveAt(i);
	}
	CFrameWnd::OnClose();
}

void CDraftFrame::OnEnd()
{
	DestroyWindow();
}

void CDraftFrame::OnProgCreate()
{
	this->m_pd.Create(IDD_DIALOG1,&m_wndStatusBar);
}

void CDraftFrame::OnProgDestroy()
{
	this->m_pd.DestroyWindow();
}

BOOL CDraftFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	this->m_split_attachedfile_others.CreateStatic(this, 2, 1);
	this->m_split_attachedfile_others.SetStaticBorder(TRUE);
	this->m_split_address_mailedit.CreateStatic(&m_split_attachedfile_others, 2, 1, WS_CHILD|WS_VISIBLE|WS_BORDER, m_split_attachedfile_others.IdFromRowCol(0,0));

	this->m_split_address_mailedit.CreateView(0, 0, RUNTIME_CLASS(CAddressView), CSize(0,DEF_ADDRESS_HEIGHT), pContext);
	this->m_split_address_mailedit.CreateView(1, 0, RUNTIME_CLASS(CMailEditView), CSize(0, 0), pContext);
	this->m_split_address_mailedit.NoBorder();
	this->m_split_address_mailedit.SetStaticBorder(TRUE);
	this->m_split_attachedfile_others.CreateView(1, 0, RUNTIME_CLASS(CAttachedFileView), CSize(0, 0), pContext);

	this->m_pAddrsV = (CAddressView*)m_split_address_mailedit.GetPane(0, 0);
	this->m_pEditV = (CMailEditView*)m_split_address_mailedit.GetPane(1, 0);
	this->m_pListV2 = (CAttachedFileView*)m_split_attachedfile_others.GetPane(1, 0);

	// adjust size of CAddressView
	CSize size = this->m_pAddrsV->GetTotalSize();
	this->m_split_address_mailedit.SetRowInfo(0, size.cy, size.cy);

	// initialyzation
	this->m_pAddrsV->OnInitialUpdate();
	this->m_pEditV->OnInitialUpdate();
	this->m_pListV2->OnInitialUpdate();

	if(this->m_me.HowManyPart() > 1 && this->m_me.GetMode() != ME_MODE_PGP){
		this->HideAttachedFileView(FALSE);
	}else{
		this->HideAttachedFileView(TRUE);
	}

	this->m_flag = TRUE;

	return TRUE;
}

void CDraftFrame::OnAddFile() 
{
	// prepare for dialog.
	CString path;
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CFileDialog dlg(TRUE, NULL, NULL, OFN_PATHMUSTEXIST, NULL, this);
	dlg.m_ofn.lpstrTitle = _T( "Ytt@C" );
	if(dlg.DoModal() == IDOK){
		path = dlg.GetPathName();
	}else{
		return;
	}

	// put path variable into m_me (MimeEncode)
	if(!m_me.AddAttachedFile(path))
		AfxMessageBox("cannot open file");
	
	// add item to attachedfileview.
	CString file_name = g_get_file_name(path);
	this->m_pListV2->AddFile(file_name);

	// adjust someplace that is associated with gui.
	this->HideAttachedFileView(FALSE);
	this->ReArrangeSplit();
	this->m_pEditV->SetFocus();
}

void CDraftFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	if(this->m_flag)
		this->ReArrangeSplit();
}

void CDraftFrame::OnAddress()
{
	this->m_me.SetTo(this->m_pAddrsV->GetTo());
	this->m_me.SetCc(this->m_pAddrsV->GetCc());
	this->m_me.SetBcc(this->m_pAddrsV->GetBcc());
	this->m_me.SetFrom(this->m_pAddrsV->GetFrom());
	this->m_me.SetSubject(this->m_pAddrsV->GetSubject());
	this->m_me.SetReplyTo(this->m_pAddrsV->GetReplyTo());

	CStringArray to;
	CStringArray cc;
	CStringArray bcc;

	g_split_address(this->m_me.GetTo(), to, FALSE, FALSE);
	g_split_address(this->m_me.GetCc(), cc, FALSE, FALSE);
	g_split_address(this->m_me.GetBcc(), bcc, FALSE, FALSE);

	int i;
	for(i=0; i<to.GetSize(); i++){
		if(to.GetAt(i).IsEmpty())
			to.RemoveAt(i);
	}
	for(i=0; i<cc.GetSize(); i++){
		if(cc.GetAt(i).IsEmpty())
			cc.RemoveAt(i);
	}
	for(i=0; i<bcc.GetSize(); i++){
		if(bcc.GetAt(i).IsEmpty())
			bcc.RemoveAt(i);
	}

	CDraftAddressBookDlg ad;
	ad.SetTo(to);
	ad.SetCc(cc);
	ad.SetBcc(bcc);
	ad.SetMode(ADDRESS_MODE_TO);
	ad.DoModal();
}

void CDraftFrame::OnGpg()
{
	this->OnGpgKeyManagement();
}

void CDraftFrame::CloseIME(CView* view)
{
	HIMC hImc = ImmGetContext(view->GetSafeHwnd());
	m_ime_status = ImmGetOpenStatus(hImc);
	ImmSetOpenStatus(hImc, FALSE);
	ImmReleaseContext(view->GetSafeHwnd(), hImc);
}

void CDraftFrame::RecoverIME(CView* view)
{
	if(view == NULL){
		return;
	}
	HIMC hImc = ImmGetContext(view->GetSafeHwnd());
	ImmSetOpenStatus(hImc, this->m_ime_status);
	ImmReleaseContext(view->GetSafeHwnd(), hImc);
}

BOOL CDraftFrame::KeyDown(UINT nChar,CView* view)
{
	CStatusBar& sb = this->m_wndStatusBar;
	if(::GetKeyState(VK_CONTROL) & 0xff00){	// whether or not pressing CTRL
		switch(nChar){
		case 'C':
			if(sb.GetPaneText(0)=="C-c"){
				this->RecoverIME(view);
				if(!m_button_sendmail)
					return TRUE;
				sb.SetPaneText(0,"C-c C-c");
				this->OnSend();
				sb.SetPaneText(0, "");
				return TRUE;
			}
			if(sb.GetPaneText(0)!="C-x"){
				this->CloseIME(view);
				sb.SetPaneText(0,"C-c");
				return TRUE;
			}else{
				this->RecoverIME(view);
				return TRUE;
			}
		case 'X':
			if(sb.GetPaneText(0)=="C-x" || sb.GetPaneText(0)=="C-c"){
				this->RecoverIME(view);
				sb.SetPaneText(0,"");
			}
			else{
				this->CloseIME(view);
				sb.SetPaneText(0,"C-x");
			}
			return TRUE;
		case 'G':
			sb.SetPaneText(0, "");
		}
	}
	return FALSE;
}

BOOL CDraftFrame::Char(UINT nChar,CView* view)
{
	if(m_wndStatusBar.GetPaneText(0)=="C-x"){
		switch(nChar){
		case 'o':
			this->m_wndStatusBar.SetPaneText(0,"C-x o");
			this->RecoverIME(view);
			this->OnSwitchView();
			this->m_wndStatusBar.SetPaneText(0,"");
			return TRUE;
		case 19:
			this->m_wndStatusBar.SetPaneText(0, "C-x C-s");
			this->RecoverIME(view);
			this->OnSaveToDraft();
			return TRUE;
		case 9:
			this->m_wndStatusBar.SetPaneText(0,"C-x C-i");
			this->RecoverIME(view);
			this->OnAddFile();
			this->m_wndStatusBar.SetPaneText(0, "");
			return TRUE;
		case 24:	// ignore Ctrl-X in OnChar()
			return TRUE;
		}
		this->RecoverIME(view);
		this->m_wndStatusBar.SetPaneText(0,"");
		return TRUE;
	}
	if(m_wndStatusBar.GetPaneText(0)=="C-c"){
		switch(nChar){
		case 3:		// ignore Ctrl-C in OnChar()
			return TRUE;
		}
		this->RecoverIME(view);
		this->m_wndStatusBar.SetPaneText(0,"");
		return TRUE;
	}
	return FALSE;
}

void CDraftFrame::OnUpdateSend(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_button_sendmail);
}

void CDraftFrame::OnUpdateGpgExp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_button_gpgexp);
}

void CDraftFrame::OnUpdateAddress(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_address);
}

void CDraftFrame::OnUpdateSaveDraft(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_savedraft);
}

void CDraftFrame::OnUpdateExtEditor(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_exteditor);
}

void CDraftFrame::OnSwitchView()
{
	CWnd* wnd = GetFocus();
	if(wnd == m_pEditV)
		this->m_pAddrsV->m_to.SetFocus();
	else
		this->m_pEditV->SetFocus();
}

void CDraftFrame::OnGpgEnc()
{
	CGpg gpg;

	// selection of key.
//	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CGpgKeyListDlg lkd(this);
	CString recipient;
	recipient.Empty();
	if(lkd.DoModal()==IDOK && this->m_key_id_list.GetSize()){
		// preparation of executing process.
		CStringArray list;
		CString recipient;
		int max = this->m_key_id_list.GetSize();
		for(int i=0; i<max; i++){
			recipient = this->m_key_id_list[i];
			list.Add(recipient);
		}
		CString body;
		this->m_pEditV->GetText(body);
		this->m_me.SetMultipartBody(0, body);

		if(!gpg.Encode(list, m_me.GetMail(ME_GET_PRE_ENC_PGP), body)){
			this->MessageBox(gpg.GetErrorMsg(), "GPG error");
			return;
		}

		// display
		this->m_pEditV->SetWindowText(body);
		// for pgp/mime
		this->m_me.AddPgpEncrypted(body);
		this->m_pEditV->GetRichEditCtrl().SetReadOnly();
		this->HideAttachedFileView(TRUE);
		this->m_button_addfile = FALSE;
		this->m_button_exteditor = FALSE;
		this->m_button_gpgenc = FALSE;
		this->m_button_gpgexp = FALSE;
	}
}

void CDraftFrame::OnUpdateGpgEnc(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_gpgenc);
}

void CDraftFrame::OnUpdateGpg(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_gpg);
}

void CDraftFrame::OnUpdateAddFile(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_addfile);
}

void CDraftFrame::OnGpgExport() 
{
	CGpg gpg;

	// selection of key.
	CGpgKeyListDlg lkd;
	if(lkd.DoModal()==IDOK && this->m_key_id_list.GetSize()){
		// below may work under conditon that GpgKeyListDlg cannot accept multiple selection.
		CString id = this->m_key_id_list[0];
		CString out = gpg.ExportKey(id);
		this->m_me.AddPgpKey(out);
		this->m_pListV2->AddPgpKey();
		this->HideAttachedFileView(FALSE);
	}
}

void CDraftFrame::OnClose() 
{
	if(m_send_dlg != NULL)
		return;

	if(m_pEditV->GetRichEditCtrl().GetModify() || m_pAddrsV->GetModify()){
		if(!SaveToDraft(TRUE)){
			this->SetForegroundWindow();
			return;
		}
	}

	CPochyApp *app = (CPochyApp*)AfxGetApp();
	for(int i=0; i<app->m_draft_array.GetSize(); i++){
		if(this == app->m_draft_array[i])
			app->m_draft_array.RemoveAt(i);
	}

	CFrameWnd::OnClose();
}

void CDraftFrame::SetStatusBarText(int pane, LPSTR buf)
{
    // cannot use PostMessage, as the panel type is not set correctly
	::SendMessage(m_wndStatusBar, SB_SETTEXT, (WPARAM)pane | 0, (LPARAM)(LPSTR)buf);
}

void CDraftFrame::AttachFileFromCxCi()
{
/*	if(!m_hide){
		m_wndSplit.HideRow(1);
		m_hide=TRUE;
		if(!m_hide2){
			m_wndSplit1.HideRow(3);
			m_hide2=TRUE;
		}
		ArrangeSplit();
		m_pEditV->SetFocus();
	}else{
		// t@C͗pEBhEo
		m_wndSplit.ShowRow();
		m_hide=FALSE;
		ArrangeSplit();
//		m_wndSplit2.SetActivePane(0,0);
		m_wndSplit1.SetActivePane(3, 0);

		char buf[1024];
		_getdcwd(_getdrive(),buf,1023);
		CString wd = buf;
		wd.Replace("\\","/");// ̕\L̂ق肭
		m_wndStatusBar.SetPaneText(0,"t@C͂܂傤");// b
		wd=wd+"/";
		m_pFileV->SetWindowText(wd);
		m_pFileV->GetRichEditCtrl().SetSel(wd.GetLength(),wd.GetLength());
		m_pFileV->SetFocus();
	}*/
}


BOOL CDraftFrame::CreateToolbar()
{
	DWORD dwTBStyle, dwStyle;

	dwTBStyle = TBSTYLE_FLAT; // ̕ӂ̃X^C͓K
	dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC;
	if(!m_wndToolBar.CreateEx(this, dwTBStyle, dwStyle)){
		TRACE0("Failed to create toolbar\n");
		return FALSE;    // fail to create
	}

	CImageList img;
	HINSTANCE hInst = AfxFindResourceHandle((LPCTSTR)IDR_TEST, RT_BITMAP);
	ASSERT(hInst != NULL);

	int nIconWidth = WIDTH_ICON_DRAFT;
	int nIconHeight = HEIGHT_ICON_DRAFT;
	LPCTSTR lpBitmap = (LPCTSTR)IDR_DRAFTFRAME;
	UINT uFlags = LR_CREATEDIBSECTION;

	//skin.ini
	CPochyApp *pApp =(CPochyApp*)::AfxGetApp();
	CString strToolbarFilePath;
	if(pApp->m_skin.getToolbarDraftIcons() == "") {
		strToolbarFilePath = ((CPochyApp*)::AfxGetApp())->m_app_path + TOOLBAR_DRAFT_FILENAME;
	} else {
		strToolbarFilePath = pApp->m_skin.getSkinIniPath() + "\\" + pApp->m_skin.getToolbarDraftIcons();
	}

	HBITMAP hBitmap = (HBITMAP)::LoadImage(hInst, strToolbarFilePath, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
	if (hBitmap != NULL)
	{
		BITMAP bitmap;
		if (::GetObject(hBitmap, sizeof(bitmap), &bitmap) > 0)
		{
			nIconWidth = bitmap.bmWidth / NUMBER_OF_TOOLBAR_DRAFT_ICON;
			nIconHeight = bitmap.bmHeight;
			lpBitmap = strToolbarFilePath;
			uFlags |= LR_LOADFROMFILE;
		}
		::DeleteObject(hBitmap);
	}

	img.Attach(ImageList_LoadImage(hInst, lpBitmap, nIconWidth, 0, /*CLR_NONE*/RGB(255, 255, 255), IMAGE_BITMAP, uFlags));
	m_wndToolBar.GetToolBarCtrl().SetImageList(&img);
	img.Detach();

	m_wndToolBar.SetSizes(CSize(nIconWidth + 7, nIconHeight + 6), CSize(nIconWidth, nIconHeight));
	m_wndToolBar.SetButtons(NULL, 6);

	m_wndToolBar.SetButtonInfo(0, ID_SEND_MAIL, TBSTYLE_BUTTON, 0);
	m_wndToolBar.SetButtonInfo(1, ID_ADD_FILE, TBSTYLE_BUTTON, 1);
	m_wndToolBar.SetButtonInfo(2, ID_DRAFT_GPG, TBSTYLE_BUTTON, 2);
	m_wndToolBar.SetButtonInfo(3, ID_DRAFT_ADDRESS, TBSTYLE_BUTTON, 3);
	m_wndToolBar.SetButtonInfo(4, ID_SAVE_TO_DRAFT, TBSTYLE_BUTTON, 4);
	m_wndToolBar.SetButtonInfo(5, ID_DRAFT_EXT_EDITOR, TBSTYLE_BUTTON, 5);

	// dropdown menu
    m_wndToolBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	// gpg
	this->m_wndToolBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	DWORD style = this->m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_DRAFT_GPG));
	style |= TBSTYLE_DROPDOWN;
	this->m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_DRAFT_GPG), style);

	return TRUE;
}

BOOL CDraftFrame::SaveToDraft(BOOL confirm)
{
	CWaitCursor wait_cursor; // turn cursor into hourglass
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;
	CSummaryView *sv = mf->m_pListV;
	CString path = app->m_app_path+"\\"+m_account+"\\draft";
	CString box_name;

	CString body;
	m_pEditV->GetText(body);

	m_me.SetTo(m_pAddrsV->GetTo());
	m_me.SetCc(m_pAddrsV->GetCc());
	m_me.SetBcc(m_pAddrsV->GetBcc());
	m_me.SetFrom(m_pAddrsV->GetFrom());
	m_me.SetSubject(m_pAddrsV->GetSubject());
	m_me.SetReplyTo(m_pAddrsV->GetReplyTo());
	CTime time = CTime::GetCurrentTime();
	m_me.SetDate(time.Format("%d %b %Y %H:%M:%S ")+app->m_time_zone_offset);

	// setting body.
	if(m_me.GetMode() == ME_MODE_NONE)
		m_me.SetMultipartBody(0, body);

	// need or not confirmation dialog.
	if(confirm){
		CString message;

		GetPrivateProfileString(
			"mailbox",
			"draft",
			"",
			box_name.GetBuffer(BUF_LENGTH),
			BUF_LENGTH,
			app->m_app_path+"\\"+this->m_account+"\\account.ini");
		box_name.ReleaseBuffer();
		if(box_name.IsEmpty()){
			message.Format("%s\r\n\r\n%s֕ۑ܂H", m_me.GetSubject(), DEF_BOXNAME_DRAFT);
		}else{
			message.Format("%s\r\n\r\n%s֕ۑ܂H", m_me.GetSubject(), box_name);
		}
		int check = this->MessageBox(message, "[̕ۑ", MB_YESNOCANCEL);
		if(check == IDYES){
			sv->SaveMail(path, m_me.GetMail(ME_GET_DRAFT), SMRY_STATUS_NONE, SMRY_COLUMN_TO);
		}else if(check == IDCANCEL){
			return FALSE;
		}
	}else{
		sv->SaveMail(path, m_me.GetMail(ME_GET_DRAFT), SMRY_STATUS_NONE, SMRY_COLUMN_TO);
	}
	return TRUE;
}

void CDraftFrame::OnDestroy() 
{
	WINDOWPLACEMENT wndPlace;
	GetWindowPlacement(&wndPlace);

	// save window position in ini file.
	CPochyApp *app = (CPochyApp *)AfxGetApp();

	app->WriteProfileInt("DraftWndPlace", "Left", wndPlace.rcNormalPosition.left);
	app->WriteProfileInt("DraftWndPlace", "Top", wndPlace.rcNormalPosition.top);
	app->WriteProfileInt("DraftWndPlace", "Right", wndPlace.rcNormalPosition.right);
	app->WriteProfileInt("DraftWndPlace", "Bottom", wndPlace.rcNormalPosition.bottom);

	// save window status in ini file (maximum, iconize, other)
	if(this->IsZoomed())
		app->WriteProfileInt("DraftWndPlace", "Zoom", 1);
	else if(this->IsIconic()) 
		app->WriteProfileInt("DraftWndPlace", "Zoom", 1);
	else 
		app->WriteProfileInt("DraftWndPlace", "Zoom", 0);

	CFrameWnd::OnDestroy();
}

void CDraftFrame::OnChangeBkColorDraft() 
{

}

void CDraftFrame::OnChangeTxtColorDraft() 
{

}

void CDraftFrame::OnToolbarDropDown(NMHDR *pNMHDR, LRESULT *plr)
{
	CWnd *pWnd;
	UINT nID;

	NMTOOLBAR *pnmtb = (NMTOOLBAR *)pNMHDR;

	// Switch on button command id's
	switch (pnmtb->iItem){
	case ID_DRAFT_GPG:
		pWnd = &m_wndToolBar;
		nID  = IDR_DRAFTFRAME_POPUP_GPG;
		break;
	default:
		return;
	}

	// load and display popup menu
	CMenu menu;
	menu.LoadMenu(nID);
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup);

	CRect rc;
	pWnd->SendMessage(TB_GETRECT, pnmtb->iItem, (LPARAM)&rc);
	pWnd->ClientToScreen(&rc);

	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_VERTICAL, rc.left, rc.bottom, this, &rc);

	return;
}

BOOL CDraftFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
    // EBhENXo^
    // EBhE₷Ȃ邩HOOG
	if (cs.lpszName){
		WNDCLASS wc;
		::GetClassInfo(AfxGetInstanceHandle(), cs.lpszClass, &wc);
		// _T()ň͂ĂȂdebug[hŎsiHj
		wc.lpszClassName = _T("_PochyClass"); // DȖOݒ
		AfxRegisterClass(&wc);
		cs.lpszClass = wc.lpszClassName;
	}

	BOOL r = CFrameWnd::PreCreateWindow(cs);
	cs.style ^= FWS_ADDTOTITLE;
	return r;
}

void CDraftFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	lpMMI->ptMinTrackSize.x = 200;
//	lpMMI->ptMinTrackSize.y = 0;
	// minimum size of window

//	lpMMI->ptMaxTrackSize.x = ;
//	lpMMI->ptMaxTrackSize.y = ;
	// maximum size of window
}

void CDraftFrame::OnExtEditor()
{
	AfxBeginThread(ExEditor, this);

}

void CDraftFrame::ReArrangeSplit()
{
	CRect rect;
	m_split_attachedfile_others.GetClientRect(&rect);
	rect.NormalizeRect();
	int height = rect.Height()-4/* may be width of frame */;
	rect.SetRectEmpty();

	m_split_attachedfile_others.SetRowInfo(0, height-HT_ATTACHED_HEIGHT, 0);
	m_split_attachedfile_others.RecalcLayout();

	this->Invalidate(FALSE);
	this->UpdateWindow();
}

void CDraftFrame::HideAttachedFileView(BOOL b)
{
	if(b && m_hide_attach == FALSE){
		m_split_attachedfile_others.HideRow(1);
		m_hide_attach = TRUE;
		this->Invalidate(FALSE);
		this->UpdateWindow();
	}else if(!b && m_hide_attach == TRUE){
		m_split_attachedfile_others.ShowRow();
		m_hide_attach = FALSE;
		this->Invalidate(FALSE);
		this->UpdateWindow();
	}
}

void CDraftFrame::DisableButton(BOOL b)
{
	
}

void CDraftFrame::OnGpgKeyManagement() 
{
	CGpgDlg gd;
	gd.DoModal();
}

BOOL CDraftFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct) 
{
	if(pCopyDataStruct->dwData == WM_TITLE){
		CString title = (char *)pCopyDataStruct->lpData;
		this->SetWindowText(title);
	}
	return CFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}

void CDraftFrame::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	if(app->GetProfileInt("Customize", "MewKeyBind", 0)){
		this->Char(nChar, NULL);
	}
	CFrameWnd::OnChar(nChar, nRepCnt, nFlags);
}

void CDraftFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	if(app->GetProfileInt("Customize", "MewKeyBind", 0)){
		this->KeyDown(nChar, NULL);
	}
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL CDraftFrame::PreTranslateMessage(MSG* pMsg) 
{
	if (m_acceleratorTable.TranslateAccelerator(m_hWnd, pMsg))
	{
		return TRUE;
	}
	
	return CFrameWnd::PreTranslateMessage(pMsg);
}

BOOL CDraftFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	switch (LOWORD(wParam))
	{
	case ID_ADDRESS_COMPLEMENT:
		{
			// Address View ̃CxgđM
			return ::SendMessage(m_pAddrsV->GetSafeHwnd(), WM_COMMAND, wParam, lParam);
		}
		break;
	}
	
	return CFrameWnd::OnCommand(wParam, lParam);
}

void CDraftFrame::LoadAccelerator()
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	std::string strKeyIniPath = app->m_app_path + _T("\\KeySetting.ini");
//	m_acceleratorTable.Save(strKeyIniPath, _T("DraftFrameKey"));
	m_acceleratorTable.Load(strKeyIniPath, _T("DraftFrameKey"));
	HMENU hMenu = ::GetMenu(m_hWnd);
	m_acceleratorTable.ModifyMenuCaption(hMenu);
}

void CDraftFrame::SetAcceleratorTargetWindow()
{
	m_acceleratorTable.AddTargetWindow(m_pEditV->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->m_to.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->m_cc.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->m_bcc.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->m_subject.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->m_reply_to.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->m_from.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->GetDlgItem(IDC_BUTTON_TO)->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->GetDlgItem(IDC_BUTTON_CC)->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAddrsV->GetDlgItem(IDC_BUTTON_BCC)->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pListV2->GetSafeHwnd());
}

void CDraftFrame::LoadDefaultAccelerator()
{
	m_acceleratorTable.DeleteAll();

	m_acceleratorTable.AddAccelerator(_T("SendMail"),			ID_SEND_MAIL,					_T("Ctrl+T"),		_T("M(&T)"));
	m_acceleratorTable.AddAccelerator(_T("SwitchView"),			ID_SWITCH_VIEW,					_T("Ctrl+O"),		_T("r[̃tH[JX؂ւ"));
	m_acceleratorTable.AddAccelerator(_T("SaveToDraft"),		ID_SAVE_TO_DRAFT,				_T("Ctrl+S"),		_T("htg֕ۑ(&S)"));
	m_acceleratorTable.AddAccelerator(_T("AddFile"),			ID_ADD_FILE,					_T("Ctrl+I"),		_T("Yt(&I)..."));
	m_acceleratorTable.AddAccelerator(_T("ExternalEditor"),		ID_DRAFT_EXT_EDITOR,			_T("Ctrl+E"),		_T("OGfB^[(&E)..."));
	m_acceleratorTable.AddAccelerator(_T("ShowAddressBook"),	ID_DRAFT_ADDRESS,				_T("Ctrl+B"),		_T("AhX\(&A)..."));
	m_acceleratorTable.AddAccelerator(_T("GPGKeyManagement"),	ID_GPG_DRAFT_KEY_MANAGEMENT,	_T("Ctrl+G"),		_T("̊Ǘ(&G)..."));
	m_acceleratorTable.AddAccelerator(_T("GPGEncode"),			ID_GPG_ENC,						_T("Ctrl+K"),		_T("Í(&K)"));
	m_acceleratorTable.AddAccelerator(_T("GPGAttachKey"),		ID_GPG_EXP,						_T(""),				_T("̓Yt(&E)"));
	m_acceleratorTable.AddAccelerator(_T("AddressComplement"),	ID_ADDRESS_COMPLEMENT,			_T("Ctrl+UP"),		_T("AhX̕⊮"));
	m_acceleratorTable.AddAccelerator(_T("AddressComplement"),	ID_ADDRESS_COMPLEMENT,			_T("Ctrl+DOWN"),	_T("AhX̕⊮"));

	m_acceleratorTable.CreateAcceleratorTable();
}

void CDraftFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{
	CFrameWnd::OnSysCommand(nID, lParam);

	CPochyApp *pPochyApp = (CPochyApp *)AfxGetApp();
	if (pPochyApp != NULL)
	{
		CMainFrame *pMainFrame = (CMainFrame*)pPochyApp->m_pMainWnd;
		if (pMainFrame != NULL)
		{
			pMainFrame->CallPluginCallback(GetSafeHwnd(), nID);
		}
	}
}
