/*
 * Copyright (C) 2002-2003 chik & s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

#include "stdafx.h"
#include "Pochy.h"
#include "DraftFrame.h"
#include "lib.h"

UINT ExEditor(LPVOID pParam)
{
	// draftframeB
	CDraftFrame *df = (CDraftFrame *)pParam;
	df->ShowWindow(SW_HIDE);

	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	CString text;
	df->m_pEditV->GetWindowText(text);
	CString file_path = g_get_tmp_file();
	g_cstring2file(text, file_path);

	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString editor_path = app->GetProfileString("Editor", "Path", "notepad.exe");
	if(editor_path.IsEmpty())
		editor_path = "notepad";
	CString comline;
	comline.Format("%s \"%s\"", editor_path, file_path);

	memset(&si, 0, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	si.wShowWindow = SW_SHOW;
	BOOL b = CreateProcess(NULL, comline.GetBuffer(0), NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
	CloseHandle(pi.hThread);

	int ret;
	while((ret = WaitForSingleObject(pi.hProcess, 0)) != WAIT_ABANDONED){
		// bZ[WL[擾A݂Ώ𑣂
		MSG msg;
		if(::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
		// vZXIȂA[v𔲂
		if(ret == WAIT_OBJECT_0)
			break;
	}
	CloseHandle(pi.hProcess);

	text.Empty();
	g_file2cstring(file_path, text);
	df->m_pEditV->GetRichEditCtrl().SetWindowText("");
	df->m_pEditV->GetRichEditCtrl().SetWindowText(text);
	DeleteFile(file_path);

	// draftframe\
	df->ShowWindow(SW_SHOW);

	return TRUE;
}