/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// Filter.cpp: CFilter
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pochy.h"
#include "Filter.h"
#include "CodeConvert.h"

#include "FetchMail.h"
#include "direct.h"			// _mkdir
#include "HeaderInfo.h"
#include "lib.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CFilter::CFilter(LPCTSTR path)
{
	m_data.SetSize(0);
	SetPath(path);
	SetData();
}

CFilter::CFilter()
{

}

CFilter::~CFilter()
{

}

// analyze ocntent of variable, return apropriate path.
CString CFilter::GetPath(CHeaderInfo &hi)
{
	CString buf;
	CString ReturnPath;

	if(m_data.GetSize() == 0){
		buf.Empty();
		return buf;
	}

	ReturnPath = Find(hi);
#if 0
	// if directory does not exist, return false.
	if(!ReturnPath.IsEmpty() && g_is_there(ReturnPath.GetBuffer(0)))
		return ReturnPath;
#else
	// if directory dose not exist, try to create H
	if(!ReturnPath.IsEmpty()){
		_mkdir(ReturnPath);
		g_fcreate(ReturnPath + "\\list");
		return ReturnPath;
	}
#endif

	buf.Empty();
	return buf; // if nothing is filtered, return empty.
}

BOOL CFilter::SetData()
{
	CString message;
	CString buf;
	CStdioFile ReadFile;
	int position;
	int cnt;
	
	m_data.RemoveAll();

	if(!ReadFile.Open(m_file_path.GetBuffer(1), CFile::modeRead | CFile::typeText)){
#if 0 // if filter file does not exist, create.
		message.Format("CFilter: cannot open %s", m_file_path.GetBuffer(0));
		AfxMessageBox(message.GetBuffer(0));
		return FALSE;
#else
//		CString null;
		g_cstring2file(FILTER_INSTRUCTION, m_file_path); // create filter file.
		if(!ReadFile.Open(m_file_path, CFile::modeRead | CFile::typeText)){
			message.Format("CFilter: cannot open %s", m_file_path.GetBuffer(0));
			AfxMessageBox(message.GetBuffer(0));
			return -1;
		}
#endif
	}

	cnt = 0;
	while(FALSE != ReadFile.ReadString(buf)){
		if(buf.Find("!") == 0) continue;
		else if(buf.Find("#") == 0) continue;

		buf.TrimLeft();
		buf.TrimRight();
		m_data.SetSize(m_data.GetSize()+1);
		if(buf.Find("\\") == 0 && 
			buf.FindOneOf("/:*\?\"<>|") == -1){
			m_data[cnt].path = buf;
		}else{
			message.Format("%s ͕spathł", buf);
			AfxMessageBox(message);
			buf.Empty();
			m_data[cnt].path = buf;
		}

		int cnt2 = 0;
		while(FALSE != ReadFile.ReadString(buf)){
			if(buf.Find("!") == 0) break;
			else if(buf.Find("#") == 0) break;
			buf.TrimLeft();
			buf.TrimRight();
			position = buf.Find("=");

			m_data[cnt].data.SetSize(m_data[cnt].data.GetSize()+1);
			m_data[cnt].data[cnt2].name = buf.Left(position);
			m_data[cnt].data[cnt2].value = buf.Mid(position+1);
			m_data[cnt].data[cnt2].chkbit = 0;

			cnt2++;
		}
		cnt++;
	}
	return TRUE;
}

void CFilter::SetPath(LPCTSTR path)
{
	m_path.Empty(); m_file_path.Empty();
	m_path = path;
	m_file_path = m_path + "\\filter";
}

// analyze variable, return appropriate path for saveing mail.
CString CFilter::Find(CHeaderInfo &hi)
{
	int cnt = 0;
	int cnt2 = 0;
	CString buf;

	while(cnt < m_data.GetSize())
	{
		while(cnt2 < m_data[cnt].data.GetSize())
		{
			buf = hi.GetOneLine(m_data[cnt].data[cnt2].name.GetBuffer(0));
			if(buf.Find(m_data[cnt].data[cnt2].value.GetBuffer(0)) != -1)
			{
				m_data[cnt].data[cnt2].chkbit = 1;
				if(Check(cnt) == TRUE)
				{
					if(!m_data[cnt].path.IsEmpty()){
						return m_path + m_data[cnt].path;
					}else{
						buf.Empty();
						return buf;
					}
				}
			}
			cnt2++;
		}
		cnt2 = 0;
		cnt++;
	}
	buf.Empty();
	return buf; // if don't find any path, return empty.
}

BOOL CFilter::Check(int num)
{
	int cnt = 0;
	while(cnt < m_data[num].data.GetSize()){
		if(m_data[num].data[cnt].chkbit == 1){
			cnt++;
			continue;
		}else{
			return FALSE;
		}
	}
	return TRUE;
}
