/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// SettingDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Pochy.h"
#include "SettingAccountDlg.h"
#include "direct.h"
#include "mainfrm.h"
#include "lib.h"
#include "AccountView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSettingAccountDlg _CAO


CSettingAccountDlg::CSettingAccountDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSettingAccountDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSettingAccountDlg)
	//}}AFX_DATA_INIT
}


void CSettingAccountDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingAccountDlg)
	DDX_Control(pDX, IDC_SETTING_CHECK_APOP, m_apop);
	DDX_Control(pDX, IDC_SETTING_CHECK_DELMAIL, m_deletemail_pop);
	DDX_Control(pDX, IDC_SETTING_CHECK_POP_BEFORE_SMTP, m_pop_before_smtp);
	DDX_Control(pDX, IDOK, m_button_ok);
	DDX_Control(pDX, IDC_SETTING_BOXNAME, m_boxname);
	DDX_Control(pDX, IDC_SETTING_SIG, m_signature);
	DDX_Control(pDX, IDC_SETTING_USERID, m_user);
	DDX_Control(pDX, IDC_SETTING_ADDRESS, m_address);
	DDX_Control(pDX, IDC_SETTING_PASS, m_password);
	DDX_Control(pDX, IDC_SETTING_SMTP_PORT, m_smtpserver_port);
	DDX_Control(pDX, IDC_SETTING_SMTP_IP, m_smtpserver);
	DDX_Control(pDX, IDC_SETTING_POP_PORT, m_popserver_port);
	DDX_Control(pDX, IDC_SETTING_POP_IP, m_popserver);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingAccountDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingAccountDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettingAccountDlg bZ[W nh

BOOL CSettingAccountDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	get_app;
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CString current_account = mf->m_pAcntV->GetCurrentAccountName();

	CString path = app->m_app_path + "\\" + current_account + "\\account.ini";
	CString pop_addr;
	GetPrivateProfileString("pop", "server_addr", "", pop_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	pop_addr.ReleaseBuffer();
	m_popserver.SetWindowText(pop_addr);

	CString pop_port;
	GetPrivateProfileString("pop", "port", "", pop_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	pop_port.ReleaseBuffer();
	if(pop_port.IsEmpty()) pop_port = "110";
	m_popserver_port.SetWindowText(pop_port);

	CString smtp_addr;
	GetPrivateProfileString("smtp", "server_addr", "", smtp_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	smtp_addr.ReleaseBuffer();
	m_smtpserver.SetWindowText(smtp_addr);

	CString smtp_port;
	GetPrivateProfileString("smtp", "port", "", smtp_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	smtp_port.ReleaseBuffer();
	if(smtp_port.IsEmpty()) smtp_port = "25";
	m_smtpserver_port.SetWindowText(smtp_port);

	CString pass;
	GetPrivateProfileString("pop", "pass", "", pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	pass.ReleaseBuffer();
	m_password.SetWindowText(pass);

	CString address;
	GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	address.ReleaseBuffer();
	m_address.SetWindowText(address);

	CString user;
	GetPrivateProfileString("pop", "user", "", user.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	user.ReleaseBuffer();
	m_user.SetWindowText(user);

	m_boxname.SetWindowText(current_account);

	m_deletemail_pop.SetCheck(GetPrivateProfileInt("pop", "delete_mail", 0, path));

	m_pop_before_smtp.SetCheck(GetPrivateProfileInt("smtp", "pop_before_smtp", 0, path));

	m_apop.SetCheck(GetPrivateProfileInt("pop", "apop", 0, path));

	// gȂAiO
	CString signature;
	signature.Empty();
	if(g_file2cstring(app->m_app_path+"\\"+mf->m_pAcntV->GetCurrentAccountName()+"\\signature", signature))
		m_signature.SetWindowText(signature);
	else
		m_signature.SetWindowText("");

	return FALSE;
}

void CSettingAccountDlg::OnOK() 
{
	get_app;
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CString current_account = mf->m_pAcntV->GetCurrentAccountName();

	// ҏWꂽ[UQbg
	CString user;
	this->GetDlgItemText(IDC_SETTING_BOXNAME, user);

	// OύX
	if(current_account != user){
		// ̃tH_݂ꍇ͏𒆒f
		if(g_is_there(app->m_app_path+"\\"+user)){
			CString message;
			message.Format("%s͊ɑ݂Ă܂\r\nOς܂傤", user);
			AfxMessageBox(message);
			return;
		}
		rename(app->m_app_path+"\\"+current_account, app->m_app_path+"\\"+user);
		mf->m_pAcntV->RenameAccount(current_account, user);
		// OύXꂽAJEgftHgAJEgɐݒ肳Ăꍇ
		if(app->GetProfileString("DefaultMailBox", "boxname") == current_account)
			app->WriteProfileString("DefaultMailBox", "boxname", user);
	}

	CString path = app->m_app_path+"\\"+user+"\\account.ini";

	CString stmp;
	m_user.GetWindowText(stmp); WritePrivateProfileString("pop", "user", stmp, path);
	m_password.GetWindowText(stmp); WritePrivateProfileString("pop", "pass", stmp, path);
	m_popserver.GetWindowText(stmp); WritePrivateProfileString("pop", "server_addr", stmp, path);
	m_smtpserver.GetWindowText(stmp); WritePrivateProfileString("smtp", "server_addr", stmp, path);
	m_address.GetWindowText(stmp); WritePrivateProfileString("mailbox", "address", stmp, path);
	m_popserver_port.GetWindowText(stmp); WritePrivateProfileString("pop", "port", stmp, path);
	m_smtpserver_port.GetWindowText(stmp); WritePrivateProfileString("smtp", "port", stmp, path);
	m_signature.GetWindowText(stmp);
	DeleteFile(app->m_app_path + "\\" + user + "\\signature");
	g_cstring2file(stmp ,app->m_app_path + "\\" + user + "\\signature");

	CString check;
	// check romoving delete mail from spool or not
	itoa(m_deletemail_pop.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);
	check.ReleaseBuffer();
	WritePrivateProfileString("pop", "delete_mail", check, path);
	// check using pop before smtp or not
	itoa(m_pop_before_smtp.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);
	check.ReleaseBuffer();
	WritePrivateProfileString("smtp", "pop_before_smtp", check, path);
	// check using apop or not
	itoa(m_apop.GetCheck(), check.GetBuffer(BUF_LENGTH), BUF_LENGTH);
	check.ReleaseBuffer();
	WritePrivateProfileString("pop", "apop", check, path);

	CDialog::OnOK();
}
