/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// pochy.cpp :
//

#include "stdafx.h"
#include "Pochy.h"
#include "MainFrm.h"
#include "PochyDoc.h"
#include "MailEditView.h"
#include "lib.h"
#include "Gpg.h"
#include "DraftFrame.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPochyApp

BEGIN_MESSAGE_MAP(CPochyApp, CWinApp)
	//{{AFX_MSG_MAP(CPochyApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// ẄZbgAbv R}h
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPochyApp NX̍\z

CPochyApp::CPochyApp()
{
	CGpg gpg;
	m_gpg_enable = gpg.Check();
	m_gpg_passphrase.Empty();
	m_pop_passphrase.Empty();
	// toolbarreplyAtransferAheaderAgpg{^𖳌ɂ
}

/////////////////////////////////////////////////////////////////////////////
// B CPochyApp IuWFNg

CPochyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CPochyApp NX̏

BOOL CPochyApp::InitInstance()
{
	CString path;
	int point;

	// dN̖h~ƊɋNĂꍇforefroudɂ
	HANDLE mutex = CreateMutex(NULL, TRUE, "GPG_Mailer_Pochy_!");
	if(!mutex)
		return FALSE;
	if(GetLastError() == ERROR_ALREADY_EXISTS){
		HWND hwnd = GetWindow(GetDesktopWindow(), GW_CHILD);
		while(hwnd){
			if(GetProp(hwnd, "GPG_Mailer_Pochy_!")){
				if(IsIconic(hwnd))
					ShowWindow(hwnd, SW_RESTORE);
				SetForegroundWindow(GetLastActivePopup(hwnd));
				return FALSE;
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}
		return FALSE;
	}
	
	// WIȏ
	// ̋@\gpAst@C̃TCY
	// Έȉ̓̏[`̒sKvȂ
	// 폜ĂB
//	if(!AfxSocketInit()){
//		AfxMessageBox("\Pbg̏Ɏs܂B");
//		return FALSE;
//	}

#ifdef _AFXDLL
	Enable3dControls();		// L DLL ̒ MFC gpꍇɂ͂ĂяoĂB
#else
	Enable3dControlsStatic();	// MFC ƐÓIɃNĂꍇɂ͂ĂяoĂB
#endif

	// ݒ肪ۑ鉺̃WXg L[ύX܂B
	// TODO: ̕AЖ܂͏ȂǓK؂Ȃ̂
	// ύXĂB

	// ݈ʒũtpX擾Asetting.iniւ̃pX쐬
	GetModuleFileName(NULL, path.GetBuffer(1024), 1024); // -> 1024pXԂƗ̂ŗv
	path.ReleaseBuffer();
	point = path.ReverseFind('\\');
	path = path.Left(point);
	m_app_path = path;
	path += "\\setting.ini";

	// if some file that is required for pochy is missing, create those file. 
	// you run pochy first time, this may be occured.
	if(!g_is_there(this->m_app_path+"\\address.csv")){
		g_fcreate(this->m_app_path+"\\address.csv");
	}

	// WXgł͂ȂApochy.exeƓtH_init@CɃZbeBOۑ
	free((void *)m_pszProfileName);
	m_pszProfileName = _tcsdup(path.GetBuffer(0));	//͂܂
	LoadStdProfileSettings();  // W INI t@C̃IvV[ނ܂ (MRU ܂)

	// AvP[Vp̃hLg ev[go^܂BhLg ev[g
	//  ̓hLgAt[ EBhEƃr[邽߂ɋ@\܂B
	pDoc1Template = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CPochyDoc),
		RUNTIME_CLASS(CMainFrame),       // C SDI t[ EBhE
		RUNTIME_CLASS(CTextView));
	AddDocTemplate(pDoc1Template);

	// init@C wndPlace Zoom=1 ̏ꍇEBhEő剻ċN
	if(this->GetProfileInt("wndPlace", "Zoom", 1) == 1) m_nCmdShow = SW_MAXIMIZE;

	// DDEAfile open ȂǕW̃VF R}h̃R}hC͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// R}hCŃfBXpb` R}hw肵܂B
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// C EBhEꂽ̂ŁA\ƍXVs܂B
	this->m_pMainWnd->ShowWindow(SW_SHOW);
	this->m_pMainWnd->UpdateWindow();

	// EBhẼvpeBXgɃj[NȏǉƂ
	// dN̍ۂɂ̃EBhET̂Ɏg
	SetProp(this->m_pMainWnd->GetSafeHwnd(), "GPG_Mailer_Pochy_!", (HANDLE)1);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_copyright;
	CStatic	m_version;
	//}}AFX_DATA

	// ClassWizard z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_APPABOUT_COPY, m_copyright);
	DDX_Control(pDX, IDC_ABOUTBOX_VERSION, m_version);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CPochyApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void CPochyApp::CreateDraftFrame()
{
/*	CSingleDocTemplate* pDoc2Template;
	pDoc2Template = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CPochyDoc),
		RUNTIME_CLASS(CDraftFrame),
		RUNTIME_CLASS(CMailEditView));
	AddDocTemplate(pDoc2Template);

	ASSERT(pDoc2Template != NULL);
	ASSERT_KINDOF(CDocTemplate, pDoc2Template);

//	pTmpWnd = m_pMainWnd;
//	m_pMainWnd = NULL;
	m_pDraftWnd = new CDraftFrame;

	pDoc2Template->OpenDocumentFile(NULL, FALSE);

//	ASSERT_KINDOF(CDraftFrame, m_pMainWnd);
	ASSERT_KINDOF(CDraftFrame, this->m_pDraftWnd);
//	CDraftFrame *df = static_cast<CDraftFrame*>(m_pMainWnd);
	CDraftFrame *df = static_cast<CDraftFrame*>(this->m_pDraftWnd);
//	m_pMainWnd = pTmpWnd;
*/

	// ݂̃hLgw|C^擾
	CDocument *pDoc = (CDocument*)((CFrameWnd *)AfxGetMainWnd())->GetActiveDocument();

	// hLgev[g̍쐬
	CSingleDocTemplate DocTemplate(
		IDR_MAINFRAME,
		NULL,
		RUNTIME_CLASS(CDraftFrame),
		RUNTIME_CLASS(CMailEditView));

	// Vt[EBhEAr[̍쐬
	CFrameWnd *fw = DocTemplate.CreateNewFrame(pDoc, NULL);
	if(fw == NULL){
		TRACE("cannot create draftframe");
		return;
	}

	// t[EBhȄ
//	DocTemplate.InitialUpdateFrame(fw, pDoc, TRUE);

	m_pDraftWnd = fw; //ꂽt[EBhẼ|C^ۑ
	CDraftFrame *df = static_cast<CDraftFrame*>(this->m_pDraftWnd);

	if(this->GetProfileInt("DraftWndPlace", "Zoom", 0) == 1)
		df->ShowWindow(SW_MAXIMIZE);
	else
		df->ShowWindow(SW_SHOW);

	m_draft_array.Add(df);
	df->UpdateWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CPochyApp bZ[W nh

int CPochyApp::SearchUser(CString name)
{
	for(int i=0;i<m_user_list.GetSize();i++)
		if(m_user_list[i] == name)
		return i;
	return -1;
}

int CPochyApp::ExitInstance() 
{	
//	if(m_pszProfileName){
//		delete ((void*)m_pszProfileName);
//		m_pszProfileName = NULL;
//	}

	// vpeBXgGg폜
	RemoveProp(m_pMainWnd->GetSafeHwnd(), "GPG_Mailer_Pochy_!");

	return CWinApp::ExitInstance();
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	this->m_version.SetWindowText(VERSION);
	this->m_copyright.SetWindowText(COPYRIGHT);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}
