/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// DraftAddressBookDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "pochy.h"
#include "DraftAddressBookDlg.h"
#include "DraftAddressBookAddDlg.h"
#include "Csv.h"
#include "lib.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDraftAddressBookDlg _CAO


CDraftAddressBookDlg::CDraftAddressBookDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDraftAddressBookDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDraftAddressBookDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CDraftAddressBookDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDraftAddressBookDlg)
	DDX_Control(pDX, IDC_DRAFT_ADDRESSBOOK_CHECK_ADDRESS, m_check_address);
	DDX_Control(pDX, IDC_DRAFT_ADDRESSBOOK_ADD, m_button_add);
	DDX_Control(pDX, IDC_DRAFT_ADDRESSBOOK_DEL, m_button_del);
	DDX_Control(pDX, IDC_DRAFT_ADDRESSBOOK_TAB, m_tc);
	DDX_Control(pDX, IDC_DRAFT_ADDRESSBOOK_DST_LIST, m_lc_dst);
	DDX_Control(pDX, IDC_DRAFT_ADDRESSBOOK_ORG_LIST, m_lc_org);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDraftAddressBookDlg, CDialog)
	//{{AFX_MSG_MAP(CDraftAddressBookDlg)
	ON_NOTIFY(TCN_SELCHANGE, IDC_DRAFT_ADDRESSBOOK_TAB, OnSelchangeTab)
	ON_BN_CLICKED(IDC_DRAFT_ADDRESSBOOK_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DRAFT_ADDRESSBOOK_DEL, OnDel)
	ON_BN_CLICKED(IDC_DRAFT_ADDRESSBOOK_ADD2, OnAdd2)
	ON_NOTIFY(NM_DBLCLK, IDC_DRAFT_ADDRESSBOOK_ORG_LIST, OnDblclkOrgList)
	ON_NOTIFY(NM_DBLCLK, IDC_DRAFT_ADDRESSBOOK_DST_LIST, OnDblclkDstList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_DRAFT_ADDRESSBOOK_DST_LIST, OnDstItemchanged)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_DRAFT_ADDRESSBOOK_ORG_LIST, OnOrgItemchanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDraftAddressBookDlg bZ[W nh

BOOL CDraftAddressBookDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CCsv csv(app->m_app_path+"\\address.csv");

	int n;
	int i;
	int column_width[] = { 100, 200, 180 };
	char* column[] = { "O", "[AhX", "l" };
	LV_COLUMN lvc;
	lvc.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH|LVCF_SUBITEM;
	lvc.fmt = LVCFMT_LEFT;
	for(n=0; n<3; n++){
		lvc.pszText = column[n];
		lvc.cx = column_width[n];
		m_lc_org.InsertColumn(n, &lvc);
	}
	m_lc_org.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_lc_org.ModifyStyle(0, LVS_SHOWSELALWAYS);
	for(n=0; n<csv.GetRowSize(); n++){
		m_lc_org.InsertItem(n, csv.GetValue(n, 0));
		m_lc_org.SetItemData(n, n);
		for(i=1; i<3; i++){
			m_lc_org.SetItemText(n, i, csv.GetValue(n, i));
		}
	}

	lvc.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH|LVCF_SUBITEM;
	lvc.fmt = LVCFMT_LEFT;
	lvc.pszText = "[AhX";
	lvc.cx = 300;
	m_lc_dst.InsertColumn(0, &lvc);
	m_lc_dst.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_lc_dst.ModifyStyle(0, LVS_SHOWSELALWAYS);

	m_lc_dst.DeleteAllItems();
	switch(m_mode){
	case ADDRESS_MODE_TO:
		for(i=0; i<m_cstra_to.GetSize(); i++){
			if(!m_cstra_to.GetAt(i).IsEmpty()){
				m_lc_dst.InsertItem(i, m_cstra_to.GetAt(i));
			}
		}
		break;
	case ADDRESS_MODE_CC:
		for(i=0; i<m_cstra_cc.GetSize(); i++){
			if(!m_cstra_cc.GetAt(i).IsEmpty()){
				m_lc_dst.InsertItem(i, m_cstra_cc.GetAt(i));
			}
		}
		break;
	case ADDRESS_MODE_BCC:
		for(i=0; i<m_cstra_bcc.GetSize(); i++){
			if(!m_cstra_bcc.GetAt(i).IsEmpty()){
				m_lc_dst.InsertItem(i, m_cstra_bcc.GetAt(i));
			}
		}
		break;
	}

	TC_ITEM ti;  //^uACe\
	//^uRg[ɍڂ̒ǉ
	ti.mask = TCIF_TEXT;
	ti.pszText = "To:"; //^ǔo̐ݒ
	m_tc.InsertItem(0, &ti); //^uRg[ɍڂ}

	ti.mask = TCIF_TEXT;
	ti.pszText = "Cc:";
	m_tc.InsertItem(1, &ti);

	ti.mask = TCIF_TEXT;
	ti.pszText = "Bcc:";
	m_tc.InsertItem(2, &ti);

	m_tc.SetCurSel(m_mode);

	this->m_button_del.EnableWindow(FALSE);
	this->m_button_add.EnableWindow(FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDraftAddressBookDlg::SetMode(int mode)
{
	m_mode = mode;
}

void CDraftAddressBookDlg::SetTo(CStringArray &to)
{
	CString buf;
	for(int i=0; i<to.GetSize(); i++){
		buf = to.GetAt(i);
		buf.TrimLeft(" ");
		buf.TrimRight(" ");
		to.SetAt(i, buf);
	}
	m_cstra_to.Copy(to);
}

void CDraftAddressBookDlg::SetCc(CStringArray &cc)
{
	CString buf;
	for(int i=0; i<cc.GetSize(); i++){
		buf = cc.GetAt(i);
		buf.TrimLeft(" ");
		buf.TrimRight(" ");
		cc.SetAt(i, buf);
	}
	m_cstra_cc.Copy(cc);
}

void CDraftAddressBookDlg::SetBcc(CStringArray &bcc)
{
	CString buf;
	for(int i=0; i<bcc.GetSize(); i++){
		buf = bcc.GetAt(i);
		buf.TrimLeft(" ");
		buf.TrimRight(" ");
		bcc.SetAt(i, buf);
	}
	m_cstra_bcc.Copy(bcc);
}

void CDraftAddressBookDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i;

	m_lc_dst.DeleteAllItems();
	
	int index = m_tc.GetCurSel();
	switch(index){
		case 0:
			m_mode = ADDRESS_MODE_TO;
			for(i=0; i<m_cstra_to.GetSize(); i++)
				m_lc_dst.InsertItem(i, m_cstra_to.GetAt(i));
			break;
		case 1:
			m_mode = ADDRESS_MODE_CC;
			for(i=0; i<m_cstra_cc.GetSize(); i++)
				m_lc_dst.InsertItem(i, m_cstra_cc.GetAt(i));
			break;
		case 2:
			m_mode = ADDRESS_MODE_BCC;
			for(i=0; i<m_cstra_bcc.GetSize(); i++)
				m_lc_dst.InsertItem(i, m_cstra_bcc.GetAt(i));
			break;
	}
	*pResult = 0;
}

void CDraftAddressBookDlg::OnAdd() 
{
	CString address;
	CString name;
	CString buf;
	int item;

	POSITION pos = m_lc_org.GetFirstSelectedItemPosition();
	while(pos){
		item = m_lc_org.GetNextSelectedItem(pos);
		address = g_ma(m_lc_org.GetItemText(item, 1));
		name = m_lc_org.GetItemText(item, 0);
		if(!name.IsEmpty()){
			if(name.Find(",") == -1){
				buf.Format("%s <%s>", name, address);
			}else{
				buf.Format("\"%s\" <%s>", name, address);
			}
		}else{
			buf = address;
		}
		m_lc_dst.InsertItem(m_lc_org.GetItemCount(), buf);
		switch(m_mode){
		case ADDRESS_MODE_TO:
			m_cstra_to.Add(buf);
			break;
		case ADDRESS_MODE_CC:
			m_cstra_cc.Add(buf);
			break;
		case ADDRESS_MODE_BCC:
			m_cstra_bcc.Add(buf);
			break;
		}
		// I
		m_lc_org.SetItemState(item, 0, LVIS_SELECTED);
	}
}

void CDraftAddressBookDlg::OnOK() 
{
	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	CString buf;
	buf.Empty();
	int i;
	for(i=0; i<m_cstra_to.GetSize(); i++){
		if(i==0)
			buf+=m_cstra_to.GetAt(i);
		else
			buf+=", "+m_cstra_to.GetAt(i);
	}
	df->m_me.SetTo(buf); buf.Empty();

	for(i=0; i<m_cstra_cc.GetSize(); i++){
		if(i==0)
			buf+=m_cstra_cc.GetAt(i);
		else
			buf+=", "+m_cstra_cc.GetAt(i);
	}
	df->m_me.SetCc(buf); buf.Empty();

	for(i=0; i<m_cstra_bcc.GetSize(); i++){
		if(i==0)
			buf+=m_cstra_bcc.GetAt(i);
		else
			buf+=", "+m_cstra_bcc.GetAt(i);
	}
	df->m_me.SetBcc(buf); buf.Empty();

	df->m_pAddrsV->OnInitialUpdate();

	CDialog::OnOK();
}

void CDraftAddressBookDlg::OnDel() 
{
	CString address;
	CString name;
	CString buf;
	int item;
	int i;

	POSITION pos = m_lc_dst.GetFirstSelectedItemPosition();
	while(pos){
		item = m_lc_dst.GetNextSelectedItem(pos);
		m_lc_dst.SetItemData(item, 1);
	}
	i=0;
	while(i<m_lc_dst.GetItemCount()){
		if(m_lc_dst.GetItemData(i) == 1){
			m_lc_dst.DeleteItem(i);
			continue;
		}
		i++;
	}

	switch(m_mode){
	case ADDRESS_MODE_TO:
		m_cstra_to.RemoveAll();
		for(i=0; i<m_lc_dst.GetItemCount(); i++)
			m_cstra_to.Add(m_lc_dst.GetItemText(i, 0));
		break;
	case ADDRESS_MODE_CC:
		m_cstra_cc.RemoveAll();
		for(i=0; i<m_lc_dst.GetItemCount(); i++)
			m_cstra_cc.Add(m_lc_dst.GetItemText(i, 0));
		break;
	case ADDRESS_MODE_BCC:
		m_cstra_bcc.RemoveAll();
		for(i=0; i<m_lc_dst.GetItemCount(); i++)
			m_cstra_bcc.Add(m_lc_dst.GetItemText(i, 0));
		break;
	}		
}

void CDraftAddressBookDlg::OnAdd2() 
{
	CString address;
	CDraftAddressBookAddDlg ad(this);
	ad.DoModal();
}

void CDraftAddressBookDlg::OnDblclkOrgList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	POSITION pos = m_lc_org.GetFirstSelectedItemPosition();
	int item = m_lc_org.GetNextSelectedItem(pos);

	CString buf;
	CString address = g_ma(m_lc_org.GetItemText(item, 1));
	CString name = m_lc_org.GetItemText(item, 0);

	if(address.IsEmpty()){
		return;
	}

	if(this->m_check_address.GetCheck() == 1){
		if(!name.IsEmpty()){
			if(name.Find(",") == -1){
				buf.Format("%s <%s>", name, address);
			}else{
				buf.Format("\"%s\" <%s>", name, address);
			}
		}else{
			buf = address;
		}
	}else{
		buf = address;
	}
	m_lc_dst.InsertItem(m_lc_org.GetItemCount(), buf);
	switch(m_mode){
	case ADDRESS_MODE_TO:
		m_cstra_to.Add(buf);
		break;
	case ADDRESS_MODE_CC:
		m_cstra_cc.Add(buf);
		break;
	case ADDRESS_MODE_BCC:
		m_cstra_bcc.Add(buf);
		break;
	}
	// I
	m_lc_org.SetItemState(item, 0, LVIS_SELECTED);

	*pResult = 0;
}

void CDraftAddressBookDlg::OnDblclkDstList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CString address;
	CString name;
	CString buf;
	int item;
	int i;

	POSITION pos = m_lc_dst.GetFirstSelectedItemPosition();
	item = m_lc_dst.GetNextSelectedItem(pos);
	m_lc_dst.DeleteItem(item);

	switch(m_mode){
	case ADDRESS_MODE_TO:
		m_cstra_to.RemoveAll();
		for(i=0; i<m_lc_dst.GetItemCount(); i++)
			m_cstra_to.Add(m_lc_dst.GetItemText(i, 0));
		break;
	case ADDRESS_MODE_CC:
		m_cstra_cc.RemoveAll();
		for(i=0; i<m_lc_dst.GetItemCount(); i++)
			m_cstra_cc.Add(m_lc_dst.GetItemText(i, 0));
		break;
	case ADDRESS_MODE_BCC:
		m_cstra_bcc.RemoveAll();
		for(i=0; i<m_lc_dst.GetItemCount(); i++)
			m_cstra_bcc.Add(m_lc_dst.GetItemText(i, 0));
		break;
	}

	*pResult = 0;
}

void CDraftAddressBookDlg::OnDstItemchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	if(0 < this->m_lc_dst.GetSelectedCount()){
		this->m_button_del.EnableWindow();
	}else{
		this->m_button_del.EnableWindow(FALSE);
	}
	*pResult = 0;
}

void CDraftAddressBookDlg::OnOrgItemchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	if(0 < this->m_lc_org.GetSelectedCount()){
		this->m_button_add.EnableWindow();
	}else{
		this->m_button_add.EnableWindow(FALSE);
	}
	*pResult = 0;
}
