/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// Gpg.cpp: CGpg NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Gpg.h"
#include "lib.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CGpg::CGpg()
{

}

CGpg::~CGpg()
{

}

BOOL CGpg::Encode(CStringArray &list, CString in, CString &out)
{
	CString recipient;
	CString error;

	// e|[t@Cւ̃pX擾
	CString tmp_file = g_get_tmp_file();
	// ۑ
	if(!g_cstring2file(in, tmp_file)){
		m_error = "g_cstring2file()";
		return FALSE;
	}

	for(int i=0; i < list.GetSize(); i++)
		recipient += "-r "+list[i]+" ";

	CStringArray comline;
	CString out1;
	CString out2;
	CString command;
	command = "gpg --encrypt --always-trust -a --output - "+recipient+tmp_file;
//	command.Format("gpg --always-trust -a --output - "+recipient+"--verbose -e %s", tmp_file);
	comline.Add(command);
	g_connect_process(comline, out1, out2);
	if(out1.Find("failed")!=-1){
		m_error = out2;
		return FALSE;
	}

	DeleteFile(tmp_file);

	out = out1;
	return TRUE;
}

CString CGpg::GetKeyList()
{
	CStringArray comline;
	CString out2;

	// JXg擾	
	CString pub;
	comline.Add("gpg --list-key --with-colon");
	if(!g_connect_process(comline, pub, out2))
		pub.Empty();

	// 閧Xg擾
	CString sec;
	comline.SetAt(0, "gpg --list-secret-key --with-colon");
	if(!g_connect_process(comline, sec, out2))
		sec.Empty();

	return pub+sec;
}

BOOL CGpg::Check()
{
	CString out1;
	CString out2;
	CStringArray comline;
	comline.Add("gpg --list-key");
	return g_connect_process(comline, out1, out2);
}

BOOL CGpg::DelPubKey(CString id)
{
	CStringArray comline;
	CString out1;
	CString out2;
	comline.RemoveAll();

//	comline.Add("gpg --command-fd 0 --delete-key "+id);
//	comline.Add("Y\r\n");
	comline.Add("gpg --batch --yes --delete-keys "+id);
	g_connect_process(comline, out1, out2);
	if(out2.Find("failed")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

BOOL CGpg::DelSecKey(CString id)
{
	CStringArray comline;
	CString out1;
	CString out2;
	comline.RemoveAll();
	comline.Add("gpg --command-fd 0 --delete-secret-key "+id);
	comline.Add("Y\r\n");
	comline.Add("Y\r\n");
//	comline.Add("gpg --batch --yes --delete-secret-keys "+id);
	g_connect_process(comline, out1, out2);
	if(out2.Find("failed")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

BOOL CGpg::GenKey(GEN_KEY_STRUCT *gen_key_struct)
{
	CString out1;
	CString out2;
	CStringArray comline;
	CString gen_info_file;
 
	gen_info_file = "Key-Type: " + gen_key_struct->Key_Type + "\r\n";
	gen_info_file += "Key-Length: " + gen_key_struct->Key_Length + "\r\n";
	gen_info_file += "Subkey-Type: " + gen_key_struct->Subkey_Type + "\r\n";
	gen_info_file += "Subkey-Length: " + gen_key_struct->Subkey_Length + "\r\n";
	gen_info_file += "Name-Real: " + gen_key_struct->Name_Real + "\r\n";
	gen_info_file += "Name-Comment: " + gen_key_struct->Name_Comment + "\r\n";
	gen_info_file += "Name-Email: " + gen_key_struct->Name_Email + "\r\n";
	gen_info_file += "Expire-Date: " + gen_key_struct->Expire_Date + "\r\n";
	gen_info_file += "Passphrase: " + gen_key_struct->Passphrase + "\r\n";

	CString path = g_get_tmp_file();
	g_cstring2file(gen_info_file, path);

	comline.Add("gpg --batch --gen-key -a "+path);

	if(!g_connect_process(comline ,out1, out2))
		return FALSE;
	DeleteFile(path);

	if(out2.Find("missing")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	if(out2.Find("invalid expire")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

CString CGpg::Decode(CString path, CString pass)
{
	CStringArray comline;
	CString body;
	CString out2;
	comline.Add("gpg --command-fd 0 -o - --verbose -d \""+path+"\"");
	comline.Add(pass+"\r\n");
	comline.Add(pass+"\r\n");
	comline.Add("\r\n");
	comline.Add("\r\n");
	comline.Add("\r\n");
	g_connect_process(comline, body, out2);

	if(out2.Find("failed")!=-1){
		AfxMessageBox(out2);
		body.Empty();
		return body;
	}
	return body;
}

CString CGpg::GetErrorMsg()
{
	return m_error;
}

BOOL CGpg::ImportKey(CString key)
{
	CString out1;
	CString out2;
	CString path = g_get_tmp_file();
	g_cstring2file(key, path);
	CStringArray comline;
	comline.Add("gpg --import "+path);
	if(!g_connect_process(comline, out1, out2))
		return FALSE;
	DeleteFile(path);
	if(-1 != out2.Find("failed")){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

BOOL CGpg::ImportKey(LPCTSTR path)
{
	CString out1;
	CString out2;
	CStringArray comline;
	CString command;
	command.Format("gpg --import %s", path);
	comline.Add(command);
	if(!g_connect_process(comline, out1, out2))
		return FALSE;
	if(-1 != out2.Find("failed")){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

CString CGpg::GetPubKeyList()
{
	CStringArray comline;
	CString out2;
	CString pub;
	comline.Add("gpg --list-key --with-colon");
	if(!g_connect_process(comline, pub, out2))
		pub.Empty();

	return pub;
}

CString CGpg::GetSecKeyList()
{
	CStringArray comline;
	CString out2;
	CString sec;
	comline.SetAt(0, "gpg --list-secret-key --with-colon");
	if(!g_connect_process(comline, sec, out2))
		sec.Empty();

	return sec;
}

CString CGpg::ExportKey(CString id)
{
	CString out1;
	CString out2;

	CStringArray comline;
	comline.Add("gpg --always-trust -a --export "+id);
	if(!g_connect_process(comline, out1, out2)){
		out1.Empty();
		AfxMessageBox(out2);
		m_error = out2;
		return out1;
	}
	return out1;
}

CString CGpg::ExportSecKey(CString id)
{
	CString out1;
	CString out2;

	CStringArray comline;
	comline.Add("gpg --always-trust -a --export-secret-key "+id);
	if(!g_connect_process(comline, out1, out2)){
		out1.Empty();
		AfxMessageBox(out2);
		m_error = out2;
		return out1;
	}
	return out1;
}
