/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * 2003-11-19 Big modification is done for gpg path setting by minamina.
 * For license terms, see the file COPYING in this directory.
 */

// Gpg.cpp: CGpg NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
#include "Pochy.h"
// end
#include "Gpg.h"
#include "lib.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CGpg::CGpg()
{
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
	LoadPath();
// end
}

CGpg::~CGpg()
{

}

BOOL CGpg::Encode(CStringArray &list, CString in, CString &out)
{
	CString recipient;
	CString error;

	// get path of temporal file
	CString tmp_file = g_get_tmp_file();
	// save
	if(!g_cstring2file(in, tmp_file)){
		m_error = "g_cstring2file()";
		return FALSE;
	}

	for(int i=0; i < list.GetSize(); i++)
		recipient += "-r "+list[i]+" ";

	CStringArray comline;
	CString out1;
	CString out2;
	CString command;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	command = "gpg --encrypt --always-trust -a --output - "+recipient+tmp_file;
//	command.Format("gpg --always-trust -a --output - "+recipient+"--verbose -e %s", tmp_file);
	command = GetPath() + GetHomeOption() + "--encrypt --always-trust -a --output - "+recipient+tmp_file;
// end
	comline.Add(command);
	g_connect_process(comline, out1, out2);
	if(out1.Find("failed")!=-1){
		m_error = out2;
		return FALSE;
	}

	DeleteFile(tmp_file);

	out = out1;
	return TRUE;
}

CString CGpg::GetKeyList()
{
	CStringArray comline;
	CString out2;

	// get public key list
	CString pub;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --list-key --with-colon");
	comline.Add(GetPath() + GetHomeOption() + "--list-key --with-colon");
// end
	if(!g_connect_process(comline, pub, out2))
		pub.Empty();

	// get secret key list
	CString sec;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.SetAt(0, "gpg --list-secret-key --with-colon");
	comline.SetAt(0, GetPath() + GetHomeOption() + "--list-secret-key --with-colon");
// end
	if(!g_connect_process(comline, sec, out2))
		sec.Empty();

	return pub+sec;
}

BOOL CGpg::Check()
{
	CString out1;
	CString out2;
	CStringArray comline;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --list-key");
	comline.Add(GetPath() + GetHomeOption() + "--list-key");
// end
	return g_connect_process(comline, out1, out2);
}

BOOL CGpg::DelPubKey(CString id)
{
	CStringArray comline;
	CString out1;
	CString out2;
	comline.RemoveAll();

// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add(GetPath() + GetHomeOption() + "--command-fd 0 --delete-key "+id);
//	comline.Add("Y\r\n");
//	comline.Add("gpg --batch --yes --delete-keys "+id);
	comline.Add(GetPath() + GetHomeOption() + "--batch --yes --delete-keys "+id);
// end
	g_connect_process(comline, out1, out2);
	if(out2.Find("failed")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

BOOL CGpg::DelSecKey(CString id)
{
	CStringArray comline;
	CString out1;
	CString out2;
	comline.RemoveAll();
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --command-fd 0 --delete-secret-key "+id);
	comline.Add(GetPath() + GetHomeOption() + "--command-fd 0 --delete-secret-key "+id);
// end
	comline.Add("Y\r\n");
	comline.Add("Y\r\n");
	g_connect_process(comline, out1, out2);
	if(out2.Find("failed")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

BOOL CGpg::GenKey(GEN_KEY_STRUCT *gen_key_struct)
{
	CString out1;
	CString out2;
	CStringArray comline;
	CString gen_info_file;
 
	gen_info_file = "Key-Type: " + gen_key_struct->Key_Type + "\r\n";
	gen_info_file += "Key-Length: " + gen_key_struct->Key_Length + "\r\n";
	gen_info_file += "Subkey-Type: " + gen_key_struct->Subkey_Type + "\r\n";
	gen_info_file += "Subkey-Length: " + gen_key_struct->Subkey_Length + "\r\n";
	gen_info_file += "Name-Real: " + gen_key_struct->Name_Real + "\r\n";
	gen_info_file += "Name-Comment: " + gen_key_struct->Name_Comment + "\r\n";
	gen_info_file += "Name-Email: " + gen_key_struct->Name_Email + "\r\n";
	gen_info_file += "Expire-Date: " + gen_key_struct->Expire_Date + "\r\n";
	gen_info_file += "Passphrase: " + gen_key_struct->Passphrase + "\r\n";

	CString path = g_get_tmp_file();
	g_cstring2file(gen_info_file, path);

// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --batch --gen-key -a "+path);
	comline.Add(GetPath() + GetHomeOption() + "--batch --gen-key -a "+path);
// end

	if(!g_connect_process(comline ,out1, out2))
		return FALSE;
	DeleteFile(path);

	if(out2.Find("missing")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	if(out2.Find("invalid expire")!=-1){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

CString CGpg::Decode(CString path, CString pass)
{
	CStringArray comline;
	CString body;
	CString out2;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --command-fd 0 -o - --verbose -d \""+path+"\"");
	comline.Add(GetPath() + GetHomeOption() + "--command-fd 0 -o - --verbose -d \""+path+"\"");
// end
	comline.Add(pass+"\r\n");
	comline.Add(pass+"\r\n");
	comline.Add("\r\n");
	comline.Add("\r\n");
	comline.Add("\r\n");
	g_connect_process(comline, body, out2);

	if(out2.Find("failed")!=-1){
		AfxMessageBox(out2);
		body.Empty();
		return body;
	}
	return body;
}

CString CGpg::GetErrorMsg()
{
	return m_error;
}

BOOL CGpg::ImportKey(CString key)
{
	CString out1;
	CString out2;
	CString path = g_get_tmp_file();
	g_cstring2file(key, path);
	CStringArray comline;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --import "+path);
	comline.Add(GetPath() + GetHomeOption() + "--import "+path);
// end
	if(!g_connect_process(comline, out1, out2))
		return FALSE;
	DeleteFile(path);
	if(-1 != out2.Find("failed")){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

BOOL CGpg::ImportKey(LPCTSTR path)
{
	CString out1;
	CString out2;
	CStringArray comline;
	CString command;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	command.Format("gpg --import %s", path);
	command.Format(GetPath() + GetHomeOption() + "--import %s", path);
// end
	comline.Add(command);
	if(!g_connect_process(comline, out1, out2))
		return FALSE;
	if(-1 != out2.Find("failed")){
		AfxMessageBox(out2);
		return FALSE;
	}
	return TRUE;
}

CString CGpg::GetPubKeyList()
{
	CStringArray comline;
	CString out2;
	CString pub;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --list-key --with-colon");
	comline.Add(GetPath() + GetHomeOption() + "--list-key --with-colon");
// end
	if(!g_connect_process(comline, pub, out2))
		pub.Empty();

	return pub;
}

CString CGpg::GetSecKeyList()
{
	CStringArray comline;
	CString out2;
	CString sec;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.SetAt(0, "gpg --list-secret-key --with-colon");
	comline.SetAt(0, GetPath() + GetHomeOption() + "--list-secret-key --with-colon");
// end
	if(!g_connect_process(comline, sec, out2))
		sec.Empty();

	return sec;
}

CString CGpg::ExportKey(CString id)
{
	CString out1;
	CString out2;

	CStringArray comline;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --always-trust -a --export "+id);
	comline.Add(GetPath() + GetHomeOption() + "--always-trust -a --export "+id);
// end
	if(!g_connect_process(comline, out1, out2)){
		out1.Empty();
		AfxMessageBox(out2);
		m_error = out2;
		return out1;
	}
	return out1;
}

CString CGpg::ExportSecKey(CString id)
{
	CString out1;
	CString out2;

	CStringArray comline;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//	comline.Add("gpg --always-trust -a --export-secret-key "+id);
	comline.Add(GetPath() + GetHomeOption() + "--always-trust -a --export-secret-key "+id);
// end
	if(!g_connect_process(comline, out1, out2)){
		out1.Empty();
		AfxMessageBox(out2);
		m_error = out2;
		return out1;
	}
	return out1;
}

const CString& CGpg::GetPath()
{
	return m_strPath;
}

const CString& CGpg::GetHomeOption()
{
	return m_strHomeOption;
}

void CGpg::LoadPath()
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	m_strPath = app->GetProfileString(_T("GPG"), _T("Path"), _T("GPG\\gpg.exe"));
	m_strHomeOption = app->GetProfileString(_T("GPG"), _T("Home"), _T("GPG\\Home"));

	if (m_strPath == _T(""))
	{
		m_strPath = _T("gpg.exe ");
	}
	else
	{
		if (!(m_strPath.GetAt(1) == _T(':') || m_strPath.Left(2) == _T("\\\\")))
		{
			// tpX⊮
			m_strPath = app->m_app_path + _T("\\") + m_strPath;
		}
		if (g_is_there(m_strPath))
		{
			m_strPath = _T("\"") + m_strPath + _T("\" ");
		}
		else
		{
			m_strPath = _T("gpg.exe ");
		}
	}

	if (m_strHomeOption != _T(""))
	{
		if (!(m_strHomeOption.GetAt(1) == _T(':') || m_strHomeOption.Left(2) == _T("\\\\")))
		{
			// tpX⊮
			m_strHomeOption = app->m_app_path + _T("\\") + m_strHomeOption;
		}
		if (g_is_there(m_strHomeOption))
		{
			m_strHomeOption = _T("\"") + m_strHomeOption + _T("\" ");
			m_strHomeOption = _T("--homedir ")  + m_strHomeOption;
		}
		else
		{
			m_strHomeOption = _T("");
		}
	}
}
