/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// TextView.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Pochy.h"
#include "TextView.h"
#include "FetchMail.h"
#include "CodeConvert.h"
#include "mainfrm.h"
#include "sendmail.h"
#include "PassPhraseDlg.h"
#include "HeaderInfo.h"
#include <Shlwapi.h> // StrStrI vWFNg̐ݒ̃N"Shlwapi.lib"ǉ
#include "quoted-printable.h"
#include "base64.h"
#include "lib.h"
#include "direct.h"			// _mkdir
#include "Gpg.h"

#include "Template.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TEXTVIEW_BACKGROUND_FILENAME _T("\\skin\\TextViewBk.bmp")

/////////////////////////////////////////////////////////////////////////////
// CTextView

IMPLEMENT_DYNCREATE(CTextView, CRichEditView)

CTextView::CTextView()
{
	m_current_part = -1;
}

CTextView::~CTextView()
{
}


BEGIN_MESSAGE_MAP(CTextView, CBitmapRichEditView)
	//{{AFX_MSG_MAP(CTextView)
	ON_WM_CHAR()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_TEXTVIEW_COPY, OnPopupCopy)
	ON_COMMAND(ID_TEXTVIEW_SELALL, OnPopupSelall)
	ON_COMMAND(ID_TEXTVIEW_BROWSER, OnPopupBrowser)
	ON_COMMAND(ID_TEXTVIEW_EDITOR, OnPopupEditor)
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
	ON_NOTIFY_REFLECT_EX(EN_LINK, OnLink)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextView `

void CTextView::OnDraw(CDC* pDC)
{	
	CDocument* pDoc = GetDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CTextView ff

#ifdef _DEBUG
void CTextView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void CTextView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTextView bZ[W nh

void CTextView::OnInitialUpdate()
{
	CRichEditView::OnInitialUpdate();
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CRichEditCtrl& r = GetRichEditCtrl();

	LOGFONT lf;
	LPBYTE pData;
	UINT nSize;
	if(app->GetProfileBinary("TextViewFont", "LogFont", &pData, &nSize)){
		ASSERT(nSize == sizeof(LOGFONT));
		::CopyMemory(&lf, pData, sizeof(LOGFONT));
		delete [] pData; 
	}else{
		lf.lfHeight = -16;
		lf.lfWidth = 0;
		lf.lfEscapement = 0;
		lf.lfOrientation = 0;
		lf.lfWeight = 400;
		lf.lfItalic = 0;
		lf.lfUnderline = 0;
		lf.lfStrikeOut = 0;
		lf.lfCharSet = 128;
		lf.lfOutPrecision = 3;
		lf.lfClipPrecision = 2;
		lf.lfQuality = 1;
		lf.lfPitchAndFamily = 49;
		strcpy(lf.lfFaceName, "lr SVbN");
	}
	this->SetFontEx(lf);

	r.SetBackgroundColor(FALSE, RGB(
				app->GetProfileInt("TextViewColor", "BkColorR", DEF_BKG_COLOR_R),
				app->GetProfileInt("TextViewColor", "BkColorG", DEF_BKG_COLOR_G),
				app->GetProfileInt("TextViewColor", "BkColorB", DEF_BKG_COLOR_B)));
	r.SetReadOnly(TRUE);

	this->SetFontColorAndLink();

	// prepare for header template
	if(g_is_there(app->m_app_path+"\\template\\header.htmpl")){
		g_file2cstring(app->m_app_path+"\\template\\header.htmpl", this->m_header_template);
	}else{
		this->m_header_template = DEF_HEADER_TEMPLATE;
	}

	// set backgroud bitmap
	CString strBackgroundFilePath;
	if(app->m_skin.getTextViewBackBmp() == ""){
		strBackgroundFilePath = app->m_app_path + TEXTVIEW_BACKGROUND_FILENAME;
	}else{
		strBackgroundFilePath = app->m_skin.getSkinIniPath() + "\\" + app->m_skin.getTextViewBackBmp();
	}
	SetBkImage(strBackgroundFilePath);
//	CString strBackgroundFilePath = app->m_app_path + TEXTVIEW_BACKGROUND_FILENAME;
//	SetBkImage(strBackgroundFilePath);
}

void CTextView::Font()
{
	CRichEditCtrl& r = GetRichEditCtrl();
	CHARFORMAT cf;
	DWORD dwMask = r.GetDefaultCharFormat(cf);

	LOGFONT lf = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "\0"};
	if(cf.dwEffects & CFE_STRIKEOUT)
		lf.lfStrikeOut = 1;
	if(cf.dwEffects & CFE_UNDERLINE)
		lf.lfUnderline = 1;
	if(cf.dwEffects & CFE_ITALIC)
		lf.lfItalic |= 1;
	if(cf.dwEffects & CFE_BOLD)
		lf.lfWeight = FW_BOLD;
	else
		lf.lfWeight = FW_NORMAL;
	strcpy(lf.lfFaceName, cf.szFaceName);
	lf.lfPitchAndFamily = cf.bPitchAndFamily;
	lf.lfCharSet = cf.bCharSet;
	lf.lfHeight = cf.yHeight * 4/3 * 1/20;

	CFontDialog fd(&lf, CF_EFFECTS | CF_SCREENFONTS | CF_BOTH, NULL, this);
	fd.m_cf.rgbColors = cf.crTextColor;
	if(fd.DoModal() == IDOK){
		int minilen = min(strlen(lf.lfFaceName), LF_FACESIZE);
		strncpy(cf.szFaceName, lf.lfFaceName, minilen);

		cf.bPitchAndFamily = lf.lfPitchAndFamily;
		cf.bCharSet = lf.lfCharSet;

		cf.yHeight = fd.m_cf.iPointSize * 2;
		cf.crTextColor = fd.m_cf.rgbColors;
		cf.dwEffects &= ~CFE_AUTOCOLOR;

		cf.dwMask = CFM_BOLD | CFM_CHARSET | CFM_COLOR | CFM_FACE | CFM_ITALIC | CFM_SIZE | CFM_OFFSET | CFM_STRIKEOUT | CFM_UNDERLINE;
		if(lf.lfStrikeOut)
			cf.dwEffects |= CFE_STRIKEOUT;
		else
			cf.dwEffects &= ~CFE_STRIKEOUT;
		if(lf.lfUnderline)
			cf.dwEffects |= CFE_UNDERLINE;
		else
			cf.dwEffects &= ~CFE_UNDERLINE;
		if(lf.lfItalic)
			cf.dwEffects |= CFE_ITALIC;
		else
			cf.dwEffects &= ~CFE_ITALIC;
		if(lf.lfWeight > FW_NORMAL)
			cf.dwEffects |= CFE_BOLD;
		else
			cf.dwEffects &= ~CFE_BOLD;

		r.SetDefaultCharFormat(cf);
		Invalidate(TRUE);
		this->UpdateWindow();
	}
	TRACE("height=%d\n",cf.yHeight);
}

void CTextView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

	if(mf->Char(nChar))
		return;

	switch(nChar){
		case '<': // plan to implement
			break;
		case '>': // plan to implement
			break;
		default:
			break;
	}
}

CString CTextView::GetCurrentPath()
{
	return m_path;
}

CString CTextView::GetCurrentRawHeader()
{
	return m_md.m_hi.GetAllDecoded();
}

CString CTextView::GetCurrentSubject()
{
	return m_md.m_hi.GetSubject();
}

CString CTextView::GetCurrentFrom()
{
	return m_md.m_hi.GetFrom();
}

CString CTextView::GetCurrentTo()
{
	return m_md.m_hi.GetTo();
}

CString CTextView::GetCurrentCc()
{
	return m_md.m_hi.GetCc();
}

CString CTextView::GetCurrentDate()
{
	return m_md.m_hi.GetDate();
}

CString CTextView::GetCurrentMsgID()
{
	return m_md.m_hi.GetMsgID();
}

CString CTextView::GetCurrentBody()
{
	return m_body;
}

CString CTextView::GetCurrentHeader()
{
	return m_header;
}

CString CTextView::GetCurrentCT()
{
	return m_md.GetContentType(m_current_part);
}

int CTextView::GetCurrentCTE()
{
	return m_md.GetEncodingType(m_current_part);
}

CString CTextView::GetCurrentReplyTo()
{
	return m_md.m_hi.GetReplyTo();
}

CString CTextView::GetCurrentText()
{
	return m_text;
}

BOOL CTextView::IsPgpMime()
{
	return g_cstr_compare(m_md.m_hi.GetProtocol(), "application/pgp-encrypted");
}

void CTextView::OnLink(NMHDR* in_pNotifyHeader, LRESULT* out_pResult)
{
	*out_pResult = 0;
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CString current_account = mf->m_pAcntV->GetCurrentAccountName();

	ENLINK * pLink = (ENLINK*)in_pNotifyHeader;
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
/*	if(pLink->msg == WM_LBUTTONDBLCLK && m_onlink != pLink->lParam){
		// dNh߂Ɍ݂̃}EX̃NbNꂽ|CgۑĂ
		m_onlink = pLink->lParam; // ̍

		// get charactor of clicked link
		GetRichEditCtrl().SetSel(pLink->chrg);
		CString link = GetRichEditCtrl().GetSelText();

		if(link.Find("mailto:") == 0||link.Find("Mailto:") == 0){
			// initialization.
			app->m_me.Initialize();
			// setting To
			if(link.Find("?", 7) != -1) // mailto:hoge@hoge.com?subject=PGP%20Key&Body=Please%20send%20keyƂ
				// subject, body is not implemented.
				app->m_me.SetTo(link.Mid(7, link.Find("?", 7)-7));
			else
				app->m_me.SetTo(link.Mid(7));
			// setting From
			CString path = app->m_app_path+"\\"+current_account+"\\account.ini";
			CString address;
			GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
			address.ReleaseBuffer();
			app->m_me.SetFrom(address);

			// getting signature.
			CString signature;
			g_file2cstring(app->m_app_path+"\\"+current_account+"\\signature", signature);
			// set main text.
			app->m_me.AddText(signature);
			// draftframe
			app->CreateDraftFrame(mf->m_pAcntV->GetCurrentAccountName());
		}else{
			ShellExecute(this->GetSafeHwnd(), _T( "open" ), link, NULL, NULL, SW_NORMAL);*/
	if(app->GetProfileInt("Customize", "TextViewSingleClick", 1)){
		if(pLink->msg == WM_LBUTTONUP && m_onlink != pLink->lParam){
			// dNh߂Ɍ݂̃}EX̃NbNꂽ|CgۑĂ
			m_onlink = pLink->lParam; // ̍

			// get charactor of clicked link
			GetRichEditCtrl().SetSel(pLink->chrg);
			CString link = GetRichEditCtrl().GetSelText();

			if(link.Find("mailto:") == 0||link.Find("Mailto:") == 0){
				// initialization.
				app->m_me.Initialize();
				// setting To
				if(link.Find("?", 7) != -1) // mailto:hoge@hoge.com?subject=PGP%20Key&Body=Please%20send%20keyƂ
					// subject, body is not implemented.
					app->m_me.SetTo(link.Mid(7, link.Find("?", 7)-7));
				else
					app->m_me.SetTo(link.Mid(7));

				// setting From
				CString path = app->m_app_path+"\\"+current_account+"\\account.ini";
				CString address;
				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				address.ReleaseBuffer();
				app->m_me.SetFrom(address);

				// setting "cc"
				CString cc;
				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				cc.ReleaseBuffer();
				app->m_me.SetCc(cc);

				// setting "bcc"
				CString bcc;
				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				bcc.ReleaseBuffer();
				app->m_me.SetBcc(bcc);

				// setting "reply-to"
				CString reply_to;
				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				reply_to.ReleaseBuffer();
				app->m_me.SetReplyTo(reply_to);

				// getting signature.
				CString signature;
				g_file2cstring(app->m_app_path+"\\"+current_account+"\\signature", signature);
				// set main text.
				app->m_me.AddText(signature);
				// draftframe
				app->CreateDraftFrame(mf->m_pAcntV->GetCurrentAccountName());
			}else{
				ShellExecute(this->GetSafeHwnd(), _T( "open" ), link, NULL, NULL, SW_NORMAL);
			}
		}
	}else{
		if(pLink->msg == WM_LBUTTONDBLCLK && m_onlink != pLink->lParam){
			// dNh߂Ɍ݂̃}EX̃NbNꂽ|CgۑĂ
			m_onlink = pLink->lParam; // ̍

			// get charactor of clicked link
			GetRichEditCtrl().SetSel(pLink->chrg);
			CString link = GetRichEditCtrl().GetSelText();

			if(link.Find("mailto:") == 0||link.Find("Mailto:") == 0){
				// initialization.
				app->m_me.Initialize();
				// setting To
				if(link.Find("?", 7) != -1) // mailto:hoge@hoge.com?subject=PGP%20Key&Body=Please%20send%20keyƂ
					// subject, body is not implemented.
					app->m_me.SetTo(link.Mid(7, link.Find("?", 7)-7));
				else
					app->m_me.SetTo(link.Mid(7));

				// setting From
				CString path = app->m_app_path+"\\"+current_account+"\\account.ini";
				CString address;
				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				address.ReleaseBuffer();
				app->m_me.SetFrom(address);

				// setting "cc" field
				CString cc;
				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				cc.ReleaseBuffer();
				app->m_me.SetCc(cc);

				// setting "bcc" field
				CString bcc;
				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				bcc.ReleaseBuffer();
				app->m_me.SetBcc(bcc);

				// setting "reply-to" field
				CString reply_to;
				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				reply_to.ReleaseBuffer();
				app->m_me.SetReplyTo(reply_to);

				// getting signature.
				CString signature;
				g_file2cstring(app->m_app_path+"\\"+current_account+"\\signature", signature);
				// set main text.
				app->m_me.AddText(signature);
				// draftframe
				app->CreateDraftFrame(mf->m_pAcntV->GetCurrentAccountName());
			}else{
				ShellExecute(this->GetSafeHwnd(), _T( "open" ), link, NULL, NULL, SW_NORMAL);
			}
// end
		}
	}
}

void CTextView::DisplayPart(int part)
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CStringArray body;
	CString message;
	CString header;
	CString tmp;
	CTemplate tmpl;

	m_current_part = part;
	m_md.GetBody(part, body);
	g_cstra2cstr(body, message, g_cstra_getsize(body));

	if(m_md.GetFileName(part).IsEmpty()){
		// in case of base64 in text/plain or text/html.
		if(m_md.GetEncodingType(part) == BASE64){
			message.Remove('\r');
			message.Remove('\n');
			char* in_base64 = message.GetBuffer(0);
			char* out_base64 = new char[message.GetLength()];
			int len = from64tobits(out_base64, in_base64, strlen(in_base64));
			out_base64[len] = 0;
			message.Empty();
			message = out_base64;
			delete out_base64;
		}
		// in case of quoted-printable in text/plain or text/html
		if(m_md.GetEncodingType(part) == QUOTED_PRINTABLE){
			// fromQPtobits̎₵
			// implementation of fromQPtobits is weird.
			char* in_qp = message.GetBuffer(0);
			char* out_qp = new char[message.GetLength()+10]; // łbuffer̗eʂȂ݂ŎXꂪłSȂɂȂ邱ƂBBB 
			// +10fromQPtobits̍Ōő}NULL 
			// +10 mean fromQPtobits insert NULL last.
			// CString  GetBuffer NULL͊܂܂Ȃ̂HHHH 
			// not clear that CString::GetBuffer not include NULL ?????
			int len = fromQPtobits(out_qp, in_qp, strlen(in_qp));
			out_qp[len] = 0;
			message.Empty();
			message = out_qp;
			delete out_qp;
		}
		CCodeConvert cc(message);
		message = cc.ToSjis();
	}else{ // in case of attachment file.
		if(GetCurrentCTE() == SEVEN_BIT){
			CCodeConvert cc(message);
			message = cc.ToSjis();
		}
		else if(GetCurrentCTE() == EIGHT_BIT){
			CCodeConvert cc(message);
			message = cc.ToSjis();
		}else{
			message.Format("Ytt@C\r\n%s", m_md.GetFileName(part));
		}
	}
	m_body = message;

	// prepare for header info displayed on textview of headerview.
	header = tmpl.GetString(&m_md, this->m_header_template);
	header.TrimRight();
	m_header = header;

	if(!app->GetProfileInt("Customize", "HeaderView", 1)){
		message = header+"\r\n\r\n"+message;
	}
	m_text = message;

	this->SetWindowText("");
	this->SetWindowText(message);
	if(app->GetProfileInt("Customize", "HeaderView", 1)){
		header.TrimRight();
		mf->m_pHeadV->SetHeaderText(header);
	}

/*	CHARFORMAT cf;
	GetRichEditCtrl().SetSel(0, header.GetLength());
	GetRichEditCtrl().GetSelectionCharFormat(cf);
	cf.dwMask = CFM_COLOR|CFM_BACKCOLOR;
	cf.crTextColor = RGB(
		app->GetProfileInt("TextViewHdColor", "TxtColorR", DEF_HEADER_INFO_COLOR_R),
		app->GetProfileInt("TextViewHdColor", "TxtColorG", DEF_HEADER_INFO_COLOR_G),
		app->GetProfileInt("TextViewHdColor", "TxtColorB", DEF_HEADER_INFO_COLOR_B));
	
	GetRichEditCtrl().SetSelectionCharFormat(cf);
	GetRichEditCtrl().HideSelection(TRUE, FALSE);
	GetRichEditCtrl().SetSel(0, 0);*/
	this->SetFontColorAndLink();
}

void CTextView::Update(CString path)
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CListCtrl &lc = mf->m_pMultiV->GetListCtrl();

	m_path = path;

	// after getting 0st element of MULTIPARTSTRUCT in mimedecode class, and display.
	if(path.IsEmpty()){ // if empty, not display. 
		this->Clear();
	}else{
		if(!m_md.DoIt(path)){ // analyze mime structure of mail.
			this->Clear();
			return;
		}
		DisplayPart(0); // anyway, 0st element of MULTIPARTSTRUCT is on display.

		// pgp/mime or not
		if(IsPgpMime()&&app->m_gpg_enable)
			mf->m_button_gpg_dec = TRUE;
		// in case of being not compatible to pgp/mime 
		else if((-1 != GetCurrentBody().Find("-----BEGIN PGP MESSAGE-----"))&&app->m_gpg_enable)
			mf->m_button_gpg_dec = TRUE;
		else
			mf->m_button_gpg_dec = FALSE;

		// setting multipartview
		lc.DeleteAllItems();
		int n;
		if(1 < m_md.HowManyPart()){ // in case of two or more than tree multipart.
			n = 0;
			CString enc_type;
			while(n < m_md.HowManyPart()){
				lc.InsertItem(n, m_md.GetContentType(n));
				switch(m_md.GetEncodingType(n)){
				case BASE64:
					enc_type = "base64";
					break;
				case QUOTED_PRINTABLE:
					enc_type = "quoted-printable";
					break;
				case SEVEN_BIT:
					enc_type = "7bit";
					break;
				}
				lc.SetItemText(n, 1, enc_type);
				if(!m_md.GetFileName(n).IsEmpty()){
					lc.SetItemText(n, 2, m_md.GetFileName(n));
				}
				n++;
			}
			mf->HideMultiPartView(FALSE);
			// setting 0th item selected.
			lc.SetItemState(0, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
		}
		else if(!m_md.GetFileName(0).IsEmpty()){ // in case of only one attachment file.
			lc.InsertItem(0, m_md.GetFileName(0));

			mf->HideMultiPartView(FALSE);
			// setting item of 0 selected.
			lc.SetItemState(0, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
		}
		else{ // in case of not multipart, nor number of multipart is one, text/html
			mf->HideMultiPartView(TRUE);
		}
		mf->m_pMultiV->ReArrange();
		mf->ReArrangeSplit();
	}
}

void CTextView::Update2(CString mail)
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CListCtrl &lc = mf->m_pMultiV->GetListCtrl();

	// ȉmimedecodeMULTIPARTSTRUCT0Ԗڂ̗vf擾ĕ\
	if(mail.IsEmpty()){ // ̏ꍇ͉\Ȃ
		this->Clear();
	}else{
		if(!m_md.DoIt2(mail)){ // [mime\𕪐͂
			// [Ăꍇ͂̂܂ܕ\B
			this->Clear();
			return;
		}
		DisplayPart(0); // 肠AMULTIPARTSTRUCT0Ԗڂ̗vf\

		// pgp/mimeǂ
		if(IsPgpMime()&&app->m_gpg_enable)
			mf->m_button_gpg_dec = TRUE;
		// pgp/mimeΉpgp[
		else if(-1 != GetCurrentBody().Find("-----BEGIN PGP MESSAGE-----")&&app->m_gpg_enable)
			mf->m_button_gpg_dec = TRUE;
		else
			mf->m_button_gpg_dec = FALSE;

		// multipartview ̐ݒ
		lc.DeleteAllItems();
		int n;
		if(1 < m_md.HowManyPart()){ // multipart2ȏ̏ꍇ
			n = 0;
			CString enc_type;
			while(n < m_md.HowManyPart()){
					lc.InsertItem(n, m_md.GetContentType(n));
					switch(m_md.GetEncodingType(n)){
					case BASE64:
						enc_type = "base64";
						break;
					case QUOTED_PRINTABLE:
						enc_type = "quoted-printable";
						break;
					case SEVEN_BIT:
						enc_type = "7bit";
						break;
					}
					lc.SetItemText(n, 1, enc_type);
					lc.SetItemText(n, 2, m_md.GetFileName(n));
				n++;
			}
			mf->HideMultiPartView(FALSE);
			// 0Ԗڂ̃ACeIԂɂ
			lc.SetItemState(0, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);

		}
		else if(!m_md.GetFileName(0).IsEmpty()){ // Ytt@C1̏ꍇ
			lc.InsertItem(0, m_md.GetFileName(0));
			mf->HideMultiPartView(FALSE);
			// 0Ԗڂ̃ACeIԂɂ
			lc.SetItemState(0, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
		}
		else{ // multipartłȂAmultipart̐1Atext/html݂̂̏ꍇ
			mf->HideMultiPartView(TRUE);
		}
		mf->m_pMultiV->ReArrange();
		mf->ReArrangeSplit();
	}
}

void CTextView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	POINT pt;

	PostMessage(WM_NULL, 0, 0); // this is point
	GetCursorPos(&pt);
	CMenu menu;

	menu.LoadMenu(IDR_TEXTVIEW_POPUP);

	// 񂪑IĂ邩ǂmF
	CRichEditCtrl &r = GetRichEditCtrl();
	if(r.GetSelText().IsEmpty())
		menu.EnableMenuItem(ID_TEXTVIEW_COPY, MF_GRAYED /*  */);
	else
		menu.EnableMenuItem(ID_TEXTVIEW_COPY, MF_ENABLED /* L */);

	// htmltextbinaryf

	CMenu *pPopup = menu.GetSubMenu(0);
	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, (int)pt.x, (int)pt.y, this);
	CRichEditView::OnRButtonDown(nFlags, point);
}

void CTextView::OnPopupCopy() 
{
	// IĂ镶Nbv{[hɃRs[
	CRichEditCtrl &r = GetRichEditCtrl();
	r.Copy();
}

void CTextView::OnPopupSelall() 
{
	// select all
	CRichEditCtrl &r = GetRichEditCtrl();
	r.SetSel(0, -1);
}

void CTextView::OnPopupBrowser() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CStringArray body;

	if(this->m_current_part == -1) return;

	this->m_md.GetBody(this->m_current_part, body);

	CString buf;
	g_cstra2cstr(body, buf, g_cstra_getsize(body));

	if(this->m_md.GetEncodingType(this->m_current_part) == BASE64){
		buf.Remove('\r');
		buf.Remove('\n');
		char* in_base64 = buf.GetBuffer(0);
		char* out_base64 = new char[buf.GetLength()];
		int len = from64tobits(out_base64, in_base64, strlen(in_base64));
		out_base64[len] = 0;
		buf.Empty();
		buf = out_base64;
		delete out_base64;
	}
	// in case of quoted-printable in text/plain or text/html
	else if(this->m_md.GetEncodingType(this->m_current_part) == QUOTED_PRINTABLE){
		// fromQPtobits̎₵
		// implementation of fromQPtobits is weird.
		char* in_qp = buf.GetBuffer(0);
		char* out_qp = new char[buf.GetLength()+10]; // łbuffer̗eʂȂ݂ŎXꂪłSȂɂȂ邱ƂBBB 
		// +10fromQPtobits̍Ōő}NULL 
		// +10 mean fromQPtobits insert NULL last.
		// CString  GetBuffer NULL͊܂܂Ȃ̂HHHH 
		// not clear that CString::GetBuffer not include NULL ?????
		int len = fromQPtobits(out_qp, in_qp, strlen(in_qp));
		out_qp[len] = 0;
		buf.Empty();
		buf = out_qp;
		delete out_qp;
	}

	CString msg_id;
	// use Message-ID for file name
	msg_id = m_md.m_hi.GetMsgID();
	msg_id = g_ma(msg_id);
	msg_id.Replace(".", "_");

	if(!g_is_there(app->m_app_path+"\\temp")) // if temp directory not exist, create
		_mkdir(app->m_app_path+"\\temp");

	g_cstring2file(buf, app->m_app_path+"\\temp\\"+msg_id+".html");
	ShellExecute(NULL, "open", app->m_app_path+"\\temp\\"+msg_id+".html", NULL, NULL, SW_SHOW);
}

void CTextView::OnPopupEditor() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString body = GetCurrentHeader()+"\r\n"+GetCurrentBody();
	CString msg_id;

	// user Message-ID for file name
	msg_id = m_md.m_hi.GetMsgID();
	msg_id = g_ma(msg_id);
	msg_id.Replace(".", "_");

	if(!g_is_there(app->m_app_path+"\\temp")) // if temp directory not exist, create
		_mkdir(app->m_app_path+"\\temp");

	FILE* file = fopen(app->m_app_path+"\\temp\\"+msg_id+".txt", "wb");
	fwrite(body.GetBuffer(0), sizeof(char), body.GetLength(), file);
	fclose(file);

	CString file_path = app->m_app_path+"\\temp\\"+msg_id+".txt";
	CString editor_path = app->GetProfileString("Editor", "Path", "notepad");
	if(editor_path.IsEmpty())
		editor_path = "notepad";
	file_path = "\""+file_path+"\"";
	// t@Cpathsetting.iniŎw肳ꂽeditorŊJ
	ShellExecute(NULL, NULL, editor_path, file_path, NULL, SW_SHOWNORMAL);
}

void CTextView::OnSetFocus(CWnd* pOldWnd) 
{
	CRichEditView::OnSetFocus(pOldWnd);
}

void CTextView::SetFontEx(LOGFONT &lf)
{
	m_font.DeleteObject();
	if(m_font.CreateFontIndirect(&lf))
		GetRichEditCtrl().SetFont(&m_font);
	this->SetFontColorAndLink();
}

void CTextView::SetFontColorAndLink()
{
	CRichEditCtrl &r = GetRichEditCtrl();
	CPochyApp* app = (CPochyApp*)AfxGetApp();

	// enable clickable url
	long lENM = r.GetEventMask();
	lENM |= ENM_LINK;
	r.SetEventMask(lENM);
	::SendMessage(m_hWnd, EM_AUTOURLDETECT, TRUE, 0);

	// set attribute of charactor
	CHARFORMAT2 cf;
	r.GetDefaultCharFormat(cf);
	cf.dwMask = CFM_COLOR | CFM_PROTECTED | CFM_FACE | CFM_SIZE | CFM_CHARSET | CFM_SUBSCRIPT;
	cf.crTextColor = RGB(
		app->GetProfileInt("TextViewColor", "TxtColorR", DEF_TXT_COLOR_R),
		app->GetProfileInt("TextViewColor", "TxtColorG", DEF_TXT_COLOR_G),
		app->GetProfileInt("TextViewColor", "TxtColorB", DEF_TXT_COLOR_B));
	cf.dwEffects = CFE_PROTECTED | CFE_SUBSCRIPT;
//	cf.bCharSet = CHINESEBIG5_CHARSET;
//	strcpy(cf.szFaceName, "MingLiU");//cf.szFaceName
//	r.SendMessage(EM_SETCHARFORMAT,(WPARAM)SCF_ALL,(LPARAM)&cf);
	r.SetSel(0, -1);
	r.SetSelectionCharFormat(cf);
	r.HideSelection(TRUE, FALSE);
	r.SetSel(0, 0);

	// if header view is not active, set header charactor color.
	if(!app->GetProfileInt("Customize", "HeaderView", 1)){
// modified by hiranaka, added to Pochy0.1.9, 2003/11/23
// start
//		CString mail;
//		r.GetWindowText(mail);
//		r.SetSel(0, mail.Find("\r\n\r\n")+2);
		FINDTEXTEX ft;
		ft.chrg.cpMin = 0;
		ft.chrg.cpMax = -1;
		ft.lpstrText = _T("\r\r");
		long pos = r.FindText(FR_DOWN, &ft);
		r.SetSel(0, pos);
// end
		r.GetSelectionCharFormat(cf);
		cf.dwMask = CFM_COLOR | CFM_BACKCOLOR;
		cf.crTextColor = RGB(
			app->GetProfileInt("TextViewHdColor", "TxtColorR", DEF_HEADER_INFO_COLOR_R),
			app->GetProfileInt("TextViewHdColor", "TxtColorG", DEF_HEADER_INFO_COLOR_G),
			app->GetProfileInt("TextViewHdColor", "TxtColorB", DEF_HEADER_INFO_COLOR_B));
		r.SetSelectionCharFormat(cf);
		r.HideSelection(TRUE, FALSE);
		r.SetSel(0, 0);
	}
}

void CTextView::ReDisplay()
{
	if(m_current_part != -1)
		DisplayPart(m_current_part);
}

CFont *CTextView::GetFontEx()
{
	return &m_font;
}

void CTextView::Clear()
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

	this->SetWindowText("");
	this->m_current_part = 0;
	this->m_body.Empty();
	this->m_current_part = -1;
	this->m_display_header.Empty();
	this->m_header.Empty();
	this->m_mail.Empty();
	this->m_multipart_header.Empty();
	this->m_path.Empty();

	mf->HideMultiPartView(TRUE);
}

BOOL CTextView::PreCreateWindow(CREATESTRUCT& cs) 
{

	return CBitmapRichEditView::PreCreateWindow(cs);
}
