/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// HeaderInfo.cpp: CHeaderInfo NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pochy.h"
#include "HeaderInfo.h"
#include "Fetchmail.h"
#include "quoted-printable.h"
#include "CodeConvert.h"
#include "base64.h"
#include "_regex.h"
#include "lib.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CHeaderInfo::CHeaderInfo(CString buf)
{
	int point;

	// initialyze
	InitMemVal();

	// if whole mail is handed over, only header part is picked up.
	switch(point = buf.Find("\r\n\r\n")){
		case -1:
			g_string2cstringarray(buf, m_undecoded_header, "\r\n", TRUE);
			break;
		default:
			buf = buf.Left(point + strlen("\r\n"));
			g_string2cstringarray(buf, m_undecoded_header, "\r\n", TRUE);
			break;
	}
	Decode();	// wb_𐮂蕶R[hϊs
	Analyze();	// wb_𕪐͂āAKvȏoɊi[
}

CHeaderInfo::CHeaderInfo()
{

}

CHeaderInfo::~CHeaderInfo()
{

}

BOOL CHeaderInfo::DoIt(CStringArray &buf)
{
	// initialyze
	InitMemVal();

	int n;
	int max;
	CString message;

	// if whole mail is handed over, only header part is picked up.
	max = buf.GetSize();
	for(n=0; n<max; n++){
		if(buf.GetAt(n) == "\x0D\x0A")
			break;
		m_undecoded_header.Add(buf.GetAt(n));
	}
	Decode();	// wb_𐮂蕶R[hϊs
	Analyze();	// wb_𕪐͂āAKvȏoɊi[

	if(n == 0)
		return FALSE;

	return TRUE;
}

// wb_𕪐͂ĕKvȏoϐɊi[
void CHeaderInfo::Analyze()
{
	CString header_name;
	int pos;
	int max = m_decoded_header.GetSize();
	for(int i = 0; i < max; i++){
		pos = m_decoded_header[i].Find(":");
		if(pos == -1)
			continue;
		header_name = m_decoded_header[i].Left(pos);
		header_name.MakeLower();

		if(strcmp("subject", header_name) == 0){
			m_subject = m_decoded_header[i].Mid(strlen("Subject:"));
			g_cstring_chop(m_subject);
			continue;
		}else if(strcmp("cc", header_name) == 0){
			m_cc = m_decoded_header[i].Mid(strlen("cc:"));
			g_cstring_chop(m_cc);
			continue;
		}else if(strcmp("bcc", header_name) == 0){
			m_bcc = m_decoded_header[i].Mid(strlen("bcc:"));
			g_cstring_chop(m_bcc);
			continue;
		}else if(strcmp("from", header_name) == 0){
			m_from = m_decoded_header[i].Mid(strlen("from:"));
			g_cstring_chop(m_from);
			continue;
		}else if(strcmp("to", header_name) == 0){
			m_to = m_decoded_header[i].Mid(strlen("to:"));
			g_cstring_chop(m_to);
			continue;
		}else if(strcmp("x-mailer", header_name) == 0){
			m_xmailer = m_decoded_header[i].Mid(strlen("x-mailer:"));
			g_cstring_chop(m_xmailer);
			continue;
		}else if(strcmp("reply-to", header_name) == 0){
			m_replyto = m_decoded_header[i].Mid(strlen("reply-to:"));
			g_cstring_chop(m_replyto);
			continue;
		}else if(strcmp("date", header_name) == 0){
			m_date = m_decoded_header[i].Mid(strlen("Date:"));
			g_cstring_chop(m_date);
			continue;
		}else if(strcmp("content-transfer-encoding", header_name) == 0){
			CString cte;
			m_cte = m_decoded_header[i];
			g_cstring_chop(m_cte);
			cte = m_decoded_header[i].Mid(strlen("Content-Transfer-Encoding:"));
			cte.MakeLower();
			g_cstring_chop(cte);
			if(strcmp("7bit", cte) == 0)
				m_enc = SEVEN_BIT;
			else if(strcmp("8bit", cte) == 0)
				m_enc = EIGHT_BIT;
			else if(strcmp("bin", cte) == 0)
				m_enc = BIN;
			else if(strcmp("base64", cte) == 0)
				m_enc = BASE64;
			else if(strcmp("x-gzip64", cte) == 0) // x-gzip64 is temporarily treat as base64 (zlib.dll is necessary)
				m_enc = BASE64;
			else if(strcmp("quoted-printable", cte) == 0)
				m_enc = QUOTED_PRINTABLE;
			continue;
		}else if(strcmp("message-id", header_name) == 0){
			m_msg_id = m_decoded_header[i].Mid(strlen("Message-ID:"));
			g_cstring_chop(m_msg_id);
			continue;
		}else if(strcmp("in-reply-to", header_name) == 0){
			m_in_reply_to = m_decoded_header[i].Mid(strlen("In-Reply-To:"));
			g_cstring_chop(m_in_reply_to);
			continue;
		}else if(strcmp("content-type", header_name) == 0){
			m_ct = m_decoded_header[i];
			g_cstring_chop(m_ct);
			AnalyzeCT();
			continue;
		}else if(strcmp("content-disposition", header_name) == 0){
			m_cd = m_decoded_header[i];
			g_cstring_chop(m_cd);
			AnalyzeCD();
			continue;
		}else if(strcmp("x-popfile-link", header_name) == 0){
			m_popfile_link = m_decoded_header[i].Mid(strlen("X-POPFile-Link:"));
			g_cstring_chop(m_popfile_link);
			continue;
		}
	}
	/* there is no Content-Type, below is applied
	Content-Type: text/plain; charset=US-ASCII
	Content-Transfer-Encoding: 7bit 
	*/
	if(m_type.IsEmpty())
		m_type = "text/plain";
	if(m_charset.IsEmpty())
		m_charset = "US-ASCII ";
	// m_cte is already set as 0(7bit) in InitMemVal()
}

CString CHeaderInfo::GetAllDecoded()
{
	CString buf;

	g_cstringarray2cstring(m_decoded_header, buf);
	return buf;
}

CString CHeaderInfo::GetAllUnDecoded()
{
	CString buf;

	g_cstringarray2cstring(m_undecoded_header, buf);
	return buf;
}

void CHeaderInfo::GetAllUnDecoded(CStringArray &header)
{
	header.Copy(m_undecoded_header);
}

// om_decoded_headerkeysɎso֐
CString CHeaderInfo::GetOneLine(LPCTSTR key)
{
	CString buf;
	int n;
	int max;

	// prepare for regex
	regex_t reg;
	regmatch_t pmatch[1];

	int len = sizeof(char)*10+strlen(key);
	char *r = new char[len];
	wsprintf(r, "^%s.*$", key);

	regcomp(&reg, r, REG_EXTENDED | REG_NEWLINE | REG_ICASE);

	max = m_decoded_header.GetSize();
	for(n=0; n<max; n++){
		buf = m_decoded_header.GetAt(n);
		if(0 == regexec(&reg, buf, 1, pmatch, 0)){
			delete[] r;
			regfree(&reg);
			return buf;
		}
	}

	regfree(&reg);
	delete[] r;
	buf.Empty();
	return buf; // if nothing is matched, return empty
}

// [wb_folding whilte space폜֐
void CHeaderInfo::RemoveFoldingWhiteSpace(CStringArray *header)
{

	CString cline;
	CString pline;
	int n;

	cline.Empty();
	pline.Empty();

	for(n=0; n<header->GetSize(); n++){
		if(header->GetAt(n).Find(" ") == 0){
			while(1){
				if(n == header->GetSize() || header->GetAt(n).Find(" ") != 0) break;						
				cline = header->GetAt(n);
				while(cline.Find(" ") == 0) cline.Delete(0, 1);

				pline = header->GetAt(n-1);
				pline.TrimRight("\r\n");
				pline += cline;
				header->SetAt(n-1, pline);
				header->RemoveAt(n, 1);
				pline.ReleaseBuffer();
			}
		}
	}

	for(n=0; n<header->GetSize(); n++){
		if(header->GetAt(n).Find("\t") == 0){
			while(1){
				if(n == header->GetSize() || header->GetAt(n).Find("\t") != 0) break;						
				cline = header->GetAt(n);
				while(cline.Find("\t") == 0) cline.Delete(0, 1);

				pline = header->GetAt(n-1);
				pline.TrimRight("\r\n");
				pline += cline;
				header->SetAt(n-1, pline);
				header->RemoveAt(n, 1);
				pline.ReleaseBuffer();
			}
		}
	}

}

// [wb_base64Aquoted-printablefR[hAfolding white space菜AR[h̕ϊs
void CHeaderInfo::Decode()
{
	regex_t reg; // for regex
	regmatch_t pmatch[5]; // result of regexec is put into this
	char *regex = "=\\?([^\\?]+)\\?([BQbq])\\?([^\\?]*)\\?="; // for "=?ISO-2022-JP?B?hogehogehoge?="
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE);

	CString temp1;
	CString temp2;
	CString buf;
	CString encode_type;	// B(base64) / Q(quoted-printable)
	CString char_type;		// ISO-2022-JP and so on
	CString char_encoded;	// part of encode
	int n;
	int max;
	CStringArray header;

	// initialyze and copy
	header.RemoveAll();
	header.Copy(m_undecoded_header);

	// folding white space 
	RemoveFoldingWhiteSpace(&header);

	// linear white space
	RemoveLinearWhiteSpace(&header);

	max = header.GetSize();
	for(n=0; n<max; n++){
		buf = header.GetAt(n);
		temp1.Empty();
		temp2.Empty();

		// K\base64Aquoted-printableencodeꂽ|ĂāAdecode
		while(1){
			if(buf.Find("?")==-1)
				break;

			if(0 != regexec(&reg, buf, 4, pmatch, 0))
				break;

			temp1.Empty();
			temp2.Empty();
			temp1			+=	buf.Left(pmatch[0].rm_so);
			encode_type		=	buf.Mid(pmatch[2].rm_so, pmatch[2].rm_eo-pmatch[2].rm_so);
			char_type		=	buf.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
			char_encoded	=	buf.Mid(pmatch[3].rm_so, pmatch[3].rm_eo-pmatch[3].rm_so);

			if(encode_type == "B" || encode_type == "b"){
				g_decode_base64(char_encoded, temp2);
				temp1 += temp2;
				temp2.Empty();
			}else if(encode_type == "Q" || encode_type == "q"){
				char_encoded.Replace("_", " ");
				g_decode_qp(char_encoded, temp2);
				temp1 += temp2;
				temp2.Empty();
			}
			temp1 += buf.Mid(pmatch[0].rm_eo);
			buf = temp1;
		}
		// convert char code
		CCodeConvert cc(buf);
		buf = cc.ToSjis();
		m_decoded_header.Add(buf);
	}
	regfree(&reg);

}

CString CHeaderInfo::GetSubject()
{
	return m_subject;
}

CString CHeaderInfo::GetTo()
{
	return m_to;
}

CString CHeaderInfo::GetCc()
{
	return m_cc;
}

CString CHeaderInfo::GetBcc()
{
	return m_bcc;
}
/*
CString CHeaderInfo::GetLocalDate()
{
	return m_local_date;
}*/

CString CHeaderInfo::GetDate()
{
	return m_date;
}

CString CHeaderInfo::GetFrom()
{
	return m_from;
}

CString CHeaderInfo::GetXmailer()
{
	return m_xmailer;
}
CString CHeaderInfo::GetReplyTo()
{
	return m_replyto;
}

CString CHeaderInfo::GetMsgID()
{
	return m_msg_id;
}

CString CHeaderInfo::GetInReplyTo()
{
	return m_in_reply_to;
}

CString CHeaderInfo::GetCTE()
{
	return m_cte;
}

int CHeaderInfo::GetEnc()
{
	return m_enc;
}

CString CHeaderInfo::GetCT()
{
	return m_ct;
}

CString CHeaderInfo::GetCD()
{
	return m_cd;
}

CString CHeaderInfo::GetBoundary()
{
	return m_boundary;
}

CString CHeaderInfo::GetCharset()
{
	return m_charset;
}

CString CHeaderInfo::GetFilename()
{
	return m_filename;
}

CString CHeaderInfo::GetName()
{
	return m_name;
}

CString CHeaderInfo::GetProtocol()
{
	return m_protocol;
}

CString CHeaderInfo::GetPopfileLink()
{
	return m_popfile_link;
}

BOOL CHeaderInfo::IsMultipart()
{
	if(!m_boundary.IsEmpty())
		return TRUE;
	return FALSE;
}

/*CString CHeaderInfo::ReformDate(CString buf)
{
	CString temp;
	CString day;
	CString month;
	CString year;
	CString hour;
	CString minute;
	CString second;
	CString zone;

	regex_t reg; // for regex
	regmatch_t pmatch[10]; // result of regexec is put into this

	char *regex = "Date:[ \t]*([a-zA-Z]+)*,* *([0-9]+) +([a-zA-Z]+) +([0-9]+) +([0-9]+):([0-9]+):*([0-9]*) +([+-0-9a-zA-Z]*)";
//		Date:     Mon, 3 Feb 2003 00:00:43 -0600
//		Date: Sat, 29 Mar 2003 05:01:48 +0900
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, buf, 9, pmatch, 0)){
		year = buf.Mid(pmatch[4].rm_so, pmatch[4].rm_eo-pmatch[4].rm_so);
		month = buf.Mid(pmatch[3].rm_so, pmatch[3].rm_eo-pmatch[3].rm_so);
		day = buf.Mid(pmatch[2].rm_so, pmatch[2].rm_eo-pmatch[2].rm_so);
		hour = buf.Mid(pmatch[5].rm_so, pmatch[5].rm_eo-pmatch[5].rm_so);
		minute = buf.Mid(pmatch[6].rm_so, pmatch[6].rm_eo-pmatch[6].rm_so);
		second = buf.Mid(pmatch[7].rm_so, pmatch[7].rm_eo-pmatch[7].rm_so);
		zone = buf.Mid(pmatch[8].rm_so, pmatch[8].rm_eo-pmatch[8].rm_so);
	}
	regfree(&reg);

	if(month.Find("Apr") != -1) month = "04";
	else if(month.Find("May") != -1) month = "05";
	else if(month.Find("Jun") != -1) month = "06";
	else if(month.Find("Jul") != -1) month = "07";
	else if(month.Find("Aug") != -1) month = "08";
	else if(month.Find("Sep") != -1) month = "09";
	else if(month.Find("Oct") != -1) month = "10";
	else if(month.Find("Nov") != -1) month = "11";
	else if(month.Find("Dec") != -1) month = "12";
	else if(month.Find("Jan") != -1) month = "01";
	else if(month.Find("Feb") != -1) month = "02";
	else if(month.Find("Mar") != -1) month = "03";
	else{
		buf.Empty();
		return buf;
	}

	CTime t(atoi(year), atoi(month), atoi(day), atoi(hour), atoi(minute), atoi(second));
	if(!zone.IsEmpty()){
		// adjust time zone
		CString dif_plus_minus;
		CString dif_hour;
		CString dif_minute;
		CString loc_plus_minus;
		CString loc_hour;
		CString loc_minute;
		CString loc_zone;
		// if not offset
		if(!zone.SpanExcluding("0123456789+-").IsEmpty()){
			zone = g_get_tzoffset_from_tzname(zone);
		}
		dif_plus_minus = zone[0];
		dif_hour = zone.Mid(1, 2);
		dif_minute = zone.Mid(3, 2);
		// change to GMT
		if(dif_plus_minus == "-"){
			t += CTimeSpan(0, atoi(dif_hour), atoi(dif_minute), 0);
		}else if(dif_plus_minus == "+"){
			t -= CTimeSpan(0, atoi(dif_hour), atoi(dif_minute), 0);
		}
		// change local time
		loc_zone = DEF_TIME_ZONE;
		loc_plus_minus = loc_zone[0];
		loc_hour = loc_zone.Mid(1, 2);
		loc_minute = loc_zone.Mid(3, 2);
		if(loc_plus_minus == "-"){
			t -= CTimeSpan(0, atoi(loc_hour), atoi(loc_minute), 0);
		}else if(loc_plus_minus == "+"){
			t += CTimeSpan(0, atoi(loc_hour), atoi(loc_minute), 0);
		}
	}

	return t.Format("%Y/%m/%d %H:%M:%S");
}*/

void CHeaderInfo::AnalyzeCT()
{
	regex_t reg; // for regex
	regmatch_t pmatch[2]; // result of regexec is put into this

	// type/subtype
	char *regex = "^content-type: *([^;\r\n]+).*$";
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, m_ct, 2, pmatch, 0)){
		m_type = m_ct.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
	}
	regfree(&reg);

	// boundary
	regex = "boundary= *\"*([^\";\r\n]+)\"*";
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, m_ct, 2, pmatch, 0)){
		m_boundary = m_ct.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
	}
	regfree(&reg);

	// charset
	regex = "charset= *\"*([^\";\r\n]+)\"*";
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, m_ct, 2, pmatch, 0)){
		m_charset = m_ct.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
	}
	regfree(&reg);

	// name
	regex = "name= *\"*([^\";\r\n]+)\"*";
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, m_ct, 2, pmatch, 0)){
		m_name = m_ct.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
	}
	regfree(&reg);

	// protocol pgp/mime
	regex = "protocol= *\"*([^\";\r\n]+)\"*";
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, m_ct, 2, pmatch, 0)){
		m_protocol = m_ct.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
	}
	regfree(&reg);
}

void CHeaderInfo::AnalyzeCD()
{
	regex_t reg; // for regex
	regmatch_t pmatch[2]; // result of regexec is put into this

	// filename
	char *regex	= "filename= *\"*([^;\"\r\n]+)\"*";
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, m_cd, 2, pmatch, 0)){
		m_filename = m_cd.Mid(pmatch[1].rm_so, pmatch[1].rm_eo-pmatch[1].rm_so);
	}
	regfree(&reg);
}

CString CHeaderInfo::GetCType()
{
	return m_type;
}

CString CHeaderInfo::GetCSubType()
{
	return m_subtype;
}

void CHeaderInfo::InitMemVal()
{
	m_subject.Empty();
	m_boundary.Empty();
	m_cc.Empty();
	m_bcc.Empty();
	m_cd.Empty();
	m_charset.Empty();
	m_ct.Empty();
	m_cte.Empty();
	m_filename.Empty();
	m_name.Empty();
//	m_local_date.Empty();
	m_date.Empty();
	m_from.Empty();
	m_to.Empty();
	m_xmailer.Empty();
	m_replyto.Empty();
	m_msg_id.Empty();
	m_in_reply_to.Empty();
	m_subtype.Empty();
	m_type.Empty();
	m_protocol.Empty();
	m_popfile_link.Empty();
	m_decoded_header.RemoveAll();
	m_undecoded_header.RemoveAll();
	m_enc = SEVEN_BIT; // 7bit
}

void CHeaderInfo::RemoveLinearWhiteSpace(CStringArray *header)
{
	CString buf1;
	CString buf2;
	regex_t reg; // for regex
	regmatch_t pmatch[3]; // result of regexec is put into this
	char *regex = "=\\?[^\\?]+\\?[BQbq]\\?[^\\?]*\\?=([ \t]+)=\\?[^\\?]+\\?[BQbq]\\?[^\\?]*\\?="; // regex for "=?ISO-2022-JP?B?hogehogehoge?= =?ISO-2022-JP?B?hogehogehoge?="
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE);

	for(int i=0; i<header->GetSize(); i++){
		buf1 = header->GetAt(i);
		if(buf1.Find("?")==-1){
				continue;
		}
		while(0 == regexec(&reg, buf1, 2, pmatch, 0)){
			buf2 +=	buf1.Left(pmatch[1].rm_so);
			buf1 = buf1.Mid(pmatch[1].rm_eo);
		}
		if(!buf1.IsEmpty()){
			buf2 += buf1;
		}
		header->SetAt(i, buf2);
		buf2.Empty();
	}
	regfree(&reg);
}

CString CHeaderInfo::GetHeaderFieldBody(CString field_name)
{
	CString buf = GetOneLine(field_name);
	buf = buf.Mid(buf.Find(":")+1);
	buf.TrimRight("\r\n");
	return buf;
}
