/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// GpgKeyListDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Pochy.h"
#include "GpgKeyListDlg.h"
#include "DraftFrame.h"
#include "Gpg.h"
#include "lib.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpgKeyListDlg _CAO

CGpgKeyListDlg::CGpgKeyListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGpgKeyListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpgKeyListDlg)
	//}}AFX_DATA_INIT
}

void CGpgKeyListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpgKeyListDlg)
	DDX_Control(pDX, IDC_LIST1, m_lc);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGpgKeyListDlg, CDialog)
	//{{AFX_MSG_MAP(CGpgKeyListDlg)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_LIST1, OnGetdispinfoList1)
	ON_BN_CLICKED(ID_GENKEY, OnGenkey)
	ON_BN_CLICKED(ID_DELKEY, OnDelkey)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpgKeyListDlg bZ[W nh

BOOL CGpgKeyListDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Xgr[փJݒ 
	int Num;
	int ColumnWidth[] = { 175, 50, 65, 185, 75, 75 };
	char* Column[] = { "̎", "", "Mx", "O", "", "L" };
	LV_COLUMN lvc;
	lvc.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH|LVCF_SUBITEM;
	lvc.fmt = LVCFMT_LEFT;
	for(Num = 0; Num < 6; Num++){
		lvc.pszText = Column[Num];
		lvc.cx = ColumnWidth[Num];
		m_lc.InsertColumn(Num, &lvc);
	}
	m_lc.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	ReDraw();
	return FALSE;
}

void CGpgKeyListDlg::OnGetdispinfoList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	int Num,maxNum;
	char *buf;

	Num = pDispInfo->item.iItem;
	maxNum = m_keylist.GetSize();

	if(pDispInfo->item.mask & LVIF_TEXT){
		switch(pDispInfo->item.iSubItem){
			case 1:// 
				buf = m_keylist[Num].m_str3.GetBuffer(0);
				break;
			case 2:// Mx
				buf = m_keylist[Num].m_str2.GetBuffer(0);
				break;
			case 3:// O
				buf = m_keylist[Num].m_str10.GetBuffer(0);
				break;
			case 4:// 
				buf = m_keylist[Num].m_str6.GetBuffer(0);
				break;
			case 5:// L
				buf = m_keylist[Num].m_str7.GetBuffer(0);
				break;
		}
		lstrcpy(pDispInfo->item.pszText, buf);
	}
	*pResult = 0;
}

void CGpgKeyListDlg::TranslateKeycode(SLISTSTACK& ls)
{
	if(ls.m_str4=="16"){
		if(ls.m_str1=="pub" || ls.m_str1=="sub")
		ls.m_str4="ELGamal(encrypt)";
		if(ls.m_str1=="sec" || ls.m_str1=="ssb")
		ls.m_str4="ELGamal(decrypt)";
	}
	if(ls.m_str4=="17"){
		if(ls.m_str1=="pub" || ls.m_str1=="sub")
		ls.m_str4="DSA(verify)";
		if(ls.m_str1=="sec" || ls.m_str1=="ssb")
		ls.m_str4="DSA(sign)";
	}
	if(ls.m_str4=="20"){
		if(ls.m_str1=="pub" || ls.m_str1=="sub")
			ls.m_str4="ELGamal(public)";
		if(ls.m_str1=="sec" || ls.m_str1=="ssb")
			ls.m_str4="ELGamal(secret)";
	}
	if(ls.m_str7.IsEmpty())
		ls.m_str7="-";
	if(ls.m_str2=="u")
		ls.m_str2="Ultimately";
	if(ls.m_str2=="q")
		ls.m_str2="Undefined";
	if(ls.m_str2=="f")
		ls.m_str2="Full";
	ls.m_str8 = "#"+ls.m_str8;
}

void CGpgKeyListDlg::TruncateSubKey()
{
	for(int i=0;i<m_keylist.GetSize();i++){
		if(m_keylist.GetAt(i).m_str1 == "sec" || m_keylist.GetAt(i).m_str1 == "ssb"){
			for(int j=0;j<m_keylist.GetSize();j++){
				if(m_keylist.GetAt(j).m_str5 == m_keylist.GetAt(i).m_str5 && (m_keylist.GetAt(j).m_str1 == "pub" || m_keylist.GetAt(j).m_str1 == "sub")){
					m_keylist[i].m_str8 = m_keylist.GetAt(j).m_str8;
				}
			}
		}
	}
	for(i=0;i<m_keylist.GetSize();i++){
		if(m_keylist.GetAt(i).m_str1 == "sub"){
			for(int j=0;j<m_keylist.GetSize();j++){
				if(m_keylist.GetAt(j).m_str8 == m_keylist.GetAt(i).m_str8 && m_keylist.GetAt(j).m_str1 == "pub"){
					m_keylist[j].m_str4 += "/"+m_keylist.GetAt(i).m_str4;
				}
			}
			m_keylist.RemoveAt(i);
			i--;
		}
	}
	for(i=0;i<m_keylist.GetSize();i++)
		TRACE("ID=%s\n",m_keylist.GetAt(i).m_str8);
	for(i=0;i<m_keylist.GetSize();i++){
		if(m_keylist.GetAt(i).m_str1 == "ssb"){
			for(int j=0;j<m_keylist.GetSize();j++){
				if(m_keylist.GetAt(j).m_str8 == m_keylist.GetAt(i).m_str8 && m_keylist.GetAt(j).m_str1 == "sec")
					m_keylist[j].m_str4 += "/"+m_keylist.GetAt(i).m_str4;
			}
			m_keylist.RemoveAt(i);
			i--;
		}
	}
}


void CGpgKeyListDlg::Str2Sliststack(CString& str,SLISTSTACK& ls)
{
	int i;
	CStringArray stra;
	CString* pstr;
	CString buf;
	g_string2cstringarray(str, stra,":", FALSE);
	for(i=0;i<stra.GetSize()-1;i++){
		pstr = &ls.m_str1 + i;
		buf = stra.GetAt(i);
//		buf.TrimRight(":");
		*pstr = buf;
	}
}

void CGpgKeyListDlg::OnOK() 
{
	SaveKeyIdList();
	CDialog::OnOK();
}

void CGpgKeyListDlg::OnGenkey() 
{
}

void CGpgKeyListDlg::OnDelkey() 
{
//	CPochyApp* app = (CPochyApp*)AfxGetApp();
	POSITION pos = m_lc.GetFirstSelectedItemPosition();
//	int si = m_lc.GetNextSelectedItem(pos);
	int si;
/*	while(si!=-1){
		CStringArray comline;
		CString out1;
		CString out2;
		comline.RemoveAll();
		if(m_keylist[si].m_str1 == "pub")
			comline.Add("gpg --command-fd 0 --delete-key " + m_keylist[si].m_str8);
		if(m_keylist[si].m_str1 == "sec")
			comline.Add("gpg --command-fd 0 --delete-secret-key " + m_keylist[si].m_str8);
		comline.Add("Y\r\n");
		g_connect_process(comline, out1, out2);
		if(out2.Find("failed")!=-1)
		si = m_lc.GetNextSelectedItem(pos);
	}*/
	CGpg gpg;
	CString message;
	while(pos){
		si = m_lc.GetNextSelectedItem(pos);
		message = m_keylist[si].m_str10+"\r\n\r\n폜ĂǂłH";
		if(IDYES != AfxMessageBox(message, MB_YESNO))
			continue;
		if(m_keylist[si].m_str1 == "pub")
//			gpg.DelPubKey(m_keylist[si].m_str8);
			gpg.DelPubKey(g_ma(m_keylist[si].m_str10));
//			AfxMessageBox("cannot delete pubric-key");
		if(m_keylist[si].m_str1 == "sec")
//			gpg.DelSecKey(m_keylist[si].m_str8);
			gpg.DelSecKey(g_ma(m_keylist[si].m_str10));
//			AfxMessageBox("cannot delete secret-key");
	}
	ReDraw();
}

void CGpgKeyListDlg::SaveKeyIdList()
{
	CDraftFrame *df = (CDraftFrame *)GetParentFrame();
	df->m_key_id_list.RemoveAll();
	POSITION pos = m_lc.GetFirstSelectedItemPosition();
	int si = m_lc.GetNextSelectedItem(pos);
	while(si!=-1){
		df->m_key_id_list.Add(g_ma(m_keylist[si].m_str10));
		si = m_lc.GetNextSelectedItem(pos);
	}
}

void CGpgKeyListDlg::ReDraw()
{
	// Xg擾
	CGpg gpg;
	CString pub;
	CString out2;
	CString body;
	body = gpg.GetPubKeyList();

	// Xgr[ɕ\
	int i;
	SLISTSTACK list;
	CStringArray bodya;
	g_string2cstringarray(body, bodya, "\r\n", FALSE);

	m_keylist.RemoveAll();
	for(i=0;i<bodya.GetSize();i++){
		CString tmps = bodya.GetAt(i);
		if(tmps.Find("pub")==0 || tmps.Find("sub")==0 || tmps.Find("sec")==0 || tmps.Find("ssb")==0){
			Str2Sliststack(tmps,list);
			TranslateKeycode(list);
			m_keylist.Add(list);
		}
	}
	TruncateSubKey();

	m_lc.DeleteAllItems();
	for(i=0;i<m_keylist.GetSize();i++)
		m_lc.InsertItem(m_lc.GetItemCount(),m_keylist.GetAt(i).m_str4);

	// Ԃ̐ݒ
	m_lc.SetFocus();
	m_lc.SetItemState(0,LVIS_SELECTED | LVIS_FOCUSED,-1);
}
