/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// MimeEncode.cpp: CMimeEncode NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pochy.h"
#include "MimeEncode.h"
#include "base64.h"
#include "CodeConvert.h"
#include "lib.h"
#include "process.h" // getpid()
#include "_regex.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CMimeEncode::CMimeEncode()
{
	this->Initialize();
}

CMimeEncode::~CMimeEncode()
{

}

void CMimeEncode::Initialize()
{
	m_data.m_multipart.RemoveAll();
	m_data.m_bcc.Empty();
	m_data.m_cc.Empty();
	m_data.m_from.Empty();
	m_data.m_in_reply_to.Empty();
	m_data.m_references.Empty();
	m_data.m_reply_to.Empty();
	m_data.m_message_id.Empty();
	m_data.m_subject.Empty();
	m_data.m_to.Empty();
	m_data.m_date.Empty();
	m_data.m_xmailer.Empty();
	m_mime_mode = ME_MODE_NONE;
}

int CMimeEncode::HowManyPart()
{
	return m_data.m_multipart.GetSize();
}

void CMimeEncode::CopyFrom(CMimeEncode *me)
{
	int i;
	Initialize();
	
	m_data.m_bcc = me->m_data.m_bcc;
	m_data.m_cc = me->m_data.m_cc;
	m_data.m_from = me->m_data.m_from;
	m_data.m_in_reply_to = me->m_data.m_in_reply_to;
	m_data.m_message_id = me->m_data.m_message_id;
	m_data.m_reply_to = me->m_data.m_reply_to;
	m_data.m_references = me->m_data.m_references;
	m_data.m_subject = me->m_data.m_subject;
	m_data.m_to = me->m_data.m_to;
	m_mime_mode = me->m_mime_mode;

	for(i=0; i<me->HowManyPart(); i++){
		m_data.m_multipart.Add(me->m_data.m_multipart[i]);
	}
}

CString CMimeEncode::GetBcc()
{
	return m_data.m_bcc;
}

CString CMimeEncode::GetCc()
{
	return m_data.m_cc;
}

CString CMimeEncode::GetFrom()
{
	return m_data.m_from;
}

CString CMimeEncode::GetInReplyTo()
{
	return m_data.m_in_reply_to;
}

CString CMimeEncode::GetReferences()
{
	return m_data.m_references;
}

CString CMimeEncode::GetSubject()
{
	return m_data.m_subject;
}

CString CMimeEncode::GetDate()
{
	return m_data.m_date;
}

CString CMimeEncode::GetMail(int for_what)
{
	CString header;
	CString mail;
	CString boundary;
	CString part_header;
	CString part_body;
	CCodeConvert cc;

	// wb_̍\
	// RFC 822 	To: Pooh Lovers:pooh@100acre.woodwest.uk,piglet@beech.tree.uk; not yet.
	if(for_what != ME_GET_PRE_ENC_PGP){
		header += "To: "+GetTo()+"\r\n";
		header += "From: "+GetFrom()+"\r\n";
		header += "Subject: "+GetSubject()+"\r\n";
		if(!GetCc().IsEmpty())
			header += "Cc: "+GetCc()+"\r\n";
		if(!GetInReplyTo().IsEmpty())
			header += "In-reply-to: "+GetInReplyTo()+"\r\n";
		if(!GetReferences().IsEmpty())
			header += "References: "+GetReferences()+"\r\n";
		if(!GetReplyTo().IsEmpty())
			header += "Reply-To: "+GetReplyTo()+"\r\n";
		if((for_what == ME_GET_DRAFT || for_what == ME_GET_OUTBOX) && !GetBcc().IsEmpty())
			header += "Bcc: "+GetBcc()+"\r\n";
		if(!GetMessageID().IsEmpty())
			header += "Message-ID: "+GetMessageID()+"\r\n";
		if(!m_data.m_date.IsEmpty())
			header += "Date: "+GetDate()+"\r\n";
		if(!m_data.m_xmailer.IsEmpty())
			header += "X-Mailer: "+m_data.m_xmailer+"\r\n";
		header += "MIME-Version: 1.0\r\n";
	}

	// bodyȂmultipart폜idraftɕۑꍇ͗Oj
	int i = 0;
	if(for_what != ME_GET_DRAFT){
		for(i=0; i<HowManyPart(); i++){
			if(m_data.m_multipart[i].m_body.IsEmpty()){
				m_data.m_multipart.RemoveAt(i);
				continue;
			}
		}
	}

	CString body;
	if(0==HowManyPart()){
		header += "Content-Type: text/plain\r\n";
		header += "Content-Transfer-Encoding: 7bit\r\n";
		cc.SetString(header);
		header = cc.ToJis();
		EncodeHeader(header);
		mail = header + "\r\n";
	}else if(1==HowManyPart()){
		if(!GetCT(0).IsEmpty()) header += GetCT(0)+"\r\n";
		if(!GetCTE(0).IsEmpty()) header += GetCTE(0)+"\r\n";
		if(!GetCD(0).IsEmpty()) header += GetCD(0)+"\r\n";
		cc.SetString(header);
		header = cc.ToJis();
		EncodeHeader(header);
		body = GetBody(0);
		cc.SetString(body);
		body = cc.ToJis();
		mail = header+"\r\n"+body;
	}else{
		boundary = this->GetBoundaryChar();
		for(i=0; i<this->HowManyPart(); i++){
			while(this->GetBody(i).Find(boundary) != -1){
				Sleep(10);
				boundary = this->GetBoundaryChar();
			}
		}
		if(m_mime_mode == ME_MODE_NONE){
			header += "Content-Type: multipart/mixed;\r\n\tboundary=\""+boundary+"\"\r\n";
			header += "Content-Transfer-Encoding: 7bit\r\n";
		}else if(m_mime_mode == ME_MODE_PGP){
			header += "Content-Type: multipart/encrypted; protocol=application/pgp-encrypted;\r\n\tboundary=\""+boundary+"\"\r\n";
			header += "Content-Transfer-Encoding: 7bit\r\n";
		}else if(m_mime_mode == ME_MODE_RFC822){}
		cc.SetString(header);
		header = cc.ToJis();
		EncodeHeader(header);
		for(i=0; i<this->HowManyPart(); i++){
			body += "--"+boundary+"\r\n";
			// part cannonical header
			if(!GetCT(i).IsEmpty()) part_header = GetCT(i)+"\r\n";
			if(!GetCTE(i).IsEmpty()) part_header += GetCTE(i)+"\r\n";
			if(!GetCD(i).IsEmpty()) part_header += GetCD(i)+"\r\n";
			cc.SetString(part_header);
			part_header = cc.SjisToJis();
			EncodeHeader(part_header);
			part_header.TrimRight("\r\n");
			part_header += "\r\n\r\n";
			body += part_header;
			// part body
			part_body = GetBody(i);
			cc.SetString(part_body);
			part_body = cc.SjisToJis();
			part_body.TrimRight("\r\n");
			part_body += "\r\n\r\n";
			body += part_body;
		}
		body += "--"+boundary+"--\r\n";
		mail = header+"\r\n"+body;
	}
	return mail;
}

CString CMimeEncode::GetMultipartBody(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_body;
}

CString CMimeEncode::GetMultipartEncType(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_encoding_type;
}

CString CMimeEncode::GetMultipartFileName(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_file_name;
}

CString CMimeEncode::GetMultipartPath(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_path;
}

CString CMimeEncode::GetMultipartType(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_type;
}

CString CMimeEncode::GetTo()
{
	return m_data.m_to;
}

CString CMimeEncode::GetMessageID()
{
	return m_data.m_message_id;
}

CString CMimeEncode::GetReplyTo()
{
	return m_data.m_reply_to;
}

void CMimeEncode::SetBcc(CString bcc)
{
	m_data.m_bcc = bcc;
}

void CMimeEncode::SetCc(CString cc)
{
	m_data.m_cc = cc;
}

void CMimeEncode::SetFrom(CString from)
{
	m_data.m_from = from;
}

void CMimeEncode::SetInReplyTo(CString in_reply_to)
{
	m_data.m_in_reply_to = in_reply_to;
}

void CMimeEncode::SetReferences(CString references)
{
	m_data.m_references = references;
}

void CMimeEncode::SetDate(CString date)
{
	m_data.m_date = date;
}

void CMimeEncode::AddMultipart(MULTIPART_STRUCT2 &multipart)
{
	m_data.m_multipart.Add(multipart);
}

void CMimeEncode::SetMultipart(int part, MULTIPART_STRUCT2 &multipart)
{
	m_data.m_multipart.SetAt(part, multipart);
}


void CMimeEncode::SetMultipartBody(int part, CString body)
{
	m_data.m_multipart[part].m_body = body;
}

void CMimeEncode::SetSubject(CString subject)
{
	m_data.m_subject = subject;
}

void CMimeEncode::SetTo(CString to)
{
	m_data.m_to = to;
}

void CMimeEncode::SetXMailer(CString xmailer)
{
	m_data.m_xmailer = xmailer;
}

void CMimeEncode::SetMessageID(CString message_id)
{
	m_data.m_message_id = message_id;
}

void CMimeEncode::SetReplyTo(CString reply_to)
{
	m_data.m_reply_to = reply_to;
}

void CMimeEncode::EncodeHeader(CString& org)
{
	int i;
	int max;

	CStringArray array_org;
	CStringArray array_dst;
	CStringArray array_tmp;
	CString buf;

	if(org.IsEmpty())
		return;

	// push each row into array.(not include "\r\n")
	// last element is empty, so need to remove
	g_string2cstringarray(org, array_org, "\r\n", FALSE);
	array_org.RemoveAt(array_org.GetSize()-1);

	max = array_org.GetSize();
	for(i=0; i<max; i++)
	{
		buf = array_org.GetAt(i);
		array_tmp.RemoveAll();
		
		if(
			buf.Find("To: ") == 0 ||
			buf.Find("Cc: ") == 0 ||
			buf.Find("Bcc: ") == 0 ||
			buf.Find("From: ") == 0)
		{
			this->EncodeAddress(buf, array_tmp);
		}
		else if(buf.Find("Content-Type: ") == 0 ||
			buf.Find("Content-Disposition: ") == 0)
		{
			this->EncodeParam(buf, array_tmp);
		}
		else
		{
			this->EncodeNoParam(buf, array_tmp);
		}
		array_dst.Append(array_tmp);
	}
	g_cstringarray2cstring(array_dst, org);

}

BOOL CMimeEncode::EncodeBase64FromFile(CString path, CString &buf)
{
	FILE *file;
	unsigned char in[READBUFSIZE*3];
	unsigned char out[READBUFSIZE*4+(2*READBUFSIZE/76)+1];
	CString msg;

	DWORD size = g_get_file_size(path);

	file = fopen(path, "rb");
	if(file == NULL){
		msg.Format("cannot open %s", path);
		AfxMessageBox(msg);
		return FALSE;
	}

	CString c;
	CString tmp;
	char *ptmp = tmp.GetBuffer(g_get_file_size(path)/5*7);

	int len = 0;
	while(1){
		if(size > READBUFSIZE*3){
			fread(in, sizeof(unsigned char), READBUFSIZE*3, file);
			to64frombits(out, in, READBUFSIZE*3);
			c = out;
			c += "\r\n";
			strcpy(ptmp, c);
			ptmp += c.GetLength();
			len += c.GetLength();
			size -= READBUFSIZE*3;
		}else{
			fread(in, sizeof(unsigned char), size, file);
			to64frombits(out, in, size);
			c = out;
			c += "\r\n";
			strcpy(ptmp, c);
			ptmp += c.GetLength();
			len += c.GetLength();
			break;
		}
	}
	tmp.ReleaseBuffer(len);
	buf = tmp;
	fclose(file);
	return TRUE;
}

BOOL CMimeEncode::AddAttachedFile(CString path)
{
/*	Content-Type: application/octet-stream; name=hogehoge
	Content-Transfer-Encoding: base64
	Content-Disposition: attachment; filename=hogehoge*/

	CString file_name = path.Mid(path.ReverseFind('\\')+1);
	CString extention = file_name.Mid(file_name.ReverseFind('.')+1);

	MULTIPART_STRUCT2 data;
	data.m_encoding_type = "base64";
	data.m_file_name = file_name;
	data.m_type = this->GetMediaType(extention);
	if(data.m_type.IsEmpty()){
		data.m_type = "application/octet-stream";
	}
	data.m_path = path;

	data.m_content_type.Format("Content-Type: %s; name=\"%s\"", 
		data.m_type, file_name);

	data.m_content_transfer_encoding = "Content-Transfer-Encoding: base64";

	data.m_content_disposition.Format("Content-Disposition: attachment; filename=\"%s\"",
		file_name);

	if(!this->EncodeBase64FromFile(path, data.m_body))
		return FALSE;

	m_data.m_multipart.Add(data);
	return TRUE;
}

void CMimeEncode::AddPgpKey(CString key)
{
	MULTIPART_STRUCT2 data;
	data.m_content_type = "Content-Type: application/pgp-keys";
	data.m_body = key;

	m_data.m_multipart.Add(data);
}

void CMimeEncode::AddPgpEncrypted(CString enc)
{
	SetMode(ME_MODE_PGP);

	m_data.m_multipart.RemoveAll();
	
	MULTIPART_STRUCT2 data;
	data.m_content_type = "Content-Type: application/pgp-encrypted";
	data.m_content_transfer_encoding = "Content-Transfer-Encoding: 7bit";
	data.m_body = "Version: 1\r\n";

	m_data.m_multipart.Add(data);

	data.m_content_type = "Content-Type: application/octet-stream";
	data.m_content_transfer_encoding = "Content-Transfer-Encoding: 7bit";
	data.m_body = enc;

	m_data.m_multipart.Add(data);
}

void CMimeEncode::AddText(CString body)
{
/*	Content-Type: text/plain; charset=iso-2022-jp
	Content-Transfer-Encoding: 7bit*/
	
	MULTIPART_STRUCT2 data;
	data.m_encoding_type = "7bit";
	data.m_type = "text/plain";
/*	if(g_is_all_ascii(body)){
		data.m_content_type = "Content-Type: text/plain";
	}else{*/
		data.m_content_type = "Content-Type: text/plain; charset=ISO-2022-JP";
/*	}*/
	data.m_content_transfer_encoding = "Content-Transfer-Encoding: 7bit";
	data.m_body = body;

	m_data.m_multipart.Add(data);
}

void CMimeEncode::RemoveMultipart(int part)
{
	ASSERT(part < HowManyPart());
	m_data.m_multipart.RemoveAt(part);
}

void CMimeEncode::AddRFC822(CString mail)
{

}

CString CMimeEncode::GetCT(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_content_type;
}

CString CMimeEncode::GetCD(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_content_disposition;
}

CString CMimeEncode::GetCTE(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_content_transfer_encoding;
}

CString CMimeEncode::GetBody(int part)
{
	ASSERT(part < HowManyPart());
	return m_data.m_multipart[part].m_body;
}

void CMimeEncode::SetMode(int mime_mode)
{
	m_mime_mode = mime_mode;
}

int CMimeEncode::GetMode()
{
	return m_mime_mode;
}

BOOL CMimeEncode::EncodeBase64(CString &out, CString in)
{
	return TRUE;
}

CString CMimeEncode::GetBoundaryChar()
{
	CString boundary;
	CString day_of_week;
	CString month;
//	enum {sun=1, man, tue, wed, thu, fri, sat};
//	enum {jan=1, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec};

	CTime t = CTime::GetCurrentTime();

	switch(t.GetDayOfWeek()){
	case 1:
		day_of_week = "Sun";
		break;
	case 2:
		day_of_week = "Man";
		break;
	case 3:
		day_of_week = "Tue";
		break;
	case 4:
		day_of_week = "Wed";
		break;
	case 5:
		day_of_week = "Thu";
		break;
	case 6:
		day_of_week = "Fri";
		break;
	case 7:
		day_of_week = "Sat";
		break;

	}

	switch(t.GetMonth()){
	case 1:
		month = "Jan";
		break;
	case 2:
		month = "Feb";
		break;
	case 3:
		month = "Mar";
		break;
	case 4:
		month = "Apr";
		break;
	case 5:
		month = "May";
		break;
	case 6:
		month = "Jun";
		break;
	case 7:
		month = "Jul";
		break;
	case 8:
		month = "Aug";
		break;
	case 9:
		month = "Sep";
		break;
	case 10:
		month = "Oct";
		break;
	case 11:
		month = "Nov";
		break;
	case 12:
		month = "Dec";
		break;
	}

	boundary.Format("--Next_Part(%s_%s_%02d_%02d:%02d:%02d_%d_%d)-",
		day_of_week,
		month,
		t.GetDay(),
		t.GetHour(),
		t.GetMinute(),
		t.GetSecond(),
		t.GetYear(),
		getpid());

	return boundary;

}

void CMimeEncode::AddTo(CString address)
{
	if(!m_data.m_to.IsEmpty() && !address.IsEmpty()){
		m_data.m_to += ","+address;
	}else if(!address.IsEmpty()){
		m_data.m_to = address;
	}
}

void CMimeEncode::AddCc(CString address)
{
	if(!m_data.m_cc.IsEmpty() && !address.IsEmpty()){
		m_data.m_cc += ","+address;
	}else if(!address.IsEmpty()){
		m_data.m_cc = address;
	}
}

void CMimeEncode::AddBcc(CString address)
{
	if(!m_data.m_bcc.IsEmpty() && !address.IsEmpty()){
		m_data.m_bcc += ","+address;
	}else if(!address.IsEmpty()){
		m_data.m_bcc = address;
	}
}

CString CMimeEncode::GetMediaType(CString extention)
{
	CMapStringToString map;

	map.SetAt("ez",		"application/andrew-inset");	//ez
	map.SetAt("xls",	"application/excel");			//xls
	map.SetAt("bin",	"application/octet-stream");	//bin
	map.SetAt("oda",	"application/oda");				//oda
	map.SetAt("pdf",	"application/pdf");				//pdf
	map.SetAt("pgp",	"application/pgp");				//pgp
	map.SetAt("ps",		"application/postscript");		//ps PS eps
	map.SetAt("eps",	"application/postscript");
	map.SetAt("rtf",	"application/rtf");				//rtf
	map.SetAt("arj",	"application/x-arj-compressed");//arj
	map.SetAt("bcpio",	"application/x-bcpio");			//bcpio
	map.SetAt("pgn",	"application/x-chess-pgn");		//pgn
	map.SetAt("cpio",	"application/x-cpio");			//cpio
	map.SetAt("csh",	"application/x-csh");			//csh
	map.SetAt("deb",	"application/x-debian-package");//deb
	map.SetAt("com",	"application/x-msdos-program");	//com exe bat
	map.SetAt("exe",	"application/x-msdos-program");
	map.SetAt("bat",	"application/x-msdos-program");
	map.SetAt("dvi",	"application/x-dvi");			//dvi
	map.SetAt("gtar",	"application/x-gtar");			//gtar
	map.SetAt("gz",		"application/x-gunzip");		//gz
	map.SetAt("hdf",	"application/x-hdf");			//hdf
	map.SetAt("latex",	"application/x-latex");			//latex
	map.SetAt("mif",	"application/x-mif");			//mif
	map.SetAt("cdf",	"application/x-netcdf");		//cdf nc
	map.SetAt("nc",		"application/x-netcdf");
	map.SetAt("pl",		"application/x-perl");			//pl pm
	map.SetAt("pm",		"application/x-perl");
	map.SetAt("rar",	"application/x-rar-compressed");//rar
	map.SetAt("sh",		"application/x-sh");			//sh
	map.SetAt("shar",	"application/x-shar");			//shar
	map.SetAt("sv4cpio","application/x-sv4cpio");		//sv4cpio
	map.SetAt("sv4src",	"application/x-sv4crc");		//sv4crc
	map.SetAt("tar",	"application/x-tar");			//tar
	map.SetAt("tgz",	"application/x-tar-gz");		//tgz tar.gz
	map.SetAt("tar.gz",	"application/x-tar-gz");
	map.SetAt("tcl",	"application/x-tcl");			//tcl
	map.SetAt("tex",	"application/x-tex");			//tex
	map.SetAt("texi",	"application/x-texinfo");		//texi texinfo
	map.SetAt("texinfo","application/x-texinfo");
	map.SetAt("t",		"application/x-troff");			//t tr roff
	map.SetAt("tr",		"application/x-troff");
	map.SetAt("roff",	"application/x-troff");
	map.SetAt("man",	"application/x-troff-man");		//man
	map.SetAt("me",		"application/x-troff-me");		//me
	map.SetAt("ms",		"application/x-troff-ms");		//ms
	map.SetAt("ustar",	"application/x-ustar");			//ustar
	map.SetAt("src",	"application/x-wais-source");	//src
	map.SetAt("zip",	"application/x-zip-compressed");//zip

	map.SetAt("snd",	"audio/basic");					//snd
	map.SetAt("mid",	"audio/midi");					//mid midi
	map.SetAt("midi",	"audio/midi");
	map.SetAt("au",		"audio/ulaw");					//au
	map.SetAt("aif",	"audio/x-aiff");				//aif aifc aiff
	map.SetAt("aifc",	"audio/x-aiff");
	map.SetAt("aiff",	"audio/x-aiff");
	map.SetAt("wav",	"audio/x-wav");					//wav

	map.SetAt("gif",	"image/gif");					//gif
	map.SetAt("ief",	"image/ief");					//ief
	map.SetAt("jpe",	"image/jpeg");					//jpe jpeg jpg
	map.SetAt("jpeg",	"image/jpeg");
	map.SetAt("jpg",	"image/jpeg");
	map.SetAt("png",	"image/png");					//png
	map.SetAt("tif",	"image/tiff");					//tif tiff
	map.SetAt("tiff",	"image/tiff");
	map.SetAt("ras",	"image/x-cmu-raster");			//ras
	map.SetAt("pnm",	"image/x-portable-anymap");		//pnm
	map.SetAt("pbm",	"image/x-portable-bitmap");		//pbm
	map.SetAt("pgm",	"image/x-portable-graymap");	//pgm
	map.SetAt("ppm",	"image/x-portable-pixmap");		//ppm
	map.SetAt("rgb",	"image/x-rgb");					//rgb
	map.SetAt("xbm",	"image/x-xbitmap");				//xbm
	map.SetAt("xpm",	"image/x-xpixmap");				//xpm
	map.SetAt("xwd",	"image/x-xwindowdump");			//xwd

	map.SetAt("html",	"text/html");					//html htm
	map.SetAt("htm",	"text/html");
	map.SetAt("asc",	"text/plain");					//asc txt
	map.SetAt("txt",	"text/plain");
	map.SetAt("rtx",	"text/richtext");				//rtx
	map.SetAt("tsv",	"text/tab-separated-values");	//tsv
	map.SetAt("etx",	"text/x-setext");				//etx

	map.SetAt("dl",		"video/dl");					//dl
	map.SetAt("fli",	"video/fli");					//fli
	map.SetAt("gl",		"video/gl");					//gl
	map.SetAt("mp2",	"video/mpeg");					//mp2 mpe mpeg mpg
	map.SetAt("mpe",	"video/mpeg");
	map.SetAt("mpeg",	"video/mpeg");
	map.SetAt("mpg",	"video/mpeg");
	map.SetAt("mov",	"video/quicktime");				//mov qt
	map.SetAt("qt",		"video/quicktime");
	map.SetAt("avi",	"video/x-msvideo");				//avi
	map.SetAt("movie",	"video/x-sgi-movie");			//movie

	map.SetAt("vrm",	"x-world/x-vrml");				//vrm vrml wrl
	map.SetAt("vrml",	"x-world/x-vrml");
	map.SetAt("wrl",	"x-world/x-vrml");

	extention.MakeLower();

	CString media_type;
	map.Lookup(extention, media_type);
	return media_type;
}

BOOL CMimeEncode::Count4Enc(CString buf, int max_len, int *ret_len)
{
	BOOL esc = FALSE;
	int n = 0;
	for(;;){
		if(n > buf.GetLength()){
			return -1;
		}
		if(buf[n] == 0x1b && !esc){
			esc = TRUE;
			n+=3;
			if(n > max_len){
				*ret_len = n-3;
				return FALSE;
			}
		}else if(buf[n] == 0x1b && esc){
			esc = FALSE;
			n+=3;
			if(n > max_len){
				*ret_len =  n-3;
				return TRUE;
			}
		}else if(esc){
			n+=2;
			if(n > max_len){
				*ret_len = n-2;
				return TRUE;
			}
		}else{
			n++;
			if(n > max_len){
				 *ret_len = n-1;
				 return FALSE;
			}
		}
	}
}

void CMimeEncode::EncodeNoParam(CString buf, CStringArray &array)
{
	CString name;
	CString tmp1;
	CString tmp2;
	CString tmp3;
	CString tmp4;
	int i;

	array.RemoveAll();
	buf.TrimRight("\r\n");

	// if buf include iso-2022 char, need to encode with base64
	if(g_is_iso2022(buf)){
		name = buf.Left(buf.Find(" ")+1);
		tmp1 = buf.Mid(name.GetLength());
		if(name.GetLength()+tmp1.GetLength()*4/3+18 > 76){
			if(Count4Enc(tmp1, 34, &i)){
				tmp2 = tmp1.Left(i) + "\x1b\x28\x42";
				tmp1 = "\x1b\x24\x42" + tmp1.Mid(i);
			}else{
				tmp2 = tmp1.Left(i);
				tmp1 = tmp1.Mid(i);
			}
			g_encode_base64(tmp2, tmp3);
			tmp4.Format("%s=?ISO-2022-JP?B?%s?=\r\n", name, tmp3);
			array.Add(tmp4);
			while(42 < tmp1.GetLength()){
				if(Count4Enc(tmp1, 40, &i)){
					tmp2 = tmp1.Left(i) + "\x1b\x28\x42";
					tmp1 = "\x1b\x24\x42" + tmp1.Mid(i);
				}else{
					tmp2 = tmp1.Left(i);
					tmp1 = tmp1.Mid(i);
				}
				g_encode_base64(tmp2, tmp3);
				tmp4.Format(" =?ISO-2022-JP?B?%s?=\r\n", tmp3);
				array.Add(tmp4);
			}
			g_encode_base64(tmp1, tmp3);
			tmp4.Format(" =?ISO-2022-JP?B?%s?=\r\n", tmp3);
			array.Add(tmp4);
		}else{
			g_encode_base64(tmp1, tmp3);
			tmp4.Format("%s=?ISO-2022-JP?B?%s?=\r\n", name, tmp3);
			array.Add(tmp4);
		}
	// if buf not include iso-2022 char, may be this mean buf include only ascii char.
	}else{
		if(buf.GetLength() > 74){
			tmp1 = buf.Left(75);
			buf = buf.Mid(75);
			array.Add(tmp1+"\r\n");
			while(buf.GetLength() > 73){
				tmp1 = buf.Left(74);
				buf = buf.Mid(74);
				array.Add(" "+tmp1+"\r\n");
			}
			array.Add(" "+buf+"\r\n");
		}else{
			array.Add(buf+"\r\n");
		}
	}
}

void CMimeEncode::EncodeAddress(CString buf, CStringArray &array)
{
	int i;
	int max;
	CString header_name;
	CString header_field;
	CString address_name;
	CString address;
	CString tmp1;
	CString tmp2;
	CString tmp3;
	CStringArray array_tmp1;
	CStringArray array_tmp2;
	CStringArray array_tmp3;

	array_tmp1.RemoveAll();
	array_tmp2.RemoveAll();
	array_tmp2.RemoveAll();

	header_name = buf.Left(buf.Find(" ")+1);
	header_field = buf.Mid(header_name.GetLength());
	g_split_address(header_field, array_tmp1, TRUE, FALSE);

	max = array_tmp1.GetSize();
	if(max > 1){
		for(i=0; i<max; i++){
			if(g_split_name_address(array_tmp1.GetAt(i), address_name, address)){
				array_tmp2.Add(address_name);
				array_tmp2.Add(address);
			}else{
				array_tmp2.Add(array_tmp1.GetAt(i));
			}
		}

		max = array_tmp2.GetSize();
		for(i=0; i<max; i++){
			if(g_is_iso2022(array_tmp2.GetAt(i))){
//				if(strlen(" ")+array_tmp2.GetLength()*4/3+18 > 76){
//					
//				}
				g_encode_base64(array_tmp2.GetAt(i), tmp2);
				tmp3.Format("=?ISO-2022-JP?B?%s?=", tmp2);
				array_tmp3.Add(tmp3);
			}else{
				array_tmp3.Add(array_tmp2.GetAt(i));
			}
		}

		array.Add(header_name+"\r\n");
		max = array_tmp3.GetSize();
		for(i=0; i<max; i++){
			tmp1.Format(" %s\r\n", array_tmp3.GetAt(i));
			array.Add(tmp1);
		}
	}else{
		if(g_split_name_address(header_field, address_name, address)){
			if(g_is_iso2022(address_name)){
				g_encode_base64(address_name, tmp1);
				tmp2.Format("=?ISO-2022-JP?B?%s?=", tmp1);
				array_tmp2.Add(tmp2);
			}else{
				array_tmp2.Add(address_name);
			}
			array_tmp2.Add(address);
		}else{
			array_tmp2.Add(header_field);
		}

		if(array_tmp2.GetSize() > 1){
			tmp1.Format("%s\r\n", header_name);
			array.Add(tmp1);
			max = array_tmp2.GetSize();
			for(i=0; i<max; i++){
				tmp1.Format(" %s\r\n", array_tmp2.GetAt(i));
				array.Add(tmp1);
			}
		}else{
			tmp1.Format("%s\r\n", buf);
			array.Add(tmp1);
		}
	}
}

void CMimeEncode::EncodeParam(CString buf, CStringArray &array)
{
	array.RemoveAll();
	buf.TrimRight("\r\n");

	CString filename;
	CString type;
	regex_t reg1;
	regex_t reg2;
	regmatch_t pmatch1[2];
	regmatch_t pmatch2[3];
	const char *regex1 = "^Content-Disposition: *attachment; *filename=\"*([^\"\r\n]+)\"*";
	const char *regex2 = "^Content-Type: ([^;]+); *name=\"*([^\"\r\n]+)\"*";
	CString tmp1, tmp2, tmp3;
	int len;

	// content-disposiotion
	regcomp(&reg1, regex1, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg1, buf, 2, pmatch1, 0)){
		filename = buf.Mid(pmatch1[1].rm_so, pmatch1[1].rm_eo-pmatch1[1].rm_so);
		if(g_is_iso2022(filename)){
			array.Add("Content-Disposition: attachment;\r\n");
			if(filename.GetLength() > 30){
				if(Count4Enc(filename, 31, &len)){
					tmp1 = filename.Left(len) + "\x1b\x28\x42";
					filename = "\x1b\x24\x42" + filename.Mid(len);
				}else{
					tmp1 = filename.Left(len);
					filename = filename.Mid(len);
				}
				g_encode_base64(tmp1, tmp2);
				tmp3.Format(" filename=\"=?ISO-2022-JP?B?%s?=\r\n", tmp2);
				array.Add(tmp3);
				while(filename.GetLength() > 38){
					if(Count4Enc(filename, 39, &len)){
						tmp1 = filename.Left(len) + "\x1b\x28\x42";
						filename = "\x1b\x24\x42" + filename.Mid(len);
					}else{
						tmp1 = filename.Left(len);
						filename = filename.Mid(len);
					}
					g_encode_base64(tmp1, tmp2);
					tmp3.Format(" =?ISO-2022-JP?B?%s?=\r\n", tmp2);
					array.Add(tmp3);
				}
				g_encode_base64(filename, tmp1);
				tmp2.Format(" =?ISO-2022-JP?B?%s?=\"\r\n", tmp1);
				array.Add(tmp2);
				goto last1;
			}else{
				g_encode_base64(filename, tmp1);
				tmp2.Format(" filename=\"=?ISO-2022-JP?B?%s?=\"\r\n", tmp1);
				array.Add(tmp2);
				goto last1;
			}
		}else{
			array.Add("Content-Disposition: attachment;\r\n");
			tmp2.Format(" filename=\"%s\"\r\n", filename);
			array.Add(tmp2);
			goto last1;
		}
	}
	// content-type
	regcomp(&reg2, regex2, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg2, buf, 3, pmatch2, 0)){
		type = buf.Mid(pmatch2[1].rm_so, pmatch2[1].rm_eo-pmatch2[1].rm_so);
		filename = buf.Mid(pmatch2[2].rm_so, pmatch2[2].rm_eo-pmatch2[2].rm_so);
		if(g_is_iso2022(filename)){
			tmp1.Format("Content-Type: %s;\r\n", type);
			array.Add(tmp1);
			if(filename.GetLength() > 30){
				if(Count4Enc(filename, 31, &len)){
					tmp1 = filename.Left(len) + "\x1b\x28\x42";
					filename = "\x1b\x24\x42" + filename.Mid(len);
				}else{
					tmp1 = filename.Left(len);
					filename = filename.Mid(len);
				}
				g_encode_base64(tmp1, tmp2);
				tmp3.Format(" name=\"=?ISO-2022-JP?B?%s?=\r\n", tmp2);
				array.Add(tmp3);
				while(filename.GetLength() > 38){
					if(Count4Enc(filename, 39, &len)){
						tmp1 = filename.Left(len) + "\x1b\x28\x42";
						filename = "\x1b\x24\x42" + filename.Mid(len);
					}else{
						tmp1 = filename.Left(len);
						filename = filename.Mid(len);
					}
					g_encode_base64(tmp1, tmp2);
					tmp3.Format(" =?ISO-2022-JP?B?%s?=\r\n", tmp2);
					array.Add(tmp3);
				}
				g_encode_base64(filename, tmp1);
				tmp2.Format(" =?ISO-2022-JP?B?%s?=\"\r\n", tmp1);
				array.Add(tmp2);
				goto last2;
			}else{
				g_encode_base64(filename, tmp1);
				tmp2.Format(" name=\"=?ISO-2022-JP?B?%s?=\"\r\n", tmp1);
				array.Add(tmp2);
				goto last2;
			}
		}else{
			tmp1.Format("Content-Type: %s;\r\n", type);
			array.Add(tmp1);
			tmp1.Format(" name=\"%s\"\r\n", filename);
			array.Add(tmp1);
			goto last2;
		} 
	}
		
	array.Add(buf+"\r\n");

	last2:
	regfree(&reg2);
	last1:
	regfree(&reg1);
}
