// PluginListDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "pochy.h"
#include "PluginListDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPluginListDialog _CAO

CPluginListDialog::CPluginListDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CPluginListDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPluginListDialog)
	//}}AFX_DATA_INIT
}

void CPluginListDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPluginListDialog)
	DDX_Control(pDX, IDC_LIST_PLUGIN, m_listPlugin);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPluginListDialog, CDialog)
	//{{AFX_MSG_MAP(CPluginListDialog)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_PLUGIN, OnItemChanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPluginListDialog bZ[W nh

BOOL CPluginListDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_listPlugin.SetExtendedStyle(m_listPlugin.GetExtendedStyle() | LVS_EX_FULLROWSELECT);

	m_listPlugin.InsertColumn(0, _T("O"), LVCFMT_LEFT, 200, -1);
	m_listPlugin.InsertColumn(1, _T("o[W"), LVCFMT_LEFT, 80, -1);
	m_listPlugin.InsertColumn(2, _T(""), LVCFMT_LEFT, 200, -1);

	CPochyApp *pPochyApp = (CPochyApp*)::AfxGetApp();
	const CPluginManager::PLUGIN_LIST& pluginList = pPochyApp->m_pluginManager.GetPluginList();
	CPluginManager::PLUGIN_LIST::const_iterator it;
	int nIndex = 0;
	for (it = pluginList.begin(); it != pluginList.end(); ++it)
	{
		const CPlugin::CInfo& info = it->GetInfo();
		m_listPlugin.InsertItem(nIndex, info.m_name.c_str());
		m_listPlugin.SetItemText(nIndex, 1, info.m_version.c_str());
		m_listPlugin.SetItemText(nIndex, 2, info.m_copyright.c_str());
		m_listPlugin.SetItemData(nIndex, reinterpret_cast<DWORD>(it));
		nIndex++;
	}

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CPluginListDialog::OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	std::string infoString;
	NMLISTVIEW* pNMListView = (NMLISTVIEW*)pNMHDR;
	if (pNMListView->uNewState & LVIS_SELECTED == LVIS_SELECTED )
	{
		CPluginManager::PLUGIN_LIST::const_iterator it;
		it = reinterpret_cast<CPluginManager::PLUGIN_LIST::const_iterator>(m_listPlugin.GetItemData(pNMListView->iItem));
		const CPlugin::CInfo& info = it->GetInfo();
		infoString = info.m_name + _T("\r\n") +
			info.m_version + _T("\r\n") +
			info.m_copyright + _T("\r\n\r\n") +
			info.m_comments.c_str();
	}

	GetDlgItem(IDC_EDIT_COMMENT)->SetWindowText(infoString.c_str());

	*pResult = 0;
}
