// PochyPlugin.h v0.1.02 Copyright(C) 2004 minamina
// Pochy Plugin Define

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef POCHY_PLUGIN_H
#define POCHY_PLUGIN_H

// Pochy API o[W
//
// 4oCgŏʂ\ ( 0)AW[o[WA}Ci[o[WArW̏
// ) 0x00030507 = version 3.5.07
//
// W[o[W͏ʌ݊ȂȂƂ (ÂgȂȂƂ)
// }Ci[o[W͐V API R[obNǉꂽƂ
// rW̓oOCȂǂŃC^[tF[X̕ύXsȂƂ
// ύX\ł (AKȂƂ͌Ȃ)
#define POCHY_API_VERSION (0x00000102)

// PC_OnPreFilter Ȃǂŗp Pochy pӂobt@[̃TCY
#define POCHY_PLUGIN_PATH_BUFFER_SIZE (MAX_PATH)

#define POCHY_PLUGIN_INFO_NAME_SIZE (128)
#define POCHY_PLUGIN_INFO_VERSION_SIZE (128)
#define POCHY_PLUGIN_INFO_COPYRIGHT_SIZE (128)
#define POCHY_PLUGIN_INFO_COMMENTS_SIZE (512)

typedef struct tagPOCHY_PLUGIN_INFO
{
	TCHAR szName[POCHY_PLUGIN_INFO_NAME_SIZE];
	TCHAR szVersion[POCHY_PLUGIN_INFO_VERSION_SIZE];
	TCHAR szCopyright[POCHY_PLUGIN_INFO_COPYRIGHT_SIZE];
	TCHAR szComments[POCHY_PLUGIN_INFO_COMMENTS_SIZE];
} POCHY_PLUGIN_INFO, *LPPOCHY_PLUGIN_INFO;

enum POCHY_WINDOW_TYPE
{
	PW_MAIN_FRAME = 0,
	PW_SUMMARY_VIEW = 1,
	PW_ACCOUNT_VIEW = 2,
	PW_FOLDER_VIEW = 3,
	PW_TEXT_VIEW = 4,
	PW_HEADER_VIEW = 5,
	PW_MULTIPART_VIEW = 6,

	PW_DRAFT_FRAME = 100,
	PW_ADDRESS_VIEW = 101,
	PW_MAIL_EDIT_VIEW = 102,
	PW_ATTACHED_FILE_VIEW = 103,
};

enum POCHY_RESULT_TYPE
{
	PR_CLOSE_OK = 0,
	PR_CLOSE_CANCEL = 1,
	PR_SEND_OK = 0,
	PR_SEND_CANCEL = 1,
};

enum POCHY_MENU_TYPE
{
	POCHY_MENU_SYSTEM = 0,
	POCHY_MENU_FILE = 1,
	POCHY_MENU_MAIL = 2,
	POCHY_MENU_VIEW = 3,
	POCHY_MENU_SETTING = 4,
	POCHY_MENU_GPG = 5,
	POCHY_MENU_PLUGIN = 6,
	POCHY_MENU_HELP = 7,

	POCHY_MENU_TASKTRAY = 100,
	POCHY_MENU_SUMMARY_VIEW = 101,
	POCHY_MENU_ACCOUNT_VIEW = 102, // no menu
	POCHY_MENU_FOLDER_VIEW = 103,
	POCHY_MENU_TEXT_VIEW = 104,
	POCHY_MENU_HEADER_VIEW = 105, // no menu
	POCHY_MENU_MULTIPART_VIEW = 106,

	POCHY_MENU_DRAFT_SYSTEM = 200,
	POCHY_MENU_DRAFT_MAIL = 201,
	POCHY_MENU_DRAFT_VIEW = 202,
	POCHY_MENU_DRAFT_GPG = 203,
	POCHY_MENU_DRAFT_HELP = 204,

	POCHY_MENU_DRAFT_MAIL_EDIT_VIEW = 300,
	POCHY_MENU_DRAFT_ATTACHED_FILE_VIEW = 301,
};

// Pochy ŗp郁j[R[obN`
typedef void (CALLBACK* POCHY_MENU_CALLBACK)(HWND hWnd, UINT nID);

#endif // POCHY_PLUGIN_H
