// TimeEx.cpp: CTimeEx NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TimeEx.h"
#include "_regex.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CTimeEx::CTimeEx(time_t time, LPCTSTR offset)
{
	SetTimeT(time, offset);
}

CTimeEx::CTimeEx(LPCTSTR mail_format_date)
{
	SetMailFormatDate(mail_format_date);
}

CTimeEx::CTimeEx()
{

}

CTimeEx::~CTimeEx()
{

}

void CTimeEx::SetMailFormatDate(LPCTSTR mail_format_date)
{
	CString date = mail_format_date;
	CString year;
	CString month;
	CString day;
	CString hour;
	CString minute;
	CString second;
	CString offset;
	regex_t reg; // for regex
	regmatch_t pmatch[10]; // result of regexec is put into this
	char *regex = "([a-zA-Z]+)*,* *([0-9]+) +([a-zA-Z]+) +([0-9]+) +([0-9]+):([0-9]+):*([0-9]*) +([+-0-9a-zA-Z]*)";

	// Date:     Mon, 3 Feb 2003 00:00:43 -0600
	// Date: Sat, 29 Mar 2003 05:01:48 +0900
	regcomp(&reg, regex, REG_EXTENDED | REG_NEWLINE | REG_ICASE);
	if(0 == regexec(&reg, date, 9, pmatch, 0)){
		year = date.Mid(pmatch[4].rm_so, pmatch[4].rm_eo-pmatch[4].rm_so);
		month = date.Mid(pmatch[3].rm_so, pmatch[3].rm_eo-pmatch[3].rm_so);
		day = date.Mid(pmatch[2].rm_so, pmatch[2].rm_eo-pmatch[2].rm_so);
		hour = date.Mid(pmatch[5].rm_so, pmatch[5].rm_eo-pmatch[5].rm_so);
		minute = date.Mid(pmatch[6].rm_so, pmatch[6].rm_eo-pmatch[6].rm_so);
		second = date.Mid(pmatch[7].rm_so, pmatch[7].rm_eo-pmatch[7].rm_so);
		offset = date.Mid(pmatch[8].rm_so, pmatch[8].rm_eo-pmatch[8].rm_so);
		regfree(&reg);
	}else{
		regfree(&reg);
		return;
	}
	if(month.Find("Apr") != -1) month = "04";
	else if(month.Find("May") != -1) month = "05";
	else if(month.Find("Jun") != -1) month = "06";
	else if(month.Find("Jul") != -1) month = "07";
	else if(month.Find("Aug") != -1) month = "08";
	else if(month.Find("Sep") != -1) month = "09";
	else if(month.Find("Oct") != -1) month = "10";
	else if(month.Find("Nov") != -1) month = "11";
	else if(month.Find("Dec") != -1) month = "12";
	else if(month.Find("Jan") != -1) month = "01";
	else if(month.Find("Feb") != -1) month = "02";
	else if(month.Find("Mar") != -1) month = "03";
	else{
		return;
	}

	CTime time(atoi(year), atoi(month), atoi(day), atoi(hour), atoi(minute), atoi(second));

	m_time = time;
	if(!offset.SpanExcluding("0123456789+-").IsEmpty()){
		offset = GetTzOffsetFromTzName(offset);
	}
	if(offset.IsEmpty()){
		m_offset = "+0000";
	}else{
		m_offset = offset;
	}
}

void CTimeEx::SetTimeT(time_t time, LPCTSTR offset)
{
	m_time = time;
	
	// if not offset
	CString tmp = offset;
	if(!tmp.SpanExcluding("0123456789+-").IsEmpty()){
		tmp = GetTzOffsetFromTzName(tmp);
	}
	if(tmp.IsEmpty()){
		return;
	}else{
		m_offset = tmp;
	}
}

time_t CTimeEx::GetGmTimeT()
{
	// adjust time zone
	CString plus_minus;
	CString hour;
	CString minute;
	CTime t = m_time;

	if(m_offset.GetLength() < 5){
		return t.GetTime();
	}
	plus_minus = m_offset[0];
	hour = m_offset.Mid(1, 2);
	minute = m_offset.Mid(3, 2);

	// change to GMT
	if(plus_minus == "-"){
		t += CTimeSpan(0, atoi(hour), atoi(minute), 0);
	}else if(plus_minus == "+"){
		t -= CTimeSpan(0, atoi(hour), atoi(minute), 0);
	}

	return t.GetTime();
}

void CTimeEx::SetNewOffset(LPCTSTR offset)
{
	CTime t = GetGmTimeT();

	if(strlen(offset) < 5)
		return;

	CString dst_offset = offset;

	if(!dst_offset.SpanExcluding("0123456789+-").IsEmpty()){
		dst_offset = GetTzOffsetFromTzName(dst_offset);
	}
	if(dst_offset.IsEmpty()){
		return;
	}

	CString plus_minus = dst_offset[0];
	CString hour = dst_offset.Mid(1, 2);
	CString minute = dst_offset.Mid(3, 2);

	if(plus_minus == "-"){
		t -= CTimeSpan(0, atoi(hour), atoi(minute), 0);
	}else if(plus_minus == "+"){
		t += CTimeSpan(0, atoi(hour), atoi(minute), 0);
	}

	m_time = t;
	m_offset = dst_offset;
}

CString CTimeEx::GetFormatDate(LPCTSTR format)
{
	return m_time.Format(format);
}

CString CTimeEx::GetTzOffsetFromTzName(LPCTSTR zone_name)
{
	CString tmp = zone_name;
	tmp.MakeUpper();

	CMapStringToString map;

	map.SetAt("NZDT",	"+1300");	// New Zealand Daylight Time (j[W[hĎ)
	map.SetAt("IDLE",	"+1200");	// International Date Line, East (ۓtύXA)
	map.SetAt("NZST",	"+1200");	// New Zealand Std Time (j[W[hW)
	map.SetAt("NZT",	"+1200");	// New Zealand Time (j[W[h)
	map.SetAt("AESST",	"+1100");	// Australia Eastern Summer Std Time (I[XgAWĎ)
	map.SetAt("ACSST",	"+1030");	// Central Australia Summer Std Time (I[XgAWĎ)
	map.SetAt("CADT",	"+1030");	// Central Australia Daylight Savings Time (I[XgAĎ)
	map.SetAt("SADT",	"+1030");	// South Australian Daylight Time (I[XgA암Ď)
	map.SetAt("AEST",	"+1000");	// Australia Eastern Std Time (I[XgAW)
	map.SetAt("EAST",	"+1000");	// East Australian Std Time (I[XgAW)
	map.SetAt("GST",	"+1000");	// Guam Std Time, USSR Zone 9 (OAWԁA\rGg^C][ 9)
	map.SetAt("LIGT",	"+1000");	// Melbourne, Australia (I[XgAA{)
	map.SetAt("ACST",	"+0930");	// Central Australia Std Time (I[XgAW)
	map.SetAt("CAST",	"+0930");	// Central Australia Std Time (I[XgAW)
	map.SetAt("SAT",	"+0930");	// South Australian Std Time (I[XgA암W)
	map.SetAt("AWSST",	"+0900");	// Australia Western Summer Std Time (I[XgAW)
	map.SetAt("JST",	"+0900");	// Japan Std Time, USSR Zone 8 ({WԁA\rGg^C][ 8)
	map.SetAt("KST",	"+0900");	// Korea Standard Time (؍W)
	map.SetAt("WDT",	"+0900");	// West Australian Daylight Time (I[XgAĎ)
	map.SetAt("MT",		"+0830");	// Moluccas Time (bJ)
	map.SetAt("AWST",	"+0800");	// Australia Western Std Time (I[XgAW)
	map.SetAt("CCT",	"+0800");	// China Coastal Time (pݎ)
	map.SetAt("WADT",	"+0800");	// West Australian Daylight Time (A[XgAĎ)
	map.SetAt("WST",	"+0800");	// West Australian Std Time (I[XgAW)
	map.SetAt("JT",		"+0730");	// Java Time (Java )
	map.SetAt("WAST",	"+0700");	// West Australian Std Time (I[XgAW)
	map.SetAt("IT",		"+0330");	// Iran Time (C)
	map.SetAt("BT",		"+0300");	// Baghdad Time (oO_bh)
	map.SetAt("EETDST",	"+0300");	// Eastern Europe Daylight Savings Time ([bpĎ)
	map.SetAt("CETDST",	"+0200");	// Central European Daylight Savings Time ([bpĎ)
	map.SetAt("EET",	"+0200");	// Eastern Europe, USSR Zone 1 ([bpԁA\rGg^C][ 1)
	map.SetAt("FWT",	"+0200");	// French Winter Time (tX~)
	map.SetAt("IST",	"+0200");	// Israel Std Time (CXGW)
	map.SetAt("MEST",	"+0200");	// Middle Europe Summer Time ([bpĎ)
	map.SetAt("METDST",	"+0200");	// Middle Europe Daylight Time ([bpĎ)
	map.SetAt("SST",	"+0200");	// Swedish Summer Time (XEF[fĎ)
	map.SetAt("BST",	"+0100");	// British Summer Time (CMXĎ)
	map.SetAt("CET",	"+0100");	// Central European Time ([bp)
	map.SetAt("DNT",	"+0100");	// Dansk Normal Tid (f}[NW)
	map.SetAt("DST",	"+0100");	// Dansk Standard Time (?) (f}[NW (?))
	map.SetAt("FST",	"+0100");	// French Summer Time (tXĎ)
	map.SetAt("MET",	"+0100");	// Middle Europe Time ([bp)
	map.SetAt("MEWT",	"+0100");	// Middle Europe Winter Time ([bp~)
	map.SetAt("MEZ",	"+0100");	// Middle Europe Zone ([bp)
	map.SetAt("NOR",	"+0100");	// Norway Standard Time (mEF[W)
	map.SetAt("SET",	"+0100");	// Seychelles Time (ZCVF)
	map.SetAt("SWT",	"+0100");	// Swedish Winter Time (XEF[f~)
	map.SetAt("WETDST",	"+0100");	// Western Europe Daylight Savings Time ([bpĎ)
	map.SetAt("GMT",	"+0000");	// Greenwish Mean Time (OjbWW)
	map.SetAt("WET",	"+0000");	// Western Europe ([bp)
	map.SetAt("WAT",	"-0100");	// West Africa Time (AtJ)
	map.SetAt("NDT",	"-0230");	// Newfoundland Daylight Time (j[t@hhĎ)
	map.SetAt("ADT",	"-0300");	// Atlantic Daylight Time (吼mĎ)
	map.SetAt("NFT",	"-0330");	// Newfoundland Standard Time (j[t@hhW)
	map.SetAt("NST",	"-0330");	// Newfoundland Standard Time (j[t@hhW)
	map.SetAt("AST",	"-0400");	// Atlantic Std Time (Canada) (吼mW (Ji_))
	map.SetAt("EDT",	"-0400");	// Eastern Daylight Time (AJĎ)
	map.SetAt("ZP4",	"-0400");	// GMT +4 
	map.SetAt("CDT",	"-0500");	// Central Daylight Time (AJĎ)
	map.SetAt("EST",	"-0500");	// Eastern Standard Time (AJW)
	map.SetAt("ZP5",	"-0500");	// GMT +5 
	map.SetAt("CST",	"-0600");	// Central Std Time (AJW)
	map.SetAt("MDT",	"-0600");	// Mountain Daylight Time (AJRxĎ)
	map.SetAt("ZP6",	"-0600");	// GMT +6 hours (OjbWW +6 )
	map.SetAt("MST",	"-0700");	// Mountain Standard Time (AJRxW)
	map.SetAt("PDT",	"-0700");	// Pacific Daylight Time (AJmĎ)
	map.SetAt("PST",	"-0800");	// Pacific Std Time (AJmW)
	map.SetAt("YDT",	"-0800");	// Yukon Daylight Time ([RĎ)
	map.SetAt("HDT",	"-0900");	// Hawaii/Alaska Daylight Time (nC/AXJĎ)
	map.SetAt("YST",	"-0900");	// Yukon Standard Time ([RW)
	map.SetAt("AHST",	"-1000");	// Alaska-Hawaii Std Time (AXJ-nCW)
	map.SetAt("CAT",	"-1000");	// Central Alaska Time (AXJ)
	map.SetAt("NT",		"-1100");	// Nome Time (m[)
	map.SetAt("IDLW",	"-1200");	// International Date Line, West (ۓtύXA)

	CString value;
	map.Lookup(tmp, value);
	return value;
}

CString CTimeEx::GetMailFormatDate()
{
	CString tmp = m_time.Format("%a, %d %b %Y %H:%M:%S ")+m_offset;
	return tmp;
}
